/*
 * Decompiled with CFR 0.152.
 */
package exerelin.plugins;

import com.fs.starfarer.api.BaseModPlugin;
import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignPlugin;
import com.fs.starfarer.api.campaign.PersistentUIDataAPI;
import com.fs.starfarer.api.campaign.SectorAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.fleets.PatrolFleetManager;
import com.thoughtworks.xstream.XStream;
import exerelin.campaign.AllianceManager;
import exerelin.campaign.CovertOpsManager;
import exerelin.campaign.DiplomacyManager;
import exerelin.campaign.DirectoryScreenScript;
import exerelin.campaign.PlayerFactionStore;
import exerelin.campaign.ReinitScreenScript;
import exerelin.campaign.SectorManager;
import exerelin.campaign.StartSetupPostTimePass;
import exerelin.campaign.StatsTracker;
import exerelin.campaign.events.RevengeanceManagerEvent;
import exerelin.campaign.fleets.ExerelinPatrolFleetManager;
import exerelin.campaign.fleets.InvasionFleetManager;
import exerelin.campaign.fleets.MiningFleetManager;
import exerelin.campaign.fleets.PatrolFleetManagerReplacer;
import exerelin.campaign.fleets.ResponseFleetManager;
import exerelin.campaign.missions.ConquestMissionCreator;
import exerelin.plugins.ExerelinCoreCampaignPlugin;
import exerelin.plugins.XStreamConfig;
import exerelin.utilities.ExerelinConfig;
import exerelin.utilities.ExerelinUtils;
import exerelin.utilities.ExerelinUtilsFaction;
import exerelin.utilities.ExerelinUtilsMarket;
import exerelin.utilities.ExerelinUtilsReputation;
import exerelin.utilities.versionchecker.VCModPluginCustom;
import exerelin.world.ExerelinProcGen;
import exerelin.world.SSP_AsteroidTracker;
import java.util.HashMap;

public class ExerelinModPlugin
extends BaseModPlugin {
    public static final boolean HAVE_SWP = Global.getSettings().getModManager().isModEnabled("swp");
    public static final boolean HAVE_DYNASECTOR = Global.getSettings().getModManager().isModEnabled("dynasector");
    public static final boolean HAVE_UNDERWORLD = Global.getSettings().getModManager().isModEnabled("underworld");
    public static final boolean HAVE_STELLAR_INDUSTRIALIST = Global.getSettings().getModManager().isModEnabled("stellar_industrialist");
    public static final boolean HAVE_VERSION_CHECKER = Global.getSettings().getModManager().isModEnabled("lw_version_checker");
    protected static boolean isNewGame = false;

    protected void applyToExistingSave() {
        Global.getLogger(((Object)((Object)this)).getClass()).info((Object)"Applying Nexerelin to existing game");
        SectorAPI sector = Global.getSector();
        InvasionFleetManager im = InvasionFleetManager.create();
        AllianceManager am = AllianceManager.create();
        sector.addScript((EveryFrameScript)SectorManager.create());
        sector.addScript((EveryFrameScript)DiplomacyManager.create());
        sector.addScript((EveryFrameScript)im);
        sector.addScript((EveryFrameScript)ResponseFleetManager.create());
        sector.addScript((EveryFrameScript)MiningFleetManager.create());
        sector.addScript((EveryFrameScript)CovertOpsManager.create());
        sector.addScript((EveryFrameScript)am);
        SectorManager.setSystemToRelayMap(new HashMap<String, String>());
        SectorManager.setPlanetToRelayMap(new HashMap<String, String>());
        sector.addScript((EveryFrameScript)new PatrolFleetManagerReplacer());
        for (MarketAPI market : sector.getEconomy().getMarketsCopy()) {
            ExerelinUtils.removeScriptAndListener(market.getPrimaryEntity(), PatrolFleetManager.class, ExerelinPatrolFleetManager.class);
        }
        for (MarketAPI market : Global.getSector().getEconomy().getMarketsCopy()) {
            market.getMemoryWithoutUpdate().set("$startingFactionId", (Object)market.getFactionId());
        }
        StatsTracker.create();
        SectorManager.setCorvusMode(true);
        SectorManager.reinitLiveFactions();
        PlayerFactionStore.setPlayerFactionId("player_npc");
        sector.getFaction("player").setRelationship("player_npc", 1.0f);
        ExerelinUtilsReputation.syncFactionRelationshipsToPlayer();
        Global.getSector().getCharacterData().addAbility("exerelin_follow_me");
        PersistentUIDataAPI.AbilitySlotsAPI slots = Global.getSector().getUIData().getAbilitySlotsAPI();
        for (PersistentUIDataAPI.AbilitySlotAPI slot : slots.getCurrSlotsCopy()) {
            if (slot.getAbilityId() != null && !slot.getAbilityId().isEmpty()) continue;
            slot.setAbilityId("exerelin_follow_me");
            break;
        }
        sector.addTransientScript((EveryFrameScript)new ReinitScreenScript());
    }

    protected void refreshTariffs() {
        for (MarketAPI market : Global.getSector().getEconomy().getMarketsCopy()) {
            ExerelinUtilsMarket.setTariffs(market);
        }
    }

    public void beforeGameSave() {
    }

    public void onNewGame() {
        Global.getLogger(((Object)((Object)this)).getClass()).info((Object)"New game");
        isNewGame = true;
        ExerelinConfig.loadSettings();
        this.addScriptsIfNeeded();
    }

    protected void reverseCompatibility() {
        SectorEntityToken prism = Global.getSector().getEntityById("prismFreeport");
        if (prism != null) {
            prism.removeTag("station");
        }
    }

    public void onEnabled(boolean wasEnabledBefore) {
        Global.getLogger(((Object)((Object)this)).getClass()).info((Object)("On enabled; " + wasEnabledBefore));
        if (!isNewGame && !wasEnabledBefore) {
            Global.getLogger(((Object)((Object)this)).getClass()).info((Object)(!isNewGame + ", " + !wasEnabledBefore));
            this.applyToExistingSave();
        }
    }

    protected void addScriptsIfNeeded() {
        SectorAPI sector = Global.getSector();
        if (!sector.hasScript(ConquestMissionCreator.class)) {
            sector.addScript((EveryFrameScript)new ConquestMissionCreator());
        }
    }

    public void onGameLoad(boolean newGame) {
        Global.getLogger(((Object)((Object)this)).getClass()).info((Object)("Game load; " + SectorManager.isSectorManagerSaved()));
        isNewGame = newGame;
        this.addScriptsIfNeeded();
        ExerelinConfig.loadSettings();
        SectorManager.create();
        DiplomacyManager.create();
        InvasionFleetManager.create();
        ResponseFleetManager.create();
        MiningFleetManager.create();
        CovertOpsManager.create();
        AllianceManager.create();
        SectorAPI sector = Global.getSector();
        if (!sector.getEventManager().isOngoing(null, "exerelin_faction_salary")) {
            sector.getEventManager().startEvent(null, "exerelin_faction_salary", null);
        }
        if (!sector.getEventManager().isOngoing(null, "exerelin_faction_insurance")) {
            sector.getEventManager().startEvent(null, "exerelin_faction_insurance", null);
        }
        if (ExerelinUtilsFaction.isExiInCorvus() && !sector.getEventManager().isOngoing(null, "exerelin_exigency_respawn")) {
            sector.getEventManager().startEvent(null, "exerelin_exigency_respawn", null);
        }
        if (RevengeanceManagerEvent.getOngoingEvent() == null) {
            sector.getEventManager().startEvent(null, "exerelin_revengeance_manager", null);
        }
        if (!sector.getEventManager().isOngoing(null, "exerelin_slaves_sold")) {
            sector.getEventManager().startEvent(null, "exerelin_slaves_sold", null);
        }
        this.reverseCompatibility();
        this.refreshTariffs();
        sector.registerPlugin((CampaignPlugin)new ExerelinCoreCampaignPlugin());
        sector.addTransientScript((EveryFrameScript)new DirectoryScreenScript());
        sector.addTransientScript((EveryFrameScript)new SSP_AsteroidTracker());
        if (!HAVE_VERSION_CHECKER) {
            VCModPluginCustom.onGameLoad(newGame);
        }
    }

    public void onApplicationLoad() throws Exception {
        if (!HAVE_VERSION_CHECKER) {
            VCModPluginCustom.onApplicationLoad();
        }
    }

    public void onNewGameAfterProcGen() {
        Global.getLogger(((Object)((Object)this)).getClass()).info((Object)("New game after proc gen; " + isNewGame));
        if (!SectorManager.getCorvusMode()) {
            new ExerelinProcGen().generate();
        }
    }

    public void onNewGameAfterEconomyLoad() {
        Global.getLogger(((Object)((Object)this)).getClass()).info((Object)("New game after economy load; " + isNewGame));
        SectorManager.reinitLiveFactions();
        if (SectorManager.getCorvusMode()) {
            DiplomacyManager.initFactionRelationships(false);
        }
        for (MarketAPI market : Global.getSector().getEconomy().getMarketsCopy()) {
            market.getMemoryWithoutUpdate().set("$startingFactionId", (Object)market.getFactionId());
        }
    }

    public void onNewGameAfterTimePass() {
        Global.getLogger(((Object)((Object)this)).getClass()).info((Object)("New game after time pass; " + isNewGame));
        StartSetupPostTimePass.execute();
    }

    public void configureXStream(XStream x) {
        XStreamConfig.configureXStream(x);
    }
}

