/*
 * Decompiled with CFR 0.152.
 */
package exerelin.utilities;

import com.fs.starfarer.api.Global;
import exerelin.utilities.ExerelinFactionConfig;
import exerelin.utilities.ExerelinUtils;
import exerelin.utilities.ExerelinUtilsFaction;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ExerelinConfig {
    public static final String CONFIG_PATH = "exerelin_config.json";
    public static final String MOD_FACTION_LIST_PATH = "data/config/exerelinFactionConfig/mod_factions.csv";
    public static Logger log = Global.getLogger(ExerelinConfig.class);
    public static List<ExerelinFactionConfig> exerelinFactionConfigs;
    public static ExerelinFactionConfig defaultConfig;
    public static int minimumPlanets;
    @Deprecated
    public static int minimumStations;
    @Deprecated
    public static int minimumAsteroidBelts;
    @Deprecated
    public static float binarySystemChance;
    public static float forcePiratesInSystemChance;
    public static boolean enableIndependents;
    public static boolean enablePirates;
    public static boolean useFactionMarketSpawnWeights;
    public static float playerBaseSalary;
    public static float playerSalaryIncrementPerLevel;
    public static float playerInsuranceMult;
    public static float fleetBonusFpPerPlayerLevel;
    public static float prisonerRepatriateRepValue;
    public static float prisonerBaseRansomValue;
    public static float prisonerRansomValueIncrementPerLevel;
    public static float prisonerBaseSlaveValue;
    public static float prisonerSlaveValueIncrementPerLevel;
    public static float prisonerSlaveRepValue;
    public static float prisonerLootChancePer10Fp;
    public static float crewLootMult;
    public static String[] builtInFactions;
    public static String[] supportedModFactions;
    public static boolean allowPirateInvasions;
    public static float fleetRequestCostPerMarine;
    public static float fleetRequestCostPerFP;
    public static float invasionGracePeriod;
    public static float pointsRequiredForInvasionFleet;
    public static float baseInvasionPointsPerFaction;
    public static float invasionPointsPerPlayerLevel;
    public static float invasionPointEconomyMult;
    public static float conquestMissionRewardMult;
    public static float allianceGracePeriod;
    public static float allianceFormationInterval;
    public static boolean ignoreAlignmentForAlliances;
    public static int prismMaxWeapons;
    public static int prismNumShips;
    public static int prismNumWings;
    public static int prismNumBossShips;
    public static boolean prismRenewBossShips;
    public static boolean prismUseIBBProgressForBossShips;
    public static float prismTariff;
    public static float warWearinessDivisor;
    public static float warWearinessDivisorModPerLevel;
    public static float minWarWearinessForPeace;
    public static float warWearinessCeasefireReduction;
    public static float warWearinessPeaceTreatyReduction;
    public static boolean followersAgents;
    public static boolean followersDiplomacy;
    public static boolean enableAvesta;
    public static boolean enableShanghai;
    public static boolean enableUnos;
    public static int enableRevengeFleets;
    public static float revengePointsPerEnemyFP;
    public static float revengePointsForMarketCaptureMult;
    public static int directoryDialogKey;
    public static float baseTariffMult;
    public static float freeMarketTariffMult;
    public static int warmongerPenalty;
    public static float factionRespawnInterval;
    public static int maxFactionRespawns;
    public static boolean countPiratesForVictory;
    @Deprecated
    public static boolean ownFactionCustomsInspections;
    public static boolean useRelationshipBounds;
    public static boolean officerDeaths;
    public static boolean officerDaredevilBonus;

    public static void loadSettings() {
        try {
            System.out.println("Loading exerelinSettings");
            JSONObject settings = Global.getSettings().loadJSON(CONFIG_PATH);
            directoryDialogKey = settings.optInt("directoryDialogKey", directoryDialogKey);
            minimumPlanets = settings.optInt("minimumPlanets");
            minimumStations = settings.optInt("minimumStations");
            minimumAsteroidBelts = settings.optInt("minimumAsteroidBelts");
            binarySystemChance = (float)settings.optDouble("binarySystemChance", (double)binarySystemChance);
            forcePiratesInSystemChance = (float)settings.optDouble("piratesNotInSystemChance", (double)forcePiratesInSystemChance);
            enableIndependents = settings.optBoolean("enableIndependents", enableIndependents);
            enablePirates = settings.optBoolean("enablePirates", enablePirates);
            useFactionMarketSpawnWeights = settings.optBoolean("useFactionMarketSpawnWeights", useFactionMarketSpawnWeights);
            playerBaseSalary = (float)settings.optDouble("playerBaseSalary", (double)playerBaseSalary);
            playerSalaryIncrementPerLevel = (float)settings.optDouble("playerSalaryIncrementPerLevel", (double)playerSalaryIncrementPerLevel);
            playerInsuranceMult = (float)settings.optDouble("playerInsuranceMult", (double)playerInsuranceMult);
            fleetBonusFpPerPlayerLevel = (float)settings.optDouble("fleetBonusFpPerPlayerLevel", (double)fleetBonusFpPerPlayerLevel);
            prisonerRepatriateRepValue = (float)settings.optDouble("prisonerRepatriateRepValue", (double)prisonerRepatriateRepValue);
            prisonerBaseRansomValue = (float)settings.optDouble("prisonerBaseRansomValue", (double)prisonerBaseRansomValue);
            prisonerRansomValueIncrementPerLevel = (float)settings.optDouble("prisonerRansomValueIncrementPerLevel", (double)prisonerRansomValueIncrementPerLevel);
            prisonerBaseSlaveValue = (float)settings.optDouble("prisonerBaseSlaveValue", (double)prisonerBaseSlaveValue);
            prisonerSlaveValueIncrementPerLevel = (float)settings.optDouble("prisonerSlaveValueIncrementPerLevel", (double)prisonerSlaveValueIncrementPerLevel);
            prisonerLootChancePer10Fp = (float)settings.optDouble("prisonerLootChancePer10Fp", (double)prisonerLootChancePer10Fp);
            prisonerSlaveRepValue = (float)settings.optDouble("prisonerSlaveRepValue", (double)prisonerSlaveRepValue);
            crewLootMult = (float)settings.optDouble("crewLootMult", (double)crewLootMult);
            allowPirateInvasions = settings.optBoolean("allowPirateInvasions", allowPirateInvasions);
            fleetRequestCostPerMarine = (float)settings.optDouble("fleetRequestCostPerMarine", (double)fleetRequestCostPerMarine);
            fleetRequestCostPerFP = (float)settings.optDouble("fleetRequestCostPerFP", (double)fleetRequestCostPerFP);
            invasionGracePeriod = (float)settings.optDouble("invasionGracePeriod", (double)invasionGracePeriod);
            pointsRequiredForInvasionFleet = (float)settings.optDouble("pointsRequiredForInvasionFleet", (double)pointsRequiredForInvasionFleet);
            baseInvasionPointsPerFaction = (float)settings.optDouble("baseInvasionPointsPerFaction", (double)baseInvasionPointsPerFaction);
            invasionPointsPerPlayerLevel = (float)settings.optDouble("invasionPointsPerPlayerLevel ", (double)invasionPointsPerPlayerLevel);
            invasionPointEconomyMult = (float)settings.optDouble("invasionPointEconomyMult", (double)invasionPointEconomyMult);
            conquestMissionRewardMult = (float)settings.optDouble("conquestMissionRewardMult", (double)conquestMissionRewardMult);
            allianceGracePeriod = (float)settings.optDouble("allianceGracePeriod", (double)allianceGracePeriod);
            allianceFormationInterval = (float)settings.optDouble("allianceFormationInterval", (double)allianceFormationInterval);
            ignoreAlignmentForAlliances = settings.optBoolean("ignoreAlignmentForAlliances", ignoreAlignmentForAlliances);
            prismMaxWeapons = settings.optInt("prismMaxWeapons", prismMaxWeapons);
            prismNumShips = settings.optInt("prismNumShips", prismNumShips);
            prismNumWings = settings.optInt("prismNumWings", prismNumWings);
            prismNumBossShips = settings.optInt("prismNumBossShips", prismNumBossShips);
            prismRenewBossShips = settings.optBoolean("prismRenewBossShips", prismRenewBossShips);
            prismUseIBBProgressForBossShips = settings.optBoolean("prismUseIBBProgressForBossShips", prismUseIBBProgressForBossShips);
            prismTariff = (float)settings.optDouble("prismTariff", (double)prismTariff);
            warWearinessDivisor = (float)settings.optDouble("warWearinessDivisor", (double)warWearinessDivisor);
            warWearinessDivisorModPerLevel = (float)settings.optDouble("warWearinessDivisorModPerLevel", (double)warWearinessDivisorModPerLevel);
            minWarWearinessForPeace = (float)settings.optDouble("minWarWearinessForPeace", (double)minWarWearinessForPeace);
            warWearinessCeasefireReduction = (float)settings.optDouble("warWearinessCeasefireReduction", (double)warWearinessCeasefireReduction);
            warWearinessPeaceTreatyReduction = (float)settings.optDouble("warWearinessCeasefireReduction", (double)warWearinessCeasefireReduction);
            followersAgents = settings.optBoolean("followersAgents", followersAgents);
            followersDiplomacy = settings.optBoolean("followersDiplomacy", followersDiplomacy);
            enableAvesta = settings.optBoolean("enableAvesta", enableAvesta);
            enableShanghai = settings.optBoolean("enableShanghai", enableShanghai);
            enableUnos = settings.optBoolean("enableUnos", enableUnos);
            enableRevengeFleets = settings.optInt("enableRevengeFleets", enableRevengeFleets);
            revengePointsPerEnemyFP = (float)settings.optDouble("revengeFleetPointsPerEnemyFP", (double)revengePointsPerEnemyFP);
            revengePointsForMarketCaptureMult = (float)settings.optDouble("revengeFleetPointsForMarketCaptureMult", (double)revengePointsForMarketCaptureMult);
            baseTariffMult = (float)settings.optDouble("baseTariffMult", (double)baseTariffMult);
            freeMarketTariffMult = (float)settings.optDouble("freeMarketTariffMult", (double)freeMarketTariffMult);
            warmongerPenalty = settings.optInt("warmongerPenalty", warmongerPenalty);
            factionRespawnInterval = (float)settings.optDouble("factionRespawnInterval", (double)factionRespawnInterval);
            maxFactionRespawns = settings.optInt("maxFactionRespawns", maxFactionRespawns);
            countPiratesForVictory = settings.optBoolean("countPiratesForVictory", countPiratesForVictory);
            useRelationshipBounds = settings.optBoolean("useRelationshipBounds", useRelationshipBounds);
            officerDeaths = settings.optBoolean("officerDeaths", officerDeaths);
            officerDaredevilBonus = settings.optBoolean("officerDaredevilBonus", officerDaredevilBonus);
            builtInFactions = ExerelinUtils.JSONArrayToStringArray(settings.getJSONArray("builtInFactions"));
            ExerelinConfig.loadModFactionList();
        }
        catch (Exception e) {
            log.error((Object)("Unable to load settings: " + e.getMessage()));
        }
        if (exerelinFactionConfigs != null) {
            exerelinFactionConfigs.clear();
        }
        exerelinFactionConfigs = new ArrayList<ExerelinFactionConfig>();
        for (String factionId : builtInFactions) {
            ExerelinFactionConfig conf = new ExerelinFactionConfig(factionId);
            conf.isBuiltIn = true;
            exerelinFactionConfigs.add(conf);
            if (!factionId.equals("neutral")) continue;
            defaultConfig = conf;
        }
        for (String factionId : supportedModFactions) {
            if (!ExerelinUtilsFaction.doesFactionExist(factionId)) continue;
            exerelinFactionConfigs.add(new ExerelinFactionConfig(factionId));
        }
    }

    protected static void loadModFactionList() {
        try {
            ArrayList<String> modFactions = new ArrayList<String>();
            JSONArray modFactionsCsv = Global.getSettings().getMergedSpreadsheetDataForMod("faction", MOD_FACTION_LIST_PATH, "nexerelin");
            for (int x = 0; x < modFactionsCsv.length(); ++x) {
                JSONObject row = modFactionsCsv.getJSONObject(x);
                String factionName = row.getString("faction");
                modFactions.add(factionName);
            }
            supportedModFactions = modFactions.toArray(new String[0]);
        }
        catch (IOException | JSONException ex) {
            log.error((Object)("Failed to load mod faction file: " + ex));
        }
    }

    public static ExerelinFactionConfig getExerelinFactionConfig(String factionId) {
        for (ExerelinFactionConfig exerelinFactionConfig : exerelinFactionConfigs) {
            if (!exerelinFactionConfig.factionId.equalsIgnoreCase(factionId)) continue;
            return exerelinFactionConfig;
        }
        Global.getLogger(ExerelinConfig.class).warn((Object)("Faction config " + factionId + " not found, using default"));
        return defaultConfig;
    }

    @Deprecated
    public static List<String> getAllCustomFactionRebels() {
        ArrayList<String> customRebels = new ArrayList<String>();
        for (ExerelinFactionConfig exerelinFactionConfig : exerelinFactionConfigs) {
            if (exerelinFactionConfig.customRebelFaction.equalsIgnoreCase("")) continue;
            customRebels.add(exerelinFactionConfig.customRebelFaction);
        }
        return customRebels;
    }

    public static List<String> getModdedFactionsList(boolean onlyPlayable) {
        ArrayList<String> possibleModdedFactions = new ArrayList<String>();
        for (ExerelinFactionConfig config : exerelinFactionConfigs) {
            if (onlyPlayable && !config.playableFaction || config.isBuiltIn || !ExerelinUtilsFaction.doesFactionExist(config.factionId)) continue;
            possibleModdedFactions.add(config.factionId);
        }
        return possibleModdedFactions;
    }

    public static List<String> getBuiltInFactionsList(boolean onlyPlayable) {
        ArrayList<String> possibleBuiltInFactions = new ArrayList<String>();
        for (ExerelinFactionConfig config : exerelinFactionConfigs) {
            if (onlyPlayable && !config.playableFaction || !config.isBuiltIn) continue;
            possibleBuiltInFactions.add(config.factionId);
        }
        return possibleBuiltInFactions;
    }

    static {
        minimumPlanets = 3;
        minimumStations = 0;
        minimumAsteroidBelts = 0;
        binarySystemChance = 0.2f;
        forcePiratesInSystemChance = 0.3f;
        enableIndependents = true;
        enablePirates = true;
        useFactionMarketSpawnWeights = false;
        playerBaseSalary = 5000.0f;
        playerSalaryIncrementPerLevel = 1000.0f;
        playerInsuranceMult = 0.5f;
        fleetBonusFpPerPlayerLevel = 0.25f;
        prisonerRepatriateRepValue = 0.05f;
        prisonerBaseRansomValue = 2000.0f;
        prisonerRansomValueIncrementPerLevel = 100.0f;
        prisonerBaseSlaveValue = 4000.0f;
        prisonerSlaveValueIncrementPerLevel = 400.0f;
        prisonerSlaveRepValue = -0.02f;
        prisonerLootChancePer10Fp = 0.025f;
        crewLootMult = 0.02f;
        builtInFactions = new String[0];
        supportedModFactions = new String[0];
        allowPirateInvasions = false;
        fleetRequestCostPerMarine = 125.0f;
        fleetRequestCostPerFP = 2000.0f;
        invasionGracePeriod = 0.0f;
        pointsRequiredForInvasionFleet = 4000.0f;
        baseInvasionPointsPerFaction = 45.0f;
        invasionPointsPerPlayerLevel = 1.0f;
        invasionPointEconomyMult = 1.0f;
        conquestMissionRewardMult = 1.0f;
        allianceGracePeriod = 30.0f;
        allianceFormationInterval = 30.0f;
        ignoreAlignmentForAlliances = false;
        prismMaxWeapons = 27;
        prismNumShips = 14;
        prismNumWings = 6;
        prismNumBossShips = 3;
        prismRenewBossShips = false;
        prismUseIBBProgressForBossShips = true;
        prismTariff = 2.0f;
        warWearinessDivisor = 20000.0f;
        warWearinessDivisorModPerLevel = 200.0f;
        minWarWearinessForPeace = 8000.0f;
        warWearinessCeasefireReduction = 5000.0f;
        warWearinessPeaceTreatyReduction = 8000.0f;
        followersAgents = false;
        followersDiplomacy = true;
        enableAvesta = true;
        enableShanghai = true;
        enableUnos = true;
        enableRevengeFleets = 1;
        revengePointsPerEnemyFP = 0.1f;
        revengePointsForMarketCaptureMult = 4.0f;
        directoryDialogKey = 32;
        baseTariffMult = 1.0f;
        freeMarketTariffMult = 0.5f;
        warmongerPenalty = 0;
        factionRespawnInterval = 30.0f;
        maxFactionRespawns = 1;
        countPiratesForVictory = false;
        ownFactionCustomsInspections = false;
        useRelationshipBounds = true;
        officerDeaths = true;
        officerDaredevilBonus = true;
    }
}

