/*
 * Decompiled with CFR 0.152.
 */
package exerelin.utilities;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.fleet.FleetMemberType;
import com.fs.starfarer.api.fleet.ShipRolePick;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import exerelin.campaign.ExerelinSetupData;
import exerelin.campaign.alliances.Alliance;
import exerelin.plugins.ExerelinModPlugin;
import exerelin.utilities.ExerelinConfig;
import exerelin.utilities.ExerelinUtils;
import exerelin.utilities.StringHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ExerelinFactionConfig {
    public static final String[] DEFAULT_MINERS = new String[]{"venture_Outdated", "shepherd_Frontier"};
    public static final Map<Alliance.Alignment, Float> DEFAULT_ALIGNMENTS = new HashMap<Alliance.Alignment, Float>();
    public String factionId;
    public boolean playableFaction = true;
    public boolean corvusCompatible = false;
    public boolean isBuiltIn = false;
    public boolean pirateFaction = false;
    public boolean isPirateNeutral = false;
    public boolean spawnPatrols = false;
    @Deprecated
    public boolean spawnPiratesAndMercs = false;
    public int hostileToAll = 0;
    public double baseFleetCostMultiplier = 1.0;
    public String customRebelFaction = "";
    public String customRebelFleetId = "";
    public String rebelFleetSuffix = "Dissenters";
    public String asteroidMiningFleetName = StringHelper.getString("exerelin_fleets", "miningFleetName");
    public String gasMiningFleetName = StringHelper.getString("exerelin_fleets", "miningFleetName");
    public String logisticsFleetName = "Logistics Convoy";
    public String invasionFleetName = StringHelper.getString("exerelin_fleets", "invasionFleetName");
    public String invasionSupportFleetName = StringHelper.getString("exerelin_fleets", "invasionSupportFleetName");
    public String responseFleetName = StringHelper.getString("exerelin_fleets", "responseFleetName");
    public String defenceFleetName = StringHelper.getString("exerelin_fleets", "defenceFleetName");
    public int positiveDiplomacyExtra = 0;
    public int negativeDiplomacyExtra = 0;
    @Deprecated
    public String[] factionsLiked = new String[0];
    @Deprecated
    public String[] factionsDisliked = new String[0];
    @Deprecated
    public String[] factionsNeutral = new String[0];
    public Map<String, Float> minRelationships = new HashMap<String, Float>();
    public Map<String, Float> maxRelationships = new HashMap<String, Float>();
    public Map<String, Float> startRelationships = new HashMap<String, Float>();
    public Map<String, Float> diplomacyPositiveChance = new HashMap<String, Float>();
    public Map<String, Float> diplomacyNegativeChance = new HashMap<String, Float>();
    public Map<Alliance.Alignment, Float> alignments = new HashMap<Alliance.Alignment, Float>(DEFAULT_ALIGNMENTS);
    public Morality morality = Morality.NEUTRAL;
    public float marketSpawnWeight = 1.0f;
    public boolean freeMarket = false;
    public float tariffMult = 1.0f;
    public float invasionStrengthBonusAttack = 0.0f;
    public float invasionStrengthBonusDefend = 0.0f;
    public float invasionFleetSizeMod = 0.0f;
    public float responseFleetSizeMod = 0.0f;
    public float invasionPointMult = 1.0f;
    public float patrolSizeMult = 1.0f;
    public String factionIdForHqResponse = null;
    public boolean dropPrisoners = true;
    public boolean noHomeworld = false;
    public boolean showIntelEvenIfDead = false;
    public boolean allowAgentActions = true;
    public boolean allowPrisonerActions = true;
    public List<String> customStations = new ArrayList<String>();
    public List<String> miningVariantsOrWings = new ArrayList<String>();
    public Map<StartFleetType, List<String>> startShips = new HashMap<StartFleetType, List<String>>();

    public ExerelinFactionConfig(String factionId) {
        this.factionId = factionId;
        this.loadFactionConfig();
    }

    public void loadFactionConfig() {
        try {
            JSONObject settings = Global.getSettings().loadJSON("data/config/exerelinFactionConfig/" + this.factionId + ".json");
            this.playableFaction = settings.optBoolean("playableFaction", true);
            this.corvusCompatible = settings.optBoolean("corvusCompatible", false);
            this.pirateFaction = settings.optBoolean("pirateFaction", false);
            this.isPirateNeutral = settings.optBoolean("isPirateNeutral", false);
            this.spawnPatrols = settings.optBoolean("spawnPatrols", true);
            this.hostileToAll = settings.optInt("hostileToAll", this.hostileToAll);
            this.baseFleetCostMultiplier = settings.optDouble("baseFleetCostMultiplier", 1.0);
            this.customRebelFaction = settings.optString("customRebelFaction", this.customRebelFaction);
            this.customRebelFleetId = settings.optString("customRebelFleetId", this.customRebelFleetId);
            this.rebelFleetSuffix = settings.optString("rebelFleetSuffix", this.rebelFleetSuffix);
            this.asteroidMiningFleetName = settings.optString("asteroidMiningFleetName", this.asteroidMiningFleetName);
            this.gasMiningFleetName = settings.optString("gasMiningFleetName", this.gasMiningFleetName);
            this.logisticsFleetName = settings.optString("logisticsFleetName", this.logisticsFleetName);
            this.invasionFleetName = settings.optString("invasionFleetName", this.invasionFleetName);
            this.invasionSupportFleetName = settings.optString("invasionSupportFleetName", this.invasionSupportFleetName);
            this.defenceFleetName = settings.optString("defenceFleetName", this.defenceFleetName);
            this.responseFleetName = settings.optString("responseFleetName", this.responseFleetName);
            this.positiveDiplomacyExtra = settings.optInt("positiveDiplomacyExtra");
            this.negativeDiplomacyExtra = settings.optInt("negativeDiplomacyExtra");
            this.freeMarket = settings.optBoolean("freeMarket", this.freeMarket);
            this.marketSpawnWeight = (float)settings.optDouble("marketSpawnWeight", (double)this.marketSpawnWeight);
            this.tariffMult = (float)settings.optDouble("tariffMult", (double)this.tariffMult);
            this.invasionStrengthBonusAttack = (float)settings.optDouble("invasionStrengthBonusAttack", 0.0);
            this.invasionStrengthBonusDefend = (float)settings.optDouble("invasionStrengthBonusDefend", 0.0);
            this.invasionFleetSizeMod = (float)settings.optDouble("invasionFleetSizeMod", 0.0);
            this.responseFleetSizeMod = (float)settings.optDouble("responseFleetSizeMod", 0.0);
            this.invasionPointMult = (float)settings.optDouble("invasionPointMult", 1.0);
            this.patrolSizeMult = (float)settings.optDouble("patrolSizeMult", 1.0);
            this.factionIdForHqResponse = settings.optString("factionIdForHqResponse", this.factionIdForHqResponse);
            this.dropPrisoners = settings.optBoolean("dropPrisoners", this.dropPrisoners);
            this.noHomeworld = settings.optBoolean("noHomeworld", this.noHomeworld);
            this.showIntelEvenIfDead = settings.optBoolean("showIntelEvenIfDead", this.showIntelEvenIfDead);
            this.allowAgentActions = settings.optBoolean("allowAgentActions", this.allowAgentActions);
            this.allowPrisonerActions = settings.optBoolean("allowPrisonerActions", this.allowPrisonerActions);
            if (settings.has("miningVariantsOrWings")) {
                this.miningVariantsOrWings = Arrays.asList(this.JSONArrayToStringArray(settings.getJSONArray("miningVariantsOrWings")));
            }
            if (settings.has("customStations")) {
                this.customStations = Arrays.asList(this.JSONArrayToStringArray(settings.getJSONArray("customStations")));
            }
            if (settings.has("factionsLiked")) {
                this.factionsLiked = this.JSONArrayToStringArray(settings.getJSONArray("factionsLiked"));
            }
            if (settings.has("factionsDisliked")) {
                this.factionsDisliked = this.JSONArrayToStringArray(settings.getJSONArray("factionsDisliked"));
            }
            if (settings.has("factionsNeutral")) {
                this.factionsNeutral = this.JSONArrayToStringArray(settings.getJSONArray("factionsNeutral"));
            }
            this.fillRelationshipMap(settings, this.minRelationships, "minRelationships");
            this.fillRelationshipMap(settings, this.maxRelationships, "maxRelationships");
            this.fillRelationshipMap(settings, this.startRelationships, "startRelationships");
            this.fillRelationshipMap(settings, this.diplomacyPositiveChance, "diplomacyPositiveChance");
            this.fillRelationshipMap(settings, this.diplomacyNegativeChance, "diplomacyNegativeChance");
            if (!this.diplomacyPositiveChance.containsKey("default")) {
                this.diplomacyPositiveChance.put("default", Float.valueOf(1.0f));
            }
            if (!this.diplomacyNegativeChance.containsKey("default")) {
                this.diplomacyNegativeChance.put("default", Float.valueOf(1.0f));
            }
            if (settings.has("morality")) {
                try {
                    String moralityName = StringHelper.flattenToAscii(settings.getString("morality").toUpperCase());
                    this.morality = Morality.valueOf(moralityName);
                }
                catch (IllegalArgumentException ex) {
                    Global.getLogger(this.getClass()).warn((Object)("Invalid morality entry for faction " + this.factionId + ": " + settings.getString("morality")));
                }
            } else if (this.pirateFaction) {
                this.morality = Morality.EVIL;
            } else if (this.isPirateNeutral) {
                this.morality = Morality.AMORAL;
            }
            if (settings.has("alignments")) {
                JSONObject alignmentsJson = settings.getJSONObject("alignments");
                Iterator keys = alignmentsJson.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    float value = (float)alignmentsJson.optDouble(key, 0.0);
                    String alignmentName = StringHelper.flattenToAscii(key.toUpperCase());
                    try {
                        Alliance.Alignment alignment = Alliance.Alignment.valueOf(alignmentName);
                        this.alignments.put(alignment, Float.valueOf(value));
                    }
                    catch (IllegalArgumentException ex) {
                        Global.getLogger(this.getClass()).warn((Object)("Invalid alignment entry for faction " + this.factionId + ": " + key));
                    }
                }
            }
            this.loadStartShips(settings);
        }
        catch (IOException | JSONException ex) {
            Global.getLogger(this.getClass()).error((Object)("Failed to load faction config for " + this.factionId + ": " + ex));
        }
        if (this.miningVariantsOrWings.isEmpty()) {
            this.miningVariantsOrWings = Arrays.asList(DEFAULT_MINERS);
        }
    }

    void fillRelationshipMap(JSONObject factionSettings, Map<String, Float> map, String configKey) {
        try {
            if (!factionSettings.has(configKey)) {
                return;
            }
            JSONObject json = factionSettings.getJSONObject(configKey);
            Iterator keys = json.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                float value = (float)json.getDouble(key);
                map.put(key, Float.valueOf(value));
            }
        }
        catch (Exception ex) {
            Global.getLogger(this.getClass()).error((Object)("Failed to load diplomacy map " + configKey), (Throwable)ex);
        }
    }

    float getMaxRelationship(String factionId) {
        if (!this.maxRelationships.containsKey(factionId)) {
            return 1.0f;
        }
        return this.maxRelationships.get(factionId).floatValue();
    }

    float getMinRelationship(String factionId) {
        if (!this.minRelationships.containsKey(factionId)) {
            return -1.0f;
        }
        return this.minRelationships.get(factionId).floatValue();
    }

    public static float getMaxRelationship(String factionId1, String factionId2) {
        float max1 = ExerelinConfig.getExerelinFactionConfig(factionId1).getMaxRelationship(factionId2);
        float max2 = ExerelinConfig.getExerelinFactionConfig(factionId2).getMaxRelationship(factionId1);
        return Math.min(max1, max2);
    }

    public static float getMinRelationship(String factionId1, String factionId2) {
        float min1 = ExerelinConfig.getExerelinFactionConfig(factionId1).getMinRelationship(factionId2);
        float min2 = ExerelinConfig.getExerelinFactionConfig(factionId2).getMinRelationship(factionId1);
        return Math.max(min1, min2);
    }

    float getDiplomacyPositiveChance(String factionId) {
        if (this.diplomacyPositiveChance.containsKey(factionId)) {
            return this.diplomacyPositiveChance.get(factionId).floatValue();
        }
        if (this.diplomacyPositiveChance.containsKey("default")) {
            return this.diplomacyPositiveChance.get("default").floatValue();
        }
        return 1.0f;
    }

    float getDiplomacyNegativeChance(String factionId) {
        if (this.diplomacyNegativeChance.containsKey(factionId)) {
            return this.diplomacyNegativeChance.get(factionId).floatValue();
        }
        if (this.diplomacyNegativeChance.containsKey("default")) {
            return this.diplomacyNegativeChance.get("default").floatValue();
        }
        return 1.0f;
    }

    public static float getDiplomacyPositiveChance(String factionId1, String factionId2) {
        float chance1mod = ExerelinConfig.getExerelinFactionConfig(factionId1).getDiplomacyPositiveChance(factionId2) - 1.0f;
        float chance2mod = ExerelinConfig.getExerelinFactionConfig(factionId2).getDiplomacyPositiveChance(factionId1) - 1.0f;
        if (Math.abs(chance1mod) > Math.abs(chance2mod)) {
            return chance1mod + 1.0f;
        }
        return chance2mod + 1.0f;
    }

    public static float getDiplomacyNegativeChance(String factionId1, String factionId2) {
        float chance1mod = ExerelinConfig.getExerelinFactionConfig(factionId1).getDiplomacyNegativeChance(factionId2) - 1.0f;
        float chance2mod = ExerelinConfig.getExerelinFactionConfig(factionId2).getDiplomacyNegativeChance(factionId1) - 1.0f;
        if (Math.abs(chance1mod) > Math.abs(chance2mod)) {
            return chance1mod + 1.0f;
        }
        return chance2mod + 1.0f;
    }

    public static boolean canCeasefire(String factionId1, String factionId2) {
        if (ExerelinConfig.useRelationshipBounds && (double)ExerelinFactionConfig.getMaxRelationship(factionId1, factionId2) < -0.5) {
            return false;
        }
        return !(ExerelinFactionConfig.getDiplomacyPositiveChance(factionId1, factionId2) <= 0.0f);
    }

    public void getStartShipTypeIfAvailable(JSONObject settings, String key, StartFleetType type) throws JSONException {
        if (settings.has(key)) {
            this.startShips.put(type, ExerelinUtils.JSONArrayToArrayList(settings.getJSONArray(key)));
        }
    }

    public void loadStartShips(JSONObject settings) throws JSONException {
        this.getStartShipTypeIfAvailable(settings, "startShipsSolo", StartFleetType.SOLO);
        this.getStartShipTypeIfAvailable(settings, "startShipsSoloSSP", StartFleetType.SOLO_SSP);
        this.getStartShipTypeIfAvailable(settings, "startShipsCombatSmall", StartFleetType.COMBAT_SMALL);
        this.getStartShipTypeIfAvailable(settings, "startShipsCombatSmallSSP", StartFleetType.COMBAT_SMALL_SSP);
        this.getStartShipTypeIfAvailable(settings, "startShipsTradeSmall", StartFleetType.TRADE_SMALL);
        this.getStartShipTypeIfAvailable(settings, "startShipsTradeSmallSSP", StartFleetType.TRADE_SMALL_SSP);
        this.getStartShipTypeIfAvailable(settings, "startShipsCombatLarge", StartFleetType.COMBAT_LARGE);
        this.getStartShipTypeIfAvailable(settings, "startShipsCombatLargeSSP", StartFleetType.COMBAT_LARGE_SSP);
        this.getStartShipTypeIfAvailable(settings, "startShipsTradeLarge", StartFleetType.TRADE_LARGE);
        this.getStartShipTypeIfAvailable(settings, "startShipsTradeLargeSSP", StartFleetType.TRADE_LARGE_SSP);
    }

    protected void pickShipsAndAddToList(WeightedRandomPicker<String> picker, List<String> list, boolean clear) {
        FactionAPI faction = Global.getSector().getFaction(this.factionId);
        List picks = faction.pickShip((String)picker.pick(), 1.0f, picker.getRandom());
        for (ShipRolePick pick : picks) {
            list.add(pick.variantId);
        }
        if (clear) {
            picker.clear();
        }
    }

    protected List<String> getRandomStartShipsForTypeTemplars(StartFleetType type) {
        ArrayList<String> ships = new ArrayList<String>();
        WeightedRandomPicker rolePicker = new WeightedRandomPicker();
        if (type == StartFleetType.COMBAT_LARGE || type == StartFleetType.COMBAT_LARGE_SSP) {
            rolePicker.add((Object)"combatMedium", 1.0f);
            rolePicker.add((Object)"escortMedium", 1.0f);
            this.pickShipsAndAddToList((WeightedRandomPicker<String>)rolePicker, ships, true);
            rolePicker.add((Object)"escortSmall", 2.0f);
            rolePicker.add((Object)"combatSmall", 1.0f);
            rolePicker.add((Object)"fastAttack", 1.0f);
            this.pickShipsAndAddToList((WeightedRandomPicker<String>)rolePicker, ships, true);
            rolePicker.add((Object)"fastAttack", 2.0f);
            this.pickShipsAndAddToList((WeightedRandomPicker<String>)rolePicker, ships, true);
        } else if (type == StartFleetType.COMBAT_SMALL || type == StartFleetType.COMBAT_SMALL_SSP) {
            rolePicker.add((Object)"escortSmall", 2.0f);
            this.pickShipsAndAddToList((WeightedRandomPicker<String>)rolePicker, ships, true);
            rolePicker.add((Object)"combatSmall", 1.0f);
            rolePicker.add((Object)"fastAttack", 1.0f);
            this.pickShipsAndAddToList((WeightedRandomPicker<String>)rolePicker, ships, true);
        } else if (type == StartFleetType.SOLO || type == StartFleetType.SOLO_SSP) {
            rolePicker.add((Object)"fastAttack", 1.0f);
            this.pickShipsAndAddToList((WeightedRandomPicker<String>)rolePicker, ships, true);
        }
        return ships;
    }

    protected List<String> getRandomStartShipsForType(StartFleetType type) {
        if (this.factionId.equals("templars")) {
            return this.getRandomStartShipsForTypeTemplars(type);
        }
        ArrayList<String> ships = new ArrayList<String>();
        WeightedRandomPicker rolePicker = new WeightedRandomPicker();
        if (type == StartFleetType.COMBAT_LARGE || type == StartFleetType.COMBAT_LARGE_SSP) {
            rolePicker.add((Object)"combatLarge", 1.0f);
            this.pickShipsAndAddToList((WeightedRandomPicker<String>)rolePicker, ships, true);
            rolePicker.add((Object)"combatMedium", 2.0f);
            rolePicker.add((Object)"combatFreighterMedium", 1.0f);
            rolePicker.add((Object)"escortMedium", 1.0f);
            this.pickShipsAndAddToList((WeightedRandomPicker<String>)rolePicker, ships, true);
            rolePicker.add((Object)"combatSmall", 2.0f);
            rolePicker.add((Object)"escortSmall", 1.0f);
            rolePicker.add((Object)"fastAttack", 1.0f);
            rolePicker.add((Object)"combatFreighterSmall", 1.0f);
            this.pickShipsAndAddToList((WeightedRandomPicker<String>)rolePicker, ships, true);
        } else if (type == StartFleetType.TRADE_LARGE || type == StartFleetType.TRADE_LARGE_SSP) {
            rolePicker.add((Object)"combatFreighterLarge", 1.0f);
            rolePicker.add((Object)"freighterLarge", 1.0f);
            this.pickShipsAndAddToList((WeightedRandomPicker<String>)rolePicker, ships, true);
            rolePicker.add((Object)"combatMedium", 1.0f);
            rolePicker.add((Object)"combatFreighterMedium", 2.0f);
            rolePicker.add((Object)"escortMedium", 2.0f);
            rolePicker.add((Object)"freighterMedium", 3.0f);
            this.pickShipsAndAddToList((WeightedRandomPicker<String>)rolePicker, ships, true);
            rolePicker.add((Object)"escortSmall", 1.0f);
            rolePicker.add((Object)"fastAttack", 1.0f);
            rolePicker.add((Object)"combatFreighterSmall", 1.0f);
            rolePicker.add((Object)"freighterSmall", 1.0f);
            this.pickShipsAndAddToList((WeightedRandomPicker<String>)rolePicker, ships, true);
        } else if (type == StartFleetType.COMBAT_SMALL || type == StartFleetType.COMBAT_SMALL_SSP) {
            rolePicker.add((Object)"combatMedium", 2.0f);
            rolePicker.add((Object)"escortMedium", 1.0f);
            this.pickShipsAndAddToList((WeightedRandomPicker<String>)rolePicker, ships, true);
            rolePicker.add((Object)"combatSmall", 3.0f);
            rolePicker.add((Object)"escortSmall", 2.0f);
            rolePicker.add((Object)"fastAttack", 2.0f);
            rolePicker.add((Object)"combatFreighterSmall", 1.0f);
            this.pickShipsAndAddToList((WeightedRandomPicker<String>)rolePicker, ships, true);
            rolePicker.add((Object)"combatSmall", 2.0f);
            rolePicker.add((Object)"escortSmall", 2.0f);
            rolePicker.add((Object)"fastAttack", 2.0f);
            rolePicker.add((Object)"combatFreighterSmall", 1.0f);
            this.pickShipsAndAddToList((WeightedRandomPicker<String>)rolePicker, ships, true);
        } else if (type == StartFleetType.TRADE_SMALL || type == StartFleetType.TRADE_SMALL_SSP) {
            rolePicker.add((Object)"combatFreighterMedium", 2.0f);
            rolePicker.add((Object)"freighterMedium", 3.0f);
            this.pickShipsAndAddToList((WeightedRandomPicker<String>)rolePicker, ships, true);
            rolePicker.add((Object)"escortSmall", 1.0f);
            rolePicker.add((Object)"fastAttack", 1.0f);
            rolePicker.add((Object)"combatFreighterSmall", 2.0f);
            rolePicker.add((Object)"freighterSmall", 2.0f);
            this.pickShipsAndAddToList((WeightedRandomPicker<String>)rolePicker, ships, true);
            rolePicker.add((Object)"escortSmall", 1.0f);
            rolePicker.add((Object)"fastAttack", 1.0f);
            rolePicker.add((Object)"combatFreighterSmall", 1.0f);
            rolePicker.add((Object)"freighterSmall", 1.0f);
            this.pickShipsAndAddToList((WeightedRandomPicker<String>)rolePicker, ships, true);
        } else if (type == StartFleetType.SOLO || type == StartFleetType.SOLO_SSP) {
            rolePicker.add((Object)"combatSmall", 2.0f);
            rolePicker.add((Object)"escortSmall", 1.0f);
            rolePicker.add((Object)"fastAttack", 1.0f);
            this.pickShipsAndAddToList((WeightedRandomPicker<String>)rolePicker, ships, true);
        }
        return ships;
    }

    protected boolean isStartingShipSetValid(List<String> ships) {
        for (String variantId : ships) {
            FleetMemberAPI temp;
            FleetMemberType type = FleetMemberType.SHIP;
            if (variantId.endsWith("_wing")) {
                type = FleetMemberType.FIGHTER_WING;
            }
            if ((temp = Global.getFactory().createFleetMember(type, variantId)).isFighterWing() || !(temp.getCargoCapacity() > 0.0f) || !(temp.getFuelCapacity() > 0.0f)) continue;
            return true;
        }
        return false;
    }

    public List<String> getStartShipsForType(String typeStr, boolean allowFallback) {
        StartFleetType type = StartFleetType.valueOf(typeStr.toUpperCase());
        StartFleetType typeSSP = StartFleetType.valueOf((typeStr + "_SSP").toUpperCase());
        boolean useSSPShips = false;
        useSSPShips = this.factionId.equals("pirates") ? ExerelinModPlugin.HAVE_UNDERWORLD : ExerelinModPlugin.HAVE_SWP;
        if (ExerelinSetupData.getInstance().randomStartShips && (this.startShips.containsKey((Object)type) || this.startShips.containsKey((Object)typeSSP))) {
            boolean valid = false;
            List<String> result = null;
            for (int tries = 0; !valid && tries < 10; ++tries) {
                result = this.getRandomStartShipsForType(type);
                valid = this.isStartingShipSetValid(result);
            }
            if (valid) {
                return result;
            }
        }
        if (useSSPShips && this.startShips.containsKey((Object)typeSSP)) {
            return this.startShips.get((Object)typeSSP);
        }
        if (this.startShips.containsKey((Object)type)) {
            return this.startShips.get((Object)type);
        }
        if (!allowFallback) {
            return null;
        }
        if (this.startShips.containsKey((Object)StartFleetType.SOLO)) {
            return this.startShips.get((Object)StartFleetType.SOLO);
        }
        return Arrays.asList("wolf_Starting");
    }

    private String[] JSONArrayToStringArray(JSONArray jsonArray) {
        try {
            String[] ret = new String[jsonArray.length()];
            for (int i = 0; i < jsonArray.length(); ++i) {
                ret[i] = jsonArray.getString(i);
            }
            return ret;
        }
        catch (Exception e) {
            Global.getLogger(ExerelinFactionConfig.class).warn((Object)e);
            return new String[0];
        }
    }

    static {
        for (Alliance.Alignment alignment : Alliance.Alignment.values()) {
            DEFAULT_ALIGNMENTS.put(alignment, Float.valueOf(0.0f));
        }
    }

    public static enum Morality {
        GOOD,
        NEUTRAL,
        AMORAL,
        EVIL;

    }

    public static enum StartFleetType {
        SOLO,
        SOLO_SSP,
        COMBAT_SMALL,
        COMBAT_SMALL_SSP,
        TRADE_SMALL,
        TRADE_SMALL_SSP,
        COMBAT_LARGE,
        COMBAT_LARGE_SSP,
        TRADE_LARGE,
        TRADE_LARGE_SSP;

    }
}

