/*
 * Decompiled with CFR 0.152.
 */
package exerelin.utilities;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignEventListener;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.util.Misc;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.lazywizard.lazylib.MathUtils;
import org.lwjgl.util.vector.Vector2f;

public class ExerelinUtils {
    public static long getStartingSeed() {
        String seedStr = Global.getSector().getSeedString().replaceAll("[^0-9]", "");
        return Long.parseLong(seedStr);
    }

    public static int randomNextIntInclusive(Random rand, int max) {
        return rand.nextInt(max + 1);
    }

    public static int getRandomNearestInteger(float number) {
        if (number >= 0.0f) {
            return (int)((double)number + Math.random());
        }
        return (int)((double)number - Math.random());
    }

    public static Object getRandomArrayElement(Object[] array) {
        if (array.length == 0) {
            return null;
        }
        int randomIndex = MathUtils.getRandomNumberInRange((int)0, (int)(array.length - 1));
        return array[randomIndex];
    }

    public static Object getRandomListElement(List list) {
        if (list.isEmpty()) {
            return null;
        }
        int randomIndex = MathUtils.getRandomNumberInRange((int)0, (int)(list.size() - 1));
        return list.get(randomIndex);
    }

    public static Object getRandomListElement(List list, Random rand) {
        if (list.isEmpty()) {
            return null;
        }
        int randomIndex = rand.nextInt(list.size());
        return list.get(randomIndex);
    }

    public static float lerp(float x, float y, float alpha) {
        return (1.0f - alpha) * x + alpha * y;
    }

    public static MarketAPI getClosestMarket(String factionId) {
        List markets = Global.getSector().getEconomy().getMarketsCopy();
        FactionAPI faction = Global.getSector().getFaction(factionId);
        CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        MarketAPI closestMarket = null;
        float closestDist = 999999.0f;
        Vector2f playerLoc = playerFleet.getLocationInHyperspace();
        for (MarketAPI market : markets) {
            float dist = Misc.getDistance((Vector2f)market.getLocationInHyperspace(), (Vector2f)playerLoc);
            if (!(dist < closestDist) || market.getFaction() != faction) continue;
            closestMarket = market;
            closestDist = dist;
        }
        return closestMarket;
    }

    public static String[] JSONArrayToStringArray(JSONArray jsonArray) {
        try {
            return jsonArray.toString().substring(1, jsonArray.toString().length() - 1).replaceAll("\"", "").split(",");
        }
        catch (Exception exception) {
            return new String[0];
        }
    }

    public static ArrayList<String> JSONArrayToArrayList(JSONArray jsonArray) {
        try {
            ArrayList<String> ret = new ArrayList<String>();
            for (int i = 0; i < jsonArray.length(); ++i) {
                ret.add(jsonArray.getString(i));
            }
            return ret;
        }
        catch (Exception exception) {
            return new ArrayList<String>();
        }
    }

    public static Map jsonToMap(JSONObject json) throws JSONException {
        Map retMap = new HashMap();
        if (json != JSONObject.NULL) {
            retMap = ExerelinUtils.toMap(json);
        }
        return retMap;
    }

    public static Map toMap(JSONObject object) throws JSONException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Iterator keysItr = object.keys();
        while (keysItr.hasNext()) {
            String key = (String)keysItr.next();
            Object value = object.get(key);
            if (value instanceof JSONArray) {
                value = ExerelinUtils.toList((JSONArray)value);
            } else if (value instanceof JSONObject) {
                value = ExerelinUtils.toMap((JSONObject)value);
            }
            map.put(key, value);
        }
        return map;
    }

    public static List toList(JSONArray array) throws JSONException {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < array.length(); ++i) {
            Object value = array.get(i);
            if (value instanceof JSONArray) {
                value = ExerelinUtils.toList((JSONArray)value);
            } else if (value instanceof JSONObject) {
                value = ExerelinUtils.toMap((JSONObject)value);
            }
            list.add(value);
        }
        return list;
    }

    public static void removeScriptAndListener(SectorEntityToken entity, Class<?> oldClass, Class<?> newClass) {
        CampaignEventListener listener = null;
        for (CampaignEventListener l : Global.getSector().getAllListeners()) {
            if (!oldClass.isInstance(l) || newClass != null && newClass.isInstance(l)) continue;
            listener = l;
            break;
        }
        if (listener != null) {
            Global.getSector().removeListener(listener);
        }
        entity.removeScriptsOfClass(oldClass);
    }

    public static void removeScriptAndListener(LocationAPI loc, Class<?> oldClass, Class<?> newClass) {
        CampaignEventListener listener = null;
        for (CampaignEventListener l : Global.getSector().getAllListeners()) {
            if (!oldClass.isInstance(l) || newClass != null && newClass.isInstance(l)) continue;
            listener = l;
            break;
        }
        if (listener != null) {
            Global.getSector().removeListener(listener);
        }
        loc.removeScriptsOfClass(oldClass);
    }
}

