/*
 * Decompiled with CFR 0.152.
 */
package exerelin.utilities;

import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.OrbitAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.Random;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.campaign.orbits.EllipticalOrbit;
import org.lwjgl.util.vector.Vector2f;

public class ExerelinUtilsAstro {
    public static float getOrbitalPeriod(float primaryRadius, float orbitRadius, float density) {
        if (density == 0.0f) {
            return 1.0E8f;
        }
        primaryRadius = (float)((double)primaryRadius * 0.01);
        orbitRadius = (float)((double)orbitRadius * 0.016);
        float mass = (float)Math.floor(4.1887903296220665 * Math.pow(primaryRadius, 3.0));
        float radiusCubed = (float)Math.pow(orbitRadius, 3.0);
        float period = (float)(Math.PI * 2 * Math.sqrt(radiusCubed / (mass *= density)) * 2.0);
        return period;
    }

    public static float getOrbitalPeriod(SectorEntityToken primary, float orbitRadius) {
        return ExerelinUtilsAstro.getOrbitalPeriod(primary.getRadius(), orbitRadius, ExerelinUtilsAstro.getDensity(primary));
    }

    public static float getDensity(SectorEntityToken primary) {
        if (primary instanceof PlanetAPI) {
            PlanetAPI planet = (PlanetAPI)primary;
            if (planet.getSpec().isNebulaCenter()) {
                return 0.0f;
            }
            if (planet.getSpec().isBlackHole()) {
                return 16.0f;
            }
            if (planet.getTypeId().equals("star_dark") || planet.getSpec().isPulsar()) {
                return 8.0f;
            }
            if (planet.isStar()) {
                return 0.5f;
            }
            if (planet.isGasGiant()) {
                return 0.5f;
            }
        }
        return 2.0f;
    }

    public static float getRandomAngle() {
        return MathUtils.getRandomNumberInRange((float)0.0f, (float)360.0f);
    }

    public static float getRandomAngle(Random rand) {
        return rand.nextFloat() * 360.0f;
    }

    public static void setOrbit(SectorEntityToken entity, SectorEntityToken primary, float orbitRadius, boolean isEllipse, float ellipseAngle, float orbitPeriod) {
        ExerelinUtilsAstro.setOrbit(entity, primary, orbitRadius, ExerelinUtilsAstro.getRandomAngle(), isEllipse, ellipseAngle, MathUtils.getRandomNumberInRange((float)1.0f, (float)1.2f), orbitPeriod);
    }

    public static void setOrbit(SectorEntityToken entity, SectorEntityToken primary, float orbitRadius, float angle, boolean isEllipse, float ellipseAngle, float ellipseMult, float orbitPeriod, int type, float spinTime) {
        angle = MathUtils.clampAngle((float)angle);
        if (isEllipse) {
            float semiMajor = (int)(orbitRadius * ellipseMult);
            float semiMinor = (int)(orbitRadius / ellipseMult);
            EllipticalOrbit ellipseOrbit = new EllipticalOrbit(primary, angle, semiMinor, semiMajor, ellipseAngle, orbitPeriod);
            entity.setOrbit((OrbitAPI)ellipseOrbit);
        } else if (type == 1) {
            entity.setCircularOrbitPointingDown(primary, angle, orbitRadius, orbitPeriod);
        } else if (type == 2) {
            entity.setCircularOrbitWithSpin(primary, angle, orbitRadius, orbitPeriod, spinTime, spinTime);
        } else {
            entity.setCircularOrbit(primary, angle, orbitRadius, orbitPeriod);
        }
    }

    public static void setOrbit(SectorEntityToken entity, SectorEntityToken primary, float orbitRadius, float angle, boolean isEllipse, float ellipseAngle, float ellipseMult, float orbitPeriod) {
        ExerelinUtilsAstro.setOrbit(entity, primary, orbitRadius, angle, isEllipse, ellipseAngle, ellipseMult, orbitPeriod, 0, 0.0f);
    }

    public static void setLagrangeOrbit(SectorEntityToken orbiter, SectorEntityToken m1, SectorEntityToken m2, int point, float m2Angle, float m2OrbitRadius, float myOrbitRadius, float orbitPeriod, boolean isEllipse, float ellipseAngle, float ellipseMult, int type, float spinTime) {
        if (point <= 0 || point > 5) {
            throw new IllegalArgumentException("Point must be in range 1-5");
        }
        switch (point) {
            case 1: 
            case 2: {
                float angle = m2Angle;
                if (point == 1) {
                    angle += 180.0f;
                }
                ExerelinUtilsAstro.setOrbit(orbiter, m2, myOrbitRadius, angle, isEllipse, ellipseAngle, ellipseMult, orbitPeriod, type, spinTime);
                break;
            }
            case 3: {
                ExerelinUtilsAstro.setOrbit(orbiter, m1, m2OrbitRadius, m2Angle + 180.0f, isEllipse, ellipseAngle, ellipseMult, orbitPeriod, type, spinTime);
                break;
            }
            case 4: 
            case 5: {
                float offset = -60.0f;
                if (point == 5) {
                    offset = 60.0f;
                }
                ExerelinUtilsAstro.setOrbit(orbiter, m1, m2OrbitRadius, m2Angle + offset, isEllipse, ellipseAngle, ellipseMult, orbitPeriod, type, spinTime);
            }
        }
    }

    public static void setLagrangeOrbit(SectorEntityToken orbiter, SectorEntityToken m1, SectorEntityToken m2, int point, float m2Angle, float m2OrbitRadius, float myOrbitRadius, float orbitPeriod, boolean isEllipse, float ellipseAngle, float ellipseMult) {
        ExerelinUtilsAstro.setLagrangeOrbit(orbiter, m1, m2, point, m2Angle, m2OrbitRadius, myOrbitRadius, orbitPeriod, isEllipse, ellipseAngle, ellipseMult, 0, 0.0f);
    }

    public static float getCurrentOrbitAngle(SectorEntityToken primary, SectorEntityToken orbiter) {
        return Misc.getAngleInDegrees((Vector2f)orbiter.getLocation(), (Vector2f)primary.getLocation());
    }

    public static float getCurrentOrbitRadius(SectorEntityToken primary, SectorEntityToken orbiter) {
        return Misc.getDistance((Vector2f)primary.getLocation(), (Vector2f)orbiter.getLocation());
    }

    public static void addAsteroidBelt(LocationAPI system, SectorEntityToken planet, int numAsteroids, float orbitRadius, float width, float minOrbitDays, float maxOrbitDays) {
        if (minOrbitDays < 0.0f) {
            minOrbitDays *= -1.0f;
        }
        if (maxOrbitDays < 0.0f) {
            maxOrbitDays *= -1.0f;
        }
        system.addAsteroidBelt(planet, numAsteroids, orbitRadius, width, minOrbitDays, maxOrbitDays);
        system.addRingBand(planet, "misc", "rings1", 256.0f, 2, Color.white, 256.0f, orbitRadius + width / 4.0f, (minOrbitDays + maxOrbitDays) / 2.0f);
        system.addRingBand(planet, "misc", "rings1", 256.0f, 2, Color.white, 256.0f, orbitRadius - width / 4.0f, (minOrbitDays + maxOrbitDays) / 2.0f);
    }

    public static SectorEntityToken addRingBand(StarSystemAPI system, SectorEntityToken focus, String category, String key, float bandWidthInTexture, int bandIndex, Color color, float bandWidthInEngine, float middleRadius, float orbitPeriodMult, boolean useTerrain) {
        float orbitPeriod = ExerelinUtilsAstro.getOrbitalPeriod(focus, middleRadius);
        if (orbitPeriod < 0.0f) {
            orbitPeriod *= -1.0f;
        }
        if (useTerrain) {
            return system.addRingBand(focus, category, key, bandWidthInTexture, bandIndex, color, bandWidthInEngine, middleRadius, orbitPeriod * orbitPeriodMult, "ring", null);
        }
        return system.addRingBand(focus, category, key, bandWidthInTexture, bandIndex, color, bandWidthInEngine, middleRadius, orbitPeriod * orbitPeriodMult);
    }

    public static SectorEntityToken addRingBand(StarSystemAPI system, SectorEntityToken focus, String category, String key, float bandWidthInTexture, int bandIndex, Color color, float bandWidthInEngine, float middleRadius, float orbitPeriodMult) {
        return ExerelinUtilsAstro.addRingBand(system, focus, category, key, bandWidthInTexture, bandIndex, color, bandWidthInEngine, middleRadius, orbitPeriodMult, false);
    }
}

