/*
 * Decompiled with CFR 0.152.
 */
package exerelin.utilities;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.SectorAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.events.CampaignEventPlugin;
import com.fs.starfarer.api.impl.campaign.missions.FactionCommissionMission;
import com.fs.starfarer.api.util.Misc;
import exerelin.campaign.SectorManager;
import exerelin.campaign.events.ExerelinFactionCommissionMissionEvent;
import exerelin.utilities.ExerelinConfig;
import exerelin.utilities.ExerelinFactionConfig;
import java.util.ArrayList;
import java.util.List;

public class ExerelinUtilsFaction {
    @Deprecated
    public static boolean doesFactionOwnSystem(String factionId, StarSystemAPI system) {
        for (MarketAPI market : Misc.getMarketsInLocation((LocationAPI)system)) {
            if (market.getFaction().getId().equalsIgnoreCase(factionId) || market.getFaction().getId().equalsIgnoreCase("neutral") || market.getFaction().getId().equalsIgnoreCase("independent")) continue;
            return false;
        }
        return true;
    }

    public static boolean doesFactionExist(String factionId) {
        return Global.getSector().getFaction(factionId) != null;
    }

    public static List<MarketAPI> getFactionMarkets(String factionId) {
        return ExerelinUtilsFaction.getFactionMarkets(factionId, false);
    }

    public static boolean hasAnyMarkets(String factionId) {
        List allMarkets = Global.getSector().getEconomy().getMarketsCopy();
        for (MarketAPI market : allMarkets) {
            if (!market.getFactionId().equals(factionId)) continue;
            return true;
        }
        return false;
    }

    public static List<MarketAPI> getFactionMarkets(String factionId, boolean onlyInvadable) {
        List allMarkets = Global.getSector().getEconomy().getMarketsCopy();
        ArrayList<MarketAPI> ret = new ArrayList<MarketAPI>();
        for (MarketAPI market : allMarkets) {
            if (onlyInvadable && market.getMemoryWithoutUpdate().getBoolean("$nex_uninvadable") || !market.getFactionId().equals(factionId)) continue;
            ret.add(market);
        }
        return ret;
    }

    public static int getFactionMarketSizeSum(String factionId) {
        List allMarkets = Global.getSector().getEconomy().getMarketsCopy();
        int pop = 0;
        for (MarketAPI market : allMarkets) {
            if (!market.getFactionId().equals(factionId)) continue;
            pop += market.getSize();
        }
        return pop;
    }

    public static String getFactionShortName(String factionId) {
        return ExerelinUtilsFaction.getFactionShortName(Global.getSector().getFaction(factionId));
    }

    public static String getFactionShortName(FactionAPI faction) {
        String name = faction.getEntityNamePrefix();
        if (name == null || name.isEmpty()) {
            name = faction.getDisplayName();
        }
        return name;
    }

    public static boolean isPirateFaction(String factionId) {
        ExerelinFactionConfig config = ExerelinConfig.getExerelinFactionConfig(factionId);
        if (config == null) {
            return false;
        }
        return config.pirateFaction;
    }

    public static boolean isPirateOrTemplarFaction(String factionId) {
        if (factionId.equals("templars")) {
            return true;
        }
        return ExerelinUtilsFaction.isPirateFaction(factionId);
    }

    public static boolean isFactionHostileToAll(String factionId) {
        if (ExerelinUtilsFaction.isPirateFaction(factionId)) {
            return true;
        }
        ExerelinFactionConfig config = ExerelinConfig.getExerelinFactionConfig(factionId);
        if (config == null) {
            return false;
        }
        return config.hostileToAll > 0;
    }

    public static boolean isExiInCorvus(String factionId) {
        if (factionId.equals("exigency") && SectorManager.getCorvusMode()) {
            SectorEntityToken tasserus = Global.getSector().getEntityById("exigency_tasserus");
            return tasserus != null;
        }
        return false;
    }

    public static boolean isExiInCorvus() {
        return ExerelinUtilsFaction.isExiInCorvus("exigency");
    }

    public static boolean isCorvusCompatible(String factionId, boolean noConfigFallback) {
        ExerelinFactionConfig config = ExerelinConfig.getExerelinFactionConfig(factionId);
        if (config == null) {
            return noConfigFallback;
        }
        return config.corvusCompatible;
    }

    public static void grantCommission(SectorEntityToken entity) {
        FactionAPI faction = entity.getFaction();
        if (!faction.getCustomBoolean("offersCommissions")) {
            return;
        }
        if (faction.getId().equals(ExerelinUtilsFaction.getCommissionFactionId())) {
            return;
        }
        ExerelinUtilsFaction.revokeCommission();
        FactionCommissionMission mission = new FactionCommissionMission(faction.getId());
        mission.playerAccept(entity);
    }

    public static void revokeCommission() {
        SectorAPI sector = Global.getSector();
        CampaignEventPlugin eventSuper = sector.getEventManager().getOngoingEvent(null, "faction_commission");
        if (eventSuper == null) {
            return;
        }
        ExerelinFactionCommissionMissionEvent event = (ExerelinFactionCommissionMissionEvent)eventSuper;
        event.endEvent();
    }

    public static String getCommissionFactionId() {
        FactionAPI commissionFaction = Misc.getCommissionFaction();
        if (commissionFaction == null) {
            return null;
        }
        return commissionFaction.getId();
    }
}

