/*
 * Decompiled with CFR 0.152.
 */
package exerelin.utilities;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.fleet.FleetMemberType;
import com.fs.starfarer.api.impl.campaign.fleets.FleetFactoryV2;
import com.fs.starfarer.api.impl.campaign.fleets.FleetParams;
import exerelin.campaign.fleets.utils.DSFleetUtilsProxy;
import exerelin.campaign.fleets.utils.SWPFleetUtilsProxy;
import exerelin.plugins.ExerelinModPlugin;
import exerelin.utilities.ExerelinConfig;
import exerelin.utilities.ExerelinFactionConfig;
import exerelin.utilities.ExerelinUtils;
import org.apache.log4j.Logger;

public class ExerelinUtilsFleet {
    public static Logger log = Global.getLogger(ExerelinUtilsFleet.class);

    public static void injectFleet(CampaignFleetAPI fleet, MarketAPI market, Float stability, Float qualityFactor, String type) {
        if (ExerelinModPlugin.HAVE_DYNASECTOR) {
            DSFleetUtilsProxy.injectFleet(fleet, market, stability, qualityFactor, type);
        }
    }

    public static FleetMemberAPI addMiningShipToFleet(CampaignFleetAPI fleet) {
        String variantId = "shepherd_Frontier";
        ExerelinFactionConfig config = ExerelinConfig.getExerelinFactionConfig(fleet.getFaction().getId());
        if (config != null && config.miningVariantsOrWings != null && !config.miningVariantsOrWings.isEmpty()) {
            variantId = (String)ExerelinUtils.getRandomListElement(config.miningVariantsOrWings);
        }
        FleetMemberAPI miner = Global.getFactory().createFleetMember(FleetMemberType.SHIP, variantId);
        fleet.getFleetData().addFleetMember(miner);
        return miner;
    }

    public static CampaignFleetAPI customCreateFleet(FactionAPI faction, FleetParams params) {
        int total = (int)(params.combatPts + params.tankerPts + params.freighterPts);
        CampaignFleetAPI fleet = null;
        fleet = ExerelinModPlugin.HAVE_DYNASECTOR ? DSFleetUtilsProxy.enhancedCreateFleet(faction, params, total) : (ExerelinModPlugin.HAVE_SWP ? SWPFleetUtilsProxy.enhancedCreateFleet(faction, params, total) : FleetFactoryV2.createFleet((FleetParams)params));
        if (ExerelinModPlugin.HAVE_DYNASECTOR && faction.getId().equals("templars")) {
            fleet.getStats().getDynamic().getMod("ds_debris_chance_battle").modifyMult("tem_spawner_nex", 0.5f);
            fleet.getStats().getDynamic().getMod("ds_derelicts_chance_battle").modifyMult("tem_spawner_nex", 0.25f);
            fleet.getStats().getDynamic().getMod("ds_derelicts_chance_fleet").modifyMult("tem_spawner_nex", 0.0f);
        }
        return fleet;
    }

    public static float getDaysToOrbit(CampaignFleetAPI fleet) {
        float daysToOrbit = 0.0f;
        daysToOrbit = (float)fleet.getFleetPoints() <= 50.0f ? 2.0f : ((float)fleet.getFleetPoints() <= 100.0f ? 4.0f : ((float)fleet.getFleetPoints() <= 150.0f ? 6.0f : 8.0f));
        return daysToOrbit *= 0.5f + (float)Math.random() * 0.5f;
    }
}

