/*
 * Decompiled with CFR 0.152.
 */
package exerelin.utilities;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.econ.CommodityOnMarketAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.econ.MarketConditionAPI;
import com.fs.starfarer.api.campaign.econ.SubmarketAPI;
import com.fs.starfarer.api.impl.campaign.submarkets.BaseSubmarketPlugin;
import com.fs.starfarer.api.util.Misc;
import exerelin.campaign.PlayerFactionStore;
import exerelin.utilities.ExerelinConfig;
import exerelin.utilities.ExerelinFactionConfig;
import exerelin.utilities.ExerelinUtilsFaction;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import org.lazywizard.lazylib.MathUtils;
import org.lwjgl.util.vector.Vector2f;

public class ExerelinUtilsMarket {
    public static final List<String> NO_INVADE_MARKETS = Arrays.asList("SCY_prismFreeport", "prismFreeport", "prismFreeport_market");

    public static float getCommodityDemand(MarketAPI market, String commodity, boolean consumingOnly) {
        float demand = market.getCommodityData((String)commodity).getDemand().getDemand().modified;
        if (consumingOnly) {
            demand -= market.getCommodityData((String)commodity).getDemand().getNonConsumingDemand().modified;
        }
        return demand;
    }

    public static float getCommodityDemand(MarketAPI market, String commodity) {
        return ExerelinUtilsMarket.getCommodityDemand(market, commodity, true);
    }

    public static float getCommoditySupply(MarketAPI market, String commodity) {
        return market.getCommodityData((String)commodity).getSupply().modified;
    }

    public static float getCommoditySupplyMult(MarketAPI market, String commodity) {
        return market.getCommodityData(commodity).getSupply().computeMultMod();
    }

    public static float getCommodityDemandMult(MarketAPI market, String commodity) {
        return market.getCommodityData(commodity).getDemand().getDemand().computeMultMod();
    }

    public static float getCommodityDemandFractionMet(MarketAPI market, String commodity, boolean clamp) {
        if (clamp) {
            return market.getCommodityData(commodity).getDemand().getClampedFractionMet();
        }
        return market.getCommodityData(commodity).getDemand().getFractionMet();
    }

    public static int countMarketConditions(MarketAPI market, String marketCondition) {
        int count = 0;
        List conditions = market.getConditions();
        for (MarketConditionAPI condition : conditions) {
            if (!condition.getId().equals(marketCondition)) continue;
            ++count;
        }
        return count;
    }

    public static float getPopulation(MarketAPI market) {
        return ExerelinUtilsMarket.getPopulation(market.getSize());
    }

    public static float getPopulation(int size) {
        if (size <= 1) {
            return 0.125f;
        }
        if (size == 2) {
            return 0.25f;
        }
        if (size == 3) {
            return 0.5f;
        }
        return (float)Math.pow(2.0, size - 4);
    }

    public static void removeOneMarketCondition(MarketAPI market, String conditionId) {
        int count = ExerelinUtilsMarket.countMarketConditions(market, conditionId);
        if (count == 0) {
            Global.getLogger(ExerelinUtilsMarket.class).warn((Object)("Tried to remove nonexistent market condition " + conditionId + " from " + market.getId()));
        }
        market.removeCondition(conditionId);
        for (int i = 0; i < count - 1; ++i) {
            market.addCondition(conditionId);
        }
    }

    public static float getHyperspaceDistance(MarketAPI market1, MarketAPI market2) {
        SectorEntityToken primary1 = market1.getPrimaryEntity();
        SectorEntityToken primary2 = market2.getPrimaryEntity();
        if (primary1.getContainingLocation() == primary2.getContainingLocation()) {
            return 0.0f;
        }
        return Misc.getDistance((Vector2f)primary1.getLocationInHyperspace(), (Vector2f)primary2.getLocationInHyperspace());
    }

    public static void refreshMarket(MarketAPI market, boolean force) {
        Field minCargoUpdateInterval;
        Field sinceLastCargoUpdate;
        if (market.getFactionId().equals("templars")) {
            return;
        }
        boolean canUpdate = true;
        if (force) {
            try {
                sinceLastCargoUpdate = BaseSubmarketPlugin.class.getDeclaredField("sinceLastCargoUpdate");
                sinceLastCargoUpdate.setAccessible(true);
                minCargoUpdateInterval = BaseSubmarketPlugin.class.getDeclaredField("minCargoUpdateInterval");
                minCargoUpdateInterval.setAccessible(true);
            }
            catch (Exception ex) {
                Global.getLogger(ExerelinUtilsMarket.class).error((Object)ex);
                return;
            }
        } else {
            sinceLastCargoUpdate = null;
            minCargoUpdateInterval = null;
        }
        if (!canUpdate) {
            return;
        }
        for (SubmarketAPI submarket : market.getSubmarketsCopy()) {
            BaseSubmarketPlugin plugin;
            block10: {
                if ("storage".equals(submarket.getSpec().getId()) || !(submarket.getPlugin() instanceof BaseSubmarketPlugin)) continue;
                plugin = (BaseSubmarketPlugin)submarket.getPlugin();
                if (force) {
                    try {
                        float lastUpdate = sinceLastCargoUpdate.getFloat(plugin);
                        float minUpdateInterval = minCargoUpdateInterval.getFloat(plugin);
                        if (!(lastUpdate > minUpdateInterval)) break block10;
                        sinceLastCargoUpdate.setFloat(plugin, minUpdateInterval + 1.0f);
                    }
                    catch (Exception ex) {
                        Global.getLogger(ExerelinUtilsMarket.class).error((Object)ex);
                        continue;
                    }
                }
            }
            plugin.updateCargoPrePlayerInteraction();
        }
    }

    public static void destroyCommodityStocks(MarketAPI market, CommodityOnMarketAPI commodity, float mult, float variance) {
        float current = commodity.getStockpile();
        if (variance != 0.0f) {
            mult *= MathUtils.getRandomNumberInRange((float)(1.0f - variance), (float)(1.0f + variance));
        }
        commodity.removeFromStockpile(current * mult);
        Global.getLogger(ExerelinUtilsMarket.class).info((Object)("Destroyed " + String.format("%.1f", Float.valueOf(current * mult)) + " of " + commodity.getId() + " on " + market.getName() + " (mult " + String.format("%.2f", Float.valueOf(mult)) + ")"));
    }

    public static void destroyCommodityStocks(MarketAPI market, String commodityId, float mult, float variance) {
        CommodityOnMarketAPI commodity = market.getCommodityData(commodityId);
        ExerelinUtilsMarket.destroyCommodityStocks(market, commodity, mult, variance);
    }

    public static void destroyAllCommodityStocks(MarketAPI market, float mult, float variance) {
        for (CommodityOnMarketAPI commodity : market.getAllCommodities()) {
            if (commodity.isNonEcon()) continue;
            ExerelinUtilsMarket.destroyCommodityStocks(market, commodity, mult, variance);
        }
    }

    public static void setTariffs(MarketAPI market) {
        String factionId = market.getFactionId();
        ExerelinFactionConfig conf = ExerelinConfig.getExerelinFactionConfig(factionId);
        market.getTariff().modifyMult("nexerelinMult", ExerelinConfig.baseTariffMult);
        market.getTariff().modifyMult("nexerelinFactionMult", conf.tariffMult);
        if (market.hasCondition("free_market")) {
            market.getTariff().modifyMult("nexerelin_freeMarket", ExerelinConfig.freeMarketTariffMult);
        } else {
            market.getTariff().unmodify("nexerelin_freeMarket");
        }
    }

    public static boolean isMarketBeingInvaded(MarketAPI market) {
        return market.getMemoryWithoutUpdate().getBoolean("$beingInvaded") || market.getId().equals(Global.getSector().getCharacterData().getMemoryWithoutUpdate().getString("$invasionTarget"));
    }

    public static boolean shouldTargetForInvasions(MarketAPI market, int minSize) {
        if (market.getSize() < minSize) {
            return false;
        }
        FactionAPI marketFaction = market.getFaction();
        ExerelinFactionConfig config = ExerelinConfig.getExerelinFactionConfig(marketFaction.getId());
        if (config != null && !config.playableFaction) {
            return false;
        }
        boolean allowPirates = ExerelinConfig.allowPirateInvasions;
        if (!allowPirates && ExerelinUtilsFaction.isPirateFaction(marketFaction.getId())) {
            return false;
        }
        return ExerelinUtilsMarket.canBeInvaded(market);
    }

    public static boolean canBeInvaded(MarketAPI market) {
        if (market.hasCondition("abandoned_station")) {
            return false;
        }
        if (market.getPrimaryEntity() instanceof CampaignFleetAPI) {
            return false;
        }
        FactionAPI marketFaction = market.getFaction();
        if (marketFaction.getId().equals(PlayerFactionStore.getPlayerFactionId())) {
            return false;
        }
        if (marketFaction.isNeutralFaction()) {
            return false;
        }
        if (!market.isInEconomy()) {
            return false;
        }
        if (market.getPrimaryEntity().hasTag("nex_uninvadable")) {
            return false;
        }
        return !market.getMemoryWithoutUpdate().getBoolean("$nex_uninvadable");
    }
}

