/*
 * Decompiled with CFR 0.152.
 */
package exerelin.utilities;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.RepLevel;
import com.fs.starfarer.api.campaign.ReputationActionResponsePlugin;
import com.fs.starfarer.api.campaign.SectorAPI;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.comm.CommMessageAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.impl.campaign.CoreReputationPlugin;
import exerelin.campaign.AllianceManager;
import exerelin.campaign.DiplomacyManager;
import exerelin.campaign.ExerelinReputationAdjustmentResult;
import exerelin.campaign.PlayerFactionStore;
import exerelin.campaign.SectorManager;
import exerelin.utilities.ExerelinFactionConfig;
import java.util.List;

public class ExerelinUtilsReputation {
    public static float getClampedRelationshipDelta(String faction1Id, String faction2Id, float delta) {
        float max = ExerelinFactionConfig.getMaxRelationship(faction1Id, faction2Id);
        float min = ExerelinFactionConfig.getMinRelationship(faction1Id, faction2Id);
        float curr = Global.getSector().getFaction(faction1Id).getRelationship(faction2Id);
        if (delta > 0.0f && curr + delta > max) {
            delta = max - curr;
        }
        if (delta < 0.0f && curr + delta < min) {
            delta = min - curr;
        }
        return delta;
    }

    public static ExerelinReputationAdjustmentResult adjustPlayerReputation(FactionAPI faction, PersonAPI person, float delta) {
        return ExerelinUtilsReputation.adjustPlayerReputation(faction, person, delta, null, null);
    }

    public static ExerelinReputationAdjustmentResult adjustPlayerReputation(FactionAPI faction, PersonAPI person, float delta, CommMessageAPI message, TextPanelAPI textPanel) {
        String factionId = faction.getId();
        FactionAPI player = Global.getSector().getFaction("player");
        boolean wasHostile = player.isHostileTo(faction);
        if (!DiplomacyManager.isRandomFactionRelationships()) {
            String myFactionId = PlayerFactionStore.getPlayerFactionId();
            delta = ExerelinUtilsReputation.getClampedRelationshipDelta(myFactionId, faction.getId(), delta);
        }
        CoreReputationPlugin.CustomRepImpact impact = new CoreReputationPlugin.CustomRepImpact();
        impact.delta = delta;
        ReputationActionResponsePlugin.ReputationAdjustmentResult result = textPanel != null ? Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(CoreReputationPlugin.RepActions.CUSTOM, (Object)impact, textPanel), factionId) : Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(CoreReputationPlugin.RepActions.CUSTOM, (Object)impact, message, true), factionId);
        if (person != null) {
            CoreReputationPlugin.CustomRepImpact impact2 = new CoreReputationPlugin.CustomRepImpact();
            impact2.delta = delta * 1.5f;
            result = textPanel != null ? Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(CoreReputationPlugin.RepActions.CUSTOM, (Object)impact2, textPanel), person) : Global.getSector().adjustPlayerReputation((Object)new CoreReputationPlugin.RepActionEnvelope(CoreReputationPlugin.RepActions.CUSTOM, (Object)impact2, message, true), person);
        }
        boolean isHostile = player.isHostileTo(faction);
        ExerelinReputationAdjustmentResult result2 = new ExerelinReputationAdjustmentResult(result.delta, wasHostile, isHostile);
        return result2;
    }

    public static void syncFactionRelationshipToPlayer(String factionIdToSync, String otherFactionId) {
        if (otherFactionId.equals("player_npc")) {
            return;
        }
        if (otherFactionId.equals("merc_hostile")) {
            return;
        }
        if (otherFactionId.equals("famous_bounty")) {
            return;
        }
        if (otherFactionId.equals("shippackfaction")) {
            return;
        }
        SectorAPI sector = Global.getSector();
        FactionAPI playerFaction = sector.getFaction("player");
        FactionAPI factionToSync = sector.getFaction(factionIdToSync);
        float relationship = playerFaction.getRelationship(otherFactionId);
        factionToSync.setRelationship(otherFactionId, relationship);
        DiplomacyManager.clampRelations(factionIdToSync, otherFactionId, 0.0f);
        AllianceManager.remainInAllianceCheck(factionIdToSync, otherFactionId);
    }

    public static void syncFactionRelationshipsToPlayer(String factionId) {
        SectorAPI sector = Global.getSector();
        FactionAPI playerFaction = sector.getFaction("player");
        FactionAPI faction = sector.getFaction(factionId);
        List factions = sector.getAllFactions();
        for (FactionAPI otherFaction : factions) {
            if (otherFaction == playerFaction || otherFaction == faction) continue;
            ExerelinUtilsReputation.syncFactionRelationshipToPlayer(factionId, otherFaction.getId());
        }
        SectorManager.checkForVictory();
    }

    public static void syncFactionRelationshipsToPlayer() {
        String playerAlignedFactionId = PlayerFactionStore.getPlayerFactionId();
        ExerelinUtilsReputation.syncFactionRelationshipsToPlayer(playerAlignedFactionId);
        if (!playerAlignedFactionId.equals("player_npc")) {
            ExerelinUtilsReputation.syncFactionRelationshipsToPlayer("player_npc");
        }
    }

    public static void syncPlayerRelationshipToFaction(String factionId, String otherFactionId) {
        FactionAPI faction = Global.getSector().getFaction(factionId);
        if (otherFactionId.equals("player_npc")) {
            return;
        }
        float relationship = faction.getRelationship(otherFactionId);
        Global.getSector().getPlayerFaction().setRelationship(otherFactionId, relationship);
    }

    public static void syncPlayerRelationshipsToFaction(String factionId) {
        SectorAPI sector = Global.getSector();
        FactionAPI playerFaction = sector.getPlayerFaction();
        FactionAPI faction = sector.getFaction(factionId);
        for (FactionAPI otherFaction : sector.getAllFactions()) {
            if (otherFaction == playerFaction || otherFaction == faction) continue;
            ExerelinUtilsReputation.syncPlayerRelationshipToFaction(factionId, otherFaction.getId());
        }
        playerFaction.setRelationship("merc_hostile", -1.0f);
        playerFaction.setRelationship("famous_bounty", -1.0f);
        playerFaction.setRelationship("shippackfaction", RepLevel.FRIENDLY);
        ExerelinUtilsReputation.syncFactionRelationshipsToPlayer("player_npc");
    }

    public static void syncPlayerRelationshipsToFaction() {
        String playerAlignedFactionId = PlayerFactionStore.getPlayerFactionId();
        ExerelinUtilsReputation.syncPlayerRelationshipsToFaction(playerAlignedFactionId);
    }
}

