/*
 * Decompiled with CFR 0.152.
 */
package exerelin.utilities;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.util.Misc;
import exerelin.utilities.ExerelinUtilsFaction;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StringHelper {
    public static final String FLEET_ASSIGNMENT_CATEGORY = "exerelin_fleetAssignments";

    public static String getString(String category, String id) {
        String str = "";
        try {
            str = Global.getSettings().getString(category, id);
        }
        catch (Exception ex) {
            Global.getLogger(StringHelper.class).warn((Object)ex);
        }
        return str;
    }

    public static String getString(String id) {
        return StringHelper.getString("general", id);
    }

    public static String substituteToken(String toModify, String token, String replace, boolean ucFormToo) {
        String str = toModify.replaceAll("\\" + token, replace);
        if (ucFormToo) {
            str = toModify.replaceAll("\\" + Misc.ucFirst((String)token), Misc.ucFirst((String)replace));
        }
        return str;
    }

    public static String substituteToken(String toModify, String token, String replace) {
        return toModify.replaceAll("\\" + token, replace);
    }

    public static String substituteTokens(String toModify, Map<String, String> replacements) {
        for (Map.Entry<String, String> tmp : replacements.entrySet()) {
            toModify = StringHelper.substituteToken(toModify, tmp.getKey(), tmp.getValue());
        }
        return toModify;
    }

    public static String getStringAndSubstituteToken(String category, String id, String token, String replace) {
        return StringHelper.getStringAndSubstituteToken(category, id, token, replace, false);
    }

    public static String getStringAndSubstituteToken(String category, String id, String token, String replace, boolean ucFormToo) {
        String str = StringHelper.getString(category, id);
        return StringHelper.substituteToken(str, token, replace, ucFormToo);
    }

    public static String getStringAndSubstituteToken(String id, String token, String replace) {
        return StringHelper.getStringAndSubstituteToken("general", id, token, replace, false);
    }

    public static String getStringAndSubstituteToken(String id, String token, String replace, boolean ucFormToo) {
        return StringHelper.getStringAndSubstituteToken("general", id, token, replace, ucFormToo);
    }

    public static String getStringAndSubstituteTokens(String category, String id, Map<String, String> replacements) {
        String str = StringHelper.getString(category, id);
        return StringHelper.substituteTokens(str, replacements);
    }

    public static String getStringAndSubstituteTokens(String id, Map<String, String> replacements) {
        return StringHelper.getStringAndSubstituteTokens("general", id, replacements);
    }

    public static String substituteFactionTokens(String str, FactionAPI faction) {
        HashMap<String, String> replacements = new HashMap<String, String>();
        String name = ExerelinUtilsFaction.getFactionShortName(faction);
        String theName = faction.getDisplayNameWithArticle();
        replacements.put("$faction", name);
        replacements.put("$Faction", Misc.ucFirst((String)name));
        replacements.put("$theFaction", theName);
        replacements.put("$TheFaction", Misc.ucFirst((String)theName));
        return StringHelper.substituteTokens(str, replacements);
    }

    public static String getFleetAssignmentString(String id, String target, String missionType) {
        String str = StringHelper.getString(FLEET_ASSIGNMENT_CATEGORY, id);
        if (target != null) {
            str = StringHelper.substituteToken(str, "$target", target);
        }
        if (missionType != null) {
            str = StringHelper.substituteToken(str, "$missionType", StringHelper.getString(FLEET_ASSIGNMENT_CATEGORY, missionType));
        }
        return str;
    }

    public static String getFleetAssignmentString(String id, String target) {
        return StringHelper.getFleetAssignmentString(id, target, null);
    }

    public static String getHisOrHer(PersonAPI person) {
        switch (person.getGender()) {
            case MALE: {
                return StringHelper.getString("his");
            }
            case FEMALE: {
                return StringHelper.getString("her");
            }
        }
        return StringHelper.getString("their");
    }

    public static String getShipOrFleet(CampaignFleetAPI fleet) {
        String fleetOrShip = StringHelper.getString("general", "fleet");
        if (fleet != null && fleet.getFleetData().getMembersListCopy().size() == 1) {
            fleetOrShip = StringHelper.getString("general", "ship");
            if (((FleetMemberAPI)fleet.getFleetData().getMembersListCopy().get(0)).isFighterWing()) {
                fleetOrShip = StringHelper.getString("general", "fighterWing");
            }
        }
        return fleetOrShip;
    }

    public static String flattenToAscii(String string) {
        StringBuilder sb = new StringBuilder(string.length());
        string = Normalizer.normalize(string, Normalizer.Form.NFD);
        for (char c : string.toCharArray()) {
            if (c > '\u007f') continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static List<String> factionIdListToFactionNameList(List<String> factionIds, boolean ucFirst) {
        ArrayList<String> result = new ArrayList<String>();
        for (String factionId : factionIds) {
            FactionAPI faction = Global.getSector().getFaction(factionId);
            String name = faction.getDisplayName();
            if (ucFirst) {
                name = Misc.ucFirst((String)name);
            }
            result.add(name);
        }
        return result;
    }

    public static String writeStringCollection(Collection<String> strings) {
        return StringHelper.writeStringCollection(strings, false, false);
    }

    public static String writeStringCollection(Collection<String> strings, boolean includeAnd, boolean oxfordComma) {
        String str = "";
        int num = 0;
        for (String entry : strings) {
            str = str + entry;
            if (++num >= strings.size()) continue;
            if (oxfordComma || !includeAnd || num <= strings.size() - 1) {
                str = str + ", ";
            }
            if (!includeAnd) continue;
            str = str + StringHelper.getString("and") + " ";
        }
        return str;
    }
}

