/*
 * Decompiled with CFR 0.152.
 */
package exerelin.utilities.versionchecker;

import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

final class UpdateInfo {
    private final List<ModInfo> hasUpdate = new ArrayList<ModInfo>();
    private final List<ModInfo> hasNoUpdate = new ArrayList<ModInfo>();
    private final List<ModInfo> failedCheck = new ArrayList<ModInfo>();
    private int numModsChecked = 0;
    private String ssUpdate = null;
    private String ssUpdateError = null;

    UpdateInfo() {
    }

    void setSSUpdate(String latestVersion) {
        this.ssUpdate = latestVersion;
    }

    String getSSUpdate() {
        return this.ssUpdate;
    }

    void setFailedSSError(String ssUpdateError) {
        this.ssUpdateError = ssUpdateError;
    }

    String getFailedSSError() {
        return this.ssUpdateError;
    }

    void addFailed(ModInfo mod) {
        this.failedCheck.add(mod);
        ++this.numModsChecked;
    }

    List<ModInfo> getFailed() {
        return new ArrayList<ModInfo>(this.failedCheck);
    }

    void addUpdate(ModInfo mod) {
        this.hasUpdate.add(mod);
        ++this.numModsChecked;
    }

    List<ModInfo> getHasUpdate() {
        return new ArrayList<ModInfo>(this.hasUpdate);
    }

    void addNoUpdate(ModInfo mod) {
        this.hasNoUpdate.add(mod);
        ++this.numModsChecked;
    }

    int getNumModsChecked() {
        return this.numModsChecked;
    }

    List<ModInfo> getHasNoUpdate() {
        return new ArrayList<ModInfo>(this.hasNoUpdate);
    }

    static final class VersionFile
    implements Comparable<VersionFile> {
        private static final String MOD_THREAD_FORMAT = "http://fractalsoftworks.com/forum/index.php?topic=%d.0";
        private final int major;
        private final int minor;
        private final int modThreadId;
        private final String patch;
        private final String masterURL;
        private final String modName;

        VersionFile(JSONObject json, boolean isMaster) throws JSONException {
            this.masterURL = isMaster ? null : json.getString("masterVersionFile");
            this.modName = isMaster ? null : json.optString("modName", "<unknown>");
            this.modThreadId = isMaster ? 0 : (int)json.optDouble("modThreadId", 0.0);
            JSONObject modVersion = json.getJSONObject("modVersion");
            this.major = modVersion.optInt("major", 0);
            this.minor = modVersion.optInt("minor", 0);
            this.patch = modVersion.optString("patch", "0");
        }

        boolean isSameAs(VersionFile other) {
            return this.compareTo(other) == 0;
        }

        boolean isOlderThan(VersionFile other) {
            return this.compareTo(other) < 0;
        }

        boolean isNewerThan(VersionFile other) {
            return this.compareTo(other) > 0;
        }

        String getName() {
            return this.modName;
        }

        private static boolean startsWithDigit(String str) {
            return !str.isEmpty() && Character.isDigit(str.charAt(0));
        }

        String getVersion() {
            if (this.patch.equals("0")) {
                return "v" + this.major + "." + this.minor;
            }
            if (VersionFile.startsWithDigit(this.patch)) {
                return "v" + this.major + "." + this.minor + "." + this.patch;
            }
            return "v" + this.major + "." + this.minor + this.patch;
        }

        String getMasterURL() {
            return this.masterURL;
        }

        String getThreadURL() {
            if (this.modThreadId == 0) {
                return null;
            }
            return String.format(MOD_THREAD_FORMAT, this.modThreadId);
        }

        public String toString() {
            return this.getName() + " " + this.getVersion();
        }

        private static String[] splitPatch(String patch) {
            StringBuilder digit = new StringBuilder(patch.length());
            String str = "";
            for (int i = 0; i < patch.length(); ++i) {
                char ch = patch.charAt(i);
                if (!Character.isDigit(ch)) {
                    str = patch.substring(i);
                    break;
                }
                digit.append(ch);
            }
            return new String[]{digit.toString(), str};
        }

        private static int comparePatch(String patch, String other) {
            if (VersionFile.startsWithDigit(patch) && VersionFile.startsWithDigit(other)) {
                int numOther;
                String[] subPatch = VersionFile.splitPatch(patch);
                String[] subOther = VersionFile.splitPatch(other);
                int numPatch = Integer.parseInt(subPatch[0]);
                if (numPatch == (numOther = Integer.parseInt(subOther[0]))) {
                    return subPatch[1].compareTo(subOther[1]);
                }
                return Integer.compare(numPatch, numOther);
            }
            return patch.compareToIgnoreCase(other);
        }

        @Override
        public int compareTo(VersionFile other) {
            if (other == null) {
                return -1;
            }
            if (this.major == other.major && this.minor == other.minor && this.patch.equalsIgnoreCase(other.patch)) {
                return 0;
            }
            if (this.major < other.major || this.major == other.major && this.minor < other.minor || this.major == other.major && this.minor == other.minor && VersionFile.comparePatch(this.patch, other.patch) < 0) {
                return -1;
            }
            return 1;
        }
    }

    static final class ModInfo
    implements Comparable<ModInfo> {
        private final VersionFile localVersion;
        private final VersionFile remoteVersion;
        private final String errorMessage;

        ModInfo(VersionFile localVersion, VersionFile remoteVersion) {
            this.localVersion = localVersion;
            this.remoteVersion = remoteVersion;
            this.errorMessage = null;
        }

        ModInfo(VersionFile localVersion, String errorMessage) {
            this.localVersion = localVersion;
            this.errorMessage = errorMessage;
            this.remoteVersion = null;
        }

        String getName() {
            return this.localVersion.getName();
        }

        VersionFile getLocalVersion() {
            return this.localVersion;
        }

        VersionFile getRemoteVersion() {
            return this.remoteVersion;
        }

        boolean failedUpdateCheck() {
            return this.remoteVersion == null;
        }

        String getErrorMessage() {
            return this.errorMessage;
        }

        boolean isUpdateAvailable() {
            return this.localVersion.isOlderThan(this.remoteVersion);
        }

        boolean isLocalNewer() {
            return this.localVersion.isNewerThan(this.remoteVersion);
        }

        String getVersionString() {
            if (this.remoteVersion == null || this.localVersion.isSameAs(this.remoteVersion)) {
                return this.localVersion.getVersion();
            }
            return this.localVersion.getVersion() + " vs " + this.remoteVersion.getVersion();
        }

        @Override
        public int compareTo(ModInfo other) {
            return this.localVersion.getName().compareTo(other.localVersion.getName());
        }
    }
}

