/*
 * Decompiled with CFR 0.152.
 */
package exerelin.utilities.versionchecker;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.ModSpecAPI;
import com.fs.starfarer.api.campaign.CampaignUIAPI;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.InteractionDialogPlugin;
import com.fs.starfarer.api.campaign.OptionPanelAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.TextPanelAPI;
import com.fs.starfarer.api.campaign.rules.MemoryAPI;
import com.fs.starfarer.api.combat.EngagementResultAPI;
import exerelin.utilities.versionchecker.Log;
import exerelin.utilities.versionchecker.UpdateInfo;
import exerelin.utilities.versionchecker.VCModPluginCustom;
import java.awt.Color;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.Display;

final class UpdateNotificationScript
implements EveryFrameScript {
    private float timeUntilWarn = 0.75f;
    private boolean isUpdateCheckDone = false;
    private boolean hasWarned = false;
    private transient Future<UpdateInfo> futureUpdateInfo;
    private transient UpdateInfo updateInfo;
    private transient List<ModSpecAPI> unsupportedMods;

    UpdateNotificationScript(List<ModSpecAPI> unsupportedMods, Future<UpdateInfo> updateInfo) {
        this.unsupportedMods = unsupportedMods;
        this.futureUpdateInfo = updateInfo;
    }

    public boolean isDone() {
        return false;
    }

    public boolean runWhilePaused() {
        return true;
    }

    private void warnUpdates(CampaignUIAPI ui) {
        int modsWithoutUpdates = this.updateInfo.getHasNoUpdate().size();
        int modsWithUpdates = this.updateInfo.getHasUpdate().size();
        int modsThatFailedUpdateCheck = this.updateInfo.getFailed().size();
        int modsRequiringManualCheck = this.unsupportedMods.size();
        if (modsWithoutUpdates > 0) {
            ui.addMessage(modsWithoutUpdates + (modsWithoutUpdates == 1 ? " Mod \u4e2a\u662f" : " Mods \u4e2a\u662f") + " \u6700\u65b0\u7248\u672c.", Integer.toString(modsWithoutUpdates), Color.GREEN);
        }
        if (modsWithUpdates > 0) {
            ui.addMessage("\u627e\u5230\u53ef\u7528\u66f4\u65b0 " + modsWithUpdates + (modsWithUpdates == 1 ? " mod." : " Mods."), Integer.toString(modsWithUpdates), Color.YELLOW);
        }
        if (modsThatFailedUpdateCheck > 0) {
            ui.addMessage("\u66f4\u65b0\u68c0\u67e5\u5931\u8d25 " + modsThatFailedUpdateCheck + (modsThatFailedUpdateCheck == 1 ? " mod." : " Mods."), Integer.toString(modsThatFailedUpdateCheck), Color.RED);
        }
        if (modsRequiringManualCheck > 0) {
            ui.addMessage("\u9700\u8981\u624b\u52a8\u68c0\u67e5\u7248\u672c " + modsRequiringManualCheck + (modsRequiringManualCheck == 1 ? " \u4e0d\u652f\u6301 Mod." : " \u4e0d\u652f\u6301 Mods."), Integer.toString(modsRequiringManualCheck), Color.YELLOW);
        }
        if (this.updateInfo.getSSUpdate() != null) {
            ui.addMessage("\u6709\u6700\u65b0\u7684\u6e38\u620f\u7248\u672c\u7b49\u5f85\u66f4\u65b0: " + this.updateInfo.getSSUpdate(), this.updateInfo.getSSUpdate(), Color.YELLOW);
        } else if (this.updateInfo.getFailedSSError() != null) {
            ui.addMessage("\u65e0\u6cd5\u68c0\u6d4b\u5230\u6700\u65b0\u7684 SS \u7248\u672c: " + this.updateInfo.getFailedSSError(), Color.RED);
        }
        String keyName = Keyboard.getKeyName((int)VCModPluginCustom.notificationKey);
        ui.addMessage("\u6309 " + keyName + " \u83b7\u53d6\u8be6\u7ec6\u66f4\u65b0\u4fe1\u606f.", keyName, Color.CYAN);
    }

    public void advance(float amount) {
        CampaignUIAPI ui = Global.getSector().getCampaignUI();
        if (Global.getSector().isInNewGameAdvance() || ui.isShowingDialog()) {
            return;
        }
        if (!this.isUpdateCheckDone) {
            if (!this.futureUpdateInfo.isDone()) {
                return;
            }
            try {
                this.updateInfo = this.futureUpdateInfo.get(1L, TimeUnit.SECONDS);
                this.futureUpdateInfo = null;
            }
            catch (InterruptedException | ExecutionException | TimeoutException ex) {
                Log.error("\u65e0\u6cd5\u68c0\u6d4b\u5230\u6700\u65b0\u7684 Mod \u66f4\u65b0\u4fe1\u606f", ex);
                ui.addMessage("\u65e0\u6cd5\u68c0\u6d4b\u5230\u6700\u65b0\u7684 Mod \u66f4\u65b0\u4fe1\u606f!", Color.RED);
                ui.addMessage("\u67e5\u770b starsector.log \u4ee5\u4e86\u89e3\u8be6\u60c5.", Color.RED);
                Global.getSector().removeScript((EveryFrameScript)this);
                return;
            }
            this.isUpdateCheckDone = true;
        }
        if (!this.hasWarned && this.timeUntilWarn <= 0.0f) {
            this.warnUpdates(ui);
            this.hasWarned = true;
        } else {
            this.timeUntilWarn -= amount;
        }
        if (Keyboard.isKeyDown((int)VCModPluginCustom.notificationKey)) {
            ui.showInteractionDialog((InteractionDialogPlugin)new UpdateNotificationDialog(this.updateInfo, this.unsupportedMods), (SectorEntityToken)Global.getSector().getPlayerFleet());
        }
    }

    private static class UpdateNotificationDialog
    implements InteractionDialogPlugin {
        private static final String ANNOUNCEMENT_BOARD = "http://fractalsoftworks.com/forum/index.php?board=1.0";
        private static final String MOD_INDEX_THREAD = "http://fractalsoftworks.com/forum/index.php?topic=177.0";
        private static final int ENTRIES_PER_PAGE = 5;
        private static final int LINE_LENGTH = 45;
        private final String ssUpdate;
        private final String ssUpdateError;
        private final List<UpdateInfo.ModInfo> hasUpdate;
        private final List<UpdateInfo.ModInfo> hasNoUpdate;
        private final List<UpdateInfo.ModInfo> failedCheck;
        private final List<ModSpecAPI> unsupported;
        private InteractionDialogAPI dialog;
        private TextPanelAPI text;
        private OptionPanelAPI options;
        private List<UpdateInfo.ModInfo> currentList;
        private int currentPage = 1;

        private UpdateNotificationDialog(UpdateInfo updateInfo, List<ModSpecAPI> unsupported) {
            this.hasUpdate = updateInfo.getHasUpdate();
            this.hasNoUpdate = updateInfo.getHasNoUpdate();
            this.failedCheck = updateInfo.getFailed();
            this.ssUpdate = updateInfo.getSSUpdate();
            this.ssUpdateError = updateInfo.getFailedSSError();
            this.unsupported = unsupported;
            Collections.sort(this.hasUpdate);
            Collections.sort(this.hasNoUpdate);
            Collections.sort(this.failedCheck);
            Collections.sort(unsupported, new Comparator<ModSpecAPI>(){

                @Override
                public int compare(ModSpecAPI o1, ModSpecAPI o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
        }

        private static String wrap(String toWrap) {
            if (toWrap == null) {
                return "";
            }
            String[] lines = toWrap.split("\n");
            StringBuilder line = new StringBuilder(45);
            StringBuilder message = new StringBuilder((int)((float)toWrap.length() * 1.1f));
            for (String rawLine : lines) {
                if (rawLine.length() <= 45) {
                    message.append(rawLine).append("\n");
                    continue;
                }
                line.setLength(0);
                String[] words = rawLine.split(" ");
                for (int y = 0; y < words.length; ++y) {
                    if (words[y].length() >= 45) {
                        if (line.length() > 0) {
                            message.append(line.toString()).append("\n");
                            line.setLength(0);
                        }
                        while (words[y].length() > 45) {
                            message.append(words[y].substring(0, 44)).append("-\n");
                            words[y] = words[y].substring(44);
                        }
                        if (words[y].isEmpty()) continue;
                        if (y == words.length - 1) {
                            message.append(words[y]).append("\n");
                            continue;
                        }
                        line.append(words[y]);
                        continue;
                    }
                    if (words[y].length() + line.length() >= 45) {
                        message.append(line.toString()).append("\n");
                        line.setLength(0);
                        --y;
                        continue;
                    }
                    line.append(words[y]);
                    line.append(" ");
                    if (y != words.length - 1) continue;
                    message.append(line.toString()).append("\n");
                }
            }
            if (!toWrap.endsWith("\n")) {
                message.deleteCharAt(message.length() - 1);
            }
            return message.toString();
        }

        private void generateModMenu() {
            int offset = (this.currentPage - 1) * 5;
            int max = Math.min(offset + 5, this.currentList.size());
            int numPages = 1 + (this.currentList.size() - 1) / 5;
            int x = offset;
            int y = 1;
            while (x < max) {
                UpdateInfo.ModInfo mod = this.currentList.get(x);
                UpdateInfo.VersionFile local = mod.getLocalVersion();
                this.options.addOption(local.getName(), (Object)local);
                this.options.setEnabled((Object)local, local.getThreadURL() != null);
                ++x;
                ++y;
            }
            if (this.currentPage > 1) {
                this.options.addOption("\u4e0a\u4e00\u9875", (Object)Menu.PREVIOUS_PAGE);
                this.options.setShortcut((Object)Menu.PREVIOUS_PAGE, 203, false, false, false, true);
            }
            if (this.currentPage < numPages) {
                this.options.addOption("\u4e0b\u4e00\u9875", (Object)Menu.NEXT_PAGE);
                this.options.setShortcut((Object)Menu.NEXT_PAGE, 205, false, false, false, true);
            }
            this.dialog.setPromptText("\u9009\u62e9\u5e76\u6253\u5f00 Mod \u7684\u5b98\u65b9\u8bba\u575b" + (numPages > 1 ? " (\u9875\u9762 " + this.currentPage + "/" + numPages + ")" : "") + ":");
            this.options.addOption("\u4e3b\u83dc\u5355", (Object)Menu.MAIN_MENU);
            this.options.setShortcut((Object)Menu.MAIN_MENU, 1, false, false, false, true);
        }

        private void goToMenu(Menu menu) {
            this.options.clearOptions();
            switch (menu) {
                case MAIN_MENU: {
                    this.text.clear();
                    int numUpToDate = this.hasNoUpdate.size();
                    int numHasUpdate = this.hasUpdate.size();
                    int numFailed = this.failedCheck.size();
                    int numUnsupported = this.unsupported.size();
                    this.text.addParagraph(numUpToDate == 1 ? "\u6709 1 mod \u4e3a\u6700\u65b0\u7248\u672c" : "\u6709 " + numUpToDate + " \u4e2a\u6700\u65b0\u7684 Mod");
                    this.text.highlightInLastPara(Color.GREEN, new String[]{Integer.toString(numUpToDate)});
                    for (UpdateInfo.ModInfo info : this.hasNoUpdate) {
                        this.text.addParagraph(UpdateNotificationDialog.wrap(" - " + info.getName() + " (" + info.getVersionString() + ")"));
                        this.text.highlightInLastPara(info.isLocalNewer() ? Color.CYAN : Color.GREEN, new String[]{info.getName(), " vs "});
                    }
                    this.text.addParagraph(numHasUpdate == 1 ? "\u6709 1 \u4e2a Mod \u9700\u8981\u66f4\u65b0" : "\u6709 " + numHasUpdate + " \u4e2a Mod \u9700\u8981\u66f4\u65b0");
                    this.text.highlightInLastPara(numHasUpdate > 0 ? Color.YELLOW : Color.GREEN, new String[]{Integer.toString(numHasUpdate)});
                    for (UpdateInfo.ModInfo info : this.hasUpdate) {
                        this.text.addParagraph(UpdateNotificationDialog.wrap(" - " + info.getName() + " (" + info.getVersionString() + ")"));
                        this.text.highlightInLastPara(Color.YELLOW, new String[]{info.getName(), " vs "});
                    }
                    if (numFailed > 0) {
                        this.text.addParagraph(numFailed == 1 ? "\u6709 1 \u4e2a Mod \u66f4\u65b0\u68c0\u67e5\u5931\u8d25" : "\u6709 " + numFailed + " Mod \u66f4\u65b0\u68c0\u67e5\u5931\u8d25");
                        this.text.highlightInLastPara(numFailed > 0 ? Color.RED : Color.GREEN, new String[]{Integer.toString(numFailed)});
                        for (UpdateInfo.ModInfo info : this.failedCheck) {
                            this.text.addParagraph(UpdateNotificationDialog.wrap(" - " + info.getName() + " (" + info.getVersionString() + ", " + info.getErrorMessage() + ")"));
                            this.text.highlightInLastPara(Color.RED, new String[]{info.getName()});
                        }
                    }
                    if (numUnsupported > 0) {
                        this.text.addParagraph(numUnsupported == 1 ? "\u6709 1 Mod \u5b58\u5728\u51b2\u7a81" : "\u6709 " + numUnsupported + " \u4e0d\u517c\u5bb9\u7684 Mod");
                        this.text.highlightInLastPara(numUnsupported > 0 ? Color.YELLOW : Color.GREEN, new String[]{Integer.toString(numUnsupported)});
                        for (ModSpecAPI mod : this.unsupported) {
                            this.text.addParagraph(UpdateNotificationDialog.wrap(" - " + mod.getName() + " (" + mod.getVersion() + ")"));
                            this.text.highlightInLastPara(Color.YELLOW, new String[]{mod.getName()});
                        }
                    }
                    this.dialog.setPromptText("\u9009\u62e9 Mod \u7c7b\u522b:");
                    this.options.addOption("\u65e0\u9700\u66f4\u65b0\u7684 Mod", (Object)Menu.LIST_NO_UPDATES);
                    this.options.setEnabled((Object)Menu.LIST_NO_UPDATES, !this.hasNoUpdate.isEmpty());
                    this.options.addOption("\u9700\u8981\u66f4\u65b0\u7684 Mod", (Object)Menu.LIST_UPDATES);
                    this.options.setEnabled((Object)Menu.LIST_UPDATES, !this.hasUpdate.isEmpty());
                    if (!this.failedCheck.isEmpty()) {
                        this.options.addOption("\u5217\u51fa\u66f4\u65b0\u68c0\u67e5\u5931\u8d25\u7684 mod", (Object)Menu.LIST_FAILED);
                    }
                    if (!this.unsupported.isEmpty()) {
                        this.options.addOption("\u524d\u5f80 mod \u7d22\u5f15\u4e3b\u9898\u5e16", (Object)Menu.UPDATE_MANUALLY);
                    }
                    if (this.ssUpdate != null) {
                        this.text.addParagraph("\u6709\u6700\u65b0\u7684\u6e38\u620f\u7248\u672c\u7b49\u5f85\u66f4\u65b0:\n - " + this.ssUpdate);
                        this.text.highlightInLastPara(Color.YELLOW, new String[]{this.ssUpdate});
                        this.options.addOption("\u4e0b\u8f7d " + this.ssUpdate, (Object)Menu.UPDATE_VANILLA);
                    } else if (this.ssUpdateError != null) {
                        String curVersion = Global.getSettings().getVersionString();
                        this.text.addParagraph("\u672a\u80fd\u68c0\u7d22\u5230\u6700\u65b0\u7684 Starsector \u6e38\u620f\u7248\u672c (" + this.ssUpdateError + "):\n - \u5f53\u524d\u7248\u672c: " + curVersion);
                        this.text.highlightFirstInLastPara(curVersion, Color.RED);
                        this.options.addOption("\u524d\u5f80 Starsector \u66f4\u65b0\u516c\u544a", (Object)Menu.UPDATE_VANILLA);
                    }
                    this.options.addOption("\u9000\u51fa", (Object)Menu.EXIT);
                    this.options.setShortcut((Object)Menu.EXIT, 1, false, false, false, true);
                    break;
                }
                case UPDATE_MANUALLY: {
                    this.goToMenu(Menu.MAIN_MENU);
                    this.text.addParagraph("\u6b63\u5728\u6253\u5f00 Mod \u7d22\u5f15\u4e3b\u9898\u5e16...");
                    this.options.setEnabled((Object)Menu.UPDATE_MANUALLY, false);
                    try {
                        Desktop.getDesktop().browse(URI.create(MOD_INDEX_THREAD));
                    }
                    catch (IOException ex) {
                        Log.error("\u6d4f\u89c8\u5668\u542f\u52a8\u5931\u8d25: ", ex);
                        this.text.addParagraph("\u6d4f\u89c8\u5668\u542f\u52a8\u5931\u8d25: " + ex.getMessage(), Color.RED);
                    }
                    break;
                }
                case UPDATE_VANILLA: {
                    this.goToMenu(Menu.MAIN_MENU);
                    this.text.addParagraph("\u6b63\u5728\u6253\u5f00\u66f4\u65b0\u901a\u77e5\u8bba\u575b...");
                    this.options.setEnabled((Object)Menu.UPDATE_VANILLA, false);
                    try {
                        Desktop.getDesktop().browse(URI.create(ANNOUNCEMENT_BOARD));
                    }
                    catch (IOException ex) {
                        Log.error("\u6d4f\u89c8\u5668\u542f\u52a8\u5931\u8d25: ", ex);
                        this.text.addParagraph("\u6d4f\u89c8\u5668\u542f\u52a8\u5931\u8d25: " + ex.getMessage(), Color.RED);
                    }
                    break;
                }
                case LIST_UPDATES: {
                    this.currentList = this.hasUpdate;
                    this.currentPage = 1;
                    this.generateModMenu();
                    break;
                }
                case LIST_NO_UPDATES: {
                    this.currentList = this.hasNoUpdate;
                    this.currentPage = 1;
                    this.generateModMenu();
                    break;
                }
                case LIST_FAILED: {
                    this.currentList = this.failedCheck;
                    this.currentPage = 1;
                    this.generateModMenu();
                    break;
                }
                case PREVIOUS_PAGE: {
                    --this.currentPage;
                    this.generateModMenu();
                    break;
                }
                case NEXT_PAGE: {
                    ++this.currentPage;
                    this.generateModMenu();
                    break;
                }
                case RETURN: {
                    this.generateModMenu();
                    break;
                }
                default: {
                    this.dialog.dismiss();
                }
            }
        }

        public void init(InteractionDialogAPI dialog) {
            this.dialog = dialog;
            this.options = dialog.getOptionPanel();
            this.text = dialog.getTextPanel();
            dialog.setTextWidth((float)Display.getWidth() * 0.9f);
            this.goToMenu(Menu.MAIN_MENU);
        }

        public void optionSelected(String optionText, Object optionData) {
            this.text.addParagraph(optionText, Color.CYAN);
            if (optionData instanceof Menu) {
                this.goToMenu((Menu)((Object)optionData));
            } else if (optionData instanceof UpdateInfo.VersionFile) {
                try {
                    UpdateInfo.VersionFile info = (UpdateInfo.VersionFile)optionData;
                    this.text.addParagraph("\u6b63\u5728\u6253\u5f00 " + info.getName() + " \u8bba\u575b\u94fe\u63a5...");
                    this.options.setEnabled((Object)info, false);
                    Desktop.getDesktop().browse(URI.create(info.getThreadURL()));
                }
                catch (IOException ex) {
                    Log.error("\u6d4f\u89c8\u5668\u542f\u52a8\u5931\u8d25: ", ex);
                    this.text.addParagraph("\u6d4f\u89c8\u5668\u542f\u52a8\u5931\u8d25: " + ex.getMessage(), Color.RED);
                }
            }
        }

        public void optionMousedOver(String optionText, Object optionData) {
        }

        public void advance(float amount) {
        }

        public void backFromEngagement(EngagementResultAPI battleResult) {
        }

        public Object getContext() {
            return null;
        }

        public Map<String, MemoryAPI> getMemoryMap() {
            return null;
        }

        private static enum Menu {
            MAIN_MENU,
            UPDATE_VANILLA,
            UPDATE_MANUALLY,
            LIST_UPDATES,
            LIST_NO_UPDATES,
            LIST_FAILED,
            PREVIOUS_PAGE,
            NEXT_PAGE,
            RETURN,
            EXIT;

        }
    }
}

