/*
 * Decompiled with CFR 0.152.
 */
package exerelin.utilities.versionchecker;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.ModSpecAPI;
import exerelin.utilities.versionchecker.Log;
import exerelin.utilities.versionchecker.UpdateInfo;
import exerelin.utilities.versionchecker.UpdateNotificationScript;
import exerelin.utilities.versionchecker.VersionChecker;
import java.io.IOException;
import java.net.URLConnection;
import java.util.ArrayList;
import org.apache.log4j.Level;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class VCModPluginCustom {
    private static final String SETTINGS_FILE = "data/config/version/version_checker_nex.json";
    private static final String CSV_PATH = "data/config/version/version_files.csv";
    private static UpdateNotificationScript script = null;
    static boolean checkSSVersion = false;
    static int notificationKey;

    public static void onApplicationLoad() throws Exception {
        new URLConnection(null){

            @Override
            public void connect() throws IOException {
            }
        }.setDefaultUseCaches(false);
        JSONObject settings = Global.getSettings().loadJSON(SETTINGS_FILE);
        notificationKey = settings.getInt("summonUpdateNotificationKey");
        checkSSVersion = settings.getBoolean("checkStarsectorVersion");
        VersionChecker.setMaxThreads(settings.getInt("maxUpdateThreads"));
        Log.setLevel(Level.toLevel((String)settings.getString("logLevel"), (Level)Level.WARN));
        ArrayList<UpdateInfo.VersionFile> versionFiles = new ArrayList<UpdateInfo.VersionFile>();
        JSONArray csv = Global.getSettings().getMergedSpreadsheetDataForMod("version file", CSV_PATH, "nexerelin");
        int numMods = csv.length();
        int csvPathLength = CSV_PATH.length() + 1;
        ArrayList<String> modPaths = new ArrayList<String>(numMods);
        Log.info("\u627e\u5230 " + numMods + " Mod \u7684\u7248\u672c\u4fe1\u606f");
        for (int x = 0; x < numMods; ++x) {
            JSONObject row = csv.getJSONObject(x);
            String versionFile = row.getString("version file");
            String source = row.optString("fs_rowSource", null);
            if (source != null && source.length() > csvPathLength) {
                modPaths.add(source.substring(0, source.length() - csvPathLength));
            }
            try {
                versionFiles.add(new UpdateInfo.VersionFile(Global.getSettings().loadJSON(versionFile), false));
                continue;
            }
            catch (JSONException ex) {
                throw new RuntimeException("\u65e0\u6cd5\u89e3\u6790\u7248\u672c\u6587\u4ef6 \"" + versionFile + "\"", ex);
            }
        }
        ArrayList<ModSpecAPI> unsupportedMods = new ArrayList<ModSpecAPI>();
        for (ModSpecAPI mod : Global.getSettings().getModManager().getEnabledModsCopy()) {
            if (modPaths.contains(mod.getPath())) continue;
            unsupportedMods.add(mod);
        }
        if (!versionFiles.isEmpty()) {
            script = new UpdateNotificationScript(unsupportedMods, VersionChecker.scheduleUpdateCheck(versionFiles));
        }
    }

    public static void onGameLoad(boolean newGame) {
        if (script != null && !script.isDone()) {
            Global.getSector().addTransientScript((EveryFrameScript)script);
        }
    }
}

