/*
 * Decompiled with CFR 0.152.
 */
package exerelin.utilities.versionchecker;

import com.fs.starfarer.api.Global;
import exerelin.utilities.versionchecker.Log;
import exerelin.utilities.versionchecker.UpdateInfo;
import exerelin.utilities.versionchecker.VCModPluginCustom;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadFactory;
import org.json.JSONException;
import org.json.JSONObject;

final class VersionChecker {
    private static final String VANILLA_UPDATE_URL = "https://bitbucket.org/LazyWizard/version-checker/downloads/vanilla.txt";
    private static int MAX_THREADS = 12;

    static void setMaxThreads(int maxThreads) {
        MAX_THREADS = maxThreads;
    }

    private static JSONObject sanitizeJSON(String rawJSON) throws JSONException {
        StringBuilder result = new StringBuilder(rawJSON.length());
        for (String str : rawJSON.split("\n")) {
            if (str.trim().startsWith("#")) continue;
            if (str.contains("#")) {
                result.append(str.substring(0, str.indexOf(35)));
                continue;
            }
            result.append(str);
        }
        return new JSONObject(result.toString());
    }

    /*
     * Exception decompiling
     */
    private static Object getRemoteVersionFile(String versionFileURL) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private static String getLatestSSVersion() throws IOException, NoSuchElementException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static UpdateInfo.ModInfo checkForUpdate(UpdateInfo.VersionFile localVersion) {
        Object remoteVersion = VersionChecker.getRemoteVersionFile(localVersion.getMasterURL());
        if (remoteVersion instanceof String) {
            return new UpdateInfo.ModInfo(localVersion, (String)remoteVersion);
        }
        return new UpdateInfo.ModInfo(localVersion, (UpdateInfo.VersionFile)remoteVersion);
    }

    static Future<UpdateInfo> scheduleUpdateCheck(List<UpdateInfo.VersionFile> localVersions) {
        FutureTask<UpdateInfo> task = new FutureTask<UpdateInfo>(new MainTask(localVersions));
        Thread thread = new Thread(task, "Thread-VC-Main");
        thread.setDaemon(true);
        thread.start();
        return task;
    }

    private VersionChecker() {
    }

    private static final class VCThreadFactory
    implements ThreadFactory {
        private int threadNum = 0;

        private VCThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            ++this.threadNum;
            Thread thread = new Thread(r, "Thread-VC-" + this.threadNum);
            thread.setDaemon(true);
            thread.setPriority(3);
            return thread;
        }
    }

    private static final class MainTask
    implements Callable<UpdateInfo> {
        private final List<UpdateInfo.VersionFile> localVersions;

        private MainTask(List<UpdateInfo.VersionFile> localVersions) {
            this.localVersions = localVersions;
        }

        private int getNumberOfThreads() {
            return Math.max(1, Math.min(MAX_THREADS, this.localVersions.size()));
        }

        private CompletionService<UpdateInfo.ModInfo> createCompletionService() {
            ExecutorService serviceInternal = Executors.newFixedThreadPool(this.getNumberOfThreads(), new VCThreadFactory());
            ExecutorCompletionService<UpdateInfo.ModInfo> service = new ExecutorCompletionService<UpdateInfo.ModInfo>(serviceInternal);
            for (UpdateInfo.VersionFile version : this.localVersions) {
                service.submit(new SubTask(version));
            }
            return service;
        }

        public static void main(String[] args) {
            String vNew;
            String vOld;
            int x;
            String[] allVersions = new String[]{"Starsector 0.35a-pre-RC2", "Starsector 0.5a-pre-RC3", "Starsector 0.51a-RC1", "Starsector 0.51a-RC3", "Starsector 0.52a-RC2", "Starsector 0.52.1a-RC4", "Starsector 0.53a-RC4", "Starsector 0.53.1a-RC5", "Starsector 0.54a-RC5", "Starsector 0.54.1a-RC2", "Starsector 0.6a-RC1", "Starsector 0.6a-RC4", "Starsector 0.6.1a-RC2", "Starsector 0.6.2a-RC2", "Starsector 0.6.2a-RC3", "Starsector 0.65a-RC1", "Starsector 0.65.1a-RC1", "Starsector 0.65.2a-RC1", "Starsector 0.7a-RC7", "Starsector 0.7a-RC10", "Starsector 0.7.1a-RC3", "Starsector 0.7.1a-RC4", "Starsector 0.7.1a-RC5", "Starsector 0.7.2a-RC1", "Starsector 0.7.2a-RC2", "Starsector 0.7.2a-RC3", "Starsector 0.8a-RC17", "Starsector 0.8a-RC18", "Starsector 0.8a-RC19", "Starsector 0.8.1a-RC5", "Starsector 0.8.1a-RC6"};
            System.out.println(" \u6309\u987a\u5e8f\u6392\u5217\n--------------");
            for (x = 0; x < allVersions.length - 1; ++x) {
                vOld = allVersions[x];
                vNew = allVersions[x + 1];
                System.out.printf("%-55s %5s\n", vOld + " vs " + vNew + ": ", MainTask.isRemoteNewer(vOld, vNew));
            }
            System.out.println("\n \u6309\u5012\u5e8f\u6392\u5217\n---------------");
            for (x = allVersions.length - 1; x > 0; --x) {
                vOld = allVersions[x];
                vNew = allVersions[x - 1];
                System.out.printf("%-55s %5s\n", vOld + " vs " + vNew + ": ", MainTask.isRemoteNewer(vOld, vNew));
            }
        }

        private static boolean isRemoteNewer(String localVersion, String remoteVersion) {
            int rcRemote;
            if (localVersion == null || remoteVersion == null) {
                return false;
            }
            String[] localRaw = localVersion.replaceAll("[^0-9.-]", "").split("-", 2);
            String[] remoteRaw = remoteVersion.replaceAll("[^0-9.-]", "").split("-", 2);
            String vLocal = localRaw[0];
            String vRemote = remoteRaw[0];
            String rcLocalRaw = localRaw.length > 1 ? localRaw[1].replaceAll("\\D", "") : "0";
            String rcRemoteRaw = remoteRaw.length > 1 ? remoteRaw[1].replaceAll("\\D", "") : "0";
            int rcLocal = rcLocalRaw.isEmpty() ? 0 : Integer.parseInt(rcLocalRaw);
            int n = rcRemote = rcRemoteRaw.isEmpty() ? 0 : Integer.parseInt(rcRemoteRaw);
            if (!vLocal.equals(vRemote)) {
                int i;
                String[] localMajorMinor = vLocal.split("\\.");
                String[] remoteMajorMinor = vRemote.split("\\.");
                for (i = 0; i < localMajorMinor.length && i < remoteMajorMinor.length && localMajorMinor[i].equals(remoteMajorMinor[i]); ++i) {
                }
                if (i < localMajorMinor.length && i < remoteMajorMinor.length) {
                    String localPadded = String.format("%-3s", localMajorMinor[i]).replace(' ', '0');
                    String remotePadded = String.format("%-3s", remoteMajorMinor[i]).replace(' ', '0');
                    return remotePadded.compareTo(localPadded) > 0;
                }
                return remoteMajorMinor.length > localMajorMinor.length;
            }
            return Integer.compare(rcRemote, rcLocal) > 0;
        }

        @Override
        public UpdateInfo call() throws InterruptedException, ExecutionException {
            Log.info("\u5f00\u59cb\u68c0\u67e5\u53ef\u7528\u66f4\u65b0");
            long startTime = System.nanoTime();
            CompletionService<UpdateInfo.ModInfo> service = this.createCompletionService();
            UpdateInfo results = new UpdateInfo();
            if (VCModPluginCustom.checkSSVersion) {
                try {
                    String currentVanilla = Global.getSettings().getVersionString();
                    String latestVanilla = VersionChecker.getLatestSSVersion();
                    Log.info("\u5f53\u524d Starsector \u7684\u6e38\u620f\u7248\u672c\u662f " + currentVanilla + ", \u5df2\u77e5\u6700\u65b0\u7684\u7248\u672c\u662f " + latestVanilla);
                    if (MainTask.isRemoteNewer(currentVanilla, latestVanilla)) {
                        Log.info("Starsector \u6709\u53ef\u7528\u7684\u66f4\u65b0!");
                        results.setSSUpdate(latestVanilla);
                    }
                }
                catch (IOException ex) {
                    Log.error("Failed to load vanilla update data from URL \"https://bitbucket.org/LazyWizard/version-checker/downloads/vanilla.txt\"", ex);
                    results.setFailedSSError(ex.getClass().getSimpleName());
                }
                catch (Exception ex) {
                    Log.error("Failed to parse vanilla update data from URL \"https://bitbucket.org/LazyWizard/version-checker/downloads/vanilla.txt\"", ex);
                    results.setFailedSSError(ex.getClass().getSimpleName());
                }
            }
            for (int modsToCheck = this.localVersions.size(); modsToCheck > 0; --modsToCheck) {
                UpdateInfo.ModInfo tmp = service.take().get();
                if (tmp.failedUpdateCheck()) {
                    results.addFailed(tmp);
                    continue;
                }
                if (tmp.isUpdateAvailable()) {
                    results.addUpdate(tmp);
                    continue;
                }
                results.addNoUpdate(tmp);
            }
            String elapsedTime = DecimalFormat.getNumberInstance().format((double)(System.nanoTime() - startTime) / 1.0E9);
            Log.info("\u68c0\u67e5\u6e38\u620f\u4e0e " + results.getNumModsChecked() + " Mods \u5728 " + elapsedTime + " seconds");
            return results;
        }

        private static class SubTask
        implements Callable<UpdateInfo.ModInfo> {
            final UpdateInfo.VersionFile version;

            private SubTask(UpdateInfo.VersionFile version) {
                this.version = version;
            }

            @Override
            public UpdateInfo.ModInfo call() throws Exception {
                return VersionChecker.checkForUpdate(this.version);
            }
        }
    }
}

