/*
 * Decompiled with CFR 0.152.
 */
package exerelin.world;

import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.PlanetSpecAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.impl.campaign.procgen.Constellation;
import com.fs.starfarer.api.impl.campaign.procgen.NameAssigner;
import com.fs.starfarer.api.impl.campaign.procgen.StarAge;
import com.fs.starfarer.api.impl.campaign.procgen.StarSystemGenerator;
import exerelin.utilities.ExerelinConfig;

public class ExerelinCoreSystemGenerator
extends StarSystemGenerator {
    public ExerelinCoreSystemGenerator(StarSystemGenerator.CustomConstellationParams params) {
        super(params);
    }

    public Constellation generate() {
        Constellation c = super.generate();
        NameAssigner namer = new NameAssigner(c);
        namer.setSpecialNamesProbability(1.0f);
        namer.assignNames(this.params.name, this.params.secondaryName);
        for (SectorEntityToken entity : this.allNameableEntitiesAdded.keySet()) {
            if (!(entity instanceof PlanetAPI) || entity.getMarket() == null) continue;
            entity.getMarket().setName(entity.getName());
        }
        return c;
    }

    public PlanetSpecAPI pickStar(StarAge age) {
        PlanetSpecAPI newStar = null;
        for (int tries = 0; tries < 8; ++tries) {
            newStar = super.pickStar(age);
            if (newStar.isBlackHole() || newStar.isPulsar()) continue;
            break;
        }
        return newStar;
    }

    protected StarSystemGenerator.GenResult addPlanetsAndTerrain(float maxOrbitRadius) {
        boolean hasOrbits;
        boolean bl = hasOrbits = random.nextFloat() < this.starData.getProbOrbits();
        if (!hasOrbits) {
            return null;
        }
        float min = 4.0f;
        float max = 9.0f;
        int numOrbits = Math.round(ExerelinCoreSystemGenerator.getNormalRandom((float)(min = Math.max(min, (float)ExerelinConfig.minimumPlanets)), (float)(max = Math.max(min, max))));
        if (numOrbits <= 0) {
            return null;
        }
        float currentRadius = this.centerRadius + 750.0f + 500.0f * random.nextFloat();
        StarSystemGenerator.GenContext context = new StarSystemGenerator.GenContext((StarSystemGenerator)this, this.system, this.systemCenter, this.starData, null, 0, this.starAge.name(), currentRadius, maxOrbitRadius, null, -1);
        if (this.systemType == StarSystemGenerator.StarSystemType.BINARY_CLOSE || this.systemType == StarSystemGenerator.StarSystemType.TRINARY_1CLOSE_1FAR) {
            context.multipliers.add("binary");
        }
        if (this.systemType == StarSystemGenerator.StarSystemType.TRINARY_2CLOSE) {
            context.multipliers.add("trinary");
        }
        StarSystemGenerator.GenResult result = this.addOrbitingEntities(context, numOrbits, false, true, false, false);
        result.context = context;
        return result;
    }
}

