/*
 * Decompiled with CFR 0.152.
 */
package exerelin.world;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CustomCampaignEntityAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.econ.CommodityOnMarketAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.econ.MarketConditionAPI;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import exerelin.campaign.fleets.ExerelinLionsGuardFleetManager;
import exerelin.plugins.ExerelinModPlugin;
import exerelin.utilities.ExerelinConfig;
import exerelin.utilities.ExerelinFactionConfig;
import exerelin.utilities.ExerelinUtils;
import exerelin.utilities.ExerelinUtilsAstro;
import exerelin.utilities.ExerelinUtilsFaction;
import exerelin.utilities.ExerelinUtilsMarket;
import exerelin.utilities.StringHelper;
import exerelin.world.ExerelinProcGen;
import exerelin.world.MarketBalancer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ExerelinMarketBuilder {
    public static Logger log = Global.getLogger(ExerelinMarketBuilder.class);
    public static final String CONFIG_FILE = "data/config/exerelin/marketConfig.json";
    public static final String SURVEY_CONDITION_FILE = "data/config/exerelin/survey_condition_archetypes.csv";
    public static final Map<Archetype, Float> PLANET_ARCHETYPE_QUOTAS = new HashMap<Archetype, Float>(Archetype.values().length);
    public static final float CABAL_MARKET_MULT = 0.4f;
    public static final float CABAL_MILITARY_MARKET_CHANCE = 0.5f;
    public static final float LUDDIC_MAJORITY_CHANCE = 0.05f;
    public static final float LUDDIC_MINORITY_CHANCE = 0.15f;
    public static final float FORCE_MILITARY_BASE_CHANCE = 0.5f;
    public static final float FORCE_MILITARY_BASE_CHANCE_PIRATE = 0.5f;
    public static final float PRE_BALANCE_BUDGET_MULT = 0.9f;
    protected static final int[] PLANET_SIZE_ROTATION = new int[]{4, 5, 6, 5, 4};
    protected static final int[] MOON_SIZE_ROTATION = new int[]{3, 4, 5, 4};
    protected static final int[] STATION_SIZE_ROTATION = new int[]{3, 4, 5, 4, 3};
    protected final Map<String, Map<Archetype, Float>> conditionArchetypes = new HashMap<String, Map<Archetype, Float>>();
    protected final List<MarketConditionDef> conditions = new ArrayList<MarketConditionDef>();
    protected final Map<String, MarketConditionDef> conditionsByID = new HashMap<String, MarketConditionDef>();
    protected final List<MarketConditionDef> specialConditions = new ArrayList<MarketConditionDef>();
    protected Map<String, Float> commodityDemand = new HashMap<String, Float>();
    protected Map<String, Float> commoditySupply = new HashMap<String, Float>();
    protected Map<Archetype, List<ExerelinProcGen.ProcGenEntity>> marketsByArchetype = new HashMap<Archetype, List<ExerelinProcGen.ProcGenEntity>>();
    protected Map<ExerelinProcGen.ProcGenEntity, Map<Archetype, Float>> marketScoresForArchetypes = new HashMap<ExerelinProcGen.ProcGenEntity, Map<Archetype, Float>>();
    protected int marketArchetypeQueueNum = 0;
    protected int numStations = 0;
    protected int numPlanets = 0;
    protected int numMoons = 0;
    protected final ExerelinProcGen procGen;
    protected final Random random;
    protected final MarketBalancer balancer = new MarketBalancer(this);
    public static Archetype[] nonMiscArchetypes;

    public ExerelinMarketBuilder(ExerelinProcGen procGen) {
        this.procGen = procGen;
        this.random = procGen.getRandom();
        try {
            JSONArray conditionArchetypesCsv = Global.getSettings().getMergedSpreadsheetDataForMod("condition", SURVEY_CONDITION_FILE, "nexerelin");
            for (int x = 0; x < conditionArchetypesCsv.length(); ++x) {
                JSONObject row = conditionArchetypesCsv.getJSONObject(x);
                String cond = row.getString("condition");
                Map<Archetype, Float> entry = this.loadSurveyConditionEntry(row);
                this.conditionArchetypes.put(cond, entry);
            }
            JSONObject config = Global.getSettings().loadJSON(CONFIG_FILE);
            JSONArray conditionsJson = config.getJSONArray("conditions");
            for (int i = 0; i < conditionsJson.length(); ++i) {
                JSONObject condJson = conditionsJson.getJSONObject(i);
                String name = condJson.getString("name");
                String requiredFaction = condJson.optString("requiredFaction", "");
                if (!requiredFaction.isEmpty() && Global.getSector().getFaction(requiredFaction) == null) continue;
                MarketConditionDef cond = new MarketConditionDef(name);
                cond.cost = condJson.optInt("cost", 0);
                cond.special = condJson.optBoolean("special", false);
                cond.minSize = condJson.optInt("minSize", 0);
                cond.maxSize = condJson.optInt("maxSize", 99);
                cond.allowStations = condJson.optBoolean("allowStations", true);
                cond.allowDuplicates = condJson.optBoolean("allowDuplicates", true);
                cond.requiredFaction = requiredFaction;
                if (condJson.has("allowedPlanets")) {
                    cond.allowedPlanets.addAll(ExerelinUtils.JSONArrayToArrayList(condJson.getJSONArray("allowedPlanets")));
                }
                if (condJson.has("disallowedPlanets")) {
                    cond.allowedPlanets.addAll(ExerelinUtils.JSONArrayToArrayList(condJson.getJSONArray("disallowedPlanets")));
                }
                if (condJson.has("conflictsWith")) {
                    cond.conflictsWith.addAll(ExerelinUtils.JSONArrayToArrayList(condJson.getJSONArray("conflictsWith")));
                }
                if (condJson.has("requiresOneOf")) {
                    cond.requiresOneOf.addAll(ExerelinUtils.JSONArrayToArrayList(condJson.getJSONArray("requiresOneOf")));
                }
                if (condJson.has("noRequireForArchetype")) {
                    String archetypeName = StringHelper.flattenToAscii(condJson.getString("noRequireForArchetype").toUpperCase());
                    cond.noRequireForArchetype = Archetype.valueOf(archetypeName);
                }
                if (condJson.has("archetypes")) {
                    JSONObject archetypesJson = condJson.getJSONObject("archetypes");
                    float defaultWeight = (float)archetypesJson.optDouble("default", 0.0);
                    for (Archetype possibleArchetype : Archetype.values()) {
                        float weight = (float)archetypesJson.optDouble(possibleArchetype.name().toLowerCase(), (double)defaultWeight);
                        cond.archetypes.put(possibleArchetype, Float.valueOf(weight));
                    }
                } else {
                    for (Archetype possibleArchetype : Archetype.values()) {
                        cond.archetypes.put(possibleArchetype, Float.valueOf(1.0f));
                    }
                }
                if (cond.special) {
                    this.specialConditions.add(cond);
                    continue;
                }
                this.conditions.add(cond);
                this.conditionsByID.put(name, cond);
            }
        }
        catch (IOException | JSONException ex) {
            log.error((Object)ex);
            throw new IllegalStateException("Error loading market condition file for proc gen: " + ex);
        }
    }

    protected Map<Archetype, Float> loadSurveyConditionEntry(JSONObject csvRow) {
        HashMap<Archetype, Float> ret = new HashMap<Archetype, Float>();
        for (Archetype archetype : nonMiscArchetypes) {
            String archetypeName = StringHelper.flattenToAscii(archetype.name().toLowerCase());
            float val = (float)csvRow.optDouble(archetypeName, 0.0);
            ret.put(archetype, Float.valueOf(val));
        }
        return ret;
    }

    protected float getConditionWeightForArchetype(MarketConditionDef cond, Archetype archetype, float defaultWeight) {
        float weight = cond.archetypes.get((Object)archetype).floatValue();
        if (weight <= 0.0f) {
            weight = defaultWeight;
        }
        return weight;
    }

    protected float getConditionWeightForArchetype(String condID, Archetype archetype, float defaultWeight) {
        if (!this.conditionsByID.containsKey(condID)) {
            return defaultWeight;
        }
        return this.getConditionWeightForArchetype(this.conditionsByID.get(condID), archetype, defaultWeight);
    }

    protected boolean isConditionAllowedForPlanet(MarketConditionDef cond, PlanetAPI planet) {
        if (!cond.allowedPlanets.isEmpty()) {
            for (String type : cond.allowedPlanets) {
                if (!this.isPlanetOfType(planet, type)) continue;
                return true;
            }
            return false;
        }
        if (cond.disallowedPlanets.isEmpty()) {
            for (String type : cond.disallowedPlanets) {
                if (!this.isPlanetOfType(planet, type)) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean isConditionAllowedForPlanet(String condID, PlanetAPI planet) {
        return this.isConditionAllowedForPlanet(this.conditionsByID.get(condID), planet);
    }

    protected boolean hasConflict(MarketConditionDef possibleCond, MarketAPI market) {
        for (String conflict : possibleCond.conflictsWith) {
            if (!market.hasCondition(conflict)) continue;
            return true;
        }
        return false;
    }

    protected boolean checkRequisiteConditions(MarketConditionDef cond, ExerelinProcGen.ProcGenEntity entityData) {
        if (cond.requiresOneOf.isEmpty()) {
            return true;
        }
        if (cond.noRequireForArchetype != null && entityData.archetype == cond.noRequireForArchetype) {
            return true;
        }
        for (String reqId : cond.requiresOneOf) {
            if (!entityData.market.hasCondition(reqId)) continue;
            return true;
        }
        return false;
    }

    public boolean isConditionAllowed(MarketConditionDef cond, ExerelinProcGen.ProcGenEntity entityData) {
        if (cond == null) {
            return false;
        }
        MarketAPI market = entityData.market;
        boolean isStation = entityData.type == ExerelinProcGen.EntityType.STATION;
        int size = market.getSize();
        if (cond.minSize > size || cond.maxSize < size) {
            return false;
        }
        if (!cond.allowStations && isStation) {
            return false;
        }
        if (!cond.allowDuplicates && market.hasCondition(cond.name)) {
            return false;
        }
        if (entityData.entity instanceof PlanetAPI && !this.isConditionAllowedForPlanet(cond, (PlanetAPI)entityData.entity)) {
            return false;
        }
        if (this.hasConflict(cond, market)) {
            return false;
        }
        return this.checkRequisiteConditions(cond, entityData);
    }

    public boolean isConditionAllowed(String conditionId, ExerelinProcGen.ProcGenEntity entityData) {
        return this.isConditionAllowed(this.conditionsByID.get(conditionId), entityData);
    }

    protected MarketConditionDef pickMarketCondition(MarketAPI market, List<MarketConditionDef> possibleConds, ExerelinProcGen.ProcGenEntity entityData, int budget, boolean isFirst) {
        WeightedRandomPicker picker = new WeightedRandomPicker(this.random);
        int numConds = 0;
        if (isFirst) {
            budget += 100;
        }
        for (MarketConditionDef possibleCond : possibleConds) {
            float weight;
            if (possibleCond.cost > budget || !this.isConditionAllowed(possibleCond, entityData) || (weight = this.getConditionWeightForArchetype(possibleCond, entityData.archetype, 0.0f)) <= 0.0f) continue;
            picker.add((Object)possibleCond, weight);
            ++numConds;
        }
        if (numConds == 0) {
            return null;
        }
        return (MarketConditionDef)picker.pick();
    }

    public void addMarketCondition(ExerelinProcGen.ProcGenEntity entityData, MarketConditionDef cond) {
        MarketAPI market = entityData.market;
        market.addCondition(cond.name);
        entityData.marketPointsSpent += cond.cost;
        if (cond.name.equals("orbital_station")) {
            ExerelinProcGen.ProcGenEntity station = this.procGen.createEntityDataForStation(entityData.entity);
            station.market = market;
            this.procGen.createStation(station, market.getFactionId(), false);
        }
    }

    public void addMarketCondition(ExerelinProcGen.ProcGenEntity entityData, String cond) {
        this.addMarketCondition(entityData, this.conditionsByID.get(cond));
    }

    public void removeMarketCondition(ExerelinProcGen.ProcGenEntity entityData, MarketConditionDef cond) {
        ExerelinUtilsMarket.removeOneMarketCondition(entityData.market, cond.name);
        entityData.marketPointsSpent -= cond.cost;
    }

    public void removeMarketCondition(ExerelinProcGen.ProcGenEntity entityData, MarketConditionAPI cond) {
        MarketConditionDef def = this.conditionsByID.get(cond.getId());
        entityData.market.removeSpecificCondition(cond.getIdForPluginModifications());
        entityData.marketPointsSpent -= def.cost;
    }

    public void removeMarketCondition(ExerelinProcGen.ProcGenEntity entityData, String cond) {
        this.removeMarketCondition(entityData, this.conditionsByID.get(cond));
    }

    public void initMarketPointsAndAddRandomConditions(MarketAPI market, ExerelinProcGen.ProcGenEntity entityData) {
        MarketConditionDef cond;
        MarketConditionDef cond2;
        log.info((Object)("Processing market conditions for " + market.getPrimaryEntity().getName() + " (" + market.getFaction().getDisplayName() + ", " + (Object)((Object)entityData.archetype) + ")"));
        int size = market.getSize();
        int points = 150;
        if (size == 3) {
            points = 200;
        } else if (size == 4) {
            points = 200;
        } else if (size == 5) {
            points = 250;
        } else if (size == 6) {
            points = 250;
        } else if (size >= 7) {
            points = 300;
        }
        int bonusPoints = 0;
        for (int i = 0; i < size / 2; ++i) {
            if (!((double)this.random.nextFloat() > 0.4)) continue;
            bonusPoints += 50;
        }
        entityData.bonusMarketPoints = bonusPoints;
        entityData.marketPoints = points += bonusPoints;
        while ((float)entityData.marketPointsSpent < (float)points * 0.9f && (cond2 = this.pickMarketCondition(market, this.conditions, entityData, (int)((float)points * 0.9f - (float)entityData.marketPointsSpent), false)) != null) {
            log.info((Object)("\tAdding condition: " + cond2.name));
            this.addMarketCondition(entityData, cond2);
        }
        int numSpecial = 0;
        numSpecial = size == 2 ? 0 : (size <= 4 ? ExerelinUtils.randomNextIntInclusive(this.random, 1) : (size <= 6 ? ExerelinUtils.randomNextIntInclusive(this.random, 1) + ExerelinUtils.randomNextIntInclusive(this.random, 1) : (size <= 8 ? 1 + ExerelinUtils.randomNextIntInclusive(this.random, 1) : 2)));
        for (int i = 0; i < numSpecial && (cond = this.pickMarketCondition(market, this.specialConditions, entityData, 0, false)) != null; ++i) {
            log.info((Object)("\tAdding condition: " + cond.name));
            this.addMarketCondition(entityData, cond);
        }
    }

    protected float getMarketBestScoreForOtherArchetype(ExerelinProcGen.ProcGenEntity market, Archetype wantedArchetype, Map<Archetype, Float> scores) {
        float bestScore = 0.0f;
        for (Archetype archetype : nonMiscArchetypes) {
            float score;
            if (archetype == wantedArchetype || !((score = scores.get((Object)archetype).floatValue()) > bestScore)) continue;
            bestScore = score;
        }
        return bestScore;
    }

    protected Map<Archetype, Float> getMarketArchetypeScore(ExerelinProcGen.ProcGenEntity market) {
        HashMap<Archetype, Float> marketScores = new HashMap<Archetype, Float>();
        for (Archetype archetype : Archetype.values()) {
            marketScores.put(archetype, Float.valueOf(0.0f));
        }
        for (MarketConditionAPI cond : market.market.getConditions()) {
            if (!this.conditionArchetypes.containsKey(cond.getId())) continue;
            Map<Archetype, Float> condScores = this.conditionArchetypes.get(cond.getId());
            for (Archetype archetype : nonMiscArchetypes) {
                float score = condScores.get((Object)archetype).floatValue();
                marketScores.put(archetype, Float.valueOf(((Float)marketScores.get((Object)archetype)).floatValue() + score));
            }
        }
        return marketScores;
    }

    protected Map<ExerelinProcGen.ProcGenEntity, Map<Archetype, Float>> getMarketArchetypeScores(List<ExerelinProcGen.ProcGenEntity> markets) {
        HashMap<ExerelinProcGen.ProcGenEntity, Map<Archetype, Float>> scores = new HashMap<ExerelinProcGen.ProcGenEntity, Map<Archetype, Float>>();
        for (ExerelinProcGen.ProcGenEntity market : markets) {
            scores.put(market, this.getMarketArchetypeScore(market));
        }
        return scores;
    }

    protected List<ExerelinProcGen.ProcGenEntity> getOrderedListOfMarketsForArchetype(List<ExerelinProcGen.ProcGenEntity> markets, Archetype archetype) {
        final HashMap<ExerelinProcGen.ProcGenEntity, Float> weightsForArchetype = new HashMap<ExerelinProcGen.ProcGenEntity, Float>();
        for (ExerelinProcGen.ProcGenEntity market : markets) {
            float weight = this.marketScoresForArchetypes.get(market).get((Object)archetype).floatValue();
            weightsForArchetype.put(market, Float.valueOf(weight -= this.getMarketBestScoreForOtherArchetype(market, archetype, this.marketScoresForArchetypes.get(market))));
        }
        ArrayList<ExerelinProcGen.ProcGenEntity> ret = new ArrayList<ExerelinProcGen.ProcGenEntity>(markets);
        Collections.sort(ret, new Comparator<ExerelinProcGen.ProcGenEntity>(){

            @Override
            public int compare(ExerelinProcGen.ProcGenEntity data1, ExerelinProcGen.ProcGenEntity data2) {
                float weight2;
                float weight1 = ((Float)weightsForArchetype.get(data1)).floatValue();
                if (weight1 == (weight2 = ((Float)weightsForArchetype.get(data2)).floatValue())) {
                    return 0;
                }
                if (weight1 > weight2) {
                    return -1;
                }
                return 1;
            }
        });
        return ret;
    }

    public List<ExerelinProcGen.ProcGenEntity> assignArchetypesToTopMarkets(List<ExerelinProcGen.ProcGenEntity> markets, Archetype archetype, int num) {
        log.info((Object)("Assigning archetypes for archetype " + archetype.name() + ", available: " + markets.size()));
        List<ExerelinProcGen.ProcGenEntity> sorted = this.getOrderedListOfMarketsForArchetype(markets, archetype);
        ArrayList<ExerelinProcGen.ProcGenEntity> results = new ArrayList<ExerelinProcGen.ProcGenEntity>();
        for (int i = 0; i < num; ++i) {
            ExerelinProcGen.ProcGenEntity market = sorted.get(i);
            market.archetype = archetype;
            results.add(market);
        }
        this.marketsByArchetype.put(archetype, results);
        markets.removeAll(results);
        return results;
    }

    public void pickMarketArchetypes(List<ExerelinProcGen.ProcGenEntity> markets) {
        ArrayList<ExerelinProcGen.ProcGenEntity> marketsCopy = new ArrayList<ExerelinProcGen.ProcGenEntity>(markets);
        int numMarkets = markets.size();
        int numAgri = (int)((float)numMarkets * PLANET_ARCHETYPE_QUOTAS.get((Object)Archetype.AGRICULTURE).floatValue());
        int numOre = (int)((float)numMarkets * PLANET_ARCHETYPE_QUOTAS.get((Object)Archetype.ORE).floatValue());
        int numVol = (int)((float)numMarkets * PLANET_ARCHETYPE_QUOTAS.get((Object)Archetype.VOLATILES).floatValue());
        int numOrg = (int)((float)numMarkets * PLANET_ARCHETYPE_QUOTAS.get((Object)Archetype.ORGANICS).floatValue());
        int numManf = (int)((float)numMarkets * PLANET_ARCHETYPE_QUOTAS.get((Object)Archetype.MANUFACTURING).floatValue());
        int numHI = (int)((float)numMarkets * PLANET_ARCHETYPE_QUOTAS.get((Object)Archetype.HEAVY_INDUSTRY).floatValue());
        this.marketScoresForArchetypes = this.getMarketArchetypeScores(markets);
        List<ExerelinProcGen.ProcGenEntity> agriMarkets = this.assignArchetypesToTopMarkets(marketsCopy, Archetype.AGRICULTURE, numAgri);
        List<ExerelinProcGen.ProcGenEntity> oreMarkets = this.assignArchetypesToTopMarkets(marketsCopy, Archetype.ORE, numOre);
        List<ExerelinProcGen.ProcGenEntity> volMarkets = this.assignArchetypesToTopMarkets(marketsCopy, Archetype.VOLATILES, numVol);
        List<ExerelinProcGen.ProcGenEntity> orgMarkets = this.assignArchetypesToTopMarkets(marketsCopy, Archetype.ORGANICS, numOrg);
        List<ExerelinProcGen.ProcGenEntity> manfMarkets = this.assignArchetypesToTopMarkets(marketsCopy, Archetype.MANUFACTURING, numManf);
        List<ExerelinProcGen.ProcGenEntity> hiMarkets = this.assignArchetypesToTopMarkets(marketsCopy, Archetype.HEAVY_INDUSTRY, numHI);
        List<ExerelinProcGen.ProcGenEntity> miscMarkets = this.assignArchetypesToTopMarkets(marketsCopy, Archetype.MISC, marketsCopy.size());
    }

    public Archetype pickArchetypeForStation(ExerelinProcGen.ProcGenEntity station) {
        WeightedRandomPicker picker = new WeightedRandomPicker(this.random);
        picker.add((Object)Archetype.MISC, 4.0f);
        if (station.terrain != null) {
            if (station.terrain.getType().equals("asteroid_belt") || station.terrain.getType().equals("asteroid_field")) {
                picker.add((Object)Archetype.ORE, 20.0f);
            } else if (station.terrain.getType().equals("ring")) {
                picker.add((Object)Archetype.VOLATILES, 20.0f);
            }
        }
        if (station.primary instanceof PlanetAPI) {
            PlanetAPI planet = (PlanetAPI)station.primary;
            if (planet.isGasGiant()) {
                picker.add((Object)Archetype.VOLATILES, 30.0f);
            } else {
                Map<Archetype, Float> scores = this.getMarketArchetypeScore(this.procGen.createEntityDataForPlanet(planet));
                for (Map.Entry<Archetype, Float> tmp : scores.entrySet()) {
                    if (!(tmp.getValue().floatValue() > 0.0f)) continue;
                    picker.add((Object)tmp.getKey(), tmp.getValue().floatValue() * 0.1f);
                }
            }
        }
        return (Archetype)((Object)picker.pick());
    }

    protected int getSizeFromRotation(int[] array, int num) {
        return array[num % array.length];
    }

    protected void addCabalSubmarkets() {
        if (ExerelinModPlugin.HAVE_UNDERWORLD) {
            ArrayList<MarketAPI> cabalCandidates = new ArrayList<MarketAPI>();
            ArrayList<MarketAPI> cabalCandidatesBackup = new ArrayList<MarketAPI>();
            for (MarketAPI market : Global.getSector().getEconomy().getMarketsCopy()) {
                if (!market.getFactionId().equals("tritachyon")) continue;
                if (market.hasCondition("military_base") && this.random.nextFloat() > 0.5f) {
                    cabalCandidatesBackup.add(market);
                    continue;
                }
                cabalCandidates.add(market);
            }
            if (cabalCandidates.isEmpty()) {
                cabalCandidates = cabalCandidatesBackup;
            }
            Comparator<MarketAPI> marketSizeComparator = new Comparator<MarketAPI>(){

                @Override
                public int compare(MarketAPI m1, MarketAPI m2) {
                    int size2;
                    int size1 = m1.getSize();
                    if (size1 > (size2 = m2.getSize())) {
                        return -1;
                    }
                    if (size2 > size1) {
                        return 1;
                    }
                    return 0;
                }
            };
            Collections.sort(cabalCandidates, marketSizeComparator);
            try {
                int i = 0;
                while ((float)i < (float)cabalCandidates.size() * 0.4f) {
                    MarketAPI market = (MarketAPI)cabalCandidates.get(i);
                    market.addSubmarket("uw_cabalmarket");
                    market.addCondition("cabal_influence");
                    log.info((Object)("Added Cabal submarket to " + market.getName() + " (size " + market.getSize() + ")"));
                    ++i;
                }
            }
            catch (RuntimeException rex) {
                // empty catch block
            }
        }
    }

    protected boolean isPlanetOfType(PlanetAPI planet, String wantedType) {
        if (planet.getTypeId().startsWith(wantedType)) {
            return true;
        }
        return planet.getSpec().getName().toLowerCase(Locale.ROOT).startsWith(wantedType);
    }

    protected void addMarketConditionForPlanetType(ExerelinProcGen.ProcGenEntity data) {
        if (!(data.entity instanceof PlanetAPI)) {
            return;
        }
        PlanetAPI planet = (PlanetAPI)data.entity;
        MarketAPI market = data.market;
        if (this.isPlanetOfType(planet, "frozen") || this.isPlanetOfType(planet, "rocky_ice") || this.isPlanetOfType(planet, "US_blue") || this.isPlanetOfType(planet, "US_ice")) {
            market.addCondition("ice");
        } else if (!(this.isPlanetOfType(planet, "barren") || this.isPlanetOfType(planet, "rocky_metallic") || this.isPlanetOfType(planet, "barren-bombarded"))) {
            if (this.isPlanetOfType(planet, "barren-desert") || this.isPlanetOfType(planet, "US_red")) {
                market.addCondition("barren_marginal");
            } else if (this.isPlanetOfType(planet, "terran-eccentric") || this.isPlanetOfType(planet, "US_lifeless")) {
                market.addCondition("twilight");
            } else if (this.isPlanetOfType(planet, "terran") || this.isPlanetOfType(planet, "US_continent")) {
                market.addCondition("terran");
            } else if (this.isPlanetOfType(planet, "jungle") || this.isPlanetOfType(planet, "US_alkali")) {
                market.addCondition("jungle");
            } else if (this.isPlanetOfType(planet, "arid") || this.isPlanetOfType(planet, "US_lifelessArid") || this.isPlanetOfType(planet, "auric")) {
                market.addCondition("arid");
            } else if (this.isPlanetOfType(planet, "desert") || this.isPlanetOfType(planet, "US_crimson")) {
                market.addCondition("desert");
            } else if (this.isPlanetOfType(planet, "water")) {
                market.addCondition("water");
            } else if (this.isPlanetOfType(planet, "tundra")) {
                market.addCondition("tundra");
            } else if (this.isPlanetOfType(planet, "cryovolcanic")) {
                market.addCondition("cryovolcanic");
            }
        }
    }

    protected MarketAPI addMarket(ExerelinProcGen.ProcGenEntity data, String factionId) {
        MarketAPI market;
        boolean isMoon;
        log.info((Object)("Creating market for " + data.name + " (" + (Object)((Object)data.type) + ")"));
        SectorEntityToken entity = data.entity;
        int marketSize = 1;
        ExerelinProcGen.EntityType entityType = data.type;
        String planetType = data.planetType;
        boolean isStation = entityType == ExerelinProcGen.EntityType.STATION;
        boolean bl = isMoon = entityType == ExerelinProcGen.EntityType.MOON;
        if (data.isHQ) {
            marketSize = 7;
        } else if (data.isCapital) {
            marketSize = Math.min(marketSize + 1, 6);
        } else {
            marketSize = isStation ? this.getSizeFromRotation(STATION_SIZE_ROTATION, this.numStations) : (isMoon ? this.getSizeFromRotation(MOON_SIZE_ROTATION, this.numMoons) : this.getSizeFromRotation(PLANET_SIZE_ROTATION, this.numPlanets));
            if (isStation) {
                ++this.numStations;
            } else if (isMoon) {
                ++this.numMoons;
            } else {
                ++this.numPlanets;
            }
        }
        if (ExerelinUtilsFaction.isPirateFaction(factionId) && --marketSize < 3) {
            marketSize = 3;
        }
        if (data.forceMarketSize != -1) {
            marketSize = data.forceMarketSize;
        }
        if ((market = entity.getMarket()) == null) {
            market = Global.getFactory().createMarket(entity.getId(), entity.getName(), marketSize);
            entity.setMarket(market);
            market.setPrimaryEntity(entity);
        } else {
            market.setSize(marketSize);
        }
        data.market = market;
        market.setFactionId(factionId);
        market.setPlanetConditionMarketOnly(false);
        if (data.isHQ) {
            market.addCondition("headquarters");
            market.addCondition("military_base");
            market.addCondition("exerelin_supply_workshop");
            if (data == this.procGen.getHomeworld()) {
                // empty if block
            }
        } else if (data.isCapital) {
            // empty if block
        }
        market.addCondition("population_" + marketSize);
        market.removeCondition("decivilized");
        boolean isPirate = ExerelinUtilsFaction.isPirateFaction(factionId);
        int minSizeForMilitaryBase = 6;
        if (isMoon) {
            minSizeForMilitaryBase = 5;
        } else if (isStation) {
            minSizeForMilitaryBase = 5;
        }
        if (isPirate) {
            --minSizeForMilitaryBase;
        }
        if (marketSize >= minSizeForMilitaryBase && !market.hasCondition("military_base")) {
            float roll = (this.random.nextFloat() + this.random.nextFloat()) * 0.5f;
            float req = 0.5f;
            if (isPirate) {
                req = 0.5f;
            }
            if (roll > req) {
                market.addCondition("military_base");
            }
        }
        if (planetType != null && !planetType.isEmpty() && planetType.equals("terran-eccentric")) {
            LocationAPI system = entity.getContainingLocation();
            CustomCampaignEntityAPI mirror = system.addCustomEntity(entity.getId() + "_mirror", "\u6052\u661f\u955c", "stellar_mirror", factionId);
            mirror.setCircularOrbitPointingDown(entity, ExerelinUtilsAstro.getCurrentOrbitAngle(entity.getOrbitFocus(), entity) + 180.0f, entity.getRadius() + 150.0f, data.entity.getOrbit().getOrbitalPeriod());
            mirror.setCustomDescriptionId("stellar_mirror");
            CustomCampaignEntityAPI shade = system.addCustomEntity(entity.getId() + "_shade", "\u6052\u661f\u7f69", "stellar_shade", factionId);
            shade.setCircularOrbitPointingDown(entity, ExerelinUtilsAstro.getCurrentOrbitAngle(entity.getOrbitFocus(), entity), entity.getRadius() + 150.0f, data.entity.getOrbit().getOrbitalPeriod());
            shade.setCustomDescriptionId("stellar_shade");
        }
        if (marketSize <= 4 && !isStation) {
            market.addCondition("frontier");
        }
        this.initMarketPointsAndAddRandomConditions(market, data);
        if (!isStation || marketSize >= 3) {
            // empty if block
        }
        ExerelinFactionConfig config = ExerelinConfig.getExerelinFactionConfig(factionId);
        if (config.freeMarket) {
            market.addCondition("free_market");
        }
        market.getTariff().modifyFlat("generator", Global.getSector().getFaction(factionId).getTariffFraction());
        ExerelinUtilsMarket.setTariffs(market);
        if (factionId.equals("luddic_church") && this.random.nextFloat() > 0.15f || this.random.nextFloat() < 0.05f) {
            market.addCondition("luddic_majority");
        } else if (factionId.equals("spire")) {
            market.addCondition("aiw_inorganic_populace");
        } else if (!factionId.equals("crystanite") && factionId.equals("interstellarimperium") && !market.hasCondition("dissident") && !market.hasCondition("large_refugee_population")) {
            market.addCondition("ii_imperialdoctrine");
        }
        if (factionId.equals("templars")) {
            market.addSubmarket("tem_templarmarket");
            market.addCondition("exerelin_templar_control");
        } else {
            market.addSubmarket("open_market");
            market.addSubmarket("black_market");
        }
        market.addSubmarket("storage");
        Global.getSector().getEconomy().addMarket(market);
        entity.setFaction(factionId);
        if (data.isHQ && factionId.equals("sindrian_diktat")) {
            ExerelinLionsGuardFleetManager script = new ExerelinLionsGuardFleetManager(market);
            entity.addScript((EveryFrameScript)script);
        }
        for (MarketConditionAPI cond : market.getConditions()) {
            this.balancer.onAddMarketCondition(market, cond);
        }
        return market;
    }

    public static void addStartingMarketCommodities(MarketAPI market) {
        for (CommodityOnMarketAPI commodity : market.getAllCommodities()) {
            if (commodity.isNonEcon() || commodity.getCommodity().hasTag("noseed")) continue;
            float demand = commodity.getDemand().getDemand().modified;
            float unmet = 1.2f - commodity.getDemand().getFractionMet();
            commodity.addToStockpile(demand * unmet);
            float supply = commodity.getSupply().modified;
            commodity.addToStockpile(supply);
        }
    }

    static {
        PLANET_ARCHETYPE_QUOTAS.put(Archetype.AGRICULTURE, Float.valueOf(0.15f));
        PLANET_ARCHETYPE_QUOTAS.put(Archetype.ORE, Float.valueOf(0.18f));
        PLANET_ARCHETYPE_QUOTAS.put(Archetype.ORGANICS, Float.valueOf(0.18f));
        PLANET_ARCHETYPE_QUOTAS.put(Archetype.VOLATILES, Float.valueOf(0.14f));
        PLANET_ARCHETYPE_QUOTAS.put(Archetype.MANUFACTURING, Float.valueOf(0.2f));
        PLANET_ARCHETYPE_QUOTAS.put(Archetype.HEAVY_INDUSTRY, Float.valueOf(0.15f));
        nonMiscArchetypes = new Archetype[]{Archetype.AGRICULTURE, Archetype.ORE, Archetype.VOLATILES, Archetype.ORGANICS, Archetype.MANUFACTURING, Archetype.HEAVY_INDUSTRY};
    }

    public static enum Archetype {
        AGRICULTURE,
        ORE,
        VOLATILES,
        ORGANICS,
        MANUFACTURING,
        HEAVY_INDUSTRY,
        MISC;

    }

    public static class MarketConditionDef {
        final String name;
        int cost = 0;
        Map<Archetype, Float> archetypes = new HashMap<Archetype, Float>();
        float chance = 0.0f;
        int minSize = 0;
        int maxSize = 99;
        boolean allowDuplicates = true;
        boolean allowStations = true;
        boolean special = false;
        String requiredFaction;
        final List<String> allowedPlanets = new ArrayList<String>();
        final List<String> disallowedPlanets = new ArrayList<String>();
        final List<String> conflictsWith = new ArrayList<String>();
        final List<String> requiresOneOf = new ArrayList<String>();
        Archetype noRequireForArchetype = null;

        public MarketConditionDef(String name) {
            this.name = name;
        }
    }
}

