/*
 * Decompiled with CFR 0.152.
 */
package exerelin.world;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignPlugin;
import com.fs.starfarer.api.campaign.CustomCampaignEntityAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.SectorGeneratorPlugin;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.CoreCampaignPluginImpl;
import com.fs.starfarer.api.impl.campaign.CoreScript;
import com.fs.starfarer.api.impl.campaign.events.CoreEventProbabilityManager;
import com.fs.starfarer.api.impl.campaign.fleets.BountyPirateFleetManager;
import com.fs.starfarer.api.impl.campaign.fleets.EconomyFleetManager;
import com.fs.starfarer.api.impl.campaign.fleets.LuddicPathFleetManager;
import com.fs.starfarer.api.impl.campaign.fleets.MercFleetManager;
import com.fs.starfarer.api.impl.campaign.fleets.PirateFleetManager;
import com.fs.starfarer.api.impl.campaign.procgen.StarAge;
import com.fs.starfarer.api.impl.campaign.procgen.StarSystemGenerator;
import com.fs.starfarer.api.util.Misc;
import data.scripts.campaign.fleets.DS_BountyPirateFleetManager;
import data.scripts.campaign.fleets.DS_LuddicPathFleetManager;
import data.scripts.campaign.fleets.DS_MercFleetManager;
import data.scripts.campaign.fleets.DS_PirateFleetManager;
import exerelin.campaign.AllianceManager;
import exerelin.campaign.CovertOpsManager;
import exerelin.campaign.DiplomacyManager;
import exerelin.campaign.ExerelinSetupData;
import exerelin.campaign.PlayerFactionStore;
import exerelin.campaign.SectorManager;
import exerelin.campaign.StatsTracker;
import exerelin.campaign.fleets.InvasionFleetManager;
import exerelin.campaign.fleets.MiningFleetManager;
import exerelin.campaign.fleets.PatrolFleetManagerReplacer;
import exerelin.campaign.fleets.ResponseFleetManager;
import exerelin.plugins.ExerelinCoreCampaignPlugin;
import exerelin.plugins.ExerelinModPlugin;
import exerelin.utilities.ExerelinUtils;
import exerelin.utilities.ExerelinUtilsAstro;
import exerelin.utilities.ExerelinUtilsMarket;
import exerelin.world.ExerelinCoreSystemGenerator;
import exerelin.world.ExerelinMarketBuilder;
import exerelin.world.VanillaSystemsGenerator;
import java.util.Random;
import org.apache.log4j.Logger;
import org.lwjgl.util.vector.Vector2f;

public class ExerelinNewGameSetup
implements SectorGeneratorPlugin {
    public static final Vector2f SECTOR_CENTER = new Vector2f(0.0f, -6000.0f);
    public static Logger log = Global.getLogger(ExerelinNewGameSetup.class);
    protected Random rand = null;

    protected void addPrismMarket(SectorAPI sector) {
        CustomCampaignEntityAPI prismEntity;
        if (ExerelinSetupData.getInstance().numSystems == 1) {
            PlanetAPI planet;
            SectorEntityToken toOrbit = Global.getSector().getEntityById("jangala");
            float radius = toOrbit.getRadius();
            float orbitDistance = radius + 150.0f;
            if (toOrbit instanceof PlanetAPI && (planet = (PlanetAPI)toOrbit).isStar()) {
                orbitDistance = radius + 2000.0f + this.rand.nextFloat() * 500.0f;
            }
            prismEntity = toOrbit.getContainingLocation().addCustomEntity("nex_prismFreeport", "Prism Freeport", "exerelin_freeport_type", "independent");
            prismEntity.setCircularOrbitPointingDown(toOrbit, ExerelinUtilsAstro.getRandomAngle(this.rand), orbitDistance, ExerelinUtilsAstro.getOrbitalPeriod(toOrbit, orbitDistance));
        } else {
            LocationAPI hyperspace = sector.getHyperspace();
            prismEntity = hyperspace.addCustomEntity("nex_prismFreeport", "Prism Freeport", "exerelin_freeport_type", "independent");
            float xpos = 2000.0f;
            if (!ExerelinSetupData.getInstance().corvusMode) {
                xpos = -2000.0f;
            }
            prismEntity.setCircularOrbitWithSpin(hyperspace.createToken(xpos, 0.0f), ExerelinUtilsAstro.getRandomAngle(this.rand), 150.0f, 60.0f, 30.0f, 30.0f);
        }
        prismEntity.addTag("nex_uninvadable");
        MarketAPI market = Global.getFactory().createMarket("nex_prismFreeport", "Prism Freeport", 5);
        market.setFactionId("independent");
        market.addCondition("population_5");
        market.addCondition("spaceport");
        market.addCondition("hydroponics_complex");
        market.addCondition("trade_center");
        market.addCondition("stealth_minefields");
        market.addCondition("cryosanctum");
        market.addCondition("military_base");
        market.addCondition("free_market");
        market.addSubmarket("open_market");
        market.addSubmarket("black_market");
        market.addSubmarket("storage");
        market.setBaseSmugglingStabilityValue(0);
        market.getMemoryWithoutUpdate().set("$nex_uninvadable", (Object)true);
        ExerelinMarketBuilder.addStartingMarketCommodities(market);
        market.getTariff().modifyFlat("generator", sector.getFaction("independent").getTariffFraction());
        ExerelinUtilsMarket.setTariffs(market);
        market.addSubmarket("exerelin_prismMarket");
        market.setPrimaryEntity((SectorEntityToken)prismEntity);
        prismEntity.setMarket(market);
        prismEntity.setFaction("independent");
        market.setSurveyLevel(MarketAPI.SurveyLevel.FULL);
        sector.getEconomy().addMarket(market);
        prismEntity.removeTag("station");
        prismEntity.setCustomDescriptionId("exerelin_prismFreeport");
    }

    public void generate(SectorAPI sector) {
        log.info((Object)"Starting sector generation...");
        this.rand = new Random(ExerelinUtils.getStartingSeed());
        ExerelinSetupData setupData = ExerelinSetupData.getInstance();
        boolean corvusMode = setupData.corvusMode;
        String hyperMap = "data/campaign/terrain/hyperspace_map.png";
        SectorEntityToken deep_hyperspace = Misc.addNebulaFromPNG((String)hyperMap, (float)0.0f, (float)0.0f, (LocationAPI)sector.getHyperspace(), (String)"terrain", (String)"deep_hyperspace", (int)4, (int)4, (String)"hyperspace", (StarAge)StarAge.ANY);
        if (corvusMode) {
            VanillaSystemsGenerator.generate(sector);
        } else {
            StarSystemGenerator.CustomConstellationParams params = new StarSystemGenerator.CustomConstellationParams(StarAge.AVERAGE);
            int num = ExerelinSetupData.getInstance().numSystems;
            params.minStars = 14;
            params.maxStars = 18;
            params.location = SECTOR_CENTER;
            new ExerelinCoreSystemGenerator(params).generate();
            CustomCampaignEntityAPI coreLabel = Global.getSector().getHyperspace().addCustomEntity("core_label_id", null, "core_label", null);
            coreLabel.setFixedLocation(SECTOR_CENTER.getX(), SECTOR_CENTER.getY());
        }
        if (setupData.prismMarketPresent) {
            this.addPrismMarket(sector);
        }
        String selectedFactionId = PlayerFactionStore.getPlayerFactionIdNGC();
        PlayerFactionStore.setPlayerFactionId(selectedFactionId);
        log.info((Object)"Adding scripts and plugins");
        sector.addScript((EveryFrameScript)new CoreScript());
        sector.addScript((EveryFrameScript)new PatrolFleetManagerReplacer());
        sector.registerPlugin((CampaignPlugin)new CoreCampaignPluginImpl());
        sector.registerPlugin((CampaignPlugin)new ExerelinCoreCampaignPlugin());
        sector.addScript((EveryFrameScript)new CoreEventProbabilityManager());
        sector.addScript((EveryFrameScript)new EconomyFleetManager());
        if (ExerelinModPlugin.HAVE_DYNASECTOR) {
            sector.addScript((EveryFrameScript)new DS_MercFleetManager());
            sector.addScript((EveryFrameScript)new DS_LuddicPathFleetManager());
            sector.addScript((EveryFrameScript)new DS_PirateFleetManager());
            sector.addScript((EveryFrameScript)new DS_BountyPirateFleetManager());
        } else {
            sector.addScript((EveryFrameScript)new MercFleetManager());
            sector.addScript((EveryFrameScript)new LuddicPathFleetManager());
            sector.addScript((EveryFrameScript)new PirateFleetManager());
            sector.addScript((EveryFrameScript)new BountyPirateFleetManager());
        }
        sector.addScript((EveryFrameScript)SectorManager.create());
        sector.addScript((EveryFrameScript)DiplomacyManager.create());
        sector.addScript((EveryFrameScript)InvasionFleetManager.create());
        sector.addScript((EveryFrameScript)ResponseFleetManager.create());
        sector.addScript((EveryFrameScript)MiningFleetManager.create());
        sector.addScript((EveryFrameScript)CovertOpsManager.create());
        sector.addScript((EveryFrameScript)AllianceManager.create());
        StatsTracker.create();
        DiplomacyManager.setRandomFactionRelationships(setupData.randomStartRelationships);
        DiplomacyManager.initFactionRelationships(false);
        SectorManager.setCorvusMode(corvusMode);
        SectorManager.setHardMode(setupData.hardMode);
        SectorManager.setFreeStart(setupData.freeStart);
        log.info((Object)"Finished sector generation");
    }
}

