/*
 * Decompiled with CFR 0.152.
 */
package exerelin.world;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignTerrainAPI;
import com.fs.starfarer.api.campaign.CustomCampaignEntityAPI;
import com.fs.starfarer.api.campaign.JumpPointAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.econ.MarketConditionAPI;
import com.fs.starfarer.api.impl.campaign.procgen.NameAssigner;
import com.fs.starfarer.api.impl.campaign.procgen.StarAge;
import com.fs.starfarer.api.impl.campaign.procgen.themes.RemnantSeededFleetManager;
import com.fs.starfarer.api.impl.campaign.procgen.themes.RemnantStationFleetManager;
import com.fs.starfarer.api.impl.campaign.shared.SharedData;
import com.fs.starfarer.api.impl.campaign.terrain.MagneticFieldTerrainPlugin;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import data.scripts.campaign.AL_ChaosCrackFleetManager;
import data.scripts.campaign.ExigencyCommRelayAdder;
import data.scripts.world.exipirated.ExipiratedAvestaFleetManager;
import data.scripts.world.exipirated.ExipiratedAvestaMovement;
import data.scripts.world.exipirated.ExipiratedCollectorFleetManager;
import data.scripts.world.exipirated.ExipiratedPatrolFleetManager;
import exerelin.campaign.DiplomacyManager;
import exerelin.campaign.ExerelinSetupData;
import exerelin.campaign.PlayerFactionStore;
import exerelin.campaign.SectorManager;
import exerelin.utilities.ExerelinConfig;
import exerelin.utilities.ExerelinFactionConfig;
import exerelin.utilities.ExerelinUtils;
import exerelin.utilities.ExerelinUtilsAstro;
import exerelin.utilities.ExerelinUtilsFaction;
import exerelin.utilities.StringHelper;
import exerelin.world.ExerelinMarketBuilder;
import exerelin.world.ExerelinNewGameSetup;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.lazywizard.lazylib.MathUtils;
import org.lwjgl.util.vector.Vector2f;

public class ExerelinProcGen {
    public static final float CORE_WIDTH = 15000.0f;
    public static final float CORE_HEIGHT = 12000.0f;
    public static final float BEACON_SEARCH_RANGE = 900.0f;
    public static final Set<String> ALLOWED_STATION_TERRAIN = new HashSet<String>(Arrays.asList("asteroid_belt", "asteroid_field", "ring"));
    protected static final String PLANET_NAMES_FILE = "data/config/exerelin/planetNames.json";
    @Deprecated
    protected static List<String> possibleSystemNames = new ArrayList<String>();
    @Deprecated
    protected static List<String> possiblePlanetNames = new ArrayList<String>();
    protected static List<String> possibleStationNames = new ArrayList<String>();
    public static final List<String> stationImages = new ArrayList<String>(Arrays.asList("station_side00", "station_side02", "station_side04", "station_jangala_type"));
    public static final Set<String> TAGS_TO_REMOVE = new HashSet<String>(Arrays.asList("theme_derelict", "theme_derelict_mothership", "theme_derelict_probes", "theme_derelict_survey_ship", "theme_remnant", "theme_remnant_destroyed", "theme_remnant_main", "theme_remnant_resurgent", "theme_remnant_secondary", "theme_remnant_suppressed"));
    protected List<String> factionIds = new ArrayList<String>();
    protected List<StarSystemAPI> systems = new ArrayList<StarSystemAPI>();
    protected List<StarSystemAPI> maybePopulatedSystems = new ArrayList<StarSystemAPI>();
    protected Set<StarSystemAPI> populatedSystems = new HashSet<StarSystemAPI>();
    protected Map<StarSystemAPI, Float> positiveDesirabilityBySystem = new HashMap<StarSystemAPI, Float>();
    protected Map<StarSystemAPI, List<ProcGenEntity>> marketsBySystem = new HashMap<StarSystemAPI, List<ProcGenEntity>>();
    protected Map<StarSystemAPI, ProcGenEntity> capitalsBySystem = new HashMap<StarSystemAPI, ProcGenEntity>();
    protected List<ProcGenEntity> planets = new ArrayList<ProcGenEntity>();
    protected List<ProcGenEntity> habitablePlanets = new ArrayList<ProcGenEntity>();
    protected List<ProcGenEntity> desirablePlanets = new ArrayList<ProcGenEntity>();
    protected List<ProcGenEntity> populatedPlanets = new ArrayList<ProcGenEntity>();
    protected List<ProcGenEntity> stations = new ArrayList<ProcGenEntity>();
    protected Map<SectorEntityToken, ProcGenEntity> procGenEntitiesByToken = new HashMap<SectorEntityToken, ProcGenEntity>();
    protected List<String> alreadyUsedStationNames = new ArrayList<String>();
    protected Map<PlanetAPI, Float> planetDesirabilityCache = new HashMap<PlanetAPI, Float>();
    protected Map<String, String> systemToRelay = new HashMap<String, String>();
    protected Map<String, String> planetToRelay = new HashMap<String, String>();
    protected ProcGenEntity homeworld;
    protected ExerelinSetupData setupData;
    protected ExerelinMarketBuilder marketSetup;
    protected Random random;
    protected Comparator<ProcGenEntity> sortByMarketPointsUsed = new Comparator<ProcGenEntity>(){

        @Override
        public int compare(ProcGenEntity e1, ProcGenEntity e2) {
            float spendPercent1 = e1.marketPointsSpent / e1.marketPoints;
            float spendPercent2 = e2.marketPointsSpent / e2.marketPoints;
            if (spendPercent1 > spendPercent2) {
                return -1;
            }
            if (spendPercent2 > spendPercent1) {
                return 1;
            }
            return 0;
        }
    };

    protected static void loadData() {
        try {
            JSONObject planetConfig = Global.getSettings().loadJSON(PLANET_NAMES_FILE);
            JSONArray systemNames = planetConfig.getJSONArray("stars");
            possibleSystemNames = ExerelinUtils.JSONArrayToArrayList(systemNames);
            JSONArray planetNames = planetConfig.getJSONArray("planets");
            possiblePlanetNames = ExerelinUtils.JSONArrayToArrayList(planetNames);
            JSONArray stationNames = planetConfig.getJSONArray("stations");
            possibleStationNames = ExerelinUtils.JSONArrayToArrayList(stationNames);
        }
        catch (IOException | JSONException ex) {
            ExerelinNewGameSetup.log.error((Object)ex);
        }
    }

    protected List<String> getStartingFactions() {
        List<String> availableFactions = this.setupData.getPlayableFactions();
        int wantedFactionNum = this.setupData.numStartFactions;
        if (wantedFactionNum <= 0) {
            if (ExerelinConfig.enableIndependents) {
                availableFactions.add("independent");
            }
            if (!ExerelinConfig.enablePirates) {
                availableFactions.remove("pirates");
            }
            return availableFactions;
        }
        int numFactions = 0;
        HashSet<String> factions = new HashSet<String>();
        if (!ExerelinSetupData.getInstance().freeStart) {
            String alignedFactionId = PlayerFactionStore.getPlayerFactionId();
            factions.add(alignedFactionId);
            availableFactions.remove(alignedFactionId);
            ++numFactions;
        }
        if (ExerelinConfig.enablePirates) {
            factions.add("pirates");
        }
        availableFactions.remove("pirates");
        if (ExerelinConfig.enableIndependents) {
            factions.add("independent");
        }
        availableFactions.remove("independent");
        availableFactions.remove("player_npc");
        WeightedRandomPicker picker = new WeightedRandomPicker(this.random);
        picker.addAll(availableFactions);
        while (numFactions < wantedFactionNum && !picker.isEmpty()) {
            String factionId = (String)picker.pickAndRemove();
            factions.add(factionId);
            ExerelinNewGameSetup.log.info((Object)("Adding starting faction: " + factionId));
            ++numFactions;
        }
        ExerelinNewGameSetup.log.info((Object)("Number of starting factions: " + numFactions));
        return new ArrayList<String>(factions);
    }

    public Random getRandom() {
        return this.random;
    }

    protected void pickEntityInteractionImage(SectorEntityToken entity, MarketAPI market, String planetType, EntityType entityType) {
        boolean largeMarket;
        WeightedRandomPicker allowedImages = new WeightedRandomPicker(this.random);
        allowedImages.add((Object)new String[]{"illustrations", "cargo_loading"});
        allowedImages.add((Object)new String[]{"illustrations", "hound_hangar"});
        allowedImages.add((Object)new String[]{"illustrations", "space_bar"});
        boolean isStation = entityType == EntityType.STATION;
        boolean isMoon = entityType == EntityType.MOON;
        int size = market.getSize();
        boolean bl = largeMarket = size >= 5;
        if (isStation) {
            boolean bl2 = largeMarket = size >= 4;
        }
        if (market.hasCondition("urbanized_polity") || largeMarket) {
            allowedImages.add((Object)new String[]{"illustrations", "urban00"});
            allowedImages.add((Object)new String[]{"illustrations", "urban01"});
            allowedImages.add((Object)new String[]{"illustrations", "urban02"});
            allowedImages.add((Object)new String[]{"illustrations", "urban03"});
            if (ExerelinUtilsFaction.doesFactionExist("citadeldefenders")) {
                allowedImages.add((Object)new String[]{"illustrationz", "streets"});
                if (!isStation) {
                    allowedImages.add((Object)new String[]{"illustrationz", "twin_cities"});
                }
            }
            if (!isStation) {
                allowedImages.add((Object)new String[]{"illustrations", "eochu_bres"});
            }
        }
        if (!isStation && market.hasCondition("ore_complex")) {
            allowedImages.add((Object)new String[]{"illustrations", "mine"});
        }
        if (largeMarket) {
            allowedImages.add((Object)new String[]{"illustrations", "industrial_megafacility"});
            allowedImages.add((Object)new String[]{"illustrations", "city_from_above"});
        }
        if (isStation && largeMarket) {
            allowedImages.add((Object)new String[]{"illustrations", "jangala_station"});
            allowedImages.add((Object)new String[]{"illustrations", "orbital"});
        }
        if (entity.getFaction().getId().equals("pirates")) {
            allowedImages.add((Object)new String[]{"illustrations", "pirate_station"});
        }
        if (!isStation && (planetType.equals("rocky_metallic") || planetType.equals("rocky_barren") || planetType.equals("barren-bombarded"))) {
            allowedImages.add((Object)new String[]{"illustrations", "vacuum_colony"});
        }
        if (planetType.equals("desert") && isMoon) {
            allowedImages.add((Object)new String[]{"illustrations", "desert_moons_ruins"});
        }
        String[] illustration = (String[])allowedImages.pick();
        entity.setInteractionImage(illustration[0], illustration[1]);
    }

    protected ProcGenEntity getHomeworld() {
        return this.homeworld;
    }

    protected boolean validateCoreSystems(List<StarSystemAPI> systems) {
        if (systems.size() < this.setupData.numSystems) {
            return false;
        }
        int numDesirables = 0;
        block0: for (StarSystemAPI system : systems) {
            int count = 0;
            for (PlanetAPI planet : system.getPlanets()) {
                if (this.getDesirability(planet) <= 0.0f) continue;
                ++numDesirables;
                if (++count < this.setupData.maxPlanetsPerSystem) continue;
                continue block0;
            }
        }
        return numDesirables >= this.setupData.numPlanets;
    }

    protected List<StarSystemAPI> getCoreSystems(float width, float height) {
        ArrayList<StarSystemAPI> list = new ArrayList<StarSystemAPI>();
        for (StarSystemAPI system : Global.getSector().getStarSystems()) {
            Vector2f loc = system.getLocation();
            if (Math.abs(loc.x - ExerelinNewGameSetup.SECTOR_CENTER.x) > width || Math.abs(loc.y - ExerelinNewGameSetup.SECTOR_CENTER.y) > height || system.hasPulsar() || system.getStar().getSpec().isBlackHole()) continue;
            list.add(system);
        }
        if (!this.validateCoreSystems(list)) {
            return this.getCoreSystems(width * 1.5f, height * 1.5f);
        }
        return list;
    }

    protected void addDesirabilityForSystem(StarSystemAPI system, float amount) {
        if (this.positiveDesirabilityBySystem.containsKey(system)) {
            amount += this.positiveDesirabilityBySystem.get(system).floatValue();
        }
        this.positiveDesirabilityBySystem.put(system, Float.valueOf(amount));
    }

    protected float getDesirabilityForMarketCondition(MarketConditionAPI cond) {
        switch (cond.getId()) {
            case "habitable": {
                return 2.0f;
            }
            case "mild_climate": {
                return 0.5f;
            }
            case "ore_abundant": 
            case "rare_ore_abundant": 
            case "organics_abundant": 
            case "volatiles_abundant": {
                return 0.3f;
            }
            case "ore_rich": 
            case "rare_ore_rich": 
            case "organics_plentiful": 
            case "volatiles_plentiful": {
                return 0.6f;
            }
            case "ore_ultrarich": 
            case "rare_ore_ultrarich": {
                return 1.0f;
            }
            case "farmland_adequate": {
                return 0.2f;
            }
            case "farmland_rich": {
                return 0.35f;
            }
            case "farmland_bountiful": {
                return 0.6f;
            }
        }
        if (cond.getGenSpec() != null) {
            float hazard = cond.getGenSpec().getHazard();
            if (hazard >= 0.5f) {
                return -0.75f;
            }
            if (hazard >= 0.25f) {
                return -0.25f;
            }
        }
        return 0.0f;
    }

    protected float getDesirability(PlanetAPI planet) {
        if (this.planetDesirabilityCache.containsKey(planet)) {
            return this.planetDesirabilityCache.get(planet).floatValue();
        }
        MarketAPI market = planet.getMarket();
        if (market == null) {
            return 0.0f;
        }
        float desirability = 0.5f;
        for (MarketConditionAPI cond : market.getConditions()) {
            desirability += this.getDesirabilityForMarketCondition(cond);
        }
        this.planetDesirabilityCache.put(planet, Float.valueOf(desirability));
        return desirability;
    }

    protected ProcGenEntity createEntityDataForPlanet(PlanetAPI planet) {
        ProcGenEntity data = new ProcGenEntity((SectorEntityToken)planet);
        data.name = planet.getName();
        data.type = planet.isMoon() ? EntityType.MOON : EntityType.PLANET;
        data.market = planet.getMarket();
        data.desirability = this.getDesirability(planet);
        data.planetType = planet.getTypeId();
        data.primary = planet.getOrbitFocus();
        data.starSystem = (StarSystemAPI)planet.getContainingLocation();
        return data;
    }

    protected void createEntityDataForSystem(StarSystemAPI system) {
        for (PlanetAPI planet : system.getPlanets()) {
            if (planet.isStar() || planet.isGasGiant()) continue;
            ProcGenEntity planetData = this.createEntityDataForPlanet(planet);
            this.procGenEntitiesByToken.put((SectorEntityToken)planet, planetData);
            this.planets.add(planetData);
            if (planetData.desirability >= 0.0f) {
                this.desirablePlanets.add(planetData);
                this.addDesirabilityForSystem(system, planetData.desirability);
            }
            if (!planet.getMarket().hasCondition("habitable")) continue;
            this.habitablePlanets.add(planetData);
        }
    }

    protected void pickPopulatedPlanets(WeightedRandomPicker<ProcGenEntity> picker, List<ProcGenEntity> planets) {
        picker.clear();
        for (ProcGenEntity planet : planets) {
            float weight = Math.max(planet.desirability + 1.0f, 0.2f);
            if (this.populatedSystems.contains(planet.starSystem)) {
                weight *= 99.0f;
            }
            picker.add((Object)planet, weight);
        }
        while (this.populatedPlanets.size() < this.setupData.numPlanets && !picker.isEmpty()) {
            ProcGenEntity candidate = (ProcGenEntity)picker.pickAndRemove();
            int numMarketsInSystem = this.marketsBySystem.get(candidate.starSystem).size();
            if (numMarketsInSystem >= this.setupData.maxPlanetsPerSystem) continue;
            this.populatedPlanets.add(candidate);
            this.populatedSystems.add(candidate.starSystem);
            this.marketsBySystem.get(candidate.starSystem).add(candidate);
        }
    }

    protected void pickPopulatedPlanets() {
        WeightedRandomPicker picker = new WeightedRandomPicker(this.random);
        ArrayList<ProcGenEntity> desirableNotHabitable = new ArrayList<ProcGenEntity>(this.desirablePlanets);
        desirableNotHabitable.removeAll(this.habitablePlanets);
        ArrayList<ProcGenEntity> notDesirable = new ArrayList<ProcGenEntity>();
        for (ProcGenEntity entity : this.planets) {
            PlanetAPI planet = (PlanetAPI)entity.entity;
            if (planet.isGasGiant() || this.desirablePlanets.contains(entity)) continue;
            notDesirable.add(entity);
        }
        ExerelinNewGameSetup.log.info((Object)("Picking habitable planets: " + this.habitablePlanets.size()));
        this.pickPopulatedPlanets((WeightedRandomPicker<ProcGenEntity>)picker, this.habitablePlanets);
        ExerelinNewGameSetup.log.info((Object)("Picking other desirable planets: " + desirableNotHabitable.size()));
        this.pickPopulatedPlanets((WeightedRandomPicker<ProcGenEntity>)picker, desirableNotHabitable);
        ExerelinNewGameSetup.log.info((Object)("Picking undesirable planets: " + notDesirable.size()));
        this.pickPopulatedPlanets((WeightedRandomPicker<ProcGenEntity>)picker, notDesirable);
    }

    protected boolean getStationNameAlreadyUsed(String newName) {
        for (String name : this.alreadyUsedStationNames) {
            if (!name.equals(newName)) continue;
            return true;
        }
        return false;
    }

    public String getStationName(SectorEntityToken target) {
        String ret;
        WeightedRandomPicker picker = new WeightedRandomPicker(this.random);
        picker.addAll(possibleStationNames);
        String name = target.getName();
        if (target instanceof CampaignTerrainAPI) {
            name = target.getContainingLocation().getName();
        }
        while (this.getStationNameAlreadyUsed(ret = name + " " + (String)picker.pickAndRemove()) && !picker.isEmpty()) {
        }
        return ret;
    }

    protected ProcGenEntity createEntityDataForStation(SectorEntityToken target) {
        ProcGenEntity data = new ProcGenEntity(null);
        data.type = EntityType.STATION;
        data.primary = target;
        if (target.getContainingLocation() instanceof StarSystemAPI) {
            data.starSystem = (StarSystemAPI)target.getContainingLocation();
        }
        if (target instanceof CampaignTerrainAPI) {
            data.terrain = (CampaignTerrainAPI)target;
            data.primary = target.getOrbitFocus();
        }
        data.name = this.getStationName(data.primary);
        data.archetype = this.marketSetup.pickArchetypeForStation(data);
        this.alreadyUsedStationNames.add(data.name);
        return data;
    }

    protected void prepFreeStations() {
        WeightedRandomPicker picker = new WeightedRandomPicker(this.random);
        for (StarSystemAPI system : this.populatedSystems) {
            for (PlanetAPI planet : system.getPlanets()) {
                ProcGenEntity entity;
                if (planet.isGasGiant() || planet.isStar() || this.procGenEntitiesByToken.containsKey(planet) && this.populatedPlanets.contains(entity = this.procGenEntitiesByToken.get(planet))) continue;
                picker.add((Object)planet);
            }
            for (CampaignTerrainAPI terrain : system.getTerrainCopy()) {
                if (!ALLOWED_STATION_TERRAIN.contains(terrain.getId())) continue;
                picker.add((Object)terrain);
            }
        }
        int count = 0;
        while (count < this.setupData.numStations && !picker.isEmpty()) {
            SectorEntityToken target = (SectorEntityToken)picker.pickAndRemove();
            StarSystemAPI loc = (StarSystemAPI)target.getContainingLocation();
            if (this.marketsBySystem.get(loc).size() >= this.setupData.maxMarketsPerSystem) continue;
            ProcGenEntity station = this.createEntityDataForStation(target);
            this.stations.add(station);
            this.marketsBySystem.get(loc).add(station);
        }
    }

    protected ProcGenEntity pickHomeworld() {
        ArrayList<ProcGenEntity> candidates = new ArrayList<ProcGenEntity>(this.populatedPlanets);
        Collections.sort(candidates, new Comparator<ProcGenEntity>(){

            @Override
            public int compare(ProcGenEntity e1, ProcGenEntity e2) {
                float desirability1 = e1.desirability;
                float desirability2 = e2.desirability;
                if (desirability1 > desirability2) {
                    return -1;
                }
                if (desirability2 > desirability1) {
                    return 1;
                }
                return 0;
            }
        });
        WeightedRandomPicker picker = new WeightedRandomPicker(this.random);
        for (int i = 0; i < candidates.size() && i != 5; ++i) {
            picker.add(candidates.get(i));
        }
        this.homeworld = (ProcGenEntity)picker.pick();
        return this.homeworld;
    }

    protected void spawnCommRelays() {
        for (StarSystemAPI system : this.populatedSystems) {
            SectorEntityToken relay = null;
            ProcGenEntity capital = this.capitalsBySystem.get(system);
            if (capital == null) continue;
            for (SectorEntityToken relayCandidate : system.getEntitiesWithTag("comm_relay")) {
                if (relay != null) {
                    system.removeEntity(relayCandidate);
                    continue;
                }
                relay = relayCandidate;
                relay.setFaction(capital.market.getFactionId());
                relay.getMemoryWithoutUpdate().unset("$commRelayNonFunctional");
            }
            if (relay == null) {
                SectorEntityToken systemPrimary;
                ExerelinNewGameSetup.log.info((Object)("Creating comm relay for system " + system.getName()));
                relay = system.addCustomEntity(system.getId() + "_relay", system.getBaseName() + " \u901a\u8baf\u5668", "comm_relay", capital.entity.getFaction().getId());
                List jumpPoints = system.getJumpPoints();
                int lp = 4;
                if (this.random.nextBoolean()) {
                    lp = 5;
                }
                SectorEntityToken capEntity = capital.entity;
                if (capital.type == EntityType.STATION) {
                    capEntity = capEntity.getOrbitFocus();
                }
                if (capEntity instanceof PlanetAPI && ((PlanetAPI)capEntity).isMoon()) {
                    capEntity = capEntity.getOrbitFocus();
                }
                if ((systemPrimary = capEntity.getOrbitFocus()) != null) {
                    float orbitRadius = ExerelinUtilsAstro.getCurrentOrbitRadius(capEntity, systemPrimary);
                    float startAngle = ExerelinUtilsAstro.getCurrentOrbitAngle(capEntity, systemPrimary);
                    ExerelinUtilsAstro.setLagrangeOrbit(relay, systemPrimary, capEntity, lp, startAngle, orbitRadius, 0.0f, capEntity.getOrbit().getOrbitalPeriod(), false, 0.0f, 1.0f, 1, 0.0f);
                    ArrayList toCheck = new ArrayList();
                    toCheck.addAll(system.getPlanets());
                    toCheck.addAll(system.getJumpPoints());
                    for (SectorEntityToken ent : toCheck) {
                        float distSq = MathUtils.getDistanceSquared((SectorEntityToken)relay, (SectorEntityToken)ent);
                        if (!(distSq < 40000.0f)) continue;
                        lp = 9 - lp;
                        ExerelinUtilsAstro.setLagrangeOrbit(relay, systemPrimary, capEntity, lp, startAngle, orbitRadius, 0.0f, capEntity.getOrbit().getOrbitalPeriod(), false, 0.0f, 1.0f, 1, 0.0f);
                        break;
                    }
                }
            }
            this.systemToRelay.put(system.getId(), relay.getId());
            this.planetToRelay.put(capital.entity.getId(), relay.getId());
        }
    }

    protected void surveyPlanets() {
        for (StarSystemAPI system : this.populatedSystems) {
            for (PlanetAPI planet : system.getPlanets()) {
                MarketAPI market;
                if (planet.isStar() || (market = planet.getMarket()) == null || !market.isPlanetConditionMarketOnly()) continue;
                market.setSurveyLevel(MarketAPI.SurveyLevel.FULL);
            }
        }
    }

    protected void setCapitals() {
        for (StarSystemAPI system : this.populatedSystems) {
            ProcGenEntity capital = null;
            List<ProcGenEntity> markets = this.marketsBySystem.get(system);
            if (markets.size() == 1) {
                capital = markets.get(0);
            } else {
                for (ProcGenEntity market : markets) {
                    if (capital == null) {
                        capital = market;
                        continue;
                    }
                    if ((!market.isHQ || capital.isHQ) && market.market.getSize() <= capital.market.getSize()) continue;
                    capital = market;
                }
            }
            if (capital == null) continue;
            this.capitalsBySystem.put(system, capital);
        }
    }

    public static void cleanupDerelicts(Collection<StarSystemAPI> systems) {
        LocationAPI hyper = Global.getSector().getHyperspace();
        ArrayList<SectorEntityToken> toRemove = new ArrayList<SectorEntityToken>();
        for (StarSystemAPI system : systems) {
            ExerelinNewGameSetup.log.info((Object)("Cleaning up system " + system.getName()));
            ExerelinUtils.removeScriptAndListener((LocationAPI)system, RemnantStationFleetManager.class, null);
            ExerelinUtils.removeScriptAndListener((LocationAPI)system, RemnantSeededFleetManager.class, null);
            for (SectorEntityToken token : system.getAllEntities()) {
                if (token.hasTag("gate") || token.hasTag("debris")) continue;
                if (token.getFaction().getId().equals("derelict") || token.getFaction().getId().equals("remnant")) {
                    toRemove.add(token);
                    continue;
                }
                if (!token.hasTag("salvageable")) continue;
                toRemove.add(token);
            }
            for (SectorEntityToken beacon : hyper.getEntitiesWithTag("warning_beacon")) {
                boolean beaconFound = false;
                for (SectorEntityToken token : system.getJumpPoints()) {
                    JumpPointAPI jump = (JumpPointAPI)token;
                    if (!MathUtils.isWithinRange((SectorEntityToken)beacon, (Vector2f)jump.getLocationInHyperspace(), (float)900.0f)) continue;
                    toRemove.add(beacon);
                    beaconFound = true;
                }
                if (!beaconFound) continue;
                break;
            }
            for (String tag : TAGS_TO_REMOVE) {
                system.removeTag(tag);
            }
            system.addTag("theme_core_populated");
        }
        for (SectorEntityToken token : toRemove) {
            ExerelinNewGameSetup.log.info((Object)("\tRemoving token " + token.getName() + "(faction " + token.getFaction().getDisplayName() + ")"));
            token.getContainingLocation().removeEntity(token);
        }
    }

    protected void renameSystems() {
        for (StarSystemAPI system : this.populatedSystems) {
            if (!NameAssigner.isNameSpecial((StarSystemAPI)system)) {
                NameAssigner.assignSpecialNames((StarSystemAPI)system);
            }
            for (SectorEntityToken entity : system.getPlanets()) {
                if (entity.getMarket() == null) continue;
                entity.getMarket().setName(entity.getName());
            }
        }
    }

    protected void init() {
        this.random = new Random(ExerelinUtils.getStartingSeed());
        this.marketSetup = new ExerelinMarketBuilder(this);
        this.setupData = ExerelinSetupData.getInstance();
        this.factionIds = this.getStartingFactions();
    }

    public void generate() {
        ExerelinNewGameSetup.log.info((Object)"Running procedural generation");
        this.init();
        this.systems = this.getCoreSystems(15000.0f, 12000.0f);
        for (StarSystemAPI system : this.systems) {
            this.positiveDesirabilityBySystem.put(system, Float.valueOf(0.0f));
            this.marketsBySystem.put(system, new ArrayList());
            this.createEntityDataForSystem(system);
        }
        Collections.sort(this.systems, new Comparator<StarSystemAPI>(){

            @Override
            public int compare(StarSystemAPI sys1, StarSystemAPI sys2) {
                float dist2;
                float desirability1 = ExerelinProcGen.this.positiveDesirabilityBySystem.get(sys1).floatValue();
                float desirability2 = ExerelinProcGen.this.positiveDesirabilityBySystem.get(sys2).floatValue();
                if (desirability1 > 0.0f && desirability2 <= 0.0f) {
                    return -1;
                }
                if (desirability2 > 0.0f && desirability1 <= 0.0f) {
                    return 1;
                }
                float dist1 = Misc.getDistance((Vector2f)sys1.getLocation(), (Vector2f)ExerelinNewGameSetup.SECTOR_CENTER);
                if (dist1 < (dist2 = Misc.getDistance((Vector2f)sys2.getLocation(), (Vector2f)ExerelinNewGameSetup.SECTOR_CENTER))) {
                    return -1;
                }
                if (dist2 < dist1) {
                    return 1;
                }
                return 0;
            }
        });
        ExerelinNewGameSetup.log.info((Object)"Ordered systems and their desirability: ");
        for (StarSystemAPI system : this.systems) {
            float desirability = this.positiveDesirabilityBySystem.get(system).floatValue();
            ExerelinNewGameSetup.log.info((Object)("\t" + system.getBaseName() + ": " + desirability));
        }
        for (int i = 0; i < ExerelinSetupData.getInstance().numSystems; ++i) {
            this.maybePopulatedSystems.add(this.systems.get(i));
        }
        ExerelinNewGameSetup.log.info((Object)"Picking populated planets");
        this.pickPopulatedPlanets();
        this.renameSystems();
        ExerelinNewGameSetup.log.info((Object)"Preparing stations");
        this.prepFreeStations();
        ExerelinNewGameSetup.log.info((Object)"Populating sector");
        this.populateSector(Global.getSector());
        this.setCapitals();
        this.spawnCommRelays();
        this.surveyPlanets();
        this.marketSetup.addCabalSubmarkets();
        ExerelinNewGameSetup.log.info((Object)"Cleaning up derelicts/Remnants");
        ExerelinProcGen.cleanupDerelicts(this.populatedSystems);
        ExerelinNewGameSetup.log.info((Object)"Balancing economy");
        this.balanceMarkets();
        ExerelinNewGameSetup.log.info((Object)"Finishing");
        this.finish();
    }

    protected SectorEntityToken createStation(ProcGenEntity station, String factionId, boolean freeStation) {
        float angle = ExerelinUtilsAstro.getRandomAngle(this.random);
        int orbitRadius = 200;
        PlanetAPI planet = (PlanetAPI)station.primary;
        if (planet.isMoon()) {
            orbitRadius = 150;
        } else if (planet.isGasGiant()) {
            orbitRadius = 500;
        } else if (planet.isStar()) {
            orbitRadius = (int)station.terrain.getOrbit().computeCurrentLocation().length();
        }
        if (!planet.isStar()) {
            orbitRadius = (int)((float)orbitRadius + planet.getRadius());
        }
        float orbitDays = ExerelinUtilsAstro.getOrbitalPeriod((SectorEntityToken)planet, orbitRadius);
        if (planet.isStar()) {
            orbitDays = station.terrain.getOrbit().getOrbitalPeriod();
        }
        String name = station.name;
        String id = name.replace(' ', '_');
        id = id.toLowerCase();
        List<String> images = stationImages;
        ExerelinFactionConfig factionConf = ExerelinConfig.getExerelinFactionConfig(factionId);
        if (factionConf != null && !factionConf.customStations.isEmpty()) {
            images = factionConf.customStations;
        }
        String image = (String)ExerelinUtils.getRandomListElement(images, this.random);
        CustomCampaignEntityAPI newStation = station.starSystem.addCustomEntity(id, name, image, factionId);
        newStation.setCircularOrbitPointingDown((SectorEntityToken)planet, angle, (float)orbitRadius, orbitDays);
        station.entity = newStation;
        if (!freeStation) {
            MarketAPI existingMarket = planet.getMarket();
            newStation.setMarket(existingMarket);
            existingMarket.getConnectedEntities().add(newStation);
            station.market = existingMarket;
        } else {
            ExerelinNewGameSetup.log.info((Object)("Adding free station " + station.name + " for " + factionId));
            station.market = this.marketSetup.addMarket(station, factionId);
        }
        this.pickEntityInteractionImage((SectorEntityToken)newStation, newStation.getMarket(), planet.getTypeId(), EntityType.STATION);
        newStation.setCustomDescriptionId("orbital_station_default");
        station.entity = newStation;
        this.procGenEntitiesByToken.put((SectorEntityToken)newStation, station);
        return newStation;
    }

    protected void addAvestaStation(SectorAPI sector, StarSystemAPI system) {
        CustomCampaignEntityAPI avesta;
        if (ExerelinSetupData.getInstance().numSystems == 1) {
            PlanetAPI toOrbit = system.getStar();
            float radius = toOrbit.getRadius();
            float orbitDistance = radius + 2000.0f + this.random.nextFloat() * 500.0f;
            avesta = toOrbit.getContainingLocation().addCustomEntity("exipirated_avesta", "Avesta Station", "exipirated_avesta_station", "exipirated");
            avesta.setCircularOrbitPointingDown((SectorEntityToken)toOrbit, ExerelinUtilsAstro.getRandomAngle(this.random), orbitDistance, ExerelinUtilsAstro.getOrbitalPeriod((SectorEntityToken)toOrbit, orbitDistance));
        } else {
            LocationAPI hyperspace = sector.getHyperspace();
            avesta = hyperspace.addCustomEntity("exipirated_avesta", "Avesta Station", "exipirated_avesta_station", "exipirated");
            ExipiratedAvestaMovement avestaMovementScript = new ExipiratedAvestaMovement((SectorEntityToken)avesta, 60.0f, 3.0f);
            sector.getPersistentData().put("exipirated_movementScript", avestaMovementScript);
            avesta.addScript((EveryFrameScript)avestaMovementScript);
        }
        avesta.setInteractionImage("illustrations", "pirate_station");
        MarketAPI market = Global.getFactory().createMarket("exipirated_avesta_market", "Avesta Station", 5);
        market.setFactionId("exipirated");
        market.addCondition("population_5");
        market.addCondition("orbital_station");
        market.addCondition("urbanized_polity");
        market.addCondition("organized_crime");
        market.addCondition("stealth_minefields");
        market.addCondition("headquarters");
        market.addCondition("outpost");
        market.addCondition("trade_center");
        market.addCondition("free_market");
        market.addSubmarket("open_market");
        market.addSubmarket("exipirated_avesta_market");
        market.addSubmarket("storage");
        market.setBaseSmugglingStabilityValue(0);
        ExerelinMarketBuilder.addStartingMarketCommodities(market);
        market.getTariff().modifyFlat("generator", 0.2f);
        market.getTariff().modifyMult("isFreeMarket", 0.5f);
        market.setPrimaryEntity((SectorEntityToken)avesta);
        avesta.setMarket(market);
        avesta.setFaction("exipirated");
        sector.getEconomy().addMarket(market);
        SharedData.getData().getMarketsWithoutPatrolSpawn().add(market.getId());
        avesta.addScript((EveryFrameScript)new ExipiratedAvestaFleetManager(market));
        avesta.addScript((EveryFrameScript)new ExipiratedPatrolFleetManager(market));
        avesta.addScript((EveryFrameScript)new ExipiratedCollectorFleetManager(market));
        avesta.addScript((EveryFrameScript)new ExigencyCommRelayAdder());
    }

    protected void addShanghai(MarketAPI market) {
        SectorEntityToken toOrbit = market.getPrimaryEntity();
        float radius = toOrbit.getRadius();
        float orbitDistance = radius + 150.0f;
        CustomCampaignEntityAPI shanghaiEntity = toOrbit.getContainingLocation().addCustomEntity("tiandong_shanghai", "Shanghai", "tiandong_shanghai", "tiandong");
        shanghaiEntity.setCircularOrbitPointingDown(toOrbit, ExerelinUtilsAstro.getRandomAngle(this.random), orbitDistance, ExerelinUtilsAstro.getOrbitalPeriod(toOrbit, orbitDistance));
        shanghaiEntity.setMarket(market);
        market.getConnectedEntities().add(shanghaiEntity);
        if (!market.hasCondition("orbital_station") && !market.hasCondition("spaceport")) {
            market.addCondition("orbital_station");
        }
        market.addSubmarket("tiandong_retrofit");
        toOrbit.addTag("shanghai");
        shanghaiEntity.addTag("shanghai");
        shanghaiEntity.addTag("shanghaiStation");
        shanghaiEntity.setInteractionImage("illustrations", "urban01");
        shanghaiEntity.setCustomDescriptionId("tiandong_shanghai");
    }

    protected void addChaosCrack(StarSystemAPI system) {
        CustomCampaignEntityAPI chaosCrack = system.addCustomEntity("chaosCrack", StringHelper.getString("Agustin", "chaosCrack"), "Chaos_Crack_type", "approlight");
        chaosCrack.getLocation().set(-10000.0f, 12000.0f);
        chaosCrack.addScript((EveryFrameScript)new AL_ChaosCrackFleetManager((SectorEntityToken)chaosCrack));
        SectorEntityToken prime_field1 = system.addTerrain("magnetic_field", (Object)new MagneticFieldTerrainPlugin.MagneticFieldParams(chaosCrack.getRadius() + 1000.0f, chaosCrack.getRadius() + 1600.0f, (SectorEntityToken)chaosCrack, chaosCrack.getRadius() + 1400.0f, chaosCrack.getRadius() + 2400.0f, new Color(50, 20, 100, 130), 1.0f, new Color[]{new Color(140, 100, 235), new Color(225, 255, 90), new Color(150, 140, 190), new Color(140, 190, 210), new Color(90, 200, 170), new Color(65, 230, 160), new Color(20, 220, 70)}));
        prime_field1.setCircularOrbit((SectorEntityToken)chaosCrack, 0.0f, 0.0f, 100.0f);
        SectorEntityToken prime_field2 = system.addTerrain("magnetic_field", (Object)new MagneticFieldTerrainPlugin.MagneticFieldParams(chaosCrack.getRadius() + 1400.0f, chaosCrack.getRadius() + 1800.0f, (SectorEntityToken)chaosCrack, chaosCrack.getRadius() + 3000.0f, chaosCrack.getRadius() + 4400.0f, new Color(50, 20, 100, 180), 1.0f, new Color[]{new Color(140, 100, 235), new Color(225, 255, 90), new Color(150, 140, 190), new Color(140, 190, 210), new Color(90, 200, 170), new Color(65, 230, 160), new Color(20, 220, 70)}));
        prime_field2.setCircularOrbit((SectorEntityToken)chaosCrack, 0.0f, 0.0f, 100.0f);
        system.addAsteroidBelt((SectorEntityToken)chaosCrack, 50, 800.0f, 200.0f, 120.0f, 180.0f, "asteroid_belt", null);
        system.addAsteroidBelt((SectorEntityToken)chaosCrack, 300, 3600.0f, 1200.0f, -150.0f, -130.0f, "asteroid_belt", null);
        system.addAsteroidBelt((SectorEntityToken)chaosCrack, 800, 5500.0f, 2400.0f, -120.0f, -300.0f, "asteroid_belt", null);
        system.addRingBand((SectorEntityToken)chaosCrack, "misc", "rings1", 256.0f, 3, Color.white, 256.0f, 800.0f, 360.0f);
        system.addRingBand((SectorEntityToken)chaosCrack, "misc", "rings1", 256.0f, 3, Color.white, 256.0f, 1200.0f, 360.0f);
        system.addRingBand((SectorEntityToken)chaosCrack, "misc", "rings1", 256.0f, 2, Color.white, 1024.0f, 3000.0f, 360.0f);
        system.addRingBand((SectorEntityToken)chaosCrack, "misc", "rings1", 256.0f, 3, Color.white, 512.0f, 2000.0f, 360.0f);
        system.addRingBand((SectorEntityToken)chaosCrack, "misc", "rings1", 256.0f, 2, Color.white, 512.0f, 4000.0f, 360.0f);
        system.addRingBand((SectorEntityToken)chaosCrack, "misc", "rings1", 256.0f, 2, Color.white, 512.0f, 6000.0f, 360.0f);
        SectorEntityToken primeNebula = Misc.addNebulaFromPNG((String)"data/campaign/terrain/agustin_prime_nebula.png", (float)chaosCrack.getLocation().x, (float)chaosCrack.getLocation().y, (LocationAPI)system, (String)"terrain", (String)"AL_primenebula", (int)4, (int)4, (String)"AL_primenebula", (StarAge)StarAge.ANY);
        primeNebula.addTag("radar_nebula");
    }

    protected void addUnos(MarketAPI market) {
        SectorEntityToken toOrbit = market.getPrimaryEntity();
        CustomCampaignEntityAPI hegemonyforALStation = toOrbit.getContainingLocation().addCustomEntity("unosStation", "Unos Station", "station_unos_type", "approlight");
        hegemonyforALStation.setCircularOrbitPointingDown(toOrbit, 225.0f, 400.0f, 50.0f);
        hegemonyforALStation.setCustomDescriptionId("station_approlight01");
    }

    protected void handleHQSpecials(SectorAPI sector, String factionId, ProcGenEntity data) {
        if (factionId.equals("exipirated") && ExerelinConfig.enableAvesta) {
            this.addAvestaStation(sector, data.starSystem);
        }
        if (factionId.equals("tiandong") && ExerelinConfig.enableShanghai) {
            this.addShanghai(data.market);
        }
        if (factionId.equals("approlight")) {
            if (ExerelinConfig.enableUnos) {
                this.addUnos(data.market);
            }
            this.addChaosCrack(data.starSystem);
            data.market.removeSubmarket("generic_military");
            data.market.addSubmarket("AL_militaryMarket");
            data.market.addSubmarket("AL_plugofbarrack");
        }
    }

    public void populateSector(SectorAPI sector) {
        for (ProcGenEntity entity : this.populatedPlanets) {
            this.marketSetup.addMarketConditionForPlanetType(entity);
        }
        this.marketSetup.pickMarketArchetypes(this.populatedPlanets);
        WeightedRandomPicker factionPicker = new WeightedRandomPicker(this.random);
        ArrayList<String> factions = new ArrayList<String>(this.factionIds);
        factions.remove("player_npc");
        factionPicker.addAll(factions);
        HashMap<String, Integer> factionPlanetCount = new HashMap<String, Integer>();
        HashMap<String, Integer> factionStationCount = new HashMap<String, Integer>();
        ArrayList<ProcGenEntity> populatedPlanetsCopy = new ArrayList<ProcGenEntity>(this.populatedPlanets);
        ArrayList<ProcGenEntity> stationsCopy = new ArrayList<ProcGenEntity>(this.stations);
        ArrayList<String> pirateFactions = new ArrayList<String>();
        for (String factionId : factions) {
            factionPlanetCount.put(factionId, 0);
            factionStationCount.put(factionId, 0);
            if (!ExerelinUtilsFaction.isPirateFaction(factionId)) continue;
            pirateFactions.add(factionId);
        }
        ArrayList<StarSystemAPI> systemsWithPirates = new ArrayList<StarSystemAPI>();
        this.pickHomeworld();
        String alignedFactionId = PlayerFactionStore.getPlayerFactionIdNGC();
        if (!ExerelinSetupData.getInstance().freeStart) {
            this.homeworld.isHQ = true;
            MarketAPI homeMarket = this.marketSetup.addMarket(this.homeworld, alignedFactionId);
            this.pickEntityInteractionImage(this.homeworld.entity, this.homeworld.entity.getMarket(), this.homeworld.planetType, this.homeworld.type);
            populatedPlanetsCopy.remove(this.homeworld);
            this.handleHQSpecials(sector, alignedFactionId, this.homeworld);
            if (pirateFactions.contains(alignedFactionId)) {
                systemsWithPirates.add(this.homeworld.starSystem);
            }
            factionPlanetCount.put(alignedFactionId, 1);
        }
        Collections.shuffle(populatedPlanetsCopy, this.random);
        Collections.shuffle(stationsCopy, this.random);
        ArrayList<ProcGenEntity> unassignedEntities = new ArrayList<ProcGenEntity>(populatedPlanetsCopy);
        for (ProcGenEntity procGenEntity : stationsCopy) {
            unassignedEntities.add(procGenEntity);
        }
        HashSet<ProcGenEntity> toRemove = new HashSet<ProcGenEntity>();
        for (String string : factions) {
            if (string.equals(alignedFactionId)) continue;
            if (populatedPlanetsCopy.size() <= 0) break;
            ProcGenEntity procGenEntity = (ProcGenEntity)populatedPlanetsCopy.get(0);
            populatedPlanetsCopy.remove(0);
            ExerelinFactionConfig exerelinFactionConfig = ExerelinConfig.getExerelinFactionConfig(string);
            if (exerelinFactionConfig == null || !exerelinFactionConfig.noHomeworld) {
                procGenEntity.isHQ = true;
            }
            this.marketSetup.addMarket(procGenEntity, string);
            this.handleHQSpecials(sector, string, procGenEntity);
            if (procGenEntity.isCapital) {
                SectorEntityToken relay = sector.getEntityById(this.systemToRelay.get(procGenEntity.starSystem.getId()));
                relay.setFaction(string);
            }
            this.pickEntityInteractionImage(procGenEntity.entity, procGenEntity.entity.getMarket(), procGenEntity.planetType, procGenEntity.type);
            if (pirateFactions.contains(string)) {
                systemsWithPirates.add(procGenEntity.starSystem);
            }
            factionPlanetCount.put(string, (Integer)factionPlanetCount.get(string) + 1);
            unassignedEntities.remove(procGenEntity);
        }
        if (!pirateFactions.isEmpty()) {
            WeightedRandomPicker weightedRandomPicker = new WeightedRandomPicker(this.random);
            Collections.shuffle(unassignedEntities, this.random);
            for (ProcGenEntity procGenEntity : unassignedEntities) {
                if (systemsWithPirates.size() == this.populatedSystems.size()) break;
                if (systemsWithPirates.contains(procGenEntity.starSystem)) continue;
                if (this.random.nextFloat() > ExerelinConfig.forcePiratesInSystemChance) {
                    systemsWithPirates.add(procGenEntity.starSystem);
                    continue;
                }
                if (weightedRandomPicker.isEmpty()) {
                    weightedRandomPicker.addAll(pirateFactions);
                }
                String string = (String)weightedRandomPicker.pickAndRemove();
                if (procGenEntity.type == EntityType.PLANET || procGenEntity.type == EntityType.MOON) {
                    this.marketSetup.addMarket(procGenEntity, string);
                    populatedPlanetsCopy.remove(procGenEntity);
                    factionPlanetCount.put(string, (Integer)factionPlanetCount.get(string) + 1);
                } else {
                    this.createStation(procGenEntity, string, true);
                    stationsCopy.remove(procGenEntity);
                    factionStationCount.put(string, (Integer)factionStationCount.get(string) + 1);
                }
                toRemove.add(procGenEntity);
                systemsWithPirates.add(procGenEntity.starSystem);
            }
            unassignedEntities.removeAll(toRemove);
        }
        HashMap<String, Float> hashMap = new HashMap<String, Float>();
        float f = 0.0f;
        for (String string : factions) {
            float share = 1.0f;
            ExerelinFactionConfig config = ExerelinConfig.getExerelinFactionConfig(string);
            if (config != null && ExerelinConfig.useFactionMarketSpawnWeights) {
                share = config.marketSpawnWeight;
            }
            f += share;
            hashMap.put(string, Float.valueOf(share));
        }
        int n = populatedPlanetsCopy.size();
        for (String factionId : factions) {
            int numPlanets = (int)((double)((float)n * (((Float)hashMap.get(factionId)).floatValue() / f)) + 0.5);
            for (int i = ((Integer)factionPlanetCount.get(factionId)).intValue(); i < numPlanets && !populatedPlanetsCopy.isEmpty(); ++i) {
                ProcGenEntity habitable = (ProcGenEntity)populatedPlanetsCopy.get(0);
                populatedPlanetsCopy.remove(0);
                unassignedEntities.remove(habitable);
                this.marketSetup.addMarket(habitable, factionId);
                factionPlanetCount.put(factionId, (Integer)factionPlanetCount.get(factionId) + 1);
                if (habitable.isCapital) {
                    SectorEntityToken relay = sector.getEntityById(this.systemToRelay.get(habitable.starSystem.getId()));
                    relay.setFaction(factionId);
                }
                this.pickEntityInteractionImage(habitable.entity, habitable.entity.getMarket(), habitable.planetType, habitable.type);
            }
            if (!populatedPlanetsCopy.isEmpty()) continue;
            break;
        }
        for (ProcGenEntity planet : populatedPlanetsCopy) {
            if (planet.market != null && !planet.market.isPlanetConditionMarketOnly()) {
                ExerelinNewGameSetup.log.error((Object)("Unassigned entity " + planet.name + " already has market!"));
                continue;
            }
            if (factionPicker.isEmpty()) {
                factionPicker.addAll(factions);
            }
            String factionId = (String)factionPicker.pickAndRemove();
            this.marketSetup.addMarket(planet, factionId);
            unassignedEntities.remove(planet);
        }
        int n2 = stationsCopy.size();
        for (String factionId : factions) {
            int numStations = (int)((double)((float)n2 * (((Float)hashMap.get(factionId)).floatValue() / f)) + 0.5);
            for (int i = ((Integer)factionStationCount.get(factionId)).intValue(); i < numStations; ++i) {
                ProcGenEntity station = (ProcGenEntity)stationsCopy.get(0);
                stationsCopy.remove(0);
                unassignedEntities.remove(station);
                this.createStation(station, factionId, true);
                factionStationCount.put(factionId, (Integer)factionStationCount.get(factionId) + 1);
                if (stationsCopy.isEmpty()) break;
            }
            if (!stationsCopy.isEmpty()) continue;
            break;
        }
        for (ProcGenEntity station : stationsCopy) {
            if (station.market != null) {
                ExerelinNewGameSetup.log.error((Object)("Unassigned entity " + station.name + " already has market!"));
                continue;
            }
            if (factionPicker.isEmpty()) {
                factionPicker.addAll(factions);
            }
            String factionId = (String)factionPicker.pickAndRemove();
            this.createStation(station, factionId, true);
        }
    }

    protected void balanceMarkets() {
        ExerelinNewGameSetup.log.info((Object)"INITIAL SUPPLY/DEMAND");
        this.marketSetup.balancer.reportSupplyDemand();
        ArrayList<ProcGenEntity> haveMarkets = new ArrayList<ProcGenEntity>(this.populatedPlanets);
        haveMarkets.addAll(this.stations);
        Collections.sort(haveMarkets, new Comparator<ProcGenEntity>(){

            @Override
            public int compare(ProcGenEntity data1, ProcGenEntity data2) {
                int size2;
                int size1 = data1.market.getSize();
                if (size1 == (size2 = data2.market.getSize())) {
                    return 0;
                }
                if (size1 > size2) {
                    return 1;
                }
                return -1;
            }
        });
        Collections.sort(haveMarkets, this.sortByMarketPointsUsed);
        this.marketSetup.balancer.balanceFood(haveMarkets);
        Collections.sort(haveMarkets, this.sortByMarketPointsUsed);
        this.marketSetup.balancer.balanceDomesticGoods(haveMarkets);
        Collections.sort(haveMarkets, this.sortByMarketPointsUsed);
        this.marketSetup.balancer.balanceFuel(haveMarkets);
        Collections.sort(haveMarkets, this.sortByMarketPointsUsed);
        this.marketSetup.balancer.balanceRareMetal(haveMarkets);
        Collections.sort(haveMarkets, this.sortByMarketPointsUsed);
        this.marketSetup.balancer.balanceMachinery(haveMarkets);
        Collections.sort(haveMarkets, this.sortByMarketPointsUsed);
        this.marketSetup.balancer.balanceSupplies(haveMarkets);
        Collections.sort(haveMarkets, this.sortByMarketPointsUsed);
        this.marketSetup.balancer.balanceOrganics(haveMarkets);
        Collections.sort(haveMarkets, this.sortByMarketPointsUsed);
        this.marketSetup.balancer.balanceVolatiles(haveMarkets);
        Collections.sort(haveMarkets, this.sortByMarketPointsUsed);
        this.marketSetup.balancer.balanceMetal(haveMarkets);
        Collections.sort(haveMarkets, this.sortByMarketPointsUsed);
        this.marketSetup.balancer.balanceOre(haveMarkets);
        ExerelinNewGameSetup.log.info((Object)"FINAL SUPPLY/DEMAND");
        this.marketSetup.balancer.reportSupplyDemand();
        for (ProcGenEntity entity : haveMarkets) {
            ExerelinMarketBuilder.addStartingMarketCommodities(entity.market);
        }
    }

    protected void finish() {
        SectorManager.setHomeworld(this.homeworld.entity);
        SectorManager.setSystemToRelayMap(this.systemToRelay);
        SectorManager.setPlanetToRelayMap(this.planetToRelay);
        SectorManager.reinitLiveFactions();
        DiplomacyManager.initFactionRelationships(false);
    }

    static {
        ExerelinProcGen.loadData();
    }

    public static enum EntityType {
        STAR,
        PLANET,
        MOON,
        STATION;

    }

    public static class ProcGenEntity {
        String name = "";
        SectorEntityToken entity;
        String planetType = "";
        float desirability = 0.0f;
        boolean inhabited = true;
        boolean isCapital = false;
        boolean isHQ = false;
        EntityType type = EntityType.PLANET;
        StarSystemAPI starSystem;
        SectorEntityToken primary;
        CampaignTerrainAPI terrain;
        MarketAPI market;
        ExerelinMarketBuilder.Archetype archetype = ExerelinMarketBuilder.Archetype.MISC;
        int forceMarketSize = -1;
        int marketPoints = 0;
        int marketPointsSpent = 0;
        int bonusMarketPoints = 0;

        public ProcGenEntity(SectorEntityToken entity) {
            this.entity = entity;
        }
    }
}

