/*
 * Decompiled with CFR 0.152.
 */
package exerelin.world;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.econ.CommoditySpecAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.econ.MarketConditionAPI;
import com.fs.starfarer.api.combat.MutableStat;
import com.fs.starfarer.api.impl.campaign.econ.BaseMarketConditionPlugin;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import exerelin.utilities.ExerelinUtilsFaction;
import exerelin.world.ExerelinMarketBuilder;
import exerelin.world.ExerelinProcGen;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.log4j.Logger;

public class MarketBalancer {
    public static final float ASSUMED_STABILITY_MULT = 1.125f;
    public static final float MAX_OVERSUPPLY = 1.4f;
    public static final float MAX_OVERDEMAND = 1.0f;
    protected static final Map<String, Float> FARMING_MULTS = new HashMap<String, Float>();
    protected static Logger log = Global.getLogger(MarketBalancer.class);
    protected Map<String, Map<MarketAPI, MutableStat>> demandByCommodity = new HashMap<String, Map<MarketAPI, MutableStat>>();
    protected Map<String, Map<MarketAPI, MutableStat>> supplyByCommodity = new HashMap<String, Map<MarketAPI, MutableStat>>();
    protected ExerelinMarketBuilder builder;
    protected Random random;

    public MarketBalancer(ExerelinMarketBuilder builder) {
        this.builder = builder;
        this.random = builder.random;
    }

    public Map<MarketAPI, MutableStat> getDemandEntries(String commodityId) {
        if (!this.demandByCommodity.containsKey(commodityId)) {
            this.demandByCommodity.put(commodityId, new HashMap());
        }
        return this.demandByCommodity.get(commodityId);
    }

    public Map<MarketAPI, MutableStat> getSupplyEntries(String commodityId) {
        if (!this.supplyByCommodity.containsKey(commodityId)) {
            this.supplyByCommodity.put(commodityId, new HashMap());
        }
        return this.supplyByCommodity.get(commodityId);
    }

    public float getDemand(String commodityId) {
        float amount = 0.0f;
        Map<MarketAPI, MutableStat> entries = this.getDemandEntries(commodityId);
        for (Map.Entry<MarketAPI, MutableStat> marketEntry : entries.entrySet()) {
            amount += marketEntry.getValue().getModifiedValue();
        }
        return amount;
    }

    public float getSupply(String commodityId) {
        float amount = 0.0f;
        Map<MarketAPI, MutableStat> entries = this.getSupplyEntries(commodityId);
        for (Map.Entry<MarketAPI, MutableStat> marketEntry : entries.entrySet()) {
            amount += marketEntry.getValue().getModifiedValue();
        }
        return amount;
    }

    public MutableStat getDemandForMarket(MarketAPI market, String commodityId) {
        Map<MarketAPI, MutableStat> entries = this.getDemandEntries(commodityId);
        if (!entries.containsKey(market)) {
            entries.put(market, new MutableStat(0.0f));
        }
        return entries.get(market);
    }

    public MutableStat getSupplyForMarket(MarketAPI market, String commodityId) {
        Map<MarketAPI, MutableStat> entries = this.getSupplyEntries(commodityId);
        if (!entries.containsKey(market)) {
            entries.put(market, new MutableStat(0.0f));
        }
        return entries.get(market);
    }

    public void modifySupplyWithTags(String condId, MarketAPI market, Set<String> tags, float mult) {
        block0: for (String commodityId : Global.getSector().getEconomy().getAllCommodityIds()) {
            CommoditySpecAPI spec;
            if (market.isIllegal(commodityId) || !(spec = Global.getSector().getEconomy().getCommoditySpec(commodityId)).isPrimary()) continue;
            for (String tag : tags) {
                if (!spec.hasTag(tag)) continue;
                this.getSupplyForMarket(market, commodityId).modifyMult(condId, mult);
                continue block0;
            }
        }
    }

    public void onAddMarketCondition(MarketAPI market, MarketConditionAPI cond) {
        String id = cond.getIdForPluginModifications();
        float sizeMult = ((BaseMarketConditionPlugin)cond.getPlugin()).getBaseSizeMult();
        float pop = ((BaseMarketConditionPlugin)cond.getPlugin()).getPopulation(market);
        float fuel = 0.0f;
        HashSet<String> tags = null;
        if (FARMING_MULTS.containsKey(cond.getId())) {
            this.getSupplyForMarket(market, "food").modifyFlat(id, this.getFarmingFood(cond.getId(), sizeMult));
        } else if (cond.getId().startsWith("population_")) {
            this.getDemandForMarket(market, "supplies").modifyFlat(id, 200.0f * sizeMult);
            this.getDemandForMarket(market, "fuel").modifyFlat(id, 200.0f * sizeMult);
            if (market.getSize() >= 4) {
                this.getDemandForMarket(market, "food").modifyFlat(id, 500.0f * sizeMult);
                this.getDemandForMarket(market, "domestic_goods").modifyFlat(id, 500.0f * sizeMult);
                this.getDemandForMarket(market, "hand_weapons").modifyFlat(id, 50.0f * sizeMult);
                this.getDemandForMarket(market, "drugs").modifyFlat(id, 100.0f * sizeMult);
                this.getSupplyForMarket(market, "crew").modifyFlat(id, 50.0f * sizeMult);
            }
            if (market.getSize() >= 5) {
                this.getDemandForMarket(market, "luxury_goods").modifyFlat(id, 100.0f * sizeMult);
                this.getDemandForMarket(market, "organs").modifyFlat(id, 100.0f * sizeMult);
            }
        } else {
            switch (cond.getId()) {
                case "antimatter_fuel_production": {
                    this.getDemandForMarket(market, "organics").modifyFlat(id, 1000.0f * sizeMult);
                    this.getDemandForMarket(market, "volatiles").modifyFlat(id, 1000.0f * sizeMult);
                    this.getDemandForMarket(market, "rare_metals").modifyFlat(id, 300.0f * sizeMult);
                    this.getDemandForMarket(market, "heavy_machinery").modifyFlat(id, 200.0f * sizeMult);
                    this.getSupplyForMarket(market, "fuel").modifyFlat(id, 2500.0f * sizeMult);
                    break;
                }
                case "autofac_heavy_industry": {
                    this.getDemandForMarket(market, "metals").modifyFlat(id, 1000.0f * sizeMult);
                    this.getDemandForMarket(market, "rare_metals").modifyFlat(id, 100.0f * sizeMult);
                    this.getDemandForMarket(market, "organics").modifyFlat(id, 1000.0f * sizeMult);
                    this.getDemandForMarket(market, "volatiles").modifyFlat(id, 1000.0f * sizeMult);
                    this.getDemandForMarket(market, "heavy_machinery").modifyFlat(id, 200.0f * sizeMult);
                    this.getSupplyForMarket(market, "supplies").modifyFlat(id, 5000.0f * sizeMult);
                    this.getSupplyForMarket(market, "heavy_machinery").modifyFlat(id, 1200.0f * sizeMult);
                    this.getSupplyForMarket(market, "hand_weapons").modifyFlat(id, 2000.0f * sizeMult);
                    break;
                }
                case "cottage_industry": {
                    this.getDemandForMarket(market, "organics").modifyFlat(id, 2000.0f * sizeMult);
                    this.getSupplyForMarket(market, "domestic_goods").modifyFlat(id, 1000.0f * sizeMult);
                    break;
                }
                case "cryosanctum": {
                    this.getDemandForMarket(market, "crew").modifyFlat(id, 0.01f * pop * 0.5f);
                    this.getDemandForMarket(market, "organics").modifyFlat(id, 0.1f * pop);
                    this.getDemandForMarket(market, "volatiles").modifyFlat(id, 0.1f * pop);
                    this.getDemandForMarket(market, "heavy_machinery").modifyFlat(id, 0.01f * pop);
                    this.getSupplyForMarket(market, "crew").modifyFlat(id, 50.0f);
                    this.getSupplyForMarket(market, "organs").modifyFlat(id, 500.0f);
                    break;
                }
                case "decivilized": {
                    this.getDemandForMarket(market, "domestic_goods").modifyMult(id, 0.0f);
                    this.getDemandForMarket(market, "luxury_goods").modifyMult(id, 0.0f);
                    this.getDemandForMarket(market, "organs").modifyMult(id, 0.0f);
                    this.getDemandForMarket(market, "drugs").modifyMult(id, 5.0f);
                    this.getDemandForMarket(market, "hand_weapons").modifyFlat(id, 0.01f * pop);
                    this.getDemandForMarket(market, "supplies").modifyFlat(id, 0.01f * pop);
                    tags = new HashSet<String>(Arrays.asList("heavy_industry_in", "heavy_industry_out", "light_industry_in", "light_industry_out", "refining_in", "refining_out"));
                    this.modifySupplyWithTags(id, market, tags, 0.0f);
                    this.getSupplyForMarket(market, "food").modifyMult(id, 0.25f);
                    break;
                }
                case "dissident": {
                    this.getDemandForMarket(market, "marines").modifyFlat(id, 0.001f * pop);
                    this.getDemandForMarket(market, "hand_weapons").modifyFlat(id, 0.01f * pop);
                    this.getSupplyForMarket(market, "crew").modifyMult(id, 2.0f);
                    break;
                }
                case "free_market": {
                    this.getDemandForMarket(market, "drugs").modifyFlat(id, 100.0f * sizeMult);
                    break;
                }
                case "frontier": {
                    this.getDemandForMarket(market, "hand_weapons").modifyFlat(id, 0.001f * pop);
                    this.getDemandForMarket(market, "supplies").modifyFlat(id, 0.01f * pop);
                    this.getDemandForMarket(market, "luxury_goods").modifyMult(id, 0.1f);
                    break;
                }
                case "hydroponics_complex": {
                    this.getSupplyForMarket(market, "food").modifyFlat(id, 400.0f * sizeMult);
                    break;
                }
                case "large_refugee_population": {
                    this.getSupplyForMarket(market, "crew").modifyFlat(id, 10.0f);
                    this.getSupplyForMarket(market, "crew").modifyMult(id, 2.0f);
                    this.getSupplyForMarket(market, "organs").modifyFlat(id, pop * 1.0E-5f);
                    tags = new HashSet<String>(Arrays.asList("food", "light_industry_out"));
                    this.modifySupplyWithTags(id, market, tags, 0.5f);
                    break;
                }
                case "light_industrial_complex": {
                    this.getDemandForMarket(market, "organics").modifyFlat(id, 500.0f * sizeMult);
                    this.getDemandForMarket(market, "volatiles").modifyFlat(id, 500.0f * sizeMult);
                    this.getDemandForMarket(market, "heavy_machinery").modifyFlat(id, 100.0f * sizeMult);
                    this.getSupplyForMarket(market, "domestic_goods").modifyFlat(id, 1000.0f * sizeMult);
                    this.getSupplyForMarket(market, "luxury_goods").modifyFlat(id, 200.0f * sizeMult);
                    break;
                }
                case "luddic_majority": {
                    this.getDemandForMarket(market, "luxury_goods").modifyMult(id, 0.1f);
                    break;
                }
                case "military_base": {
                    this.getDemandForMarket(market, "supplies").modifyFlat(id, 500.0f);
                    this.getDemandForMarket(market, "fuel").modifyFlat(id, 2000.0f);
                    this.getDemandForMarket(market, "hand_weapons").modifyFlat(id, 1000.0f);
                    this.getDemandForMarket(market, "heavy_machinery").modifyFlat(id, 50.0f);
                    this.getDemandForMarket(market, "crew").modifyFlat(id, 250.0f);
                    this.getDemandForMarket(market, "marines").modifyFlat(id, 50.0f);
                    this.getSupplyForMarket(market, "crew").modifyFlat(id, 500.0f);
                    this.getSupplyForMarket(market, "marines").modifyFlat(id, 150.0f);
                    break;
                }
                case "orbital_burns": {
                    this.getSupplyForMarket(market, "food").modifyMult(id, 2.0f);
                    break;
                }
                case "orbital_station": {
                    fuel = 1000.0f + 0.002f * pop * 0.5f;
                    fuel = Math.min(fuel, 15000.0f);
                    this.getDemandForMarket(market, "fuel").modifyFlat(id, fuel);
                    this.getDemandForMarket(market, "supplies").modifyFlat(id, 500.0f);
                    this.getDemandForMarket(market, "crew").modifyFlat(id, 250.0f);
                    break;
                }
                case "ore_complex": {
                    this.getDemandForMarket(market, "heavy_machinery").modifyFlat(id, 100.0f * sizeMult);
                    this.getSupplyForMarket(market, "ore").modifyFlat(id, 2000.0f * sizeMult);
                    this.getSupplyForMarket(market, "rare_ore").modifyFlat(id, 400.0f * sizeMult);
                    break;
                }
                case "ore_refining_complex": {
                    float ore = 3000.0f * sizeMult;
                    float rareOre = 600.0f * sizeMult;
                    this.getDemandForMarket(market, "ore").modifyFlat(id, ore);
                    this.getDemandForMarket(market, "rare_ore").modifyFlat(id, rareOre);
                    this.getDemandForMarket(market, "heavy_machinery").modifyFlat(id, 100.0f * sizeMult);
                    this.getSupplyForMarket(market, "metals").modifyFlat(id, ore * 0.5f);
                    this.getSupplyForMarket(market, "rare_metals").modifyFlat(id, rareOre * 0.5f);
                    break;
                }
                case "organics_complex": {
                    this.getDemandForMarket(market, "heavy_machinery").modifyFlat(id, 100.0f * sizeMult);
                    this.getSupplyForMarket(market, "organics").modifyFlat(id, 5500.0f * sizeMult);
                    break;
                }
                case "organized_crime": {
                    this.getDemandForMarket(market, "organics").modifyFlat(id, 500.0f * sizeMult * 1.125f);
                    this.getDemandForMarket(market, "volatiles").modifyFlat(id, 500.0f * sizeMult * 1.125f);
                    this.getDemandForMarket(market, "marines").modifyFlat(id, 100.0f);
                    this.getDemandForMarket(market, "hand_weapons").modifyFlat(id, 50.0f * sizeMult);
                    this.getSupplyForMarket(market, "drugs").modifyFlat(id, 1000.0f * sizeMult);
                    this.getSupplyForMarket(market, "drugs").modifyFlat(id, 400.0f * sizeMult);
                    break;
                }
                case "rural_polity": {
                    this.getDemandForMarket(market, "domestic_goods").modifyMult(id, 0.5f);
                    this.getDemandForMarket(market, "luxury_goods").modifyMult(id, 0.5f);
                    this.getDemandForMarket(market, "drugs").modifyMult(id, 0.5f);
                    this.getDemandForMarket(market, "organs").modifyMult(id, 0.5f);
                    this.getSupplyForMarket(market, "food").modifyMult(id, 2.0f);
                    break;
                }
                case "shipbreaking_center": {
                    this.getSupplyForMarket(market, "heavy_machinery").modifyFlat(id, 500.0f);
                    this.getSupplyForMarket(market, "metals").modifyFlat(id, 4000.0f);
                    this.getSupplyForMarket(market, "rare_metals").modifyFlat(id, 2000.0f);
                    this.getSupplyForMarket(market, "supplies").modifyFlat(id, 10000.0f);
                    break;
                }
                case "spaceport": {
                    fuel = 1000.0f + 0.002f * pop;
                    fuel = Math.min(fuel, 15000.0f);
                    this.getDemandForMarket(market, "fuel").modifyFlat(id, fuel);
                    this.getDemandForMarket(market, "supplies").modifyFlat(id, 1000.0f);
                    this.getDemandForMarket(market, "crew").modifyFlat(id, 1000.0f);
                    break;
                }
                case "volatiles_complex": {
                    this.getDemandForMarket(market, "heavy_machinery").modifyFlat(id, 100.0f * sizeMult);
                    this.getSupplyForMarket(market, "volatiles").modifyFlat(id, 5500.0f * sizeMult);
                    break;
                }
                case "volturnian_lobster_pens": {
                    this.getSupplyForMarket(market, "luxury_goods").modifyFlat(id, 5000.0f * sizeMult);
                    break;
                }
                case "exerelin_supply_workshop": {
                    this.getDemandForMarket(market, "metals").modifyFlat(id, 250.0f * sizeMult);
                    this.getDemandForMarket(market, "rare_metals").modifyFlat(id, 25.0f * sizeMult);
                    this.getDemandForMarket(market, "organics").modifyFlat(id, 250.0f * sizeMult);
                    this.getDemandForMarket(market, "volatiles").modifyFlat(id, 250.0f * sizeMult);
                    this.getDemandForMarket(market, "heavy_machinery").modifyFlat(id, 40.0f * sizeMult);
                    this.getSupplyForMarket(market, "supplies").modifyFlat(id, 1000.0f * sizeMult);
                    this.getSupplyForMarket(market, "hand_weapons").modifyFlat(id, 500.0f * sizeMult);
                }
            }
        }
    }

    public void addMarketCondition(ExerelinProcGen.ProcGenEntity entity, String conditionId) {
        String token = entity.market.addCondition(conditionId);
        this.onAddMarketCondition(entity.market, entity.market.getSpecificCondition(token));
    }

    public void onRemoveMarketCondition(MarketAPI market, MarketConditionAPI cond) {
        for (Map.Entry<String, Map<MarketAPI, MutableStat>> commodityEntry : this.demandByCommodity.entrySet()) {
            for (Map.Entry<MarketAPI, MutableStat> marketEntry : commodityEntry.getValue().entrySet()) {
                marketEntry.getValue().unmodify(cond.getIdForPluginModifications());
            }
        }
        for (Map.Entry<String, Map<MarketAPI, MutableStat>> commodityEntry : this.supplyByCommodity.entrySet()) {
            for (Map.Entry<MarketAPI, MutableStat> marketEntry : commodityEntry.getValue().entrySet()) {
                marketEntry.getValue().unmodify(cond.getIdForPluginModifications());
            }
        }
    }

    protected void removeMarketCondition(ExerelinProcGen.ProcGenEntity entity, String conditionId) {
        MarketConditionAPI cond = entity.market.getFirstCondition(conditionId);
        this.onRemoveMarketCondition(entity.market, cond);
        this.builder.removeMarketCondition(entity, cond);
    }

    public float getFarmingFood(String conditionId, float sizeMult) {
        float mult = 0.0f;
        if (FARMING_MULTS.containsKey(conditionId)) {
            mult = FARMING_MULTS.get(conditionId).floatValue();
        }
        return 1000.0f * mult * sizeMult;
    }

    protected void balanceDomesticGoods(List<ExerelinProcGen.ProcGenEntity> candidateEntities) {
        String comId = "domestic_goods";
        log.info((Object)("Pre-balance domestic goods supply/demand: " + (int)this.getSupply(comId) + " / " + (int)this.getDemand(comId)));
        WeightedRandomPicker entityPicker = new WeightedRandomPicker(this.random);
        for (ExerelinProcGen.ProcGenEntity entity : candidateEntities) {
            MarketAPI market = entity.market;
            if (market == null) continue;
            int size = market.getSize();
            float weight = Math.max(entity.marketPoints - entity.marketPointsSpent, 200);
            if (market.hasCondition("light_industrial_complex") && this.getSupply(comId) > this.getDemand(comId) * 1.4f) {
                this.removeMarketCondition(entity, "light_industrial_complex");
                weight *= 25.0f;
                log.info((Object)("Removed balancing Light Industrial Complex from " + market.getName() + " (size " + size + ")"));
            }
            if (market.hasCondition("cottage_industry")) {
                weight *= 0.25f;
            }
            entityPicker.add((Object)entity, weight *= this.builder.getConditionWeightForArchetype("light_industrial_complex", entity.archetype, 0.1f));
        }
        while (this.getDemand(comId) > this.getSupply(comId) * 1.0f && !entityPicker.isEmpty()) {
            ExerelinProcGen.ProcGenEntity entity = (ExerelinProcGen.ProcGenEntity)entityPicker.pickAndRemove();
            this.addMarketCondition(entity, "light_industrial_complex");
            log.info((Object)("Added balancing Light Industrial Complex to " + entity.market.getName()));
        }
        log.info((Object)("Final domestic goods supply/demand: " + (int)this.getSupply(comId) + " / " + (int)this.getDemand(comId)));
    }

    protected void balanceRareMetal(List<ExerelinProcGen.ProcGenEntity> candidateEntities) {
        String comId = "rare_metals";
        log.info((Object)("Pre-balance rare metal supply/demand: " + (int)this.getSupply(comId) + " / " + (int)this.getDemand(comId)));
        WeightedRandomPicker entityPicker = new WeightedRandomPicker(this.random);
        for (ExerelinProcGen.ProcGenEntity entity : candidateEntities) {
            int size;
            MarketAPI market = entity.market;
            if (market == null || (size = market.getSize()) <= 4) continue;
            float weight = Math.max(entity.marketPoints - entity.marketPointsSpent, 200);
            if (market.hasCondition("shipbreaking_center") && this.getSupply(comId) > this.getDemand(comId) * 1.4f) {
                this.removeMarketCondition(entity, "shipbreaking_center");
                log.info((Object)("Removed balancing shipbreaking center from " + market.getName()));
                weight *= 100.0f;
            }
            weight *= this.builder.getConditionWeightForArchetype("shipbreaking_center", entity.archetype, 0.1f);
            if (ExerelinUtilsFaction.isFactionHostileToAll(market.getFactionId())) {
                weight *= 0.01f;
            }
            if (weight == 0.0f) continue;
            entityPicker.add((Object)entity, weight);
        }
        while ((double)this.getDemand(comId) > (double)this.getSupply(comId) * 1.2 && !entityPicker.isEmpty()) {
            ExerelinProcGen.ProcGenEntity entity = (ExerelinProcGen.ProcGenEntity)entityPicker.pickAndRemove();
            this.addMarketCondition(entity, "shipbreaking_center");
            log.info((Object)("Added balancing shipbreaking center to " + entity.market.getName()));
        }
        log.info((Object)("Final rare metal supply/demand: " + (int)this.getSupply(comId) + " / " + (int)this.getDemand(comId)));
    }

    protected void balanceMachinery(List<ExerelinProcGen.ProcGenEntity> candidateEntities) {
        String comId = "heavy_machinery";
        log.info((Object)("Pre-balance machinery supply/demand: " + (int)this.getSupply(comId) + " / " + (int)this.getDemand(comId)));
        WeightedRandomPicker entityPicker = new WeightedRandomPicker(this.random);
        for (ExerelinProcGen.ProcGenEntity entity : candidateEntities) {
            int size;
            MarketAPI market = entity.market;
            if (market == null || (size = market.getSize()) <= 3) continue;
            float weight = Math.max(entity.marketPoints - entity.marketPointsSpent, 200);
            if (market.hasCondition("autofac_heavy_industry") && this.getSupply(comId) > this.getDemand(comId) * 1.4f * 1.2f) {
                this.removeMarketCondition(entity, "autofac_heavy_industry");
                log.info((Object)("Removed balancing heavy autofactory from " + market.getName()));
                weight *= 100.0f;
            }
            weight *= this.builder.getConditionWeightForArchetype("autofac_heavy_industry", entity.archetype, 0.1f);
            if (ExerelinUtilsFaction.isFactionHostileToAll(market.getFactionId())) {
                weight *= 0.01f;
            }
            if (weight == 0.0f) continue;
            entityPicker.add((Object)entity, weight);
        }
        while (this.getDemand(comId) > this.getSupply(comId) * 1.0f && !entityPicker.isEmpty()) {
            ExerelinProcGen.ProcGenEntity entity = (ExerelinProcGen.ProcGenEntity)entityPicker.pickAndRemove();
            MarketAPI market = entity.market;
            this.addMarketCondition(entity, "autofac_heavy_industry");
            log.info((Object)("Added balancing heavy autofac to " + market.getName()));
        }
        log.info((Object)("Final machinery supply/demand: " + (int)this.getSupply(comId) + " / " + (int)this.getDemand(comId)));
    }

    protected void balanceSupplies(List<ExerelinProcGen.ProcGenEntity> candidateEntities) {
        String comId = "supplies";
        log.info((Object)("Pre-balance supplies supply/demand: " + (int)this.getSupply(comId) + " / " + (int)this.getDemand(comId)));
        WeightedRandomPicker entityPicker = new WeightedRandomPicker(this.random);
        for (ExerelinProcGen.ProcGenEntity entity : candidateEntities) {
            MarketAPI market = entity.market;
            if (market == null) continue;
            int size = market.getSize();
            float weight = Math.max(entity.marketPoints - entity.marketPointsSpent, 200);
            if (market.hasCondition("exerelin_supply_workshop") && !entity.isHQ && this.getSupply(comId) > this.getDemand(comId) * 1.4f) {
                this.removeMarketCondition(entity, "exerelin_supply_workshop");
                log.info((Object)("Removed balancing supply workshop from " + market.getName()));
                weight *= 100.0f;
            }
            weight *= this.builder.getConditionWeightForArchetype("exerelin_supply_workshop", entity.archetype, 0.25f);
            if (ExerelinUtilsFaction.isFactionHostileToAll(market.getFactionId())) {
                weight *= 0.01f;
            }
            if (weight == 0.0f || !this.builder.isConditionAllowed("exerelin_supply_workshop", entity)) continue;
            entityPicker.add((Object)entity, weight);
        }
        while (this.getDemand(comId) > this.getSupply(comId) * 1.0f && !entityPicker.isEmpty()) {
            ExerelinProcGen.ProcGenEntity entity = (ExerelinProcGen.ProcGenEntity)entityPicker.pickAndRemove();
            this.addMarketCondition(entity, "exerelin_supply_workshop");
            log.info((Object)("Added balancing supply workshop to " + entity.market.getName()));
        }
        log.info((Object)("Final supplies supply/demand: " + (int)this.getSupply(comId) + " / " + (int)this.getDemand(comId)));
    }

    protected void balanceFood(List<ExerelinProcGen.ProcGenEntity> candidateEntities) {
        String comId = "food";
        log.info((Object)("Pre-balance food supply/demand: " + (int)this.getSupply(comId) + " / " + (int)this.getDemand(comId)));
        WeightedRandomPicker entityPicker = new WeightedRandomPicker(this.random);
        for (ExerelinProcGen.ProcGenEntity entity : candidateEntities) {
            MarketAPI market = entity.market;
            if (market == null) continue;
            float weight = Math.max(entity.marketPoints - entity.marketPointsSpent, 200);
            if (this.getSupply(comId) > this.getDemand(comId) * 1.4f) {
                if (market.hasCondition("rural_polity") && (double)this.random.nextFloat() > 0.5) {
                    this.removeMarketCondition(entity, "rural_polity");
                    weight *= 25.0f;
                    log.info((Object)("Removed balancing Rural Polity from " + market.getName()));
                } else if (market.hasCondition("hydroponics_complex")) {
                    this.removeMarketCondition(entity, "hydroponics_complex");
                    weight *= 25.0f;
                    log.info((Object)("Removed balancing Hydroponics Complex from " + market.getName()));
                } else if (market.hasCondition("orbital_burns") && (double)this.random.nextFloat() > 0.5) {
                    this.removeMarketCondition(entity, "orbital_burns");
                    weight *= 25.0f;
                    log.info((Object)("Removed balancing Orbital Burns from " + market.getName()));
                } else if (market.hasCondition("aquaculture")) {
                    this.removeMarketCondition(entity, "aquaculture");
                    weight *= 25.0f;
                    log.info((Object)("Removed balancing aquaculture from " + market.getName()));
                }
            }
            entityPicker.add((Object)entity, weight *= this.builder.getConditionWeightForArchetype("hydroponics_complex", entity.archetype, 0.1f));
        }
        while (this.getDemand(comId) > this.getSupply(comId) * 1.0f && !entityPicker.isEmpty()) {
            ExerelinProcGen.ProcGenEntity entity = (ExerelinProcGen.ProcGenEntity)entityPicker.pickAndRemove();
            MarketAPI market = entity.market;
            if (this.builder.isConditionAllowed("orbital_burns", entity)) {
                this.addMarketCondition(entity, "orbital_burns");
                log.info((Object)("Added balancing Orbital Burns to " + market.getName()));
                continue;
            }
            if (this.builder.isConditionAllowed("aquaculture", entity)) {
                this.addMarketCondition(entity, "aquaculture");
                log.info((Object)("Added balancing Aquaculture to " + market.getName()));
                continue;
            }
            if (this.builder.isConditionAllowed("rural_polity", entity)) {
                this.addMarketCondition(entity, "rural_polity");
                log.info((Object)("Added balancing Rural Polity to " + market.getName()));
                continue;
            }
            this.addMarketCondition(entity, "hydroponics_complex");
            log.info((Object)("Added balancing Hydroponics Lab to " + market.getName()));
        }
        log.info((Object)("Final food supply/demand: " + (int)this.getSupply(comId) + " / " + (int)this.getDemand(comId)));
    }

    protected void balanceFuel(List<ExerelinProcGen.ProcGenEntity> candidateEntities) {
        String comId = "fuel";
        log.info((Object)("Pre-balance fuel supply/demand: " + (int)this.getSupply(comId) + " / " + (int)this.getDemand(comId)));
        WeightedRandomPicker entityPicker = new WeightedRandomPicker(this.random);
        for (ExerelinProcGen.ProcGenEntity entity : candidateEntities) {
            MarketAPI market = entity.market;
            if (market == null) continue;
            int size = market.getSize();
            float weight = Math.max(entity.marketPoints - entity.marketPointsSpent, 200);
            if (market.hasCondition("antimatter_fuel_production") && this.getSupply(comId) > this.getDemand(comId) * 1.4f) {
                this.removeMarketCondition(entity, "antimatter_fuel_production");
                weight *= 25.0f;
                log.info((Object)("Removed balancing Antimatter Fuel Production from " + market.getName()));
            }
            if (size < 4) continue;
            weight *= this.builder.getConditionWeightForArchetype("antimatter_fuel_production", entity.archetype, 0.1f);
            if (ExerelinUtilsFaction.isFactionHostileToAll(market.getFactionId())) {
                weight *= 0.01f;
            }
            entityPicker.add((Object)entity, weight);
        }
        while (this.getDemand(comId) > this.getSupply(comId) * 1.0f && !entityPicker.isEmpty()) {
            ExerelinProcGen.ProcGenEntity entity = (ExerelinProcGen.ProcGenEntity)entityPicker.pickAndRemove();
            this.addMarketCondition(entity, "antimatter_fuel_production");
            log.info((Object)("Added balancing Antimatter Fuel Production to " + entity.market.getName()));
        }
        log.info((Object)("Final fuel supply/demand: " + (int)this.getSupply(comId) + " / " + (int)this.getDemand(comId)));
    }

    protected void balanceOrganics(List<ExerelinProcGen.ProcGenEntity> candidateEntities) {
        String comId = "organics";
        log.info((Object)("Pre-balance organics supply/demand: " + (int)this.getSupply(comId) + " / " + (int)this.getDemand(comId)));
        WeightedRandomPicker entityPicker = new WeightedRandomPicker(this.random);
        for (ExerelinProcGen.ProcGenEntity entity : candidateEntities) {
            MarketAPI market = entity.market;
            if (market == null) continue;
            int size = market.getSize();
            float weight = Math.max(entity.marketPoints - entity.marketPointsSpent, 200);
            if (market.hasCondition("organics_complex") && this.getSupply(comId) > this.getDemand(comId) * 1.4f) {
                this.removeMarketCondition(entity, "organics_complex");
                weight *= 25.0f;
                log.info((Object)("Removed balancing Organics Complex from " + market.getName()));
            }
            weight *= this.builder.getConditionWeightForArchetype("organics_complex", entity.archetype, 0.1f);
            entityPicker.add((Object)entity, weight /= (float)size);
        }
        while (this.getDemand(comId) > this.getSupply(comId) * 1.0f && !entityPicker.isEmpty()) {
            ExerelinProcGen.ProcGenEntity entity = (ExerelinProcGen.ProcGenEntity)entityPicker.pickAndRemove();
            this.addMarketCondition(entity, "organics_complex");
            log.info((Object)("Added balancing Organics Complex to " + entity.market.getName()));
        }
        log.info((Object)("Final organics supply/demand: " + (int)this.getSupply(comId) + " / " + (int)this.getDemand(comId)));
    }

    protected void balanceVolatiles(List<ExerelinProcGen.ProcGenEntity> candidateEntities) {
        String comId = "volatiles";
        log.info((Object)("Pre-balance volatiles supply/demand: " + (int)this.getSupply(comId) + " / " + (int)this.getDemand(comId)));
        WeightedRandomPicker entityPicker = new WeightedRandomPicker(this.random);
        for (ExerelinProcGen.ProcGenEntity entity : candidateEntities) {
            MarketAPI market = entity.market;
            if (market == null) continue;
            int size = market.getSize();
            float weight = Math.max(entity.marketPoints - entity.marketPointsSpent, 200);
            if (market.hasCondition("volatiles_complex") && this.getSupply(comId) > this.getDemand(comId) * 1.4f) {
                this.removeMarketCondition(entity, "volatiles_complex");
                weight *= 25.0f;
                log.info((Object)("Removed balancing Volatiles Complex from " + market.getName()));
            }
            weight *= this.builder.getConditionWeightForArchetype("volatiles_complex", entity.archetype, 0.1f);
            entityPicker.add((Object)entity, weight /= (float)size);
        }
        while (this.getDemand(comId) > this.getSupply(comId) * 1.0f && !entityPicker.isEmpty()) {
            ExerelinProcGen.ProcGenEntity entity = (ExerelinProcGen.ProcGenEntity)entityPicker.pickAndRemove();
            this.addMarketCondition(entity, "volatiles_complex");
            log.info((Object)("Added balancing Volatiles Complex to " + entity.market.getName()));
        }
        log.info((Object)("Final volatiles supply/demand: " + (int)this.getSupply(comId) + " / " + (int)this.getDemand(comId)));
    }

    protected void balanceMetal(List<ExerelinProcGen.ProcGenEntity> candidateEntities) {
        String comId = "metals";
        log.info((Object)("Pre-balance metal supply/demand: " + (int)this.getSupply(comId) + " / " + (int)this.getDemand(comId)));
        WeightedRandomPicker entityPicker = new WeightedRandomPicker(this.random);
        for (ExerelinProcGen.ProcGenEntity entity : candidateEntities) {
            MarketAPI market = entity.market;
            if (market == null) continue;
            int size = market.getSize();
            float weight = Math.max(entity.marketPoints - entity.marketPointsSpent, 200);
            if (market.hasCondition("ore_refining_complex") && this.getSupply(comId) > this.getDemand(comId) * 1.4f) {
                this.removeMarketCondition(entity, "ore_refining_complex");
                weight *= 25.0f;
                log.info((Object)("Removed balancing Ore Refining Complex from " + market.getName()));
            }
            entityPicker.add((Object)entity, weight *= this.builder.getConditionWeightForArchetype("ore_refining_complex", entity.archetype, 0.1f));
        }
        while (this.getDemand(comId) > this.getSupply(comId) * 1.0f && !entityPicker.isEmpty()) {
            ExerelinProcGen.ProcGenEntity entity = (ExerelinProcGen.ProcGenEntity)entityPicker.pickAndRemove();
            MarketAPI market = entity.market;
            this.addMarketCondition(entity, "ore_refining_complex");
            log.info((Object)("Added balancing Ore Refining Complex to " + market.getName()));
        }
        log.info((Object)("Final metal supply/demand: " + (int)this.getSupply(comId) + " / " + (int)this.getDemand(comId)));
    }

    protected void balanceOre(List<ExerelinProcGen.ProcGenEntity> candidateEntities) {
        String comId = "domestic_goods";
        log.info((Object)("Pre-balance ore supply/demand: " + (int)this.getSupply(comId) + " / " + (int)this.getDemand(comId)));
        WeightedRandomPicker entityPicker = new WeightedRandomPicker(this.random);
        for (ExerelinProcGen.ProcGenEntity entity : candidateEntities) {
            MarketAPI market = entity.market;
            if (market == null) continue;
            int size = market.getSize();
            float weight = Math.max(entity.marketPoints - entity.marketPointsSpent, 200);
            if (market.hasCondition("ore_complex") && this.getSupply(comId) > this.getDemand(comId) * 1.4f) {
                this.removeMarketCondition(entity, "ore_complex");
                weight *= 25.0f;
                log.info((Object)("Removed balancing Ore Complex from " + market.getName()));
            }
            weight *= this.builder.getConditionWeightForArchetype("ore_complex", entity.archetype, 0.1f);
            entityPicker.add((Object)entity, weight /= (float)size);
        }
        while (this.getDemand(comId) > this.getSupply(comId) * 1.0f && !entityPicker.isEmpty()) {
            ExerelinProcGen.ProcGenEntity entity = (ExerelinProcGen.ProcGenEntity)entityPicker.pickAndRemove();
            this.addMarketCondition(entity, "ore_complex");
            log.info((Object)("Added balancing Ore Complex to " + entity.market.getName()));
        }
        log.info((Object)("Final ore supply/demand: " + (int)this.getSupply(comId) + " / " + (int)this.getDemand(comId)));
    }

    public void reportSupplyDemand() {
        String[] commodities;
        for (String commodity : commodities = new String[]{"supplies", "fuel", "domestic_goods", "food", "heavy_machinery", "metals", "rare_metals", "ore", "rare_ore", "organics", "volatiles"}) {
            if (!this.demandByCommodity.containsKey(commodity) || !this.supplyByCommodity.containsKey(commodity)) continue;
            float supply = this.getSupply(commodity);
            float demand = this.getDemand(commodity);
            log.info((Object)("\t" + commodity.toUpperCase() + " supply / demand: " + (int)supply + " / " + (int)demand));
        }
    }

    static {
        FARMING_MULTS.put("terran", Float.valueOf(2.0f));
        FARMING_MULTS.put("twilight", Float.valueOf(1.0f));
        FARMING_MULTS.put("arid", Float.valueOf(0.5f));
        FARMING_MULTS.put("water", Float.valueOf(0.5f));
        FARMING_MULTS.put("jungle", Float.valueOf(0.5f));
        FARMING_MULTS.put("tundra", Float.valueOf(0.5f));
        FARMING_MULTS.put("barren_marginal", Float.valueOf(0.2f));
        FARMING_MULTS.put("desert", Float.valueOf(0.2f));
        FARMING_MULTS.put("ice", Float.valueOf(0.2f));
    }
}

