/*
 * Decompiled with CFR 0.152.
 */
package exerelin.world;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.util.IntervalUtil;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class SSP_AsteroidTracker
implements EveryFrameScript {
    private static final float INTERVAL = 0.25f;
    private static final transient Map<SectorEntityToken, Vector2f> asteroidLocationMap = new WeakHashMap<SectorEntityToken, Vector2f>(5000);
    private static final transient Map<SectorEntityToken, Vector2f> asteroidVelocityMap = new WeakHashMap<SectorEntityToken, Vector2f>(5000);
    private final IntervalUtil interval = new IntervalUtil(0.25f, 0.25f);

    public static Vector2f getVelocity(SectorEntityToken asteroid) {
        Vector2f velocity = asteroidVelocityMap.get(asteroid);
        if (velocity == null) {
            velocity = new Vector2f();
        }
        return velocity;
    }

    public void advance(float amount) {
        float days = Global.getSector().getClock().convertToDays(amount);
        this.interval.advance(days);
        if (this.interval.intervalElapsed()) {
            float scale = 1.0f / (Global.getSector().getClock().getSecondsPerDay() * 0.25f);
            CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
            if (playerFleet == null) {
                return;
            }
            LocationAPI playerLocation = playerFleet.getContainingLocation();
            if (playerLocation == null) {
                return;
            }
            List asteroids = playerLocation.getAsteroids();
            int size = asteroids.size();
            for (int i = 0; i < size; ++i) {
                SectorEntityToken asteroid = (SectorEntityToken)asteroids.get(i);
                Vector2f location = asteroidLocationMap.get(asteroid);
                Vector2f velocity = asteroidVelocityMap.get(asteroid);
                if (location == null || velocity == null) {
                    location = new Vector2f((ReadableVector2f)asteroid.getLocation());
                    asteroidLocationMap.put(asteroid, location);
                    velocity = new Vector2f();
                    asteroidVelocityMap.put(asteroid, velocity);
                    continue;
                }
                Vector2f.sub((Vector2f)asteroid.getLocation(), (Vector2f)location, (Vector2f)velocity);
                velocity.scale(scale);
                location.set((ReadableVector2f)asteroid.getLocation());
            }
        }
    }

    public boolean isDone() {
        return false;
    }

    public boolean runWhilePaused() {
        return false;
    }
}

