/*
 * Decompiled with CFR 0.152.
 */
package exerelin.world;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CustomCampaignEntityAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.RepLevel;
import com.fs.starfarer.api.campaign.SectorAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import data.scripts.world.corvus.Corvus;
import data.scripts.world.systems.AlGebbar;
import data.scripts.world.systems.Arcadia;
import data.scripts.world.systems.Askonia;
import data.scripts.world.systems.Aztlan;
import data.scripts.world.systems.Canaan;
import data.scripts.world.systems.Duzahk;
import data.scripts.world.systems.Eos;
import data.scripts.world.systems.Galatia;
import data.scripts.world.systems.Hybrasil;
import data.scripts.world.systems.Isirah;
import data.scripts.world.systems.KumariKandam;
import data.scripts.world.systems.Magec;
import data.scripts.world.systems.Mayasura;
import data.scripts.world.systems.Naraka;
import data.scripts.world.systems.Penelope;
import data.scripts.world.systems.Samarra;
import data.scripts.world.systems.Thule;
import data.scripts.world.systems.TiaTaxet;
import data.scripts.world.systems.Tyle;
import data.scripts.world.systems.Valhalla;
import data.scripts.world.systems.Westernesse;
import data.scripts.world.systems.Yma;
import data.scripts.world.systems.Zagan;

public class VanillaSystemsGenerator {
    public static void generate(SectorAPI sector) {
        StarSystemAPI system = sector.createStarSystem("Corvus");
        system.setBackgroundTextureFilename("graphics/backgrounds/background4.jpg");
        sector.setRespawnLocation((LocationAPI)system);
        sector.getRespawnCoordinates().set(-2500.0f, -3500.0f);
        VanillaSystemsGenerator.initFactionRelationships(sector);
        new Galatia().generate(sector);
        new Askonia().generate(sector);
        new Eos().generate(sector);
        new Valhalla().generate(sector);
        new Arcadia().generate(sector);
        new Magec().generate(sector);
        new Corvus().generate(sector);
        new Aztlan().generate(sector);
        new Samarra().generate(sector);
        new Penelope().generate(sector);
        new Yma().generate(sector);
        new Hybrasil().generate(sector);
        new Duzahk().generate(sector);
        new TiaTaxet().generate(sector);
        new Canaan().generate(sector);
        new AlGebbar().generate(sector);
        new Isirah().generate(sector);
        new KumariKandam().generate(sector);
        new Naraka().generate(sector);
        new Thule().generate(sector);
        new Mayasura().generate(sector);
        new Zagan().generate(sector);
        new Westernesse().generate(sector);
        new Tyle().generate(sector);
        VanillaSystemsGenerator.exerelinEndGalatiaPortionOfMission();
        LocationAPI hyper = Global.getSector().getHyperspace();
        CustomCampaignEntityAPI atlanticLabel = hyper.addCustomEntity("atlantic_label_id", null, "atlantic_label", null);
        CustomCampaignEntityAPI perseanLabel = hyper.addCustomEntity("persean_label_id", null, "persean_label", null);
        CustomCampaignEntityAPI luddicLabel = hyper.addCustomEntity("luddic_label_id", null, "luddic_label", null);
        CustomCampaignEntityAPI zinLabel = hyper.addCustomEntity("zin_label_id", null, "zin_label", null);
        CustomCampaignEntityAPI abyssLabel = hyper.addCustomEntity("opabyss_label_id", null, "opabyss_label", null);
        CustomCampaignEntityAPI telmunLabel = hyper.addCustomEntity("telmun_label_id", null, "telmun_label", null);
        CustomCampaignEntityAPI cathedralLabel = hyper.addCustomEntity("cathedral_label_id", null, "cathedral_label", null);
        CustomCampaignEntityAPI coreLabel = hyper.addCustomEntity("core_label_id", null, "core_label", null);
        atlanticLabel.setFixedLocation(500.0f, -2000.0f);
        perseanLabel.setFixedLocation(-10000.0f, 1000.0f);
        luddicLabel.setFixedLocation(-14000.0f, -9500.0f);
        zinLabel.setFixedLocation(-22000.0f, -17000.0f);
        telmunLabel.setFixedLocation(-16000.0f, 0.0f);
        cathedralLabel.setFixedLocation(-12700.0f, -12000.0f);
        coreLabel.setFixedLocation(0.0f, -6000.0f);
        abyssLabel.setFixedLocation(-65000.0f, -47000.0f);
    }

    public static void exerelinEndGalatiaPortionOfMission() {
        StarSystemAPI system = Global.getSector().getStarSystem("galatia");
        PlanetAPI ancyra = (PlanetAPI)system.getEntityById("ancyra");
        SectorEntityToken derinkuyu = system.getEntityById("derinkuyu_station");
        SectorEntityToken inner = system.getEntityById("galatia_jump_point_alpha");
        SectorEntityToken fringe = system.getEntityById("galatia_jump_point_fringe");
        SectorEntityToken relay = system.getEntityById("ancyra_relay");
        relay.getMemoryWithoutUpdate().unset("$commRelayNonFunctional");
        Global.getSector().getEconomy().addMarket(ancyra.getMarket());
        Global.getSector().getEconomy().addMarket(derinkuyu.getMarket());
        inner.getMemoryWithoutUpdate().unset("$unstable");
        inner.getMemoryWithoutUpdate().unset("$canStabilize");
        fringe.getMemoryWithoutUpdate().unset("$unstable");
        fringe.getMemoryWithoutUpdate().unset("$canStabilize");
    }

    public static void initFactionRelationships(SectorAPI sector) {
        FactionAPI hegemony = sector.getFaction("hegemony");
        FactionAPI tritachyon = sector.getFaction("tritachyon");
        FactionAPI pirates = sector.getFaction("pirates");
        FactionAPI independent = sector.getFaction("independent");
        FactionAPI kol = sector.getFaction("knights_of_ludd");
        FactionAPI church = sector.getFaction("luddic_church");
        FactionAPI path = sector.getFaction("luddic_path");
        FactionAPI player = sector.getFaction("player");
        FactionAPI diktat = sector.getFaction("sindrian_diktat");
        FactionAPI persean = sector.getFaction("persean");
        FactionAPI remnant = sector.getFaction("remnant");
        FactionAPI derelict = sector.getFaction("derelict");
        player.setRelationship(hegemony.getId(), 0.0f);
        player.setRelationship(tritachyon.getId(), 0.0f);
        player.setRelationship(persean.getId(), 0.0f);
        player.setRelationship(pirates.getId(), -0.65f);
        player.setRelationship(independent.getId(), 0.0f);
        player.setRelationship(kol.getId(), 0.0f);
        player.setRelationship(church.getId(), 0.0f);
        player.setRelationship(path.getId(), RepLevel.HOSTILE);
        hegemony.setRelationship(tritachyon.getId(), RepLevel.HOSTILE);
        hegemony.setRelationship(persean.getId(), RepLevel.HOSTILE);
        hegemony.setRelationship(pirates.getId(), RepLevel.HOSTILE);
        tritachyon.setRelationship(pirates.getId(), RepLevel.HOSTILE);
        tritachyon.setRelationship(kol.getId(), RepLevel.HOSTILE);
        tritachyon.setRelationship(church.getId(), RepLevel.HOSTILE);
        tritachyon.setRelationship(path.getId(), RepLevel.HOSTILE);
        tritachyon.setRelationship(persean.getId(), RepLevel.SUSPICIOUS);
        pirates.setRelationship(kol.getId(), RepLevel.HOSTILE);
        pirates.setRelationship(church.getId(), RepLevel.HOSTILE);
        pirates.setRelationship(path.getId(), 0.0f);
        pirates.setRelationship(independent.getId(), RepLevel.HOSTILE);
        pirates.setRelationship(diktat.getId(), RepLevel.HOSTILE);
        pirates.setRelationship(persean.getId(), RepLevel.HOSTILE);
        church.setRelationship(kol.getId(), RepLevel.COOPERATIVE);
        path.setRelationship(kol.getId(), RepLevel.FAVORABLE);
        path.setRelationship(independent.getId(), RepLevel.HOSTILE);
        path.setRelationship(hegemony.getId(), RepLevel.HOSTILE);
        path.setRelationship(diktat.getId(), RepLevel.HOSTILE);
        path.setRelationship(persean.getId(), RepLevel.HOSTILE);
        persean.setRelationship(hegemony.getId(), RepLevel.HOSTILE);
        persean.setRelationship(tritachyon.getId(), RepLevel.SUSPICIOUS);
        persean.setRelationship(pirates.getId(), RepLevel.HOSTILE);
        persean.setRelationship(path.getId(), RepLevel.HOSTILE);
        persean.setRelationship(diktat.getId(), RepLevel.COOPERATIVE);
        player.setRelationship(remnant.getId(), RepLevel.HOSTILE);
        independent.setRelationship(remnant.getId(), RepLevel.HOSTILE);
        pirates.setRelationship(remnant.getId(), RepLevel.HOSTILE);
        hegemony.setRelationship(remnant.getId(), RepLevel.HOSTILE);
        kol.setRelationship(remnant.getId(), RepLevel.HOSTILE);
        church.setRelationship(remnant.getId(), RepLevel.HOSTILE);
        path.setRelationship(remnant.getId(), RepLevel.HOSTILE);
        diktat.setRelationship(remnant.getId(), RepLevel.HOSTILE);
        persean.setRelationship(remnant.getId(), RepLevel.HOSTILE);
    }
}

