/*
 * Decompiled with CFR 0.152.
 */
package com.group_finity.mascot;

import com.group_finity.mascot.Manager;
import com.group_finity.mascot.Mascot;
import com.group_finity.mascot.NativeFactory;
import com.group_finity.mascot.config.Configuration;
import com.group_finity.mascot.config.Entry;
import com.group_finity.mascot.exception.BehaviorInstantiationException;
import com.group_finity.mascot.exception.CantBeAliveException;
import com.group_finity.mascot.exception.ConfigurationException;
import com.group_finity.mascot.imagesetchooser.ImageSetChooser;
import java.awt.AWTException;
import java.awt.Frame;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class Main {
    private static final Logger log = Logger.getLogger(Main.class.getName());
    static final String BEHAVIOR_GATHER = "ChaseMouse";
    private final Manager manager = new Manager();
    private ArrayList<String> imageSets = new ArrayList();
    private Hashtable<String, Configuration> configurations = new Hashtable();
    private static Main instance;
    private static JFrame frame;

    public static Main getInstance() {
        return instance;
    }

    public static void showError(String message) {
        JOptionPane.showMessageDialog(frame, message, "Error", 0);
    }

    public static void main(String[] args) {
        try {
            Main.getInstance().run();
        }
        catch (OutOfMemoryError err) {
            log.log(Level.SEVERE, "Out of Memory Exception.  There are probably have too many Shimeji mascots in the image folder for your computer to handle.  Select fewer image sets or move some to the img/unused folder and try again.", err);
            Main.showError("Out of Memory.  There are probably have too many \nShimeji mascots for your computer to handle.\nSelect fewer image sets or move some to the \nimg/unused folder and try again.");
            System.exit(0);
        }
    }

    public void run() {
        this.imageSets = new ImageSetChooser((Frame)frame, true).display();
        for (String imageSet : this.imageSets) {
            this.loadConfiguration(imageSet);
        }
        this.createTrayIcon();
        for (String imageSet : this.imageSets) {
            this.createMascot(imageSet);
        }
        this.getManager().start();
    }

    private void loadConfiguration(String imageSet) {
        try {
            String actionsFile = "./conf/actions.xml";
            if (new File("./conf/" + imageSet + "/actions.xml").exists()) {
                actionsFile = "./conf/" + imageSet + "/actions.xml";
            } else if (new File("./img/" + imageSet + "/conf/actions.xml").exists()) {
                actionsFile = "./img/" + imageSet + "/conf/actions.xml";
            }
            log.log(Level.INFO, imageSet + " Read Action File ({0})", actionsFile);
            Document actions = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new FileInputStream(new File(actionsFile)));
            Configuration configuration = new Configuration();
            configuration.load(new Entry(actions.getDocumentElement()), imageSet);
            String behaviorsFile = "./conf/behaviors.xml";
            if (new File("./conf/" + imageSet + "/behaviors.xml").exists()) {
                behaviorsFile = "./conf/" + imageSet + "/behaviors.xml";
            } else if (new File("./img/" + imageSet + "/conf/behaviors.xml").exists()) {
                behaviorsFile = "./img/" + imageSet + "/conf/behaviors.xml";
            }
            log.log(Level.INFO, imageSet + " Read Behavior File ({0})", behaviorsFile);
            Document behaviors = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new FileInputStream(new File(behaviorsFile)));
            configuration.load(new Entry(behaviors.getDocumentElement()), imageSet);
            configuration.validate();
            this.configurations.put(imageSet, configuration);
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "Failed to load configuration files", e);
            Main.showError("Failed to load configuration files.\nSee log for more details.");
            this.exit();
        }
        catch (SAXException e) {
            log.log(Level.SEVERE, "Failed to load configuration files", e);
            Main.showError("Failed to load configuration files.\nSee log for more details.");
            this.exit();
        }
        catch (ParserConfigurationException e) {
            log.log(Level.SEVERE, "Failed to load configuration files", e);
            Main.showError("Failed to load configuration files.\nSee log for more details.");
            this.exit();
        }
        catch (ConfigurationException e) {
            log.log(Level.SEVERE, "Failed to load configuration files", e);
            Main.showError("Failed to load configuration files.\nSee log for more details.");
            this.exit();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Failed to load configuration files", e);
            Main.showError("Failed to load configuration files.\nSee log for more details.");
            this.exit();
        }
    }

    private void createTrayIcon() {
        log.log(Level.INFO, "create a tray icon");
        MenuItem increaseMenu = new MenuItem("Another One!");
        increaseMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Main.this.createMascot();
            }
        });
        MenuItem gatherMenu = new MenuItem("Follow Mouse!");
        gatherMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Main.this.getManager().setBehaviorAll(Main.BEHAVIOR_GATHER);
            }
        });
        MenuItem oneMenu = new MenuItem("Reduce to One!");
        oneMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Main.this.getManager().remainOne();
            }
        });
        MenuItem restoreMenu = new MenuItem("Restore IE!");
        restoreMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                NativeFactory.getInstance().getEnvironment().restoreIE();
            }
        });
        MenuItem closeMenu = new MenuItem("Bye Everyone!");
        closeMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Main.this.exit();
            }
        });
        PopupMenu trayPopup = new PopupMenu();
        trayPopup.add(increaseMenu);
        trayPopup.add(gatherMenu);
        trayPopup.add(oneMenu);
        trayPopup.add(restoreMenu);
        trayPopup.add(new MenuItem("-"));
        trayPopup.add(closeMenu);
        try {
            TrayIcon icon = new TrayIcon(ImageIO.read(Main.class.getResource("/icon.png")), "shimeji-ee", trayPopup);
            icon.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (SwingUtilities.isLeftMouseButton(e)) {
                        Main.this.createMascot();
                    }
                }
            });
            SystemTray.getSystemTray().add(icon);
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "Failed to create tray icon", e);
            Main.showError("Failed to display system tray.\nSee log for more details.");
            this.exit();
        }
        catch (AWTException e) {
            log.log(Level.SEVERE, "Failed to create tray icon", e);
            Main.showError("Failed to display system tray.\nSee log for more details.");
            this.getManager().setExitOnLastRemoved(true);
        }
    }

    public void createMascot() {
        int length = this.imageSets.size();
        int random = (int)((double)length * Math.random());
        this.createMascot(this.imageSets.get(random));
    }

    public void createMascot(String imageSet) {
        log.log(Level.INFO, "create a mascot");
        Mascot mascot = new Mascot(imageSet);
        mascot.setAnchor(new Point(-1000, -1000));
        mascot.setLookRight(Math.random() < 0.5);
        try {
            mascot.setBehavior(this.getConfiguration(imageSet).buildBehavior(null, mascot));
            this.getManager().add(mascot);
        }
        catch (BehaviorInstantiationException e) {
            log.log(Level.SEVERE, "Failed to initialize the first action", e);
            Main.showError("Failed to initialize first action.\nSee log for more details.");
            mascot.dispose();
        }
        catch (CantBeAliveException e) {
            log.log(Level.SEVERE, "Fatal Error", e);
            Main.showError("Failed to initialize first action.\nSee log for more details.");
            mascot.dispose();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, imageSet + " fatal error, can not be started.", e);
            Main.showError("Could not create " + imageSet + ".\nSee log for more details.");
            mascot.dispose();
        }
    }

    public Configuration getConfiguration(String imageSet) {
        return this.configurations.get(imageSet);
    }

    private Manager getManager() {
        return this.manager;
    }

    public void exit() {
        this.getManager().disposeAll();
        this.getManager().stop();
        System.exit(0);
    }

    static {
        try {
            LogManager.getLogManager().readConfiguration(Main.class.getResourceAsStream("/logging.properties"));
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        instance = new Main();
        frame = new JFrame();
    }
}

