/*
 * Decompiled with CFR 0.152.
 */
package com.ringosham.translate;

import com.ringosham.translate.Color;
import com.ringosham.translate.LogHelper;
import com.ringosham.translate.Main;
import com.ringosham.translate.ModEventHandler;
import com.rmtheis.yandtran.detect.Detect;
import com.rmtheis.yandtran.language.Language;
import com.rmtheis.yandtran.translate.Translate;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.event.ClickEvent;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import org.apache.logging.log4j.Level;

public class ChatTranslator {
    public static Map<Language, String> languageName = new HashMap<Language, String>();
    public static List<String> commandLanguageList = new ArrayList<String>();
    public static Map<String, Language> reverseLanguageName = new HashMap<String, Language>();
    public static String[] configLanguage;
    public static Language translateChat;
    private static boolean playerSent;
    public static Language translateFrom;
    public static Language translateTo;
    public static String chatSeparator;
    private int serverResponse;
    public static boolean disableTranslation;
    public String commandPrefix = (Object)((Object)Color.GREEN) + "[" + (Object)((Object)Color.RESET) + "TranslateMod" + (Object)((Object)Color.GREEN) + "] ";
    private static String username;
    public static String loggingLevel;
    private static String chatMessage;
    public static String playerMessage;

    private final Language detectLang(String message) {
        Language lang = null;
        try {
            lang = Detect.execute(message);
        }
        catch (IOException e) {
            String stringResponse = e.getMessage();
            char[] arrayResponse = stringResponse.toCharArray();
            for (int i = 0; i < stringResponse.length(); ++i) {
                this.serverResponse = 0;
                try {
                    this.serverResponse = Integer.parseInt(Character.toString(arrayResponse[i]));
                    this.serverResponse = Integer.parseInt(stringResponse.substring(i, i + 3));
                }
                catch (Exception ex) {
                    System.out.println(stringResponse);
                }
                if (this.serverResponse != 0) break;
            }
            if (this.serverResponse == 0) {
                this.serverResponse = -404;
            }
            if (this.serverResponse != 0) {
                LogHelper.log(Level.ERROR, "Exception caught with HTTP response code " + this.serverResponse + " from translation server");
            }
        }
        catch (RuntimeException e) {
            if (e.getMessage().equals("INVALID_API_KEY - Please set the API Key with your Yandex API Key")) {
                this.serverResponse = -402;
            } else if (e.getMessage().equals("[yandex-translator-api] Error reading translation stream.")) {
                this.serverResponse = -403;
            } else {
                this.serverResponse = -404;
                e.printStackTrace();
            }
            LogHelper.log(Level.ERROR, "Internal exception caught during translation");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.serverResponse = 0;
            LogHelper.log(Level.ERROR, "Exception caught during connecting to translation server");
        }
        return lang;
    }

    private final String translate(String message, Language from, Language to) {
        String chatString = "";
        try {
            chatString = Translate.execute(message, from, to);
        }
        catch (IOException e) {
            String stringResponse = e.getMessage();
            char[] arrayResponse = stringResponse.toCharArray();
            for (int i = 0; i < stringResponse.length(); ++i) {
                this.serverResponse = 0;
                try {
                    this.serverResponse = Integer.parseInt(Character.toString(arrayResponse[i]));
                    this.serverResponse = Integer.parseInt(stringResponse.substring(i, i + 3));
                }
                catch (Exception ex) {
                    System.out.println(stringResponse);
                }
                if (this.serverResponse != 0) break;
            }
            if (this.serverResponse == 0) {
                this.serverResponse = -404;
            }
            if (this.serverResponse != 0) {
                LogHelper.log(Level.ERROR, "Exception caught with HTTP response code " + this.serverResponse + " from translation server");
            }
        }
        catch (RuntimeException e) {
            if (e.getMessage().equals("INVALID_API_KEY - Please set the API Key with your Yandex API Key")) {
                this.serverResponse = -402;
            } else if (e.getMessage().equals("[yandex-translator-api] Error reading translation stream.")) {
                this.serverResponse = -403;
            } else {
                this.serverResponse = -404;
                e.printStackTrace();
            }
            LogHelper.log(Level.ERROR, "Internal exception caught during translation");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.serverResponse = 0;
            LogHelper.log(Level.ERROR, "Exception caught during connecting to translation server");
        }
        return chatString;
    }

    private static void translateChat(String chat) {
        ChatTranslator translator = new ChatTranslator();
        if (disableTranslation) {
            return;
        }
        Language lang = translator.detectLang(chat);
        if (lang != translateChat && lang != null) {
            String translatedMessage = translator.translate(chat, lang, translateChat);
            String langName = languageName.get((Object)lang).substring(0, 1) + languageName.get((Object)lang).substring(1).toLowerCase();
            boolean filter = ChatTranslator.filterChat(translatedMessage, chat);
            if (loggingLevel.equals("debug")) {
                System.out.println(String.format("Language: %s  Selected language: %s", new Object[]{lang, translateChat}));
                System.out.println("\" " + chat + " \"");
                System.out.println("\" " + translatedMessage + " \"");
                System.out.println(Boolean.toString(filter));
            }
            if (filter) {
                Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)new ChatComponentText(((Object)((Object)Color.GRAY) + "Translated(" + langName + "): " + translatedMessage).replace(" ", " " + (Object)((Object)Color.GRAY))));
            }
        } else if (lang == null && !loggingLevel.equals("off") && translator.serverResponse != 0) {
            translator.netErrorHandling(translator.serverResponse);
        }
    }

    private static final boolean filterChat(String translated, String original) {
        return !original.trim().equalsIgnoreCase(translated.trim());
    }

    private final void netErrorHandling(int responseCode) {
        ChatTranslator translator = new ChatTranslator();
        int[] normalLog = new int[]{401, 402, 403, 404, 500, 503, -402};
        if (loggingLevel == "off") {
            return;
        }
        if (loggingLevel == "normal") {
            for (int i = 0; i < normalLog.length; ++i) {
                if (normalLog[i] == responseCode && responseCode > 0) {
                    translator.sendChatMessage((Object)((Object)Color.RED) + "Error " + responseCode + " from translation server", true);
                    continue;
                }
                if (normalLog[i] == responseCode) {
                    translator.sendChatMessage((Object)((Object)Color.RED) + "Internal error caught. Please report to the mod creator", true);
                    continue;
                }
                return;
            }
        } else if (responseCode > 0) {
            translator.sendChatMessage((Object)((Object)Color.RED) + "Error " + responseCode + " from translation server", true);
        } else {
            translator.sendChatMessage((Object)((Object)Color.RED) + "Internal error caught. Please report to the mod creator", true);
        }
        switch (responseCode) {
            case 401: {
                translator.sendChatMessage((Object)((Object)Color.RED) + "Description: Translation API key expired. Please notify the mod creator to update it.".replace(" ", " " + (Object)((Object)Color.RED)), false);
                break;
            }
            case 402: {
                translator.sendChatMessage((Object)((Object)Color.RED) + "Description: Translation API key has been blocked. Please notify the mod creator to update it".replace(" ", " " + (Object)((Object)Color.RED)), false);
                break;
            }
            case 403: {
                translator.sendChatMessage((Object)((Object)Color.RED) + "Description: The mod has exceeded the daily limit of translation requests".replace(" ", " " + (Object)((Object)Color.RED)), false);
                break;
            }
            case 404: {
                translator.sendChatMessage((Object)((Object)Color.RED) + "Description: The mod has exceeded the daily limit of translation text".replace(" ", " " + (Object)((Object)Color.RED)), false);
                break;
            }
            case 408: {
                if (loggingLevel != "debug") break;
                translator.sendChatMessage((Object)((Object)Color.RED) + "Description: Request timeout".replace(" ", " " + (Object)((Object)Color.RED)), false);
                break;
            }
            case 500: {
                translator.sendChatMessage((Object)((Object)Color.RED) + "Description: Internal server error. Translation servers are currently offline.".replace(" ", " " + (Object)((Object)Color.RED)), false);
                translator.sendChatMessage((Object)((Object)Color.RED) + "If this message is popping up continuously, type /translate disable to temporaily disable translation.".replace(" ", " " + (Object)((Object)Color.RED)), false);
                break;
            }
            case 503: {
                translator.sendChatMessage((Object)((Object)Color.RED) + "Description: Translation server is currently overloaded or down for maintainence".replace(" ", " " + (Object)((Object)Color.RED)), false);
                translator.sendChatMessage((Object)((Object)Color.RED) + "If this message is popping up continuously, type /translate disable to temporaily disable translation.".replace(" ", " " + (Object)((Object)Color.RED)), false);
                break;
            }
            case -402: {
                translator.sendChatMessage((Object)((Object)Color.RED) + "Description: Invalid translation key. This is not supposed to happen.", false);
            }
            case -403: {
                if (loggingLevel == "debug") {
                    translator.sendChatMessage((Object)((Object)Color.RED) + "Description: Error during reading translation stream", false);
                }
            }
            default: {
                System.out.println("Unknown error. Error code: " + responseCode);
                if (loggingLevel != "debug") break;
                translator.sendChatMessage((Object)((Object)Color.RED) + "Description: Unknown error recevied from servers", false);
            }
        }
        if (responseCode == 403 || responseCode == 404 || responseCode == -402) {
            translator.sendChatMessage((Object)((Object)Color.RESET) + "Switching translation key...", true);
            translator.changeKey();
        }
    }

    private final void changeKey() {
        ChatTranslator translator = new ChatTranslator();
        if (Main.setTranslateKey()) {
            translator.sendChatMessage((Object)((Object)Color.RESET) + "Translation key successfully changed", true);
        } else {
            translator.sendChatMessage((Object)((Object)Color.RED) + "All translation keys have exceeded the daily limit. The mod cannot translate your Minecraft chat until the next day. Sorry for the inconvenience", true);
            disableTranslation = true;
        }
    }

    public void showCredits() {
        ChatComponentText serviceUrl = new ChatComponentText("http://translate.yandex.com");
        ChatComponentText wrapperUrl = new ChatComponentText("https://github.com/rmtheis/yandex-translator-java-api");
        ChatComponentText forumUrl = new ChatComponentText("http://bit.ly/1PJuaOF");
        serviceUrl.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, "http://translate.yandex.com"));
        wrapperUrl.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://github.com/rmtheis/yandex-translator-java-api"));
        forumUrl.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, "http://bit.ly/1PJuaOF"));
        this.sendChatMessage(((Object)((Object)Color.AQUA) + "Real-time chat translation mod by Ringosham. Version " + Main.VERSION).replace(" ", " " + (Object)((Object)Color.AQUA)), false);
        this.sendChatMessage((IChatComponent)forumUrl);
        this.sendChatMessage((Object)((Object)Color.AQUA) + "Online translation services are provided by Yandex.Translate".replace(" ", " " + (Object)((Object)Color.AQUA)), false);
        this.sendChatMessage((IChatComponent)serviceUrl);
        this.sendChatMessage((Object)((Object)Color.AQUA) + "Yandex translator Java wrapper is provided by Robert Theis".replace(" ", " " + (Object)((Object)Color.AQUA)), false);
        this.sendChatMessage((IChatComponent)wrapperUrl);
        this.sendChatMessage((Object)((Object)Color.AQUA) + "Thanks for downloading my mod! Translation results may not be 100% accurate".replace(" ", " " + (Object)((Object)Color.AQUA)), false);
    }

    public void sendChatMessage(IChatComponent message) {
        Minecraft.func_71410_x().field_71439_g.func_145747_a(message);
    }

    public void sendChatMessage(String message, boolean addPrefix) {
        Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)new ChatComponentText(addPrefix ? this.commandPrefix : "" + message));
    }

    static {
        translateChat = Language.ENGLISH;
        playerSent = false;
        translateFrom = Language.ENGLISH;
        translateTo = Language.ENGLISH;
        disableTranslation = false;
    }

    public static class translateMe
    extends Thread {
        @Override
        public void run() {
            playerSent = true;
            ChatTranslator trans = new ChatTranslator();
            String translatedMessage = trans.translate(playerMessage, translateFrom, translateTo);
            if (translatedMessage != "") {
                Minecraft.func_71410_x().field_71439_g.func_71165_d(translatedMessage);
            } else if (!loggingLevel.equals("off")) {
                trans.netErrorHandling(trans.serverResponse);
            }
            playerSent = false;
        }
    }

    public static class chatHandler
    extends Thread {
        @Override
        public void run() {
            int i;
            if (username == null) {
                username = Minecraft.func_71410_x().field_71439_g.getDisplayName();
            }
            if (ModEventHandler.message.length() == 0) {
                return;
            }
            String[] splitChat = null;
            String[] separators = chatSeparator.split(",");
            for (i = 0; i < separators.length && (splitChat = ModEventHandler.message.split(separators[i])).length < 2; ++i) {
                splitChat = null;
            }
            if (splitChat == null) {
                return;
            }
            if (playerSent) {
                return;
            }
            chatMessage = "";
            for (i = 1; i < splitChat.length; ++i) {
                chatMessage = chatMessage.concat(splitChat[i]);
            }
            ChatTranslator.translateChat(chatMessage);
        }
    }
}

