/*
 * Decompiled with CFR 0.152.
 */
package com.ringosham.translate;

import com.ringosham.translate.ChatTranslator;
import com.ringosham.translate.Color;
import com.ringosham.translate.Main;
import com.rmtheis.yandtran.language.Language;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

public class Command
extends CommandBase {
    private List<String> aliases = new ArrayList<String>();
    private List<String> firstArg = new ArrayList<String>();
    private List<String> languageCompletion = new ArrayList<String>();
    private List<String> logCompletion = new ArrayList<String>();

    public Command() {
        this.aliases.add("translate");
        this.aliases.add("trans");
        this.aliases.add("tr");
        this.firstArg.add("credits");
        this.firstArg.add("chat");
        this.firstArg.add("me");
        this.firstArg.add("loggingLevel");
        this.firstArg.add("enable");
        this.firstArg.add("disable");
        this.logCompletion.add("off");
        this.logCompletion.add("normal");
        this.logCompletion.add("debug");
        this.languageCompletion = ChatTranslator.commandLanguageList;
    }

    public List<String> func_71514_a() {
        return this.aliases;
    }

    public String func_71517_b() {
        return "translate";
    }

    public String func_71518_a(ICommandSender command) {
        this.showUsage();
        return null;
    }

    public boolean func_71519_b(ICommandSender command) {
        return true;
    }

    public List func_71516_a(ICommandSender command, String[] args) {
        switch (args[0]) {
            case "me": {
                if (args.length == 2) {
                    ArrayList<String> subList = new ArrayList<String>();
                    for (int i = 0; i < this.languageCompletion.size(); ++i) {
                        if (!this.languageCompletion.get(i).startsWith(args[1])) continue;
                        subList.add(this.languageCompletion.get(i));
                    }
                    return subList;
                }
                if (args.length == 3) {
                    ArrayList<String> subList = new ArrayList<String>();
                    for (int i = 0; i < this.languageCompletion.size(); ++i) {
                        if (!this.languageCompletion.get(i).startsWith(args[2])) continue;
                        subList.add(this.languageCompletion.get(i));
                    }
                    return subList;
                }
                return null;
            }
            case "chat": {
                if (args.length == 2) {
                    ArrayList<String> subList = new ArrayList<String>();
                    for (int i = 0; i < this.languageCompletion.size(); ++i) {
                        if (!this.languageCompletion.get(i).startsWith(args[1])) continue;
                        subList.add(this.languageCompletion.get(i));
                    }
                    return subList;
                }
                return null;
            }
            case "loggingLevel": {
                if (args.length == 2) {
                    ArrayList<String> subList = new ArrayList<String>();
                    for (int i = 0; i < this.logCompletion.size(); ++i) {
                        if (!this.logCompletion.get(i).startsWith(args[1])) continue;
                        subList.add(this.logCompletion.get(i));
                    }
                    return subList;
                }
                return null;
            }
        }
        if (args.length == 1) {
            ArrayList<String> subList = new ArrayList<String>();
            for (int i = 0; i < this.firstArg.size(); ++i) {
                if (!this.firstArg.get(i).startsWith(args[0])) continue;
                subList.add(this.firstArg.get(i));
            }
            return subList;
        }
        return null;
    }

    protected void showUsage() {
        ChatTranslator trans = new ChatTranslator();
        trans.sendChatMessage((Object)((Object)Color.RED) + "Error: Invalid arguments. Usage are shown below", false);
        trans.sendChatMessage((Object)((Object)Color.RED) + "/translate credits", false);
        trans.sendChatMessage((Object)((Object)Color.RED) + "/translate me (language from) (language to)", false);
        trans.sendChatMessage((Object)((Object)Color.RED) + "/translate chat (language to)", false);
        trans.sendChatMessage((Object)((Object)Color.RED) + "/translate loggingLevel [off/normal/debug]", false);
        trans.sendChatMessage((Object)((Object)Color.RED) + "To translate your message, type \"/tm [message]\" or \"/transme [message]\"".replace(" ", " " + (Object)((Object)Color.RED)), false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void func_71515_b(ICommandSender command, String[] args) {
        if (!(command instanceof EntityPlayer)) return;
        ChatTranslator translator = new ChatTranslator();
        if (args.length == 0) {
            this.showUsage();
            return;
        }
        if (Main.modDisable) {
            translator.sendChatMessage((Object)((Object)Color.RED) + "The mod is disabled until the game restarts", true);
            return;
        }
        switch (args[0]) {
            case "credits": {
                translator.showCredits();
                return;
            }
            case "me": {
                if (args.length == 3) {
                    boolean argValid = false;
                    boolean bl = argValid = !(!ChatTranslator.reverseLanguageName.containsKey(args[1]) && !ChatTranslator.languageName.containsKey((Object)Language.fromString(args[1])) || !ChatTranslator.reverseLanguageName.containsKey(args[2]) && !ChatTranslator.languageName.containsKey((Object)Language.fromString(args[2])));
                    if (argValid) {
                        if (ChatTranslator.reverseLanguageName.containsKey(args[1])) {
                            Main.config.get("general", "Message language", "english", "What language your messages are?", ChatTranslator.configLanguage).set(args[1]);
                        } else {
                            Main.config.get("general", "Message language", "english", "What language your messages are?", ChatTranslator.configLanguage).set(ChatTranslator.languageName.get((Object)Language.fromString(args[1])).toLowerCase());
                        }
                        if (ChatTranslator.reverseLanguageName.containsKey(args[2])) {
                            Main.config.get("general", "Translation language(Player)", "spanish", "What language you want your message to be translated.", ChatTranslator.configLanguage).set(args[2]);
                        } else {
                            Main.config.get("general", "Translation language(Player)", "spanish", "What language you want your message to be translated.", ChatTranslator.configLanguage).set(ChatTranslator.languageName.get((Object)Language.fromString(args[2])).toLowerCase());
                        }
                        Main.config.save();
                        Main.syncConfig();
                        command.func_145747_a((IChatComponent)new ChatComponentText(translator.commandPrefix + (Object)((Object)Color.RESET) + "Your messsages will now translate from " + (Object)((Object)Color.AQUA) + ChatTranslator.languageName.get((Object)ChatTranslator.translateFrom).toLowerCase() + (Object)((Object)Color.RESET) + " to " + (Object)((Object)Color.AQUA) + ChatTranslator.languageName.get((Object)ChatTranslator.translateTo).toLowerCase()));
                        command.func_145747_a((IChatComponent)new ChatComponentText(translator.commandPrefix + (Object)((Object)Color.RESET) + "To translate your messages, type '/tm [message]'"));
                        return;
                    }
                } else {
                    if (args.length != 1) {
                        this.showUsage();
                        return;
                    }
                    command.func_145747_a((IChatComponent)new ChatComponentText(translator.commandPrefix + (Object)((Object)Color.RESET) + "Your chat messages are currently set to translate from " + (Object)((Object)Color.AQUA) + ChatTranslator.languageName.get((Object)ChatTranslator.translateFrom).toLowerCase() + (Object)((Object)Color.RESET) + " to " + (Object)((Object)Color.AQUA) + ChatTranslator.languageName.get((Object)ChatTranslator.translateTo).toLowerCase()));
                }
            }
            case "chat": {
                if (args.length == 2) {
                    if (ChatTranslator.reverseLanguageName.containsKey(args[1])) {
                        command.func_145747_a((IChatComponent)new ChatComponentText(translator.commandPrefix + (Object)((Object)Color.RESET) + "Chat will be translated to " + (Object)((Object)Color.AQUA) + args[1]));
                        this.changeLangChat(args[1]);
                        return;
                    }
                    if (ChatTranslator.languageName.containsKey((Object)Language.fromString(args[1]))) {
                        String langName = ChatTranslator.languageName.get((Object)Language.fromString(args[1])).toLowerCase();
                        command.func_145747_a((IChatComponent)new ChatComponentText(translator.commandPrefix + (Object)((Object)Color.RESET) + "Chat will be translated to " + (Object)((Object)Color.AQUA) + langName));
                        this.changeLangChat(langName);
                        return;
                    }
                    this.showUsage();
                    return;
                }
                if (args.length == 1) {
                    command.func_145747_a((IChatComponent)new ChatComponentText(translator.commandPrefix + (Object)((Object)Color.RESET) + "Your Minecraft chat has been set to translate to " + (Object)((Object)Color.AQUA) + ChatTranslator.languageName.get((Object)ChatTranslator.translateChat).toLowerCase()));
                    return;
                }
                this.showUsage();
                return;
            }
            case "loggingLevel": {
                if (args.length == 2) {
                    if (!(args[1].equals("off") || args[1].equals("normal") || args[1].equals("debug"))) {
                        this.showUsage();
                        return;
                    }
                    String[] logLevels = new String[]{"off", "normal", "debug"};
                    command.func_145747_a((IChatComponent)new ChatComponentText(translator.commandPrefix + (Object)((Object)Color.RESET) + "Error logging level has been set to " + (Object)((Object)Color.AQUA) + args[1]));
                    Main.config.load();
                    Main.config.get("general", "Error logging level", "normal", "Error logging levels. Change to debug if you want to send an bug report", logLevels).set(args[1]);
                    Main.config.save();
                    Main.syncConfig();
                    return;
                }
                if (args.length == 1) {
                    command.func_145747_a((IChatComponent)new ChatComponentText(translator.commandPrefix + (Object)((Object)Color.RESET) + "Logging level is currently set to " + (Object)((Object)Color.AQUA) + ChatTranslator.loggingLevel));
                    return;
                }
                this.showUsage();
                return;
            }
            case "enable": {
                ChatTranslator.disableTranslation = false;
                command.func_145747_a((IChatComponent)new ChatComponentText(translator.commandPrefix + (Object)((Object)Color.RESET) + "Real time chat translation " + (Object)((Object)Color.AQUA) + "enabled"));
                return;
            }
            case "disable": {
                ChatTranslator.disableTranslation = true;
                command.func_145747_a((IChatComponent)new ChatComponentText(translator.commandPrefix + (Object)((Object)Color.RESET) + "Real time chat translation " + (Object)((Object)Color.RED) + "disabled"));
                command.func_145747_a((IChatComponent)new ChatComponentText(translator.commandPrefix + (Object)((Object)Color.RESET) + "Please note that this change will not be saved. Translations will be re-enabled upon restarting the game."));
                return;
            }
        }
        this.showUsage();
    }

    private void changeLangChat(String lang) {
        Main.config.load();
        Main.config.get("general", "Translation language(Chat)", "english", "The language you want your chat to be translated to.", ChatTranslator.configLanguage).set(lang);
        Main.config.save();
        Main.syncConfig();
    }
}

