/*
 * Decompiled with CFR 0.152.
 */
package com.ringosham.translate;

import com.ringosham.proxy.CommonProxy;
import com.ringosham.translate.ChatTranslator;
import com.ringosham.translate.Command;
import com.ringosham.translate.LogHelper;
import com.ringosham.translate.ModEventHandler;
import com.ringosham.translate.TranslateCommand;
import com.rmtheis.yandtran.detect.Detect;
import com.rmtheis.yandtran.language.Language;
import com.rmtheis.yandtran.translate.Translate;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.command.ICommand;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import org.apache.logging.log4j.Level;

@Mod(modid="translate", name="Translate mod", version="2.5", guiFactory="com.ringosham.translate.GuiFactory")
public class Main {
    public static String MODID = "translate";
    public static String VERSION = "2.5";
    ModEventHandler handler = new ModEventHandler();
    @SidedProxy(clientSide="com.ringosham.proxy.ClientProxy", serverSide="com.ringosham.proxy.CommonProxy")
    public static CommonProxy proxy;
    public static Configuration config;
    public static SimpleNetworkWrapper NetWrapper;
    private static List<String> key;
    protected static boolean modDisable;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent e) {
        this.setLanguageList();
        LogHelper.log(Level.INFO, "Language list loaded");
        config = new Configuration(e.getSuggestedConfigurationFile());
        Main.syncConfig();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent e) {
        ClientCommandHandler.instance.func_71560_a((ICommand)new Command());
        ClientCommandHandler.instance.func_71560_a((ICommand)new TranslateCommand());
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent e) {
        FMLCommonHandler.instance().bus().register((Object)this.handler);
        MinecraftForge.EVENT_BUS.register((Object)this.handler);
        LogHelper.log(Level.INFO, "Event handler initialized");
        this.setKeyList();
        LogHelper.log(Level.INFO, "Translation keys loaded");
        if (Main.setTranslateKey()) {
            LogHelper.log(Level.INFO, "Translation key set");
        } else {
            LogHelper.log(Level.FATAL, "Network error / Translation keys reached max limit");
            ChatTranslator.disableTranslation = true;
            modDisable = true;
        }
    }

    public static boolean setTranslateKey() {
        for (int i = 0; i < key.size(); ++i) {
            try {
                Translate.setKey(key.get(i));
                Detect.execute("The quick brown fox jumps over the lazy dog.");
                break;
            }
            catch (Exception exception) {
                if (i != key.size() - 1) continue;
                return false;
            }
        }
        return true;
    }

    private void setKeyList() {
        key.add("trnsl.1.1.20151108T180520Z.4c123ffffa1b56d8.c2ef97b86c9ab87ac6349609d33dad24190150bc");
        key.add("trnsl.1.1.20160207T170921Z.efa082b380abd170.ce905571399f67b4c54f448ac36c6f0c663b6766");
        key.add("trnsl.1.1.20160207T184427Z.6ec4cc2d83b31d36.8178b49164b93fc1ca6b5f2c612e0500eeecc5f9");
    }

    public static void syncConfig() {
        config.load();
        String[] logLevels = new String[]{"off", "normal", "debug"};
        ChatTranslator.translateChat = ChatTranslator.reverseLanguageName.get(config.get("general", "Translation language(Chat)", "english", "The language you want your chat to be translated to.", ChatTranslator.configLanguage).getString());
        ChatTranslator.translateFrom = ChatTranslator.reverseLanguageName.get(config.get("general", "Message language", "english", "What language your messages are?", ChatTranslator.configLanguage).getString());
        ChatTranslator.translateTo = ChatTranslator.reverseLanguageName.get(config.get("general", "Translation language(Player)", "spanish", "What language you want your message to be translated.", ChatTranslator.configLanguage).getString());
        ChatTranslator.chatSeparator = config.getString("Chat separator", "general", "> ,: ,\u00bb", "This allows the mod to detect your Minecraft chat to translate. For example, \"<Notch> Hello world!\" The '> ' character will be the chat separator. Basically, the last character before the chat message is the chat separator. Add a comma between the separators to add a new one");
        ChatTranslator.loggingLevel = config.get("general", "Error logging level", "normal", "Error logging levels. Change to debug if you want to send an bug report", logLevels).getString();
        if (!(ChatTranslator.loggingLevel.equals("off") || ChatTranslator.loggingLevel.equals("normal") || ChatTranslator.loggingLevel.equals("debug"))) {
            ChatTranslator.loggingLevel = "normal";
            config.get("general", "Error logging level", "normal", "Error logging levels. Change to debug if you want to send an bug report", logLevels).set("normal");
        }
        if (ChatTranslator.translateChat == null) {
            ChatTranslator.translateChat = Language.ENGLISH;
            config.get("general", "Translation language(Chat)", "english", "The language you want your chat to be translated to.", ChatTranslator.configLanguage).set("english");
        }
        if (ChatTranslator.translateFrom == null) {
            ChatTranslator.translateFrom = Language.ENGLISH;
            config.get("general", "Message language", "english", "What language your messages are?", ChatTranslator.configLanguage).set("english");
        }
        if (ChatTranslator.translateTo == null) {
            ChatTranslator.translateTo = Language.SPANISH;
            config.get("general", "Translation language(Player)", "spanish", "What language you want your message to be translated.", ChatTranslator.configLanguage).set("spanish");
        }
        config.save();
    }

    private final void setLanguageList() {
        ArrayList<String> configList = new ArrayList<String>();
        for (Language type : Language.values()) {
            ChatTranslator.languageName.put(type, type.name());
            ChatTranslator.commandLanguageList.add(type.name().toLowerCase());
            ChatTranslator.commandLanguageList.add(type.toString());
            ChatTranslator.reverseLanguageName.put(type.name().toLowerCase(), type);
            configList.add(type.name().toLowerCase());
        }
        ChatTranslator.configLanguage = configList.toArray(new String[configList.size()]);
        Collections.unmodifiableMap(ChatTranslator.languageName);
        Collections.unmodifiableList(ChatTranslator.commandLanguageList);
        Collections.unmodifiableMap(ChatTranslator.reverseLanguageName);
    }

    static {
        key = new ArrayList<String>();
        modDisable = false;
    }
}

