/*
 * Decompiled with CFR 0.152.
 */
package com.rmtheis.yandtran.detect;

import com.rmtheis.yandtran.YandexTranslatorAPI;
import com.rmtheis.yandtran.language.Language;
import com.rmtheis.yandtran.translate.Translate;
import java.net.URL;
import java.net.URLEncoder;

public final class Detect
extends YandexTranslatorAPI {
    private static final String SERVICE_URL = "https://translate.yandex.net/api/v1.5/tr.json/detect?";
    private static final String DETECTION_LABEL = "lang";

    private Detect() {
    }

    public static Language execute(String text) throws Exception {
        Detect.validateServiceState(text);
        String params = "key=" + URLEncoder.encode(apiKey, "UTF-8") + "&text=" + URLEncoder.encode(text, "UTF-8");
        URL url = new URL(SERVICE_URL + params);
        return Language.fromString(Detect.retrievePropString(url, DETECTION_LABEL));
    }

    private static void validateServiceState(String text) throws Exception {
        int byteLength = text.getBytes("UTF-8").length;
        if (byteLength > 10240) {
            throw new RuntimeException("TEXT_TOO_LARGE - Yandex Translator (Detect) can handle up to 10,240 bytes per request");
        }
        Detect.validateServiceState();
    }

    public static void main(String[] args) {
        try {
            Translate.setKey("trnsl.1.1.20151108T180520Z.4c123ffffa1b56d8.c2ef97b86c9ab87ac6349609d33dad24190150bc");
            Language translation = Detect.execute("The quick brown fox jumps over the lazy dog.");
            System.out.println("Detected: " + translation.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

