/*
 * Decompiled with CFR 0.152.
 */
package com.ringosham.translate;

import com.ringosham.translate.LogHelper;
import com.ringosham.translate.Main;
import com.ringosham.translate.ModEventHandler;
import com.rmtheis.yandtran.detect.Detect;
import com.rmtheis.yandtran.language.Language;
import com.rmtheis.yandtran.translate.Translate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.event.ClickEvent;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import org.apache.commons.lang3.text.WordUtils;
import org.apache.logging.log4j.Level;

public class ChatTranslator {
    public static Map<Language, String> languageName = new HashMap<Language, String>();
    public static List<String> commandLanguageList = new ArrayList<String>();
    public static Map<String, Language> reverseLanguageName = new HashMap<String, Language>();
    public List<String> configList = new ArrayList<String>();
    public static String[] configLanguage;
    public static Language translateChat;
    public static boolean translateMe;
    public static Language translateFrom;
    public static Language translateTo;
    public static String chatSeparator;

    public void setLanguageList() {
        for (Language type : Language.values()) {
            languageName.put(type, type.name());
            commandLanguageList.add(type.name().toLowerCase());
            reverseLanguageName.put(type.name().toLowerCase(), type);
            this.configList.add(type.name().toLowerCase());
        }
        configLanguage = this.configList.toArray(new String[this.configList.size()]);
        Collections.unmodifiableMap(languageName);
        Collections.unmodifiableList(commandLanguageList);
        Collections.unmodifiableMap(reverseLanguageName);
        Collections.unmodifiableList(this.configList);
    }

    private Language detectLang(String message) {
        Language lang = null;
        try {
            lang = Detect.execute(message);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return lang;
    }

    private String translate(String message, Language from, Language to) {
        String chatString = "";
        try {
            chatString = Translate.execute(message, from, to);
        }
        catch (Exception e) {
            e.printStackTrace();
            LogHelper.log(Level.ERROR, "Exception caught during connecting to translation server");
        }
        return chatString;
    }

    public static void translateChat(String chat) {
        ChatTranslator translator = new ChatTranslator();
        Language lang = translator.detectLang(chat);
        if (lang != translateChat && lang != null) {
            String translatedMessage = translator.translate(chat, lang, translateChat);
            String langName = WordUtils.capitalize((String)languageName.get((Object)lang).toLowerCase());
            if (!translatedMessage.equals(ModEventHandler.message)) {
                Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)new ChatComponentText("\u00a77Translated(" + langName + "): " + translatedMessage + "\u00a7r"));
            }
        }
    }

    public static void translateMe() {
        if (translateMe) {
            // empty if block
        }
    }

    public void showCredits() {
        ChatComponentText serviceUrl = new ChatComponentText("http://translate.yandex.com");
        ChatComponentText wrapperUrl = new ChatComponentText("https://github.com/rmtheis/yandex-translator-java-api");
        ChatComponentText forumUrl = new ChatComponentText("http://minecraft.curseforge.com/projects/real-time-chat-translation-mod");
        serviceUrl.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, "http://translate.yandex.com"));
        wrapperUrl.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://github.com/rmtheis/yandex-translator-java-api"));
        forumUrl.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, ""));
        this.sendChatMessage("\u00a7bReal-time chat translation mod by Ringosham. Version " + Main.VERSION);
        this.sendChatMessage((IChatComponent)forumUrl);
        this.sendChatMessage("\u00a7bOnline translation services are provided by Yandex.Translate");
        this.sendChatMessage((IChatComponent)serviceUrl);
        this.sendChatMessage("\u00a7bYandex translator Java wrapper is provided by Robert Theis");
        this.sendChatMessage((IChatComponent)wrapperUrl);
        this.sendChatMessage("\u00a7bThanks for downloading my mod! Translation results may not \u00a7bbe \u00a7b100% accurate");
    }

    private void sendChatMessage(IChatComponent message) {
        Minecraft.func_71410_x().field_71439_g.func_145747_a(message);
    }

    public void sendChatMessage(String message) {
        Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)new ChatComponentText(message));
    }

    static {
        translateChat = Language.ENGLISH;
        translateMe = false;
        translateFrom = Language.ENGLISH;
        translateTo = Language.ENGLISH;
    }

    public static class chatHandler
    extends Thread {
        @Override
        public void run() {
            if (ModEventHandler.message.length() == 0) {
                return;
            }
            String[] splitChat = null;
            String[] separators = chatSeparator.split(",");
            for (int i = 0; i < separators.length && (splitChat = ModEventHandler.message.split(separators[i])).length < 2; ++i) {
                splitChat = null;
            }
            if (splitChat == null) {
                return;
            }
            if (splitChat[0].contains(Minecraft.func_71410_x().field_71439_g.func_70005_c_()) && translateMe) {
                return;
            }
            if (splitChat[0].contains("http")) {
                return;
            }
            String chat = "";
            for (int i = 1; i < splitChat.length; ++i) {
                chat = chat.concat(splitChat[i]);
            }
            ChatTranslator.translateChat(chat);
        }
    }
}

