/*
 * Decompiled with CFR 0.152.
 */
package com.ringosham.translate;

import com.ringosham.proxy.CommonProxy;
import com.ringosham.translate.ChatTranslator;
import com.ringosham.translate.Command;
import com.ringosham.translate.LogHelper;
import com.ringosham.translate.ModEventHandler;
import com.rmtheis.yandtran.translate.Translate;
import net.minecraft.command.ICommand;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import org.apache.logging.log4j.Level;

@Mod(modid="translate", name="Translate mod", version="1.6.1", guiFactory="com.ringosham.translate.GuiFactory", acceptedMinecraftVersions="[1.8.9]")
public class Main {
    public static String MODID = "translate";
    public static String VERSION = "1.6.1";
    ModEventHandler handler = new ModEventHandler();
    @SidedProxy(clientSide="com.ringosham.proxy.ClientProxy", serverSide="com.ringosham.proxy.CommonProxy")
    public static CommonProxy proxy;
    public static Configuration config;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent e) {
        ChatTranslator translator = new ChatTranslator();
        translator.setLanguageList();
        LogHelper.log(Level.INFO, "Language list loaded");
        config = new Configuration(e.getSuggestedConfigurationFile());
        Main.syncConfig();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent e) {
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent e) {
        FMLCommonHandler.instance().bus().register((Object)this.handler);
        MinecraftForge.EVENT_BUS.register((Object)this.handler);
        LogHelper.log(Level.INFO, "Event handler initialized");
        Translate.setKey("trnsl.1.1.20151108T180520Z.4c123ffffa1b56d8.c2ef97b86c9ab87ac6349609d33dad24190150bc");
        LogHelper.log(Level.INFO, "Translation key set");
    }

    @Mod.EventHandler
    public void serverStart(FMLServerStartingEvent e) {
        e.registerServerCommand((ICommand)new Command());
    }

    public static void syncConfig() {
        config.load();
        ChatTranslator.translateChat = ChatTranslator.reverseLanguageName.get(config.getString("Chat language", "general", "english", "The language you want your chat to be translated to.", ChatTranslator.configLanguage));
        ChatTranslator.chatSeparator = config.getString("Chat separator", "general", "> ,: ,\u00bb", "This allows the mod to detect your Minecraft chat to translate. For example, \"<Notch> Hello world!\" The '> ' character will be the chat separator. Basically, the last character before the chat message is the chat separator. Add a comma between the separators to add a new one");
    }
}

