/*
 * Decompiled with CFR 0.152.
 */
package com.rmtheis.yandtran;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public abstract class YandexTranslatorAPI {
    protected static final String ENCODING = "UTF-8";
    protected static String apiKey;
    private static String referrer;
    protected static final String PARAM_API_KEY = "key=";
    protected static final String PARAM_LANG_PAIR = "&lang=";
    protected static final String PARAM_TEXT = "&text=";

    public static void setKey(String pKey) {
        apiKey = pKey;
    }

    public static void setReferrer(String pReferrer) {
        referrer = pReferrer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String retrieveResponse(URL url) throws Exception {
        HttpsURLConnection uc = (HttpsURLConnection)url.openConnection();
        if (referrer != null) {
            uc.setRequestProperty("referer", referrer);
        }
        uc.setRequestProperty("Content-Type", "text/plain; charset=UTF-8");
        uc.setRequestProperty("Accept-Charset", ENCODING);
        uc.setRequestMethod("GET");
        try {
            int responseCode = uc.getResponseCode();
            String result = YandexTranslatorAPI.inputStreamToString(uc.getInputStream());
            if (responseCode != 200) {
                throw new Exception("Error from Yandex API: " + result);
            }
            String string = result;
            return string;
        }
        finally {
            if (uc != null) {
                uc.disconnect();
            }
        }
    }

    protected static String retrievePropString(URL url, String jsonValProperty) throws Exception {
        String response = YandexTranslatorAPI.retrieveResponse(url);
        JSONObject jsonObj = (JSONObject)JSONValue.parse(response);
        return jsonObj.get(jsonValProperty).toString();
    }

    protected static String retrievePropArrString(URL url, String jsonValProperty) throws Exception {
        String response = YandexTranslatorAPI.retrieveResponse(url);
        String[] translationArr = YandexTranslatorAPI.jsonObjValToStringArr(response, jsonValProperty);
        String combinedTranslations = "";
        for (String s : translationArr) {
            combinedTranslations = combinedTranslations + s;
        }
        return combinedTranslations.trim();
    }

    private static String[] jsonObjValToStringArr(String inputString, String subObjPropertyName) throws Exception {
        JSONObject jsonObj = (JSONObject)JSONValue.parse(inputString);
        JSONArray jsonArr = (JSONArray)jsonObj.get(subObjPropertyName);
        return YandexTranslatorAPI.jsonArrToStringArr(jsonArr.toJSONString(), null);
    }

    private static String[] jsonArrToStringArr(String inputString, String propertyName) throws Exception {
        JSONArray jsonArr = (JSONArray)JSONValue.parse(inputString);
        String[] values = new String[jsonArr.size()];
        int i = 0;
        for (Object obj : jsonArr) {
            if (propertyName != null && propertyName.length() != 0) {
                JSONObject json = (JSONObject)obj;
                if (json.containsKey(propertyName)) {
                    values[i] = json.get(propertyName).toString();
                }
            } else {
                values[i] = obj.toString();
            }
            ++i;
        }
        return values;
    }

    private static String inputStreamToString(InputStream inputStream) throws Exception {
        StringBuilder outputBuilder = new StringBuilder();
        try {
            if (inputStream != null) {
                String string;
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, ENCODING));
                while (null != (string = reader.readLine())) {
                    outputBuilder.append(string.replaceAll("\ufeff", ""));
                }
            }
        }
        catch (Exception ex) {
            throw new Exception("[yandex-translator-api] Error reading translation stream.", ex);
        }
        return outputBuilder.toString();
    }

    protected static void validateServiceState() throws Exception {
        if (apiKey == null || apiKey.length() < 27) {
            throw new RuntimeException("INVALID_API_KEY - Please set the API Key with your Yandex API Key");
        }
    }
}

