local assets =
{
    Asset("ANIM", "anim/nitre.zip"),
}

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("nitre")
    inst.AnimState:SetBuild("nitre")
    inst.AnimState:PlayAnimation("idle")

    inst:AddTag("molebait")
    inst:AddTag("quakedebris")

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end

    inst:AddComponent("edible")
    inst.components.edible.foodtype = FOODTYPE.ELEMENTAL
    inst.components.edible.hungervalue = 2
    inst:AddComponent("tradable")

    inst:AddComponent("stackable")
    inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM

    inst:AddComponent("fuel")
    inst.components.fuel.fuelvalue = TUNING.MED_LARGE_FUEL
    inst.components.fuel.fueltype = FUELTYPE.CHEMICAL

    inst:AddComponent("inspectable")

    inst:AddComponent("bait")

    inst:AddComponent("inventoryitem")

    MakeHauntableLaunchAndSmash(inst)
	-----------------------
	local function OnDeploy (inst, pt) 
    local rock1 = SpawnPrefab("rock1")
    if rock1 then
        rock1:PushEvent("growfromnitre")
		rock1.Transform:SetPosition(pt.x, pt.y, pt.z)
        inst.components.stackable:Get():Remove()
    end
end
    inst:AddComponent("deployable")
    inst.components.deployable.ondeploy = OnDeploy
------------------------------------------------------

    return inst
end

return Prefab("nitre", fn, assets)
