
local MakePlayerCharacter = require "prefabs/player_common"
local assets = {
        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wendy.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),
Asset( "ANIM", "anim/str3.zip" ),
Asset( "ANIM", "anim/str2.zip" ),
        Asset( "ANIM", "anim/str.zip" ), --character anim
}
local prefabs = { "sparks" } --no special items in mod

local start_inv = 
{
		"obsidian"
}

local function onkill(inst, data)
	if data.cause == inst.prefab 
		and not data.inst:HasTag("prey") 
		and not data.inst:HasTag("veggie") 
		and not data.inst:HasTag("structure") then
             
        			TUNING.R_D = TUNING.R_D + 5
    		
	end
end


local function applyupgrades(inst) --level up handling
	local max_upgrades = 15
	local upgrades = math.min(inst.level, max_upgrades)
	local hunger_percent = inst.components.hunger:GetPercent()
	local health_percent = inst.components.health:GetPercent()
	local sanity_percent = inst.components.sanity:GetPercent()
	inst.components.hunger.max = math.ceil (200 + upgrades * 5)
	inst.components.health.maxhealth = math.ceil (150 + upgrades * 6)
	inst.components.sanity.max = math.ceil (120 + upgrades * 6)
	
	inst.components.talker:Say("ڻȼ : ".. (inst.level))	
	if inst.level >14 then
		inst.components.talker:Say("ȫڻ")
inst.components.poisonable.duration = 10
inst.components.moisture.baseDryingRate = 0.5
inst.components.sanity.neg_aura_mult = 0
inst.components.combat:AddDamageModifier("wigfrid", TUNING.WATHGRITHR_DAMAGE_MULT)
      
     inst.components.health.absorb = 0.6


			inst.components.temperature.overheattemp = 1000
			inst.components.health.fire_damage_scale=0
inst.AnimState:SetBuild("str3")

	end
	inst.components.hunger:SetPercent(hunger_percent)
	inst.components.health:SetPercent(health_percent)
	inst.components.sanity:SetPercent(sanity_percent)	
end
local function oneat(inst, food)
	if food and food.components.edible and food.prefab == "obsidian" then
	
		--give an upgrade! 
		inst.level = inst.level + 1
		applyupgrades(inst)
                inst.SoundEmitter:PlaySound("dontstarve/characters/wx78/levelup")	
		inst.HUD.controls.status.heart:PulseGreen()
		inst.HUD.controls.status.stomach:PulseGreen()
		inst.HUD.controls.status.brain:PulseGreen()		
		inst.HUD.controls.status.brain:ScaleTo(1.3,1,.7)
		inst.HUD.controls.status.heart:ScaleTo(1.3,1,.7)
		inst.HUD.controls.status.stomach:ScaleTo(1.3,1,.7)
	end

if food and food.components.edible and food.components.edible.sanityvalue > 0 then
	local f_mana = food.components.edible.hungervalue
	TUNING.R_D = TUNING.R_D + f_mana*0.5
	end

 if food.prefab == "ice" and inst.level <15 then
       local function OnAttacked(inst, data)
    
    if data.attacker.components.freezable then
       data.attacker.components.freezable:Freeze(0.1)
    end
end
    inst:ListenForEvent("attacked", OnAttacked)
  inst.components.sanity.neg_aura_mult = 0.5
inst.components.talker:Say("")
     inst.components.moisture.baseDryingRate = 0.25
     inst.components.health.absorb = 0.4
inst.components.temperature.mintemp = 0
inst.components.poisonable.duration = 30
			
			inst.components.health.fire_damage_scale=1.5
    inst.AnimState:SetBuild("str2")

  end
end




local function onpreload(inst, data) 
	if data then
		if data.level then
			inst.level = data.level
TUNING.R_D = data.R_D
			applyupgrades(inst)

			if data.health and data.health.health then inst.components.health.currenthealth = data.health.health end
			if data.hunger and data.hunger.hunger then inst.components.hunger.current = data.hunger.hunger end
			if data.sanity and data.sanity.current then inst.components.sanity.current = data.sanity.current end
			inst.components.health:DoDelta(0)
			inst.components.hunger:DoDelta(0)
			inst.components.sanity:DoDelta(0)
		end
	end
end
local function onsave(inst, data)
	data.level = inst.level
data.R_D = TUNING.R_D

	data.charge_time = inst.charge_time
end

local function dorainsparks(inst, dt)

    if (inst.components.moisture and inst.components.moisture:GetMoisture() > 0) then
    	inst.spark_time = inst.spark_time - dt

    	if inst.spark_time <= 0 then
    		
    		--GetClock():DoLightningLighting()
    		inst.spark_time = 3+math.random()*2

    		local pos = Vector3(inst.Transform:GetWorldPosition())
    		local damage = nil

    		-- Raining, no moisture-giving equipment on head, and moisture is increasing. Pro-rate damage based on waterproofness.
    		if GetSeasonManager():IsRaining() and inst.components.inventory:GetEquippedMoistureRate(EQUIPSLOTS.HEAD) <= 0 and inst.components.moisture:GetDelta() > 0 then
	    		local waterproofmult = (inst.components.moisture and inst.components.moisture.sheltered and inst.components.inventory) and (1 - (inst.components.inventory:GetWaterproofness() + inst.components.moisture.shelter_waterproofness)) or (inst.components.inventory and (1 - inst.components.inventory:GetWaterproofness()) or 1)
	    		damage = waterproofmult > 0 and math.min(TUNING.WX78_MIN_MOISTURE_DAMAGE, TUNING.WX78_MAX_MOISTURE_DAMAGE * waterproofmult) or 0
	    		inst.components.health:DoDelta(damage, false, "rain")
				pos.y = pos.y + 1 + math.random()*1.5
	    	else -- We have moisture-giving equipment on our head or it is not raining and we are just passively wet (but drying off). Do full damage.
	    		if inst.components.moisture:GetDelta() >= 0 then -- Moisture increasing (wearing something moisturizing)
	    			inst.components.health:DoDelta(TUNING.WX78_MAX_MOISTURE_DAMAGE, false, "water")
	    		else -- Drying damage
	    			inst.components.health:DoDelta(TUNING.WX78_MOISTURE_DRYING_DAMAGE, false, "water")
	    		end
				pos.y = pos.y + .25 + math.random()*2
	    	end
			
			if not damage or (damage and damage < 0) then
				local spark = SpawnPrefab("sparks")
				spark.Transform:SetPosition(pos:Get())
			end
    	end
    end

end



local fn = function(inst)
TUNING.R_D = 300

        inst.spark_time = 3
inst:DoPeriodicTask(1/10, function() dorainsparks(inst, 1/10) end)
	inst.soundsname = "willow"
	inst.MiniMapEntity:SetIcon( "str.tex" )
	inst.level = 0
inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * 1.25)

   table.insert(inst.components.eater.foodprefs, "obsidian")
	
	table.insert(inst.components.eater.ablefoods, "obsidian")
       table.insert(inst.components.eater.foodprefs, "ice")
	
	table.insert(inst.components.eater.ablefoods, "ice")
	inst.components.eater:SetOnEatFn(oneat)
	applyupgrades(inst)
	inst.components.health:SetMaxHealth(150)
	inst.components.hunger:SetMax(200)
	inst.components.sanity:SetMax(120)

 inst:ListenForEvent("entity_death", function(wrld, data) onkill(inst, data) end, GetWorld())

TheInput:AddKeyUpHandler(KEY_R, function()--ħ
        if TheInput:IsKeyDown(KEY_SHIFT) then	
        inst.components.talker:Say("ħ     " .. (TUNING.R_D))
        end
    end)

inst.components.health.absorb = 0.2
        inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE)
	inst.OnSave = onsave
	inst.OnPreLoad = onpreload


TheInput:AddKeyUpHandler(KEY_V, function()
   if TUNING.R_D > 19 then
 inst.components.talker:Say("")
       inst.components.hunger:DoDelta(-10)
       inst.components.sanity:DoDelta(10)
       inst.components.playercontroller:Enable(false)

       inst.AnimState:SetBloomEffectHandle("shaders/anim.ksh")
       
       
      
       inst:DoTaskInTime(0.3, function()
            
            inst.sg:GoToState("hit")
            
            
            SpawnPrefab("collapse_big").Transform:SetPosition(inst.Transform:GetWorldPosition())
            GetPlayer().SoundEmitter:PlaySound("dontstarve/creatures/eyeballturret/shotexplo")
           
            inst.components.playercontroller:ShakeCamera(inst, "FULL", 2.5, 0.03, 2, 30)
       end )
       inst:DoTaskInTime(0.4, function()
            local pos = Vector3(inst.Transform:GetWorldPosition())
            local ents = TheSim:FindEntities(pos.x,pos.y,pos.z, 5)
            for k,v in pairs(ents) do
               
                if v:HasTag("monster") or v.prefab == "beefalo" or v.prefab == "babybeefalo" or v.prefab == "bunnyman" or v.prefab == "pigman" or v.prefab == "pigguard"
                   or v.prefab == "merm" or v.prefab == "monkey" or v.prefab == "tallbird" or v.prefab == "walrus" or v.prefab == "little_walrus" or v.prefab == "wasphive"
                   or v.prefab == "beehive" or v.prefab == "koalefant_summer" or v.prefab == "koalefant_winter" or v.prefab == "lureplant" or v.prefab == "penguin"
                   or v.prefab == "perd" or v.prefab == "rocky" or v.prefab == "slurper" or v.prefab == "snurtle" or v.prefab == "slurtle" or v.prefab == "slurtlehole" or v.prefab == "crab" or v.prefab == "wildbore" or v.prefab == "treeguard" or v.prefab == "mosquito_poison" or v.prefab == "ox" or v.prefab == "mermfisher" or v.prefab == "merm" or v.prefab == "solofish" or v.prefab == "sharx"
or v.prefab == "stungray" or v.prefab == "whale_blue" or v.prefab == "swordfish" or v.prefab == "knightboat" or v.prefab == "flup"  or v.prefab == "primeape" 	or v.prefab == "whale_white" or v.prefab == "tigershark" or v.prefab == "butterfly" or v.prefab == "bee" or v.prefab == "killerbee"
                   or v.prefab == "spiderden" or v.prefab == "spiderden_2" or v.prefab == "spiderden_3" then
                   v.components.health:DoDelta(-100)

                end
            end
            TUNING.R_D = TUNING.R_D - 20
            inst.components.playercontroller:Enable(true)
  end )
    end
end )

TheInput:AddKeyUpHandler(KEY_B, function()
   if TUNING.R_D > 59 then
 inst.components.talker:Say("Ʋɵ")
       inst.components.hunger:DoDelta(-30)
       inst.components.sanity:DoDelta(0)
inst.components.locomotor:Stop()
       inst.components.playercontroller:Enable(false)
inst.Physics:SetCollides(false)
   inst:DoTaskInTime(0.1, function()
        inst.AnimState:PlayAnimation("jump")
        inst.components.playercontroller:Enable(false)
        inst.components.locomotor:Stop()
        inst.Physics:SetMotorVelOverride(90,0,0) end )
   inst:DoTaskInTime(0.2, function()
        
        inst.Physics:ClearMotorVelOverride()
        inst.components.locomotor:Stop()
        local pt = inst:GetPosition()
        inst.Transform:SetPosition(pt.x, 0, pt.z)
       
        inst.AnimState:PlayAnimation("idle")
        inst.SoundEmitter:PlaySound("dontstarve/movement/bodyfall_dirt", "bodyfall") end )
       inst.AnimState:SetBloomEffectHandle("shaders/anim.ksh")
       
       
      
       inst:DoTaskInTime(0.3, function()
            
            inst.sg:GoToState("hit")
            
            
            SpawnPrefab("collapse_big").Transform:SetPosition(inst.Transform:GetWorldPosition())
            GetPlayer().SoundEmitter:PlaySound("dontstarve/creatures/eyeballturret/shotexplo")
           
            inst.components.playercontroller:ShakeCamera(inst, "FULL", 2.5, 0.03, 2, 30)
       end )
       inst:DoTaskInTime(0.4, function()
            local pos = Vector3(inst.Transform:GetWorldPosition())
            local ents = TheSim:FindEntities(pos.x,pos.y,pos.z, 15)
            for k,v in pairs(ents) do
                if v.components.workable and v.components.workable.workleft > 0 and not v.components.inventoryitem then
                   v.components.workable:Destroy(inst)
                end
                if v:HasTag("monster") or v.prefab == "beefalo" or v.prefab == "babybeefalo" or v.prefab == "bunnyman" or v.prefab == "pigman" or v.prefab == "pigguard"
                   or v.prefab == "merm" or v.prefab == "monkey" or v.prefab == "tallbird" or v.prefab == "walrus" or v.prefab == "little_walrus" or v.prefab == "wasphive"
                   or v.prefab == "beehive" or v.prefab == "koalefant_summer" or v.prefab == "koalefant_winter" or v.prefab == "lureplant" or v.prefab == "penguin"
                   or v.prefab == "perd" or v.prefab == "rocky" or v.prefab == "slurper" or v.prefab == "snurtle" or v.prefab == "slurtle" or v.prefab == "slurtlehole" or v.prefab == "crab" or v.prefab == "wildbore" or v.prefab == "treeguard" or v.prefab == "mosquito_poison" or v.prefab == "ox" or v.prefab == "mermfisher" or v.prefab == "merm" or v.prefab == "solofish" or v.prefab == "sharx"
or v.prefab == "stungray" or v.prefab == "whale_blue" or v.prefab == "swordfish" or v.prefab == "knightboat" or v.prefab == "flup"  or v.prefab == "primeape" 	or v.prefab == "whale_white" or v.prefab == "tigershark" or v.prefab == "butterfly" or v.prefab == "bee" or v.prefab == "killerbee"
                   or v.prefab == "spiderden" or v.prefab == "spiderden_2" or v.prefab == "spiderden_3" then
                   v.components.health:DoDelta(-320)
 if v.components.burnable and not v:HasTag("player") and inst.level >14 then
           v.components.burnable:Ignite()
          
        end
                end
            end
            TUNING.R_D = TUNING.R_D - 60
             inst.Physics:SetCollides(true)
            inst.components.playercontroller:Enable(true)
  end )
    end
end )



	
end

return MakePlayerCharacter("str", prefabs, assets, fn, start_inv)