
	local assets=
	{
		Asset("ANIM", "anim/mw_preservative.zip"),
		Asset("ATLAS", "images/inventoryimages/mw_preservative.xml"),
		Asset("IMAGE", "images/inventoryimages/mw_preservative.tex"),
		
	}
PrefabFiles = {
	"mw_preservative",
	}

GLOBAL.TUNING.MW_PRESERVABLES = {
		PRESERVATIVE =	{ 
								CRAFTING_AMOUNT = GetModConfigData("craftingamount"),
								MAX_STACKSIZE = 200,
								REPAIR_VALUE = GetModConfigData("repairvalue"),
						},
		CRAFTING =		{
								WOOL_AMOUNT_SUMMER = 6,
						},
}

local preservativeAtlas = "images/inventoryimages/mw_preservative.xml"
local RECIPETABS = GLOBAL.RECIPETABS
local TECH = GLOBAL.TECH
local require = GLOBAL.require
require "recipe"
require "tuning"
require "mw_preservables_locale"

local function OnRepaired(inst)
	if inst.components.perishable then
		inst:PushEvent("perishchange", {percent = inst.components.perishable:GetPercent()})
	end
end
local function AddPreservativesToFood(inst)
	if inst.components.edible and inst.components.perishable and not inst.components.repairable then
		inst:AddComponent("repairable")
		inst.components.repairable.repairmaterial = "mw_preservative"
		inst.components.repairable.announcecanfix = true
		inst.components.repairable.onrepaired = OnRepaired

		if GetModConfigData("stackawarerepairvalue") then
			local repair = inst.components.repairable.Repair
			inst.components.repairable.Repair = function(self, doer, repair_item)
													local repairValue = repair_item.components.repairer.perishrepairvalue
													if self.inst.components.stackable and self.inst.components.stackable:StackSize() > 1 then
														repair_item.components.repairer.perishrepairvalue = string.format("%.4f",repair_item.components.repairer.perishrepairvalue/self.inst.components.stackable:StackSize())+0
													end
													local result = repair(self, doer, repair_item)
													repair_item.components.repairer.perishrepairvalue = repairValue
													return result
												end
		end

	end

end

local function TryAddRecipe(condition, recipeFactory)
	if condition then
		recipeFactory()
	end
end

local function AddPreservativeRecipe()
		Recipe("mw_preservative", {Ingredient("nitre", 1)}, RECIPETABS.FARM,  TECH.SCIENCE_ONE,nil,nil,nil,TUNING.MW_PRESERVABLES.PRESERVATIVE.CRAFTING_AMOUNT).atlas =  preservativeAtlas
end
local function AddBeefaloWoolRecipe()
	 local preservativeIngredient = Ingredient("mw_preservative", 4)
	 preservativeIngredient.atlas =  preservativeAtlas

	Recipe("beefalowool", {preservativeIngredient,Ingredient("trunk_summer", 1)}, RECIPETABS.REFINE,  TECH.SCIENCE_ONE,nil,nil,nil,TUNING.MW_PRESERVABLES.CRAFTING.WOOL_AMOUNT_SUMMER)

	 
end
local function AddBeefaloWoolRecipeCapy()
	 local preservativeIngredient = Ingredient("mw_preservative", 4)
	 preservativeIngredient.atlas =  preservativeAtlas

	Recipe("beefalowool", {preservativeIngredient,Ingredient("trunk_summer", 1)}, RECIPETABS.REFINE,  TECH.SCIENCE_ONE,GLOBAL.RECIPE_GAME_TYPE.COMMON,nil,nil,nil,TUNING.MW_PRESERVABLES.CRAFTING.WOOL_AMOUNT_SUMMER)

	 
end
local function AddPreservativeRecipeCapy()
		Recipe("mw_preservative", {Ingredient("nitre", 1)}, RECIPETABS.FARM,  TECH.SCIENCE_ONE,GLOBAL.RECIPE_GAME_TYPE.COMMON,nil,nil,nil,TUNING.MW_PRESERVABLES.PRESERVATIVE.CRAFTING_AMOUNT).atlas =  preservativeAtlas
end
local function AddRecipes()
	if GLOBAL.IsDLCEnabled(GLOBAL.CAPY_DLC) then
			 AddPreservativeRecipeCapy()
			TryAddRecipe(GetModConfigData("craftwoolenabled"), AddBeefaloWoolRecipeCapy)
	else
	
	 AddPreservativeRecipe()
	 TryAddRecipe(GetModConfigData("craftwoolenabled"), AddBeefaloWoolRecipe)
	end
end

local function SetupPreservables()
	AddRecipes()
end

return SetupPreservables(), AddPrefabPostInitAny(AddPreservativesToFood)