local function Init(Sim)
	local assets=
	{
		Asset("ANIM", "anim/mw_preservative.zip"),
		Asset("ATLAS", "images/inventoryimages/mw_preservative.xml"),
		Asset("IMAGE", "images/inventoryimages/mw_preservative.tex"),
	}
	local function onfinished(inst)
		inst:Remove()
	end
	local function fn(Sim)
		local inst = CreateEntity()
		inst.entity:AddTransform()
		inst.entity:AddAnimState()
		MakeInventoryPhysics(inst)
    
    
		inst.AnimState:SetBank("mw_preservative")
		inst.AnimState:SetBuild("mw_preservative")
		inst.AnimState:PlayAnimation("idle")

		inst:AddComponent("edible")
		inst.components.edible.foodtype = "ELEMENTAL"
		inst.components.edible.hungervalue = 2
		inst:AddComponent("tradable")
    
		inst:AddComponent("stackable")
		inst.components.stackable.maxsize = TUNING.MW_PRESERVABLES.PRESERVATIVE.MAX_STACKSIZE
    
		inst:AddComponent("inspectable")
    
		inst:AddComponent("inventoryitem")
		inst.components.inventoryitem.imagename = "mw_preservative"
		inst.components.inventoryitem.atlasname = "images/inventoryimages/mw_preservative.xml"

		inst:AddComponent("repairer")


		inst.components.repairer.repairmaterial = "mw_preservative"


		inst.components.repairer.perishrepairvalue = TUNING.MW_PRESERVABLES.PRESERVATIVE.REPAIR_VALUE
		return inst
	end

	return Prefab( "common/inventory/mw_preservative", fn, assets) 

end

return Init(Sim)