class lyr_apge_init extends Object;

static function lyr_apge_init(optional bool lyr_updateTemplate = false, optional bool lyr_updateFacility = false, optional string lyr_caller = "")
{
	lyr_apge_logging("lyr_apge_logging: Called by: " $ lyr_caller);
	lyr_apge_logging("lyr_apge_logging: Caller arguments: lyr_updateTemplate = " $ lyr_updateTemplate $ ", lyr_updateFacility = " $ lyr_updateFacility);

	if(lyr_updateTemplate) lyr_apge_updateTemplate();
	if(lyr_updateFacility) lyr_apge_updateFacility();
}

static function lyr_apge_updateTemplate()
{
	local X2StrategyElementTemplateManager TemplateManager;
	local X2FacilityTemplate ProvingGroundTemplate;

	TemplateManager = class'X2StrategyElementTemplateManager'.static.GetStrategyElementTemplateManager();
	ProvingGroundTemplate = X2FacilityTemplate(TemplateManager.FindStrategyElementTemplate('ProvingGround'));

	lyr_apge_logging("lyr_apge_logging: lyr_apge_updateTemplate executed, checking template");
	lyr_apge_logging("lyr_apge_logging: ProvingGroundTemplate.StaffSlots.Length = " $ ProvingGroundTemplate.StaffSlots.Length);

	if(ProvingGroundTemplate.StaffSlots.Length == 1)
	{
		ProvingGroundTemplate.StaffSlots.AddItem('ProvingGroundStaffSlot');
		ProvingGroundTemplate.StaffSlotsLocked = 1;
		ProvingGroundTemplate.Upgrades.AddItem('lyr_apge');

		TemplateManager.AddStrategyElementTemplate(ProvingGroundTemplate, true);

		lyr_apge_logging("lyr_apge_logging: Template updated!");
	}
}

static function lyr_apge_updateFacility()
{
	local XComGameStateHistory History;
	local XComGameState GameState;
	local XComGameState_HeadquartersXCom XComHQState;
	local XComGameState_FacilityXCom ProvingGroundState;

	History = `XCOMHISTORY;	
	GameState = class'XComGameStateContext_ChangeContainer'.static.CreateChangeState("lyr - Checking for and updating existing Proving Ground facility");
	XComHQState = XComGameState_HeadquartersXCom(History.GetSingleGameStateObjectForClass(class'XComGameState_HeadquartersXCom'));
	XComHQState = XComGameState_HeadquartersXCom(GameState.CreateStateObject(class'XComGameState_HeadquartersXCom', XComHQState.ObjectID));

	lyr_apge_logging("lyr_apge_logging: lyr_apge_updateFacility executed, checking if facility exists");

	if (XComHQState.HasFacilityByName('ProvingGround'))
	{
		ProvingGroundState = XComHQState.GetFacilityByName('ProvingGround');

		lyr_apge_logging("lyr_apge_logging: Facility exists, checking if it needs an update");
		lyr_apge_logging("lyr_apge_logging: ProvingGroundState.StaffSlots.Length = " $ ProvingGroundState.StaffSlots.Length);

		if(ProvingGroundState.StaffSlots.Length == 1)
		{
			if (ProvingGroundState.HasStaff())
			{
				ProvingGroundState.EmptyAllStaffSlots(GameState);
			}

			ProvingGroundState.CreateStaffSlots(GameState);

			lyr_apge_logging("lyr_apge_logging: Facility updated!");
		}
	}

	GameState.AddStateObject(XComHQState);
	History.AddGameStateToHistory(GameState);
}

static function lyr_apge_logging(string logText)
{
	local bool loggingEnabled;
	loggingEnabled = true;

	if(loggingEnabled) `Log(logText);
}