class lyr_apge_template extends X2StrategyElement;

static function array<X2DataTemplate> CreateTemplates()
{
	local array<X2DataTemplate> Templates;

	Templates.AddItem(lyr_apge_CreateTemplate());

	return Templates;
}

static function X2DataTemplate lyr_apge_CreateTemplate()
{
	local X2FacilityUpgradeTemplate Template;
	local ArtifactCost Resources;

	`CREATE_X2TEMPLATE(class'X2FacilityUpgradeTemplate', Template, 'lyr_apge');
	Template.PointsToComplete = 0;
	Template.MaxBuild = 1;
	Template.strImage = "img:///UILibrary_StrategyImages.FacilityIcons.ChooseFacility_ProvingGrounds";
	Template.OnUpgradeAddedFn = lyr_apge_OnUpgradeAdded;

	Template.iPower = -1;
	Template.UpkeepCost = 10;

	Resources.ItemTemplateName = 'Supplies';
	Resources.Quantity = 75;
	Template.Cost.ResourceCosts.AddItem(Resources);

	return Template;
}

static function lyr_apge_OnUpgradeAdded(XComGameState NewGameState, XComGameState_FacilityUpgrade Upgrade, XComGameState_FacilityXCom Facility)
{
	Facility.PowerOutput += Upgrade.GetMyTemplate().iPower;
	Facility.UpkeepCost += Upgrade.GetMyTemplate().UpkeepCost;
	Facility.UnlockStaffSlot(NewGameState);
}