/*
 * Decompiled with CFR 0.152.
 */
package mods.helpfulvillagers.ai;

import java.util.ArrayList;
import java.util.Random;
import mods.helpfulvillagers.entity.EntityFarmer;
import mods.helpfulvillagers.enums.EnumActivity;
import mods.helpfulvillagers.util.AIHelper;
import mods.helpfulvillagers.util.ResourceCluster;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.Vec3;

public class EntityAIFarmer
extends EntityAIBase {
    private EntityFarmer farmer;
    private ChunkCoordinates target;
    private float speed;
    Random gen;

    public EntityAIFarmer(EntityFarmer farmer) {
        this.farmer = farmer;
        this.gen = new Random();
        this.target = null;
        this.speed = 0.5f;
        this.func_75248_a(1);
    }

    public boolean func_75250_a() {
        switch (this.farmer.currentActivity) {
            case GATHER: {
                return true;
            }
            case RETURN: {
                return false;
            }
            case CRAFT: {
                return true;
            }
            case STORE: {
                return true;
            }
            case IDLE: {
                return this.idle();
            }
        }
        return false;
    }

    public boolean func_75253_b() {
        switch (this.farmer.currentActivity) {
            case GATHER: {
                return this.gather();
            }
            case RETURN: {
                return false;
            }
            case CRAFT: {
                return this.craft();
            }
            case STORE: {
                return this.store();
            }
            case IDLE: {
                return this.idle();
            }
        }
        return false;
    }

    private boolean idle() {
        this.farmer.currentActivity = EnumActivity.IDLE;
        boolean dummyFlag = false;
        if (!this.farmer.field_70170_p.field_72995_K && this.farmer.homeVillage == null) {
            System.out.println("No Home Village");
            return false;
        }
        this.farmer.checkGuildHall();
        if (this.farmer.homeGuildHall == null) {
            System.out.println("No Guild Hall");
            return false;
        }
        if (this.farmer.inventory.isFull() || !this.farmer.hasTool) {
            if (this.farmer.insideHall()) {
                if (dummyFlag) {
                    this.farmer.currentActivity = EnumActivity.CRAFT;
                    return true;
                }
                if (!this.farmer.inventory.isEmpty() || !this.farmer.hasTool) {
                    this.farmer.currentActivity = EnumActivity.STORE;
                    return true;
                }
                return false;
            }
            System.out.println("Returning to Hall");
            this.farmer.currentActivity = EnumActivity.RETURN;
            return false;
        }
        if (this.farmer.field_70170_p.func_72935_r()) {
            this.farmer.currentActivity = EnumActivity.GATHER;
            return true;
        }
        if (!this.farmer.insideHall()) {
            this.farmer.currentActivity = EnumActivity.RETURN;
            return false;
        }
        if (dummyFlag) {
            this.farmer.currentActivity = EnumActivity.CRAFT;
            return true;
        }
        if (!this.farmer.inventory.isEmpty() || !this.farmer.hasTool) {
            this.farmer.currentActivity = EnumActivity.STORE;
            return true;
        }
        return true;
    }

    private boolean gather() {
        if (this.farmer.homeGuildHall == null) {
            return this.idle();
        }
        if (this.farmer.insideHall()) {
            ChunkCoordinates exit = this.farmer.homeGuildHall.entranceCoords;
            if (exit == null) {
                exit = AIHelper.getRandInsideCoords(this.farmer);
            }
            this.farmer.func_70661_as().func_75492_a((double)exit.field_71574_a, (double)exit.field_71572_b, (double)exit.field_71573_c, (double)this.speed);
        } else if (this.farmer.currentResource == null) {
            this.findFarm();
        } else {
            this.harvestCrops();
        }
        return this.idle();
    }

    private boolean store() {
        if (this.farmer.homeGuildHall == null) {
            return this.idle();
        }
        TileEntityChest chest2 = this.farmer.homeGuildHall.getAvailableChest();
        if (!this.farmer.inventory.isEmpty() || !this.farmer.hasTool) {
            if (chest2 != null) {
                this.farmer.func_70661_as().func_75492_a((double)chest2.field_145851_c, (double)chest2.field_145848_d, (double)chest2.field_145849_e, (double)this.speed);
            }
            if (chest2 != null && AIHelper.findDistance((int)this.farmer.field_70165_t, chest2.field_145851_c) <= 2 && AIHelper.findDistance((int)this.farmer.field_70163_u, chest2.field_145848_d) <= 2 && AIHelper.findDistance((int)this.farmer.field_70161_v, chest2.field_145849_e) <= 2) {
                try {
                    this.farmer.inventory.dumpInventory(chest2);
                }
                catch (NullPointerException e) {
                    chest2.func_70305_f();
                }
                if (!this.farmer.hasTool) {
                    block2: for (TileEntityChest chest2 : this.farmer.homeGuildHall.guildChests) {
                        for (ItemStack i : this.farmer.getValidTools()) {
                            if (AIHelper.chestContains(chest2, i) < 0) continue;
                            int index = AIHelper.chestContains(chest2, i);
                            this.farmer.inventory.swapEquipment(chest2, index, 0);
                            continue block2;
                        }
                    }
                }
            }
        }
        return this.idle();
    }

    private boolean craft() {
        return false;
    }

    private void findFarm() {
        if (this.target == null) {
            this.target = AIHelper.getRandInsideCoords(this.farmer);
        }
        if (this.target != null) {
            Vec3 vector = Vec3.func_72443_a((double)this.target.field_71574_a, (double)this.target.field_71572_b, (double)this.target.field_71573_c);
            Vec3 tempVec = RandomPositionGenerator.func_75464_a((EntityCreature)this.farmer, (int)10, (int)3, (Vec3)vector);
            this.farmer.func_110171_b((int)this.farmer.field_70165_t, (int)this.farmer.field_70163_u, (int)this.farmer.field_70161_v, 20);
            if (tempVec != null) {
                this.farmer.func_70661_as().func_75492_a(tempVec.field_72450_a, tempVec.field_72448_b, tempVec.field_72449_c, (double)this.speed);
            }
        }
        this.farmer.updateBoxes();
        if (this.farmer.searchBox != null && this.farmer.field_70170_p.func_72875_a(this.farmer.searchBox, Material.field_151578_c)) {
            this.farmer.currentResource = this.getNewResource();
            if (this.farmer.currentResource != null) {
                this.farmer.func_70661_as().func_75499_g();
            }
        }
        if (Math.abs(this.farmer.field_70165_t - (double)this.target.field_71574_a) <= 5.0 && Math.abs(this.farmer.field_70161_v - (double)this.target.field_71573_c) <= 5.0) {
            this.target = null;
        }
    }

    private ResourceCluster getNewResource() {
        ArrayList boxCoords = this.farmer.getValidCoords();
        boolean returnFlag = true;
        for (int i = 0; i < boxCoords.size(); ++i) {
            ResourceCluster currentCluster = new ResourceCluster(this.farmer.field_70170_p, (ChunkCoordinates)boxCoords.get(i));
            currentCluster.buildCluster();
            returnFlag = true;
            if (this.farmer.visitedFarms != null) {
                for (int j = 0; j < this.farmer.visitedFarms.size(); ++j) {
                    ResourceCluster farm = (ResourceCluster)this.farmer.visitedFarms.get(j);
                    if (!farm.matchesCluster(currentCluster)) continue;
                    returnFlag = false;
                    break;
                }
            }
            if (!returnFlag) continue;
            return currentCluster;
        }
        return null;
    }

    private void harvestCrops() {
        this.farmer.func_70661_as().func_75492_a((double)this.farmer.currentResource.coords.field_71574_a, (double)this.farmer.currentResource.coords.field_71572_b, (double)this.farmer.currentResource.coords.field_71573_c, (double)this.speed);
        if (!this.farmer.func_70661_as().func_75500_f()) {
            return;
        }
        int invIndex = -1;
        for (int i = 0; i < this.farmer.currentResource.blockCluster.size(); ++i) {
            ChunkCoordinates currentCoords = (ChunkCoordinates)this.farmer.currentResource.blockCluster.get(i);
            ChunkCoordinates aboveCoords = new ChunkCoordinates(currentCoords.field_71574_a, currentCoords.field_71572_b + 1, currentCoords.field_71573_c);
            Block aboveBlock = this.farmer.field_70170_p.func_147439_a(aboveCoords.field_71574_a, aboveCoords.field_71572_b, aboveCoords.field_71573_c);
            if (aboveBlock == Blocks.field_150464_aj || aboveBlock == Blocks.field_150459_bM || aboveBlock == Blocks.field_150469_bN) {
                int dropNum;
                if (this.farmer.field_70170_p.func_72805_g(aboveCoords.field_71574_a, aboveCoords.field_71572_b, aboveCoords.field_71573_c) < 7) continue;
                this.farmer.func_71038_i();
                this.farmer.damageItem();
                this.farmer.field_70170_p.func_147468_f(aboveCoords.field_71574_a, aboveCoords.field_71572_b, aboveCoords.field_71573_c);
                if (aboveBlock == Blocks.field_150464_aj) {
                    this.farmer.inventory.addItem(new ItemStack(Items.field_151015_O));
                    --dropNum;
                    while (dropNum > 0) {
                        this.farmer.inventory.addItem(new ItemStack(Items.field_151014_N));
                        --dropNum;
                    }
                    invIndex = this.farmer.inventory.containsItem(new ItemStack(Items.field_151014_N));
                    if (invIndex < 0) continue;
                    this.farmer.field_70170_p.func_147465_d(aboveCoords.field_71574_a, aboveCoords.field_71572_b, aboveCoords.field_71573_c, Blocks.field_150464_aj, 0, 2);
                    this.farmer.inventory.decrementSlot(invIndex);
                    continue;
                }
                if (aboveBlock == Blocks.field_150459_bM) {
                    for (dropNum = this.gen.nextInt(4) + 1; dropNum > 0; --dropNum) {
                        this.farmer.inventory.addItem(new ItemStack(Items.field_151172_bF));
                    }
                    invIndex = this.farmer.inventory.containsItem(new ItemStack(Items.field_151172_bF));
                    if (invIndex < 0) continue;
                    this.farmer.field_70170_p.func_147465_d(aboveCoords.field_71574_a, aboveCoords.field_71572_b, aboveCoords.field_71573_c, Blocks.field_150459_bM, 0, 2);
                    this.farmer.inventory.decrementSlot(invIndex);
                    continue;
                }
                if (aboveBlock != Blocks.field_150469_bN) continue;
                while (dropNum > 0) {
                    this.farmer.inventory.addItem(new ItemStack(Items.field_151174_bG));
                    --dropNum;
                }
                invIndex = this.farmer.inventory.containsItem(new ItemStack(Items.field_151174_bG));
                if (invIndex < 0) continue;
                this.farmer.field_70170_p.func_147465_d(aboveCoords.field_71574_a, aboveCoords.field_71572_b, aboveCoords.field_71573_c, Blocks.field_150469_bN, 0, 2);
                this.farmer.inventory.decrementSlot(invIndex);
                continue;
            }
            if (aboveBlock != Blocks.field_150393_bb && aboveBlock != Blocks.field_150394_bc) continue;
            ArrayList adjacent = AIHelper.getAdjacentCoords(aboveCoords);
            for (int j = 0; j < adjacent.size(); ++j) {
                ChunkCoordinates current = (ChunkCoordinates)adjacent.get(j);
                Block currentBlock = this.farmer.field_70170_p.func_147439_a(current.field_71574_a, current.field_71572_b, current.field_71573_c);
                if (currentBlock != Blocks.field_150423_aK && currentBlock != Blocks.field_150440_ba) continue;
                this.farmer.func_71038_i();
                this.farmer.damageItem();
                this.farmer.field_70170_p.func_147468_f(current.field_71574_a, current.field_71572_b, current.field_71573_c);
                this.farmer.inventory.addItem(new ItemStack(currentBlock));
            }
        }
        this.farmer.visitedFarms.add(this.farmer.currentResource);
        this.farmer.currentResource = null;
    }
}

