/*
 * Decompiled with CFR 0.152.
 */
package mods.helpfulvillagers.ai;

import java.util.ArrayList;
import java.util.Random;
import mods.helpfulvillagers.entity.EntityLumberjack;
import mods.helpfulvillagers.enums.EnumActivity;
import mods.helpfulvillagers.util.AIHelper;
import mods.helpfulvillagers.util.ResourceCluster;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.Vec3;

public class EntityAILumberjack
extends EntityAIBase {
    private EntityLumberjack lumberjack;
    private ChunkCoordinates target;
    private float speed;
    private int currentTime;
    private int previousTime;
    private float harvestTime;
    private int searchLimit;
    Random gen;

    public EntityAILumberjack(EntityLumberjack lumberjack) {
        this.lumberjack = lumberjack;
        this.gen = new Random();
        this.target = null;
        this.speed = 0.5f;
        this.currentTime = 0;
        this.previousTime = 0;
        this.harvestTime = 0.0f;
        this.searchLimit = 20;
        this.func_75248_a(1);
    }

    public boolean func_75250_a() {
        switch (this.lumberjack.currentActivity) {
            case GATHER: {
                return true;
            }
            case RETURN: {
                return false;
            }
            case CRAFT: {
                return true;
            }
            case STORE: {
                return true;
            }
            case IDLE: {
                return this.idle();
            }
        }
        return false;
    }

    public void func_75249_e() {
    }

    public boolean func_75253_b() {
        switch (this.lumberjack.currentActivity) {
            case GATHER: {
                return this.gather();
            }
            case RETURN: {
                return false;
            }
            case CRAFT: {
                return this.craft();
            }
            case STORE: {
                return this.store();
            }
            case IDLE: {
                return this.idle();
            }
        }
        return false;
    }

    private boolean idle() {
        this.lumberjack.currentActivity = EnumActivity.IDLE;
        boolean dummyFlag = false;
        if (!this.lumberjack.field_70170_p.field_72995_K && this.lumberjack.homeVillage == null) {
            System.out.println("No Home Village");
            return false;
        }
        this.lumberjack.checkGuildHall();
        if (this.lumberjack.homeGuildHall == null) {
            System.out.println("No Guild Hall");
            return false;
        }
        if (this.lumberjack.inventory.isFull() || !this.lumberjack.hasTool) {
            if (this.lumberjack.insideHall()) {
                if (dummyFlag) {
                    this.lumberjack.currentActivity = EnumActivity.CRAFT;
                    return true;
                }
                if (!this.lumberjack.inventory.isEmpty() || !this.lumberjack.hasTool) {
                    this.lumberjack.currentActivity = EnumActivity.STORE;
                    return true;
                }
                return false;
            }
            System.out.println("Returning to Hall");
            this.lumberjack.currentActivity = EnumActivity.RETURN;
            return false;
        }
        if (this.lumberjack.field_70170_p.func_72935_r()) {
            this.lumberjack.currentActivity = EnumActivity.GATHER;
            return true;
        }
        if (!this.lumberjack.insideHall()) {
            this.lumberjack.currentActivity = EnumActivity.RETURN;
            return false;
        }
        if (dummyFlag) {
            this.lumberjack.currentActivity = EnumActivity.CRAFT;
            return true;
        }
        if (!this.lumberjack.inventory.isEmpty() || !this.lumberjack.hasTool) {
            this.lumberjack.currentActivity = EnumActivity.STORE;
            return true;
        }
        return true;
    }

    private boolean gather() {
        if (this.lumberjack.homeGuildHall == null) {
            return this.idle();
        }
        if (this.lumberjack.insideHall()) {
            ChunkCoordinates exit = this.lumberjack.homeGuildHall.entranceCoords;
            if (exit == null) {
                exit = AIHelper.getRandInsideCoords(this.lumberjack);
            }
            this.lumberjack.func_70661_as().func_75492_a((double)exit.field_71574_a, (double)exit.field_71572_b, (double)exit.field_71573_c, (double)this.speed);
        } else if (this.lumberjack.currentResource == null) {
            this.findTree();
        } else {
            int distX = AIHelper.findDistance((int)this.lumberjack.field_70165_t, this.lumberjack.currentResource.coords.field_71574_a);
            int distZ = AIHelper.findDistance((int)this.lumberjack.field_70161_v, this.lumberjack.currentResource.coords.field_71573_c);
            if (distX > 5 || distZ > 5) {
                this.moveToTree();
            } else {
                this.chopTree();
            }
        }
        return this.idle();
    }

    private boolean craft() {
        return true;
    }

    private boolean store() {
        if (this.lumberjack.homeGuildHall == null) {
            return this.idle();
        }
        TileEntityChest chest2 = this.lumberjack.homeGuildHall.getAvailableChest();
        if (!this.lumberjack.inventory.isEmpty() || !this.lumberjack.hasTool) {
            if (chest2 != null) {
                this.lumberjack.func_70661_as().func_75492_a((double)chest2.field_145851_c, (double)chest2.field_145848_d, (double)chest2.field_145849_e, (double)this.speed);
            }
            if (chest2 != null && AIHelper.findDistance((int)this.lumberjack.field_70165_t, chest2.field_145851_c) <= 2 && AIHelper.findDistance((int)this.lumberjack.field_70163_u, chest2.field_145848_d) <= 2 && AIHelper.findDistance((int)this.lumberjack.field_70161_v, chest2.field_145849_e) <= 2) {
                try {
                    this.lumberjack.inventory.dumpInventory(chest2);
                }
                catch (NullPointerException e) {
                    chest2.func_70305_f();
                }
                if (!this.lumberjack.hasTool) {
                    block2: for (TileEntityChest chest2 : this.lumberjack.homeGuildHall.guildChests) {
                        for (ItemStack i : this.lumberjack.getValidTools()) {
                            if (AIHelper.chestContains(chest2, i) < 0) continue;
                            int index = AIHelper.chestContains(chest2, i);
                            this.lumberjack.inventory.swapEquipment(chest2, index, 0);
                            continue block2;
                        }
                    }
                }
            }
        }
        return this.idle();
    }

    private void findTree() {
        if (this.target == null) {
            this.target = AIHelper.getRandOutsideCoords(this.lumberjack, this.searchLimit);
        }
        if (this.target != null) {
            Vec3 vector = Vec3.func_72443_a((double)this.target.field_71574_a, (double)this.target.field_71572_b, (double)this.target.field_71573_c);
            Vec3 tempVec = RandomPositionGenerator.func_75464_a((EntityCreature)this.lumberjack, (int)10, (int)3, (Vec3)vector);
            this.lumberjack.func_110171_b((int)this.lumberjack.field_70165_t, (int)this.lumberjack.field_70163_u, (int)this.lumberjack.field_70161_v, 20);
            if (tempVec != null) {
                this.lumberjack.func_70661_as().func_75492_a(tempVec.field_72450_a, tempVec.field_72448_b, tempVec.field_72449_c, (double)this.speed);
            }
        }
        if (this.lumberjack.searchBox != null && this.lumberjack.field_70170_p.func_72875_a(this.lumberjack.searchBox, Material.field_151575_d) && !this.lumberjack.homeVillage.isInRange(this.lumberjack.field_70165_t, this.lumberjack.field_70163_u, this.lumberjack.field_70161_v)) {
            this.lumberjack.currentResource = this.getNewResource();
            if (this.lumberjack.currentResource != null) {
                this.searchLimit = 20;
                this.lumberjack.foundTree = true;
                this.lumberjack.func_70661_as().func_75499_g();
            }
        }
        if (Math.abs(this.lumberjack.field_70165_t - (double)this.target.field_71574_a) <= 5.0 && Math.abs(this.lumberjack.field_70161_v - (double)this.target.field_71573_c) <= 5.0) {
            this.target = null;
            this.searchLimit += 10;
        }
    }

    private void moveToTree() {
        this.target = this.lumberjack.currentResource.lowestCoords;
        Vec3 vector = Vec3.func_72443_a((double)this.target.field_71574_a, (double)this.target.field_71572_b, (double)this.target.field_71573_c);
        Vec3 tempVec = RandomPositionGenerator.func_75464_a((EntityCreature)this.lumberjack, (int)10, (int)3, (Vec3)vector);
        this.lumberjack.func_110171_b((int)this.lumberjack.field_70165_t, (int)this.lumberjack.field_70163_u, (int)this.lumberjack.field_70161_v, 20);
        if (tempVec != null) {
            this.lumberjack.func_70661_as().func_75492_a(tempVec.field_72450_a, tempVec.field_72448_b, tempVec.field_72449_c, (double)this.speed);
        }
    }

    private ResourceCluster getNewResource() {
        ArrayList boxCoords = this.lumberjack.getValidCoords();
        double closestDist = Double.MAX_VALUE;
        ResourceCluster closestValidCluster = null;
        for (int i = 0; i < boxCoords.size(); ++i) {
            ChunkCoordinates currCoords = (ChunkCoordinates)boxCoords.get(i);
            double dist = this.lumberjack.func_70011_f(currCoords.field_71574_a, currCoords.field_71572_b, currCoords.field_71573_c);
            if (!(dist < closestDist)) continue;
            ResourceCluster currentCluster = new ResourceCluster(this.lumberjack.field_70170_p, (ChunkCoordinates)boxCoords.get(i));
            ArrayList sideBlocks = currentCluster.getAdjacent();
            for (int j = 0; j < sideBlocks.size(); ++j) {
                Block currentBlock = (Block)sideBlocks.get(j);
                if (!currentBlock.equals(Blocks.field_150347_e) && !currentBlock.equals(Blocks.field_150344_f) && !currentBlock.equals(Blocks.field_150458_ak) && !currentBlock.equals(Blocks.field_150422_aJ) && !currentBlock.equals(Blocks.field_150396_be) && !currentBlock.equals(Blocks.field_150466_ao) && !currentBlock.equals(Blocks.field_150454_av) && !currentBlock.equals(Blocks.field_150342_X)) continue;
                currentCluster = null;
                break;
            }
            if (currentCluster == null) continue;
            closestValidCluster = currentCluster;
            closestDist = dist;
        }
        return closestValidCluster;
    }

    private void chopTree() {
        this.lumberjack.func_70661_as().func_75492_a((double)this.lumberjack.currentResource.lowestCoords.field_71574_a, (double)this.lumberjack.currentResource.lowestCoords.field_71572_b, (double)this.lumberjack.currentResource.lowestCoords.field_71573_c, (double)this.speed);
        boolean shouldSwing = false;
        if (!this.lumberjack.currentResource.builtFlag) {
            this.lumberjack.currentResource.buildCluster();
            this.lumberjack.currentResource.builtFlag = true;
        }
        if (this.lumberjack.func_70661_as().func_75500_f()) {
            this.lumberjack.func_70671_ap().func_75650_a((double)this.lumberjack.currentResource.lowestCoords.field_71574_a, (double)this.lumberjack.currentResource.lowestCoords.field_71572_b, (double)this.lumberjack.currentResource.lowestCoords.field_71573_c, 10.0f, 10.0f);
            shouldSwing = true;
            if (this.previousTime <= 0) {
                this.previousTime = this.lumberjack.field_70173_aa;
                this.harvestTime = 60.0f / this.lumberjack.getCurrentItem().func_77973_b().getDigSpeed(this.lumberjack.getCurrentItem(), this.lumberjack.currentResource.startBlock, this.lumberjack.getCurrentItem().func_77973_b().func_77647_b(0));
            }
        } else {
            shouldSwing = false;
        }
        if (this.previousTime > 0) {
            this.currentTime = this.lumberjack.field_70173_aa;
            if (!this.lumberjack.currentResource.blockCluster.isEmpty()) {
                if ((float)(this.currentTime - this.previousTime) >= this.harvestTime) {
                    this.previousTime = this.currentTime;
                    this.harvestTime = 60.0f / this.lumberjack.getCurrentItem().func_77973_b().getDigSpeed(this.lumberjack.getCurrentItem(), this.lumberjack.currentResource.startBlock, this.lumberjack.getCurrentItem().func_77973_b().func_77647_b(0));
                    ChunkCoordinates currentCoords = (ChunkCoordinates)this.lumberjack.currentResource.blockCluster.get(0);
                    Block currentBlock = this.lumberjack.field_70170_p.func_147439_a(currentCoords.field_71574_a, currentCoords.field_71572_b, currentCoords.field_71573_c);
                    int metadata = this.lumberjack.field_70170_p.func_72805_g(currentCoords.field_71574_a, currentCoords.field_71572_b, currentCoords.field_71573_c);
                    if (Block.func_149682_b((Block)currentBlock) == Block.func_149682_b((Block)this.lumberjack.currentResource.startBlock)) {
                        this.lumberjack.field_70170_p.func_147468_f(currentCoords.field_71574_a, currentCoords.field_71572_b, currentCoords.field_71573_c);
                        this.lumberjack.currentResource.blockCluster.remove(0);
                        AIHelper.breakBlock(currentCoords, this.lumberjack);
                    }
                }
            } else {
                this.lumberjack.lastResource = this.lumberjack.currentResource;
                this.lumberjack.currentResource = null;
                this.target = null;
                this.previousTime = 0;
                this.currentTime = 0;
            }
        }
        if (shouldSwing) {
            this.lumberjack.func_71038_i();
        } else {
            this.previousTime = 0;
        }
    }
}

