/*
 * Decompiled with CFR 0.152.
 */
package mods.helpfulvillagers.village;

import java.util.ArrayList;
import java.util.List;
import mods.helpfulvillagers.village.HelpfulVillage;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemAnvilBlock;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class GuildHall {
    private HelpfulVillage village;
    public World worldObj;
    public EntityItemFrame itemFrame;
    public ChunkCoordinates doorCoords;
    public ChunkCoordinates entranceCoords;
    public ArrayList insideCoords;
    public int typeNum;
    public ArrayList guildChests;

    public GuildHall() {
    }

    public GuildHall(World world, HelpfulVillage village) {
        this.worldObj = world;
        this.village = village;
        this.itemFrame = null;
        this.doorCoords = null;
        this.entranceCoords = null;
        this.typeNum = -1;
        this.insideCoords = new ArrayList();
        this.guildChests = new ArrayList();
    }

    public void findCoords(int profession) {
        List entities = this.worldObj.field_72996_f;
        for (Entity entity : entities) {
            EntityItemFrame itemFrame;
            if (!(entity instanceof EntityItemFrame) || !this.village.isInRange(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v) || (itemFrame = (EntityItemFrame)entity).func_82335_i() == null || !this.matchesProfession(itemFrame, profession) || !this.isNextToDoor((Entity)itemFrame)) continue;
            this.itemFrame = itemFrame;
            this.typeNum = profession;
            try {
                this.fillInsideCoords();
                this.findEntranceCoords();
            }
            catch (StackOverflowError e) {
                this.insideCoords.clear();
            }
            break;
        }
    }

    private boolean matchesProfession(EntityItemFrame itemFrame, int profession) {
        ItemStack itemStack = itemFrame.func_82335_i();
        if (itemStack == null) {
            return false;
        }
        switch (profession) {
            case 1: {
                return itemStack.func_77973_b() instanceof ItemAxe;
            }
            case 2: {
                return itemStack.func_77973_b() instanceof ItemPickaxe;
            }
            case 3: {
                return itemStack.func_77973_b() instanceof ItemHoe;
            }
            case 4: {
                return itemStack.func_77973_b() instanceof ItemSpade;
            }
            case 5: {
                return itemStack.func_77973_b() instanceof ItemShears;
            }
            case 6: {
                return itemStack.func_77973_b() == Items.field_151099_bA || itemStack.func_77973_b() == Items.field_151164_bB;
            }
            case 7: {
                return itemStack.func_77973_b() == Items.field_151111_aL;
            }
            case 8: {
                return itemStack.func_77973_b() instanceof ItemAnvilBlock;
            }
            case 9: {
                return itemStack.func_77973_b() instanceof ItemSword;
            }
            case 10: {
                return itemStack.func_77973_b() instanceof ItemBow;
            }
            case 11: {
                return itemStack.func_77973_b() instanceof ItemPotion;
            }
            case 12: {
                return itemStack.func_77973_b() == Items.field_151112_aM;
            }
            case 13: {
                return itemStack.func_77973_b() == Items.field_151113_aN;
            }
        }
        return false;
    }

    private boolean isNextToDoor(Entity entity) {
        int posX = (int)entity.field_70165_t;
        int posY = (int)entity.field_70163_u;
        int posZ = (int)entity.field_70161_v;
        boolean doorFlag = false;
        this.doorCoords = new ChunkCoordinates(posX, posY, posZ);
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                for (int k = 0; k < 3; ++k) {
                    if (this.worldObj.func_147439_a(posX + i, posY + j, posZ + k) == Blocks.field_150466_ao) {
                        this.doorCoords.func_71571_b(posX + i, posY + j, posZ + k);
                        doorFlag = true;
                        continue;
                    }
                    if (this.worldObj.func_147439_a(posX + i, posY + j, posZ - k) == Blocks.field_150466_ao) {
                        this.doorCoords.func_71571_b(posX + i, posY + j, posZ - k);
                        doorFlag = true;
                        continue;
                    }
                    if (this.worldObj.func_147439_a(posX + i, posY - j, posZ - k) == Blocks.field_150466_ao) {
                        this.doorCoords.func_71571_b(posX + i, posY - j, posZ - k);
                        doorFlag = true;
                        continue;
                    }
                    if (this.worldObj.func_147439_a(posX + i, posY - j, posZ + k) == Blocks.field_150466_ao) {
                        this.doorCoords.func_71571_b(posX + i, posY - j, posZ + k);
                        doorFlag = true;
                        continue;
                    }
                    if (this.worldObj.func_147439_a(posX - i, posY + j, posZ + k) == Blocks.field_150466_ao) {
                        this.doorCoords.func_71571_b(posX - i, posY + j, posZ + k);
                        doorFlag = true;
                        continue;
                    }
                    if (this.worldObj.func_147439_a(posX - i, posY + j, posZ - k) == Blocks.field_150466_ao) {
                        this.doorCoords.func_71571_b(posX - i, posY + j, posZ - k);
                        doorFlag = true;
                        continue;
                    }
                    if (this.worldObj.func_147439_a(posX - i, posY - j, posZ + k) == Blocks.field_150466_ao) {
                        this.doorCoords.func_71571_b(posX - i, posY - j, posZ + k);
                        doorFlag = true;
                        continue;
                    }
                    if (this.worldObj.func_147439_a(posX - i, posY - j, posZ - k) != Blocks.field_150466_ao) continue;
                    this.doorCoords.func_71571_b(posX - i, posY - j, posZ - k);
                    doorFlag = true;
                }
            }
        }
        if (doorFlag) {
            if (entity.field_70170_p.func_147439_a(this.doorCoords.field_71574_a, this.doorCoords.field_71572_b - 1, this.doorCoords.field_71573_c) == Blocks.field_150466_ao) {
                this.doorCoords.func_71571_b(this.doorCoords.field_71574_a, this.doorCoords.field_71572_b - 1, this.doorCoords.field_71573_c);
            }
        } else {
            this.doorCoords = null;
        }
        return doorFlag;
    }

    private void fillInsideCoords() {
        this.insideCoords.add(this.doorCoords);
        switch (this.itemFrame.field_82332_a) {
            case 0: {
                ChunkCoordinates startCoords = new ChunkCoordinates(this.doorCoords.field_71574_a, this.doorCoords.field_71572_b, this.doorCoords.field_71573_c - 1);
                ChunkCoordinates entranceCoords = new ChunkCoordinates(this.doorCoords.field_71574_a, this.doorCoords.field_71572_b, this.doorCoords.field_71573_c + 1);
                this.insideCoords.add(entranceCoords);
                this.checkZDirection(startCoords, -1);
                break;
            }
            case 1: {
                ChunkCoordinates startCoords = new ChunkCoordinates(this.doorCoords.field_71574_a + 1, this.doorCoords.field_71572_b, this.doorCoords.field_71573_c);
                ChunkCoordinates entranceCoords = new ChunkCoordinates(this.doorCoords.field_71574_a - 1, this.doorCoords.field_71572_b, this.doorCoords.field_71573_c);
                this.insideCoords.add(entranceCoords);
                this.checkXDirection(startCoords, 1);
                break;
            }
            case 2: {
                ChunkCoordinates startCoords = new ChunkCoordinates(this.doorCoords.field_71574_a, this.doorCoords.field_71572_b, this.doorCoords.field_71573_c + 1);
                ChunkCoordinates entranceCoords = new ChunkCoordinates(this.doorCoords.field_71574_a, this.doorCoords.field_71572_b, this.doorCoords.field_71573_c - 1);
                this.insideCoords.add(entranceCoords);
                this.checkZDirection(startCoords, 1);
                break;
            }
            case 3: {
                ChunkCoordinates startCoords = new ChunkCoordinates(this.doorCoords.field_71574_a - 1, this.doorCoords.field_71572_b, this.doorCoords.field_71573_c);
                ChunkCoordinates entranceCoords = new ChunkCoordinates(this.doorCoords.field_71574_a + 1, this.doorCoords.field_71572_b, this.doorCoords.field_71573_c);
                this.insideCoords.add(entranceCoords);
                this.checkXDirection(startCoords, -1);
                break;
            }
            default: {
                Object startCoords = null;
                System.out.println("START COORDS NULL");
            }
        }
    }

    private void checkXDirection(ChunkCoordinates currentCoords, int direction) {
        boolean addFlag = false;
        if (!this.insideCoords.contains(currentCoords) && this.isInside(currentCoords)) {
            if (direction < 0) {
                if (!this.worldObj.isSideSolid(currentCoords.field_71574_a, currentCoords.field_71572_b, currentCoords.field_71573_c, ForgeDirection.WEST) && this.worldObj.func_147439_a(currentCoords.field_71574_a, currentCoords.field_71572_b, currentCoords.field_71573_c) != Blocks.field_150359_w && this.worldObj.func_147439_a(currentCoords.field_71574_a, currentCoords.field_71572_b, currentCoords.field_71573_c) != Blocks.field_150410_aZ && this.worldObj.func_147439_a(currentCoords.field_71574_a, currentCoords.field_71572_b, currentCoords.field_71573_c) != Blocks.field_150399_cn && this.worldObj.func_147439_a(currentCoords.field_71574_a, currentCoords.field_71572_b, currentCoords.field_71573_c) != Blocks.field_150397_co) {
                    addFlag = true;
                }
            } else if (!this.worldObj.isSideSolid(currentCoords.field_71574_a, currentCoords.field_71572_b, currentCoords.field_71573_c, ForgeDirection.EAST) && this.worldObj.func_147439_a(currentCoords.field_71574_a, currentCoords.field_71572_b, currentCoords.field_71573_c) != Blocks.field_150359_w && this.worldObj.func_147439_a(currentCoords.field_71574_a, currentCoords.field_71572_b, currentCoords.field_71573_c) != Blocks.field_150410_aZ && this.worldObj.func_147439_a(currentCoords.field_71574_a, currentCoords.field_71572_b, currentCoords.field_71573_c) != Blocks.field_150399_cn && this.worldObj.func_147439_a(currentCoords.field_71574_a, currentCoords.field_71572_b, currentCoords.field_71573_c) != Blocks.field_150397_co) {
                addFlag = true;
            }
        }
        if (addFlag) {
            this.insideCoords.add(currentCoords);
            ChunkCoordinates nextXCoords = new ChunkCoordinates(currentCoords.field_71574_a + direction, currentCoords.field_71572_b, currentCoords.field_71573_c);
            ChunkCoordinates negYCoords = new ChunkCoordinates(currentCoords.field_71574_a, currentCoords.field_71572_b - 1, currentCoords.field_71573_c);
            ChunkCoordinates posYCoords = new ChunkCoordinates(currentCoords.field_71574_a, currentCoords.field_71572_b + 1, currentCoords.field_71573_c);
            ChunkCoordinates negZCoords = new ChunkCoordinates(currentCoords.field_71574_a, currentCoords.field_71572_b, currentCoords.field_71573_c - 1);
            ChunkCoordinates posZCoords = new ChunkCoordinates(currentCoords.field_71574_a, currentCoords.field_71572_b, currentCoords.field_71573_c + 1);
            this.checkXDirection(nextXCoords, direction);
            this.checkYDirection(negYCoords, -1);
            this.checkYDirection(posYCoords, 1);
            this.checkZDirection(negZCoords, -1);
            this.checkZDirection(posZCoords, 1);
        }
    }

    private void checkYDirection(ChunkCoordinates currentCoords, int direction) {
        boolean addFlag = false;
        if (!this.insideCoords.contains(currentCoords) && this.isInside(currentCoords)) {
            if (direction < 0) {
                if (!this.worldObj.isSideSolid(currentCoords.field_71574_a, currentCoords.field_71572_b, currentCoords.field_71573_c, ForgeDirection.UP) && this.worldObj.func_147439_a(currentCoords.field_71574_a, currentCoords.field_71572_b, currentCoords.field_71573_c) != Blocks.field_150359_w && this.worldObj.func_147439_a(currentCoords.field_71574_a, currentCoords.field_71572_b, currentCoords.field_71573_c) != Blocks.field_150410_aZ && this.worldObj.func_147439_a(currentCoords.field_71574_a, currentCoords.field_71572_b, currentCoords.field_71573_c) != Blocks.field_150399_cn && this.worldObj.func_147439_a(currentCoords.field_71574_a, currentCoords.field_71572_b, currentCoords.field_71573_c) != Blocks.field_150397_co) {
                    addFlag = true;
                }
            } else if (!this.worldObj.isSideSolid(currentCoords.field_71574_a, currentCoords.field_71572_b, currentCoords.field_71573_c, ForgeDirection.DOWN) && this.worldObj.func_147439_a(currentCoords.field_71574_a, currentCoords.field_71572_b, currentCoords.field_71573_c) != Blocks.field_150359_w && this.worldObj.func_147439_a(currentCoords.field_71574_a, currentCoords.field_71572_b, currentCoords.field_71573_c) != Blocks.field_150410_aZ && this.worldObj.func_147439_a(currentCoords.field_71574_a, currentCoords.field_71572_b, currentCoords.field_71573_c) != Blocks.field_150399_cn && this.worldObj.func_147439_a(currentCoords.field_71574_a, currentCoords.field_71572_b, currentCoords.field_71573_c) != Blocks.field_150397_co) {
                addFlag = true;
            }
        }
        if (addFlag) {
            this.insideCoords.add(currentCoords);
            ChunkCoordinates nextYCoords = new ChunkCoordinates(currentCoords.field_71574_a, currentCoords.field_71572_b + direction, currentCoords.field_71573_c);
            ChunkCoordinates negXCoords = new ChunkCoordinates(currentCoords.field_71574_a - 1, currentCoords.field_71572_b, currentCoords.field_71573_c);
            ChunkCoordinates posXCoords = new ChunkCoordinates(currentCoords.field_71574_a + 1, currentCoords.field_71572_b, currentCoords.field_71573_c + 1);
            ChunkCoordinates negZCoords = new ChunkCoordinates(currentCoords.field_71574_a, currentCoords.field_71572_b, currentCoords.field_71573_c - 1);
            ChunkCoordinates posZCoords = new ChunkCoordinates(currentCoords.field_71574_a, currentCoords.field_71572_b, currentCoords.field_71573_c + 1);
            this.checkYDirection(nextYCoords, direction);
            this.checkXDirection(negXCoords, -1);
            this.checkXDirection(posXCoords, 1);
            this.checkZDirection(negZCoords, -1);
            this.checkZDirection(posZCoords, 1);
        }
    }

    private void checkZDirection(ChunkCoordinates currentCoords, int direction) {
        boolean addFlag = false;
        if (!this.insideCoords.contains(currentCoords) && this.isInside(currentCoords)) {
            if (direction < 0) {
                if (!this.worldObj.isSideSolid(currentCoords.field_71574_a, currentCoords.field_71572_b, currentCoords.field_71573_c, ForgeDirection.SOUTH) && this.worldObj.func_147439_a(currentCoords.field_71574_a, currentCoords.field_71572_b, currentCoords.field_71573_c) != Blocks.field_150359_w && this.worldObj.func_147439_a(currentCoords.field_71574_a, currentCoords.field_71572_b, currentCoords.field_71573_c) != Blocks.field_150410_aZ && this.worldObj.func_147439_a(currentCoords.field_71574_a, currentCoords.field_71572_b, currentCoords.field_71573_c) != Blocks.field_150399_cn && this.worldObj.func_147439_a(currentCoords.field_71574_a, currentCoords.field_71572_b, currentCoords.field_71573_c) != Blocks.field_150397_co) {
                    addFlag = true;
                }
            } else if (!this.worldObj.isSideSolid(currentCoords.field_71574_a, currentCoords.field_71572_b, currentCoords.field_71573_c, ForgeDirection.NORTH) && this.worldObj.func_147439_a(currentCoords.field_71574_a, currentCoords.field_71572_b, currentCoords.field_71573_c) != Blocks.field_150359_w && this.worldObj.func_147439_a(currentCoords.field_71574_a, currentCoords.field_71572_b, currentCoords.field_71573_c) != Blocks.field_150410_aZ && this.worldObj.func_147439_a(currentCoords.field_71574_a, currentCoords.field_71572_b, currentCoords.field_71573_c) != Blocks.field_150399_cn && this.worldObj.func_147439_a(currentCoords.field_71574_a, currentCoords.field_71572_b, currentCoords.field_71573_c) != Blocks.field_150397_co) {
                addFlag = true;
            }
        }
        if (addFlag) {
            this.insideCoords.add(currentCoords);
            ChunkCoordinates nextZCoords = new ChunkCoordinates(currentCoords.field_71574_a, currentCoords.field_71572_b, currentCoords.field_71573_c + direction);
            ChunkCoordinates negXCoords = new ChunkCoordinates(currentCoords.field_71574_a - 1, currentCoords.field_71572_b, currentCoords.field_71573_c);
            ChunkCoordinates posXCoords = new ChunkCoordinates(currentCoords.field_71574_a + 1, currentCoords.field_71572_b, currentCoords.field_71573_c);
            ChunkCoordinates negYCoords = new ChunkCoordinates(currentCoords.field_71574_a, currentCoords.field_71572_b - 1, currentCoords.field_71573_c);
            ChunkCoordinates posYCoords = new ChunkCoordinates(currentCoords.field_71574_a, currentCoords.field_71572_b + 1, currentCoords.field_71573_c);
            this.checkXDirection(nextZCoords, direction);
            this.checkYDirection(negYCoords, -1);
            this.checkYDirection(posYCoords, 1);
            this.checkZDirection(negXCoords, -1);
            this.checkZDirection(posXCoords, 1);
        }
    }

    private void findEntranceCoords() {
        if (!this.isInside(new ChunkCoordinates(this.doorCoords.field_71574_a + 3, this.doorCoords.field_71572_b, this.doorCoords.field_71573_c)) && this.worldObj.func_147437_c(this.doorCoords.field_71574_a + 3, this.doorCoords.field_71572_b, this.doorCoords.field_71573_c)) {
            this.entranceCoords = new ChunkCoordinates(this.doorCoords.field_71574_a + 3, this.doorCoords.field_71572_b, this.doorCoords.field_71573_c);
            return;
        }
        if (!this.isInside(new ChunkCoordinates(this.doorCoords.field_71574_a - 3, this.doorCoords.field_71572_b, this.doorCoords.field_71573_c)) && this.worldObj.func_147437_c(this.doorCoords.field_71574_a - 3, this.doorCoords.field_71572_b, this.doorCoords.field_71573_c)) {
            this.entranceCoords = new ChunkCoordinates(this.doorCoords.field_71574_a - 3, this.doorCoords.field_71572_b, this.doorCoords.field_71573_c);
            return;
        }
        if (!this.isInside(new ChunkCoordinates(this.doorCoords.field_71574_a, this.doorCoords.field_71572_b, this.doorCoords.field_71573_c + 3)) && this.worldObj.func_147437_c(this.doorCoords.field_71574_a, this.doorCoords.field_71572_b, this.doorCoords.field_71573_c + 3)) {
            this.entranceCoords = new ChunkCoordinates(this.doorCoords.field_71574_a, this.doorCoords.field_71572_b, this.doorCoords.field_71573_c + 3);
            return;
        }
        if (!this.isInside(new ChunkCoordinates(this.doorCoords.field_71574_a, this.doorCoords.field_71572_b, this.doorCoords.field_71573_c - 3)) && this.worldObj.func_147437_c(this.doorCoords.field_71574_a, this.doorCoords.field_71572_b, this.doorCoords.field_71573_c - 3)) {
            this.entranceCoords = new ChunkCoordinates(this.doorCoords.field_71574_a, this.doorCoords.field_71572_b, this.doorCoords.field_71573_c - 3);
            return;
        }
    }

    private boolean isInside(ChunkCoordinates currentCoords) {
        if (!this.worldObj.func_72937_j(currentCoords.field_71574_a, currentCoords.field_71572_b, currentCoords.field_71573_c)) {
            return true;
        }
        for (int i = currentCoords.field_71572_b + 1; i < 256; ++i) {
            if (this.worldObj.func_147437_c(currentCoords.field_71574_a, i, currentCoords.field_71573_c)) continue;
            return true;
        }
        return false;
    }

    public ChunkCoordinates getFrameCoords() {
        return new ChunkCoordinates((int)this.itemFrame.field_70165_t, (int)this.itemFrame.field_70163_u, (int)this.itemFrame.field_70161_v);
    }

    public void checkFrame() {
        if (!this.worldObj.field_72995_K) {
            if (!(this.itemFrame == null || this.itemFrame.func_70089_S() && this.matchesProfession(this.itemFrame, this.typeNum))) {
                this.itemFrame = null;
                this.village.guildHallList.remove(this);
                this.village.unlockedHalls[this.typeNum - 1] = false;
            } else if (this.itemFrame == null) {
                this.village.guildHallList.remove(this);
                this.village.unlockedHalls[this.typeNum - 1] = false;
            }
        }
    }

    public void checkChests() {
        this.guildChests.clear();
        for (ChunkCoordinates currentCoords : this.insideCoords) {
            TileEntityChest chest;
            if (this.worldObj.func_147439_a(currentCoords.field_71574_a, currentCoords.field_71572_b, currentCoords.field_71573_c) != Blocks.field_150486_ae || this.guildChests.contains(chest = (TileEntityChest)this.worldObj.func_147438_o(currentCoords.field_71574_a, currentCoords.field_71572_b, currentCoords.field_71573_c))) continue;
            this.guildChests.add(chest);
        }
    }

    public boolean equals(Object object) {
        if (object instanceof GuildHall) {
            GuildHall guildHall = (GuildHall)object;
            if (this != null && guildHall != null && this.typeNum == guildHall.typeNum && this.doorCoords.equals((Object)guildHall.doorCoords)) {
                return true;
            }
        }
        return false;
    }

    public int getTypeNum() {
        return this.typeNum;
    }

    public void setTypeNum(int typeNum) {
        this.typeNum = typeNum;
    }

    public TileEntityChest getAvailableChest() {
        for (TileEntityChest chest : this.guildChests) {
            int size = chest.func_70302_i_();
            for (int i = 0; i < size; ++i) {
                if (chest.func_70301_a(i) != null) continue;
                return chest;
            }
        }
        return null;
    }
}

