/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.container;

import com.creativemd.creativecore.common.container.ContainerSub;
import com.creativemd.creativecore.common.container.slot.ContainerControl;
import com.creativemd.creativecore.common.container.slot.SlotControl;
import com.creativemd.creativecore.common.gui.event.container.ContainerControlEvent;
import com.creativemd.creativecore.common.gui.premade.SubContainerDialog;
import com.creativemd.creativecore.common.packet.GuiLayerPacket;
import com.creativemd.creativecore.common.packet.GuiUpdatePacket;
import com.creativemd.creativecore.common.packet.PacketHandler;
import com.n247s.api.eventapi.eventsystem.EventBus;
import cpw.mods.fml.common.FMLCommonHandler;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public abstract class SubContainer {
    public int tick;
    public EntityPlayer player;
    public ContainerSub container;
    private EventBus eventBus;
    public ArrayList<ContainerControl> controls = new ArrayList();

    public SubContainer(EntityPlayer player) {
        this.player = player;
        this.tick = 0;
        this.eventBus = new EventBus();
        this.eventBus.RegisterEventListener(this);
    }

    public int getLayerID() {
        return this.container.layers.indexOf(this);
    }

    public SubContainer createLayerFromPacket(World world, EntityPlayer player, NBTTagCompound nbt) {
        if (nbt.func_74767_n("dialog")) {
            return new SubContainerDialog(player);
        }
        return null;
    }

    public void closeLayer(NBTTagCompound nbt) {
        this.closeLayer(nbt, false);
    }

    public void closeLayer(NBTTagCompound nbt, boolean isPacket) {
        if (!isPacket) {
            PacketHandler.sendPacketToServer(new GuiLayerPacket(nbt, this.getLayerID(), true));
        }
        this.onGuiClosed();
        this.onLayerClosed(nbt, this);
        this.container.layers.remove(this);
    }

    public void onLayerClosed(NBTTagCompound nbt, SubContainer container) {
    }

    public void openNewLayer(NBTTagCompound nbt) {
        this.openNewLayer(nbt, false);
    }

    public void openNewLayer(NBTTagCompound nbt, boolean isPacket) {
        SubContainer Subcontainer = this.createLayerFromPacket(this.player.field_70170_p, this.player, nbt);
        Subcontainer.container = this.container;
        this.container.layers.add(Subcontainer);
        if (!isPacket) {
            PacketHandler.sendPacketToServer(new GuiLayerPacket(nbt, this.getLayerID(), false));
        }
    }

    public boolean raiseEvent(ContainerControlEvent event) {
        return !this.eventBus.raiseEvent(event);
    }

    public void addListener(Object listener) {
        this.eventBus.RegisterEventListener(listener);
    }

    public void initContainer() {
        this.createControls();
        this.refreshControls();
    }

    public void refreshControls() {
        for (int i = 0; i < this.controls.size(); ++i) {
            this.controls.get((int)i).parent = this;
            this.controls.get(i).setID(i);
        }
    }

    public abstract void createControls();

    public abstract void onGuiPacket(int var1, NBTTagCompound var2, EntityPlayer var3);

    public int getUpdateTick() {
        return 0;
    }

    public void sendUpdate() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.writeToNBT(nbt);
        PacketHandler.sendPacketToPlayer(new GuiUpdatePacket(nbt, false, this.getLayerID()), (EntityPlayerMP)this.player);
    }

    public void writeOpeningNBT(NBTTagCompound nbt) {
    }

    public void writeToNBT(NBTTagCompound nbt) {
    }

    public void onSlotChange() {
    }

    public void onGuiClosed() {
        for (int i = 0; i < this.controls.size(); ++i) {
            this.controls.get(i).onGuiClose();
        }
        this.eventBus.removeAllEventListeners();
    }

    public void onGuiOpened() {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            NBTTagCompound nbt = new NBTTagCompound();
            this.writeOpeningNBT(nbt);
            PacketHandler.sendPacketToPlayer(new GuiUpdatePacket(nbt, true, this.getLayerID()), (EntityPlayerMP)this.player);
        }
    }

    public void onUpdate() {
        if (this.getUpdateTick() > 0 && FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            ++this.tick;
            if (this.tick > this.getUpdateTick()) {
                this.tick = 0;
                this.sendUpdate();
            }
        }
        for (int i = 0; i < this.controls.size(); ++i) {
            this.controls.get(i).detectChange();
        }
    }

    public ArrayList<Slot> getSlots() {
        ArrayList<Slot> slots = new ArrayList<Slot>();
        for (int i = 0; i < this.controls.size(); ++i) {
            if (!(this.controls.get(i) instanceof SlotControl)) continue;
            slots.add(((SlotControl)this.controls.get((int)i)).slot);
        }
        return slots;
    }

    public void addSlotToContainer(Slot slot) {
        this.controls.add(new SlotControl(slot));
    }

    public void addPlayerSlotsToContainer(EntityPlayer player) {
        this.addPlayerSlotsToContainer(player, 8, 84);
    }

    public void addPlayerSlotsToContainer(EntityPlayer player, int x, int y) {
        int l;
        for (l = 0; l < 3; ++l) {
            for (int i1 = 0; i1 < 9; ++i1) {
                this.addSlotToContainer(new Slot((IInventory)player.field_71071_by, i1 + l * 9 + 9, i1 * 18 + x, l * 18 + y));
            }
        }
        for (l = 0; l < 9; ++l) {
            this.addSlotToContainer(new Slot((IInventory)player.field_71071_by, l, l * 18 + x, 58 + y));
        }
    }
}

