/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.gui.controls;

import com.creativemd.creativecore.common.gui.controls.GuiControl;
import javax.vecmath.Vector2d;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GuiAnalogeSlider
extends GuiControl {
    public static final ResourceLocation buttonTextures = new ResourceLocation("textures/gui/widgets.png");
    public static final ResourceLocation SliderRailTexture = new ResourceLocation("creativecore", "textures/gui/SliderRail.png");
    public static final ResourceLocation SliderTexture = new ResourceLocation("creativecore", "textures/gui/Slider.png");
    public int id;
    public float maxValue;
    public float minValue;
    public float value;
    public boolean grabbedSlider;

    public GuiAnalogeSlider(String name, int x, int y, int width, int height, int rotation, int id, float minValue, float maxValue) {
        super(name, x, y, width, height, rotation);
        this.id = id;
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    public GuiAnalogeSlider(String name, int x, int y, int width, int height, int rotation, int id, float maxValue) {
        this(name, x, y, width, height, rotation, id, 0.0f, maxValue);
    }

    public GuiAnalogeSlider(String name, int x, int y, int width, int height, int rotation) {
        this(name, x, y, width, height, rotation, 0, 0.0f, 100.0f);
    }

    @Override
    public void drawControl(FontRenderer renderer) {
        Minecraft mc = Minecraft.func_71410_x();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        mc.func_110434_K().func_110577_a(buttonTextures);
        int mouseEvent = 1;
        Vector2d mouse = this.parent.getMousePos();
        if (this.isMouseOver((int)mouse.x, (int)mouse.y)) {
            mouseEvent = 2;
        }
        if (!this.enabled) {
            mouseEvent = 0;
        }
        GL11.glEnable((int)3042);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glBlendFunc((int)770, (int)771);
    }

    @Override
    public boolean mousePressed(int posX, int posY, int button) {
        Vector2d mouse = this.parent.getMousePos();
        if (this.enabled && button == 0 && this.isMouseOver((int)mouse.x, (int)mouse.x)) {
            Minecraft mc = Minecraft.func_71410_x();
            mc.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
            this.grabbedSlider = true;
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseDragged(int posX, int posY, int button, long time) {
        Vector2d mouse = this.parent.getMousePos();
        if (this.grabbedSlider) {
            this.value = mouse.x < (double)this.posX ? this.minValue : (mouse.x > (double)(this.posX + this.width) ? this.maxValue : (this.maxValue - this.minValue) * ((float)(mouse.x - (double)this.posX) / (float)this.width));
            return true;
        }
        return false;
    }

    @Override
    public void mouseReleased(int posX, int posY, int button) {
        if (this.grabbedSlider) {
            this.grabbedSlider = false;
        }
    }
}

