/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.gui.controls;

import com.creativemd.creativecore.common.gui.controls.GuiComboBox;
import com.creativemd.creativecore.common.gui.controls.GuiListBox;
import com.creativemd.creativecore.common.gui.event.ControlChangedEvent;
import java.util.ArrayList;
import javax.vecmath.Vector2d;
import net.minecraft.entity.player.EntityPlayer;

public class GuiComboBoxExtension
extends GuiListBox {
    public GuiComboBox comboBox;

    public GuiComboBoxExtension(String name, EntityPlayer player, GuiComboBox comboBox, int x, int y, int width, int height, ArrayList<String> lines) {
        super(name, player, x, y, width, height, lines);
        this.comboBox = comboBox;
        this.selected = lines.indexOf(comboBox.caption);
    }

    @Override
    public Vector2d getCenterOffset() {
        return new Vector2d((double)(this.width / 2), (double)(-this.comboBox.height / 2));
    }

    @Override
    public void onLoseFocus() {
        if (!this.comboBox.isMouseOver()) {
            this.comboBox.closeBox();
        }
    }

    @Override
    public void onSelectionChange() {
        if (this.selected != -1 && this.selected < this.lines.size()) {
            this.comboBox.caption = (String)this.lines.get(this.selected);
            this.comboBox.raiseEvent(new ControlChangedEvent(this.comboBox));
        }
        this.comboBox.closeBox();
    }
}

