/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.gui.controls.container;

import com.creativemd.creativecore.client.rendering.RenderHelper2D;
import com.creativemd.creativecore.common.container.slot.SlotControl;
import com.creativemd.creativecore.common.gui.GuiContainerSub;
import com.creativemd.creativecore.common.gui.SubGui;
import com.creativemd.creativecore.common.gui.controls.GuiControl;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GuiSlotControl
extends GuiControl {
    public SlotControl slot;
    public ItemStack dragged = null;
    public boolean isRightClick = false;
    public GuiSlotControl startSlot = null;
    public int[] stackSize = null;
    public int index = -1;

    public GuiSlotControl(int x, int y, SlotControl slot) {
        super(slot.slot.field_75224_c.func_145825_b() + slot.slot.field_75222_d, x, y, 18, 18);
        this.slot = slot;
    }

    @Override
    public void drawControl(FontRenderer renderer) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        mc.func_110434_K().func_110577_a(GuiContainerSub.background);
        RenderHelper2D.drawTexturedModalRect(0.0, 0.0, 176.0, 0.0, 18.0, 18.0);
        ItemStack stack = this.slot.slot.func_75211_c();
        ItemStack newStack = null;
        if (this.isDragged() && this.stackSize.length > 1) {
            this.updateHandStack();
            newStack = this.getItemStackByIndex(this.index);
        } else if (this.startSlot != null) {
            this.updateStackSize();
            newStack = this.startSlot.getItemStackByIndex(this.index);
        }
        if (newStack != null) {
            if (stack != null) {
                newStack.field_77994_a += stack.field_77994_a;
            }
            stack = newStack;
        }
        if (stack != null) {
            try {
                GL11.glTranslated((double)8.0, (double)8.0, (double)0.0);
                GL11.glRotated((double)(-this.rotation), (double)0.0, (double)0.0, (double)1.0);
                GL11.glTranslated((double)-8.0, (double)-8.0, (double)0.0);
                GL11.glEnable((int)3008);
                GL11.glAlphaFunc((int)516, (float)0.1f);
                GL11.glEnable((int)3042);
                GL11.glEnable((int)2929);
                OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
                RenderHelper.func_74520_c();
                GL11.glEnable((int)32826);
                GL11.glEnable((int)2896);
                SubGui.itemRender.field_77023_b = 200.0f;
                FontRenderer font = null;
                if (this.slot.slot.func_75211_c() != null) {
                    font = this.slot.slot.func_75211_c().func_77973_b().getFontRenderer(stack);
                }
                if (font == null) {
                    font = renderer;
                }
                SubGui.itemRender.func_82406_b(font, mc.func_110434_K(), stack, 1, 1);
                String textStack = null;
                if (stack.field_77994_a == 0) {
                    textStack = "" + EnumChatFormatting.YELLOW + "0";
                }
                SubGui.itemRender.func_94148_a(font, mc.func_110434_K(), stack, 1, 1, textStack);
                SubGui.itemRender.field_77023_b = 0.0f;
            }
            catch (Exception e) {
                SubGui.itemRender.field_77023_b = 100.0f;
                ResourceLocation resourcelocation = GuiSlotControl.mc.field_71446_o.func_130087_a(1);
                TextureAtlasSprite icon = ((TextureMap)mc.func_110434_K().func_110581_b(resourcelocation)).func_110572_b("missingno");
                Minecraft.func_71410_x().field_71446_o.func_110577_a(resourcelocation);
                SubGui.itemRender.func_94149_a(1, 1, (IIcon)icon, 16, 16);
                SubGui.itemRender.field_77023_b = 0.0f;
            }
        }
        if (this.isMouseOver() || this.startSlot != null || this.isDragged()) {
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            RenderHelper2D.drawGradientRect(1, 1, 17, 17, -2130706433, -2130706433);
            GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        }
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
    }

    @Override
    public ArrayList<String> getTooltip() {
        ArrayList<String> tips = new ArrayList<String>();
        if (this.slot.slot.func_75216_d() && this.parent.container.player.field_71071_by.func_70445_o() == null) {
            List list = null;
            try {
                list = this.slot.slot.func_75211_c().func_82840_a((EntityPlayer)GuiSlotControl.mc.field_71439_g, GuiSlotControl.mc.field_71474_y.field_82882_x);
                for (int k = 0; k < list.size(); ++k) {
                    if (k == 0) {
                        list.set(k, this.slot.slot.func_75211_c().func_77953_t().field_77937_e + (String)list.get(k));
                    } else {
                        list.set(k, EnumChatFormatting.GRAY + (String)list.get(k));
                    }
                    tips.add((String)list.get(k));
                }
            }
            catch (Exception e) {
                ItemStack stack = this.slot.slot.func_75211_c();
                tips.add(Item.field_150901_e.func_148750_c((Object)stack.func_77973_b()));
                tips.add("Damage: " + stack.func_77960_j());
                tips.add("NBT: " + (stack.field_77990_d == null ? "null" : stack.field_77990_d.toString()));
            }
        }
        return tips;
    }

    @Override
    public boolean onKeyPressed(char character, int key) {
        if (key == GuiSlotControl.mc.field_71474_y.field_74316_C.func_151463_i() && this.isMouseOver()) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74757_a("ctrl", GuiScreen.func_146271_m());
            this.slot.sendNBTUpdate(2, nbt);
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseScrolled(int posX, int posY, int scrolled) {
        this.sendClickedPacket(3, scrolled);
        return true;
    }

    public void sendClickedPacket(int button, int scrolled) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("button", button);
        boolean shift = GuiScreen.func_146272_n();
        nbt.func_74757_a("shift", shift);
        nbt.func_74768_a("scrolled", scrolled);
        this.slot.sendNBTUpdate(1, nbt);
        this.slot.onSlotClicked(button, shift, scrolled);
    }

    public boolean isDragged() {
        return this.dragged != null;
    }

    @Override
    public boolean mousePressed(int posX, int posY, int button) {
        ItemStack stack = this.parent.container.player.field_71071_by.func_70445_o();
        if (stack != null && button < 2) {
            this.dragged = stack.func_77946_l();
            this.isRightClick = button == 1;
            boolean canStack = Container.func_94527_a((Slot)this.slot.slot, (ItemStack)this.dragged, (boolean)true);
            int stackSize = Math.min(this.slot.slot.func_75219_a(), this.dragged.func_77976_d());
            if (this.slot.slot.func_75216_d()) {
                stackSize -= this.slot.slot.func_75211_c().field_77994_a;
            }
            if (!this.slot.slot.func_75214_a(this.dragged)) {
                stackSize = 0;
            }
            if (stackSize > 0 && canStack) {
                this.stackSize = new int[1];
                this.stackSize[0] = stackSize;
                this.index = 0;
                return true;
            }
            this.dragged = null;
        }
        this.sendClickedPacket(button, 0);
        return true;
    }

    @Override
    public boolean mouseDragged(int posX, int posY, int button, long time) {
        if (this.startSlot == null && !this.isDragged()) {
            for (int i = 0; i < this.parent.controls.size(); ++i) {
                if (!(this.parent.controls.get(i) instanceof GuiSlotControl) || !((GuiSlotControl)this.parent.controls.get(i)).isDragged()) continue;
                this.startSlot = (GuiSlotControl)this.parent.controls.get(i);
                boolean canStack = Container.func_94527_a((Slot)this.slot.slot, (ItemStack)this.startSlot.dragged, (boolean)true);
                int stackSize = Math.min(this.slot.slot.func_75219_a(), this.startSlot.dragged.func_77976_d());
                if (this.slot.slot.func_75216_d()) {
                    stackSize -= this.slot.slot.func_75211_c().field_77994_a;
                }
                if (!this.slot.slot.func_75214_a(this.dragged)) {
                    stackSize = 0;
                }
                if (stackSize > 0 && canStack) {
                    int[] newStackSize = new int[this.startSlot.stackSize.length + 1];
                    for (int j = 0; j < this.startSlot.stackSize.length; ++j) {
                        newStackSize[j] = this.startSlot.stackSize[j];
                    }
                    newStackSize[this.startSlot.stackSize.length] = stackSize;
                    this.index = this.startSlot.stackSize.length;
                    this.startSlot.stackSize = newStackSize;
                    continue;
                }
                this.startSlot = null;
            }
        }
        return true;
    }

    @Override
    public void mouseReleased(int posX, int posY, int button) {
        if (this.isDragged() && this.stackSize.length > 1) {
            NBTTagCompound nbt = new NBTTagCompound();
            int[] slotArray = new int[this.stackSize.length];
            slotArray[this.index] = this.slot.getID();
            for (int i = 0; i < this.parent.controls.size(); ++i) {
                if (!(this.parent.controls.get(i) instanceof GuiSlotControl) || ((GuiSlotControl)this.parent.controls.get((int)i)).startSlot == null) continue;
                slotArray[((GuiSlotControl)this.parent.controls.get((int)i)).index] = ((GuiSlotControl)this.parent.controls.get((int)i)).slot.getID();
                ((GuiSlotControl)this.parent.controls.get((int)i)).startSlot = null;
                ((GuiSlotControl)this.parent.controls.get((int)i)).index = -1;
            }
            nbt.func_74783_a("slots", slotArray);
            nbt.func_74757_a("right", this.isRightClick);
            this.dragged.func_77955_b(nbt);
            this.slot.sendNBTUpdate(3, nbt);
            this.slot.splitStack(slotArray, this.dragged, this.isRightClick);
        } else if (this.isDragged()) {
            this.sendClickedPacket(this.isRightClick ? 1 : 0, 0);
        }
        this.dragged = null;
        this.stackSize = null;
    }

    public void updateStackSize() {
        if (this.startSlot != null) {
            int stackSize = Math.min(this.slot.slot.func_75219_a(), this.startSlot.dragged.func_77976_d());
            if (this.slot.slot.func_75216_d()) {
                stackSize -= this.slot.slot.func_75211_c().field_77994_a;
            }
            this.startSlot.stackSize[this.index] = stackSize;
        }
    }

    public ItemStack getItemStackByIndex(int index) {
        if (index >= this.dragged.field_77994_a) {
            return null;
        }
        ItemStack result = this.dragged.func_77946_l();
        if (this.isRightClick) {
            result.field_77994_a = 1;
        } else {
            int used = 0;
            int StackPerSlot = MathHelper.func_76141_d((float)((float)result.field_77994_a / (float)this.stackSize.length));
            for (int i = 0; i < index; ++i) {
                used += Math.min(StackPerSlot, this.stackSize[i]);
            }
            if (used < result.field_77994_a) {
                result.field_77994_a = Math.min(StackPerSlot, this.stackSize[index]);
            }
        }
        return result;
    }

    public void updateHandStack() {
        int used = 0;
        int StackPerSlot = MathHelper.func_76141_d((float)((float)this.dragged.field_77994_a / (float)this.stackSize.length));
        if (this.isRightClick) {
            StackPerSlot = 1;
        }
        for (int i = 0; i < this.stackSize.length; ++i) {
            used += Math.min(StackPerSlot, this.stackSize[i]);
        }
        int left = this.dragged.field_77994_a - used;
        ItemStack hand = this.parent.container.player.field_71071_by.func_70445_o().func_77946_l();
        hand.field_77994_a = left;
        this.parent.container.player.field_71071_by.func_70437_b(hand);
    }
}

