/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.utils;

import java.util.ArrayList;
import java.util.Arrays;

public class HashMapList<K, V> {
    private ArrayList<K> keys = new ArrayList();
    private ArrayList<ArrayList<V>> values = new ArrayList();

    public ArrayList<V> getValues(int index) {
        return this.values.get(index);
    }

    public ArrayList<V> getValues(K key) {
        int index = this.indexOfKey(key);
        if (index != -1) {
            return this.values.get(index);
        }
        return null;
    }

    public K getKey(int index) {
        return this.keys.get(index);
    }

    public K getLast() {
        if (this.keys.size() > 0) {
            return this.keys.get(this.keys.size() - 1);
        }
        return null;
    }

    public K getKey(V value) {
        for (int i = 0; i < this.values.size(); ++i) {
            int index = this.values.get(i).indexOf(value);
            if (index == -1) continue;
            return this.getKey((V)index);
        }
        return null;
    }

    public ArrayList<K> getKeys() {
        return this.keys;
    }

    public void add(K key, V[] values) {
        this.add(key, (V)new ArrayList<V>(Arrays.asList(values)));
    }

    public void add(K key, ArrayList<V> values) {
        int index = this.indexOfKey(key);
        if (index != -1) {
            this.values.get(index).addAll(values);
        } else {
            this.keys.add(key);
            ArrayList<V> newList = new ArrayList<V>();
            newList.addAll(values);
            this.values.add(newList);
        }
    }

    public void add(K key, V value) {
        int index = this.indexOfKey(key);
        if (index != -1) {
            this.values.get(index).add(value);
        } else {
            this.keys.add(key);
            ArrayList<V> newList = new ArrayList<V>();
            newList.add(value);
            this.values.add(newList);
        }
    }

    public boolean removeKey(int key) {
        if (key != -1) {
            this.keys.remove(key);
            this.values.remove(key);
            return true;
        }
        return false;
    }

    public boolean removeKey(K key) {
        return this.removeKey(this.indexOfKey(key));
    }

    public boolean removeValue(K key, V value) {
        ArrayList<V> values = this.getValues(key);
        if (values != null) {
            return values.remove(value);
        }
        return false;
    }

    public boolean removeValue(V value) {
        for (int i = 0; i < this.values.size(); ++i) {
            if (!this.values.get(i).remove(value)) continue;
            return true;
        }
        return false;
    }

    public int indexOfKey(K key) {
        return this.keys.indexOf(key);
    }

    public int size() {
        return this.keys.size();
    }
}

