/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.utils;

import com.creativemd.creativecore.common.utils.CubeObject;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.ForgeDirection;

public class RotationUtils {
    public static void applyDirection(ForgeDirection direction, ChunkCoordinates coord) {
        switch (direction) {
            case DOWN: {
                --coord.field_71572_b;
                break;
            }
            case EAST: {
                ++coord.field_71574_a;
                break;
            }
            case NORTH: {
                --coord.field_71573_c;
                break;
            }
            case SOUTH: {
                ++coord.field_71573_c;
                break;
            }
            case UP: {
                ++coord.field_71572_b;
                break;
            }
            case WEST: {
                --coord.field_71574_a;
                break;
            }
        }
    }

    public static int getIndex(ForgeDirection direction) {
        for (int i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
            if (ForgeDirection.VALID_DIRECTIONS[i] != direction) continue;
            return i;
        }
        return -1;
    }

    public static Vec3 applyVectorRotation(Vec3 vector, ForgeDirection direction) {
        double tempX = vector.field_72450_a;
        double tempY = vector.field_72448_b;
        double tempZ = vector.field_72449_c;
        switch (direction) {
            case UP: {
                vector.field_72450_a = -tempY;
                vector.field_72448_b = tempX;
                break;
            }
            case DOWN: {
                vector.field_72450_a = tempY;
                vector.field_72448_b = -tempX;
                break;
            }
            case SOUTH: {
                vector.field_72450_a = -tempZ;
                vector.field_72449_c = tempX;
                break;
            }
            case NORTH: {
                vector.field_72450_a = tempZ;
                vector.field_72449_c = -tempX;
                break;
            }
            case WEST: {
                vector.field_72450_a = -tempX;
                vector.field_72449_c = -tempZ;
                break;
            }
        }
        return vector;
    }

    public static void applyCubeRotation(CubeObject cube, ForgeDirection direction) {
        double minX = cube.minX - 0.5;
        double minY = cube.minY - 0.5;
        double minZ = cube.minZ - 0.5;
        double maxX = cube.maxX - 0.5;
        double maxY = cube.maxY - 0.5;
        double maxZ = cube.maxZ - 0.5;
        Vec3 min = RotationUtils.applyVectorRotation(Vec3.func_72443_a((double)minX, (double)minY, (double)minZ), direction);
        Vec3 max = RotationUtils.applyVectorRotation(Vec3.func_72443_a((double)maxX, (double)maxY, (double)maxZ), direction);
        min = min.func_72441_c(0.5, 0.5, 0.5);
        max = max.func_72441_c(0.5, 0.5, 0.5);
        if (min.field_72450_a < max.field_72450_a) {
            cube.minX = min.field_72450_a;
            cube.maxX = max.field_72450_a;
        } else {
            cube.minX = max.field_72450_a;
            cube.maxX = min.field_72450_a;
        }
        if (min.field_72448_b < max.field_72448_b) {
            cube.minY = min.field_72448_b;
            cube.maxY = max.field_72448_b;
        } else {
            cube.minY = max.field_72448_b;
            cube.maxY = min.field_72448_b;
        }
        if (min.field_72449_c < max.field_72449_c) {
            cube.minZ = min.field_72449_c;
            cube.maxZ = max.field_72449_c;
        } else {
            cube.minZ = max.field_72449_c;
            cube.maxZ = min.field_72449_c;
        }
    }
}

