/*
 * Decompiled with CFR 0.152.
 */
package com.n247s.api.eventapi.eventsystem;

import com.creativemd.creativecore.common.event.TickHandler;
import com.n247s.api.eventapi.EventApi;
import com.n247s.api.eventapi.eventsystem.CallHandler;
import com.n247s.api.eventapi.eventsystem.CustomEventSubscribe;
import com.n247s.api.eventapi.eventsystem.EventApiCallHandler;
import com.n247s.api.eventapi.eventsystem.EventType;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.Logger;

public class EventBus {
    private static final Logger log = EventApi.logger;
    protected final HashMap<Class<? extends EventType>, CallHandler> EventList = new HashMap();
    public ArrayList<EventType> eventsToRaise = new ArrayList();

    public EventBus() {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            this.initClient();
        } else {
            this.initServer();
        }
    }

    public void initServer() {
        TickHandler.ServerEvents.add(this);
    }

    @SideOnly(value=Side.CLIENT)
    public void initClient() {
        TickHandler.ClientEvents.add(this);
    }

    public boolean raiseEvent(EventType event, boolean force) {
        if (event.isCancelable() || force) {
            if (!this.EventList.containsKey(event.getClass())) {
                this.EventList.put(event.getClass(), new EventApiCallHandler(event.getClass()));
            }
            return this.EventList.get(event.getClass()).CallInstances(event);
        }
        this.eventsToRaise.add(event);
        return false;
    }

    public boolean raiseEvent(EventType event) {
        return this.raiseEvent(event, false);
    }

    public void bindCallHandler(CallHandler callHandler) {
        if (this.EventList.containsKey(callHandler.eventType)) {
            this.EventList.remove(callHandler.eventType);
        }
        this.EventList.put(callHandler.eventType, callHandler);
    }

    public void RegisterEventListener(Object listener) {
        Class clazz = !(listener instanceof Class) ? listener.getClass() : (Class)listener;
        Method[] methods = clazz.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method currentMethod = methods[i];
            if (!currentMethod.isAnnotationPresent(CustomEventSubscribe.class)) continue;
            if (currentMethod.getParameterTypes().length > 1) {
                log.catching((Throwable)new IllegalArgumentException("An CustomEventSubScribed Method Can't have more than one Parameter!"));
            }
            if (!EventType.class.isAssignableFrom(currentMethod.getParameterTypes()[0])) {
                log.catching((Throwable)new IllegalArgumentException("The Parameter isn't an EventType!"));
            }
            CustomEventSubscribe annotation = currentMethod.getAnnotation(CustomEventSubscribe.class);
            Class<?> methodEventType = currentMethod.getParameterTypes()[0];
            this.getCallHandlerFromEventType(methodEventType).RegisterEventListner(annotation.eventPriority(), listener, currentMethod);
        }
    }

    public void RegisterEventListeners(List<Object> listenersList) {
        for (int i = 0; i < listenersList.size(); ++i) {
            this.RegisterEventListener(listenersList.get(i));
        }
    }

    public void removeEventListener(Object Listener) {
        Class clazz = !(Listener instanceof Class) ? Listener.getClass() : (Class)Listener;
        Method[] methodArray = clazz.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            Method currentMethod = methodArray[i];
            if (!currentMethod.isAnnotationPresent(CustomEventSubscribe.class)) continue;
            if (currentMethod.getParameterTypes().length > 1) {
                log.catching((Throwable)new IllegalArgumentException("An CustomEventSubScribed Method Can't have more than one Parameter!"));
            }
            if (Listener instanceof Class && !Modifier.isStatic(currentMethod.getModifiers())) {
                log.catching((Throwable)new IllegalArgumentException("An CustomEventSubScribed Method Can't be non-static if you register an Class Object!"));
            }
            if (!EventType.class.isAssignableFrom(currentMethod.getParameterTypes()[0])) {
                log.catching((Throwable)new IllegalArgumentException("The Parameter of a CustomEventSubscribed method isn't an EventType!"));
            }
            CustomEventSubscribe annotation = currentMethod.getAnnotation(CustomEventSubscribe.class);
            Class<?> methodEventType = currentMethod.getParameterTypes()[0];
            this.getCallHandlerFromEventType(methodEventType).removeListner(annotation.eventPriority(), Listener);
        }
    }

    public void removeEventListeners(List<Object> listenersList) {
        for (int i = 0; i < listenersList.size(); ++i) {
            this.removeEventListener(listenersList.get(i));
        }
    }

    public void removeAllEventListeners() {
        for (CallHandler value : this.EventList.values()) {
            value.instanceMap.clear();
        }
        this.EventList.clear();
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            this.removeTickEventClient();
        } else {
            this.removeTickEventServer();
        }
    }

    public void removeTickEventServer() {
        TickHandler.ServerEvents.remove(this);
    }

    @SideOnly(value=Side.CLIENT)
    public void removeTickEventClient() {
        TickHandler.ClientEvents.remove(this);
    }

    public CallHandler getCallHandlerFromEventType(Class<? extends EventType> eventTypeClass) {
        if (!this.EventList.containsKey(eventTypeClass)) {
            this.EventList.put(eventTypeClass, new EventApiCallHandler(eventTypeClass));
        }
        return this.EventList.get(eventTypeClass);
    }
}

