if not ConfigScriptInitialized then
ConfigScriptInitialized = true
-------------------------------------------------------------------------
function ConfigFile() return './trainer/assets/userdata.config' end
 
function SaveTable(Table)
   local savedTables = {}
   local outFuncs = {
      ['string']  = function(value) return string.format("%q",value) end;
      ['boolean'] = function(value) if (value) then return 'true' else return 'false' end end;
      ['number']  = function(value) return string.format('%f',value) end;
   }
   local outFuncsMeta = {
      __index = function(value) return nil end;
   }
   setmetatable(outFuncs,outFuncsMeta)
   local tableOut = function(value)
      if (savedTables[value]) then return end
      local outValue = function(value) return outFuncs[type(value)](value) end
      local out = '{\n'
      for i,v in pairs(value) do if outValue(v) ~= nil then out = out..'['..outValue(i)..']='..outValue(v)..';\n' end end
      savedTables[value] = true;
      return out..'}'
   end
   outFuncs['table'] = tableOut;
   return tableOut(Table);
end
 
function SaveTableToFile(file, var)
  if not file or not var then return end
  local f = io.open(file, 'w')
  if f then
    f:write(SaveTable(var))
    f:flush()
    f:close()
    return true
  end
  return false
end
 
function LoadTable(Input)
  if not Input then return false end
  return assert(loadstring('return '..Input))()
end
 
function LoadTableFromFile(file)
  if not file then return end
  local f = io.open(file)
  if f then
    local content = f:read("*all")
    f:close()
    return LoadTable(content)
  end
  return false
end
 
function LoadConfig()
  return LoadTableFromFile(ConfigFile()) or {}
end
 
function GetConfig(key)
  if not key or not ConfigData then return nil end
  return ConfigData[key]
end
 
function SetConfig(key, value, save)
  if not key or not ConfigData then return nil end
  if ConfigData[key] ~= value then
    ConfigData[key] = value
    ConfigData['_ConfigUpdated'] = true
    if save then return SaveConfig() end
    return true
  end
  return false
end
 
function SaveConfig(force)
  if not ConfigData then return end
  if ConfigData['_ConfigUpdated'] or force then
    ConfigData['_ConfigUpdated'] = nil
    return SaveTableToFile(ConfigFile(), ConfigData)
  end
  return false
end
 
ConfigData = ConfigData or LoadConfig()
-------------------------------------------------------------------------
end