--- GOLDOZER BANK by Transcend
function find_computer()
	local units = World:find_units_quick( "all" )
		for i,unit in ipairs( units ) do
		if unit.interaction and unit:interaction() and unit:interaction().tweak_data == "computer_test" then
			return unit
		end
	end
end
 
function spawn_loot(type, _position, z_offset)
	local position = mvector3.copy(_position)
	if z_offset then mvector3.set_z(position, position.z + z_offset) end
	
	if Network:is_client() then
		managers.network:session():send_to_host( "server_drop_carry", type, managers.money:get_bag_value( type ), nil, nil, 0, position, Rotation( math.UP, math.random() * 360 ), Vector3( 0,0,0 ), 0 )
	else
		managers.player:server_drop_carry( type, managers.money:get_bag_value( type ), nil, nil, 0, position, Rotation( math.UP, math.random() * 360 ), Vector3( 0,0,0 ), 0 )
	end
end
 
function spawn(position, rotation)
	local unit_name = Idstring( "units/payday2/characters/ene_bulldozer_1/ene_bulldozer_1" )
	local spawn_ai = { init_state = "idle" }
	local unit = World:spawn_unit( unit_name, position, rotation )
	unit:base().made_of_gold = true
	unit:movement():set_character_anim_variables()
	unit:brain():set_spawn_ai( spawn_ai )
	unit:brain():set_active( true )
end
 
function spawn_cluster(position, num, cluster)
	for i=1,num do
		spawn(Vector3(position.x + (math.random() * cluster * 2 - cluster), position.y + (math.random() * cluster * 2 - cluster), position.z), Rotation( math.UP, math.random() * 360 ))
	end
end
 
_CopDamageDie = _CopDamageDie or CopDamage.die
 
_modCopDamageDie = _modCopDamageDir or function( self, variant )
	if self._unit:base().made_of_gold then
		spawn_loot("gold", self._unit:position(), 120)
	end
	return _deadCop(self, variant)
end
 
_drillDone = _drillDone or Drill.done
_modDrillDone = _modDrillDone or function(self)
	local result = _drillDone(self)
	if managers.job:current_level_id() == "branchbank" then
		local computer = find_computer()
		if computer and computer:position().x == -1281 then
			spawn_cluster(Vector3(-2068.93, 2197.47, 1.1), 3, 100)
			spawn_cluster(Vector3(-2222.62, 2285.03, 1.1), 3, 100)
		elseif computer and computer:position().x == -2920 then
			spawn_cluster(Vector3(-2246.11, 2061.04, 1.1), 3, 100)
			spawn_cluster(Vector3(-2175.62, 2285.41, 1.1), 3, 100)
		end
	Drill.done = _drillDone
	_drillDone = nil
	end
	return result
end
 
_deadCiv = _deadCiv or CivilianDamage.die
_modDeadCiv = _modDeadCiv or function(self, ... )
	spawn(self._unit:position(), self._unit:rotation())

	local result = _deadCiv( self, ... )
	self._unit:set_slot( 0 )
	managers.network:session():send_to_peers_synched( "remove_unit", self._unit )
	return result
end
 
banktoggle = banktoggle or false
 
function togglebank()
	if banktoggle then
		CopDamage.die = _CopDamageDie
		if _drillDone then Drill.done = _drillDone end
			CivilianDamage.die = _deadCiv
			banktoggle = false
			managers.hud:show_hint( { text = "Goldozer Bank Off" } )
		else
			CopDamage.die = _modCopDamageDie
		if _drillDone then Drill.done = _modDrillDone end
		CivilianDamage.die = _modDeadCiv
		banktoggle = true
		managers.hud:show_hint( { text = "Goldozer Bank On" } )
	end
end
togglebank()