--[[
This is SimpleInput, scroll down to the bottom for a usage example

the code up here is purely setup.
--]]
if not SimpleInput then
    
    function managers.menu_component:force_create_chat()
        self._lobby_chat_gui_active = true
        if self._game_chat_gui then
            self:show_game_chat_gui()
            return
        end
        self:add_game_chat()
    end

    SimpleInput = SimpleInput or class()
    SimpleInput._visible = SimpleInput._visible or false
    SimpleInput._origFuncs = SimpleInput._origFuncs or { managers_chat_send_message = managers.chat.send_message, 
                                                         ChatGui_create_input_panel = ChatGui._create_input_panel,
                                                         managers_menucomp_key_press_controller_support = managers.menu_component.key_press_controller_support,
                                                         managers_hudchat_on_focus = managers.hud and managers.hud._hud_chat._on_focus or nil,
                                                         managers_hudchat_receive_message = managers.hud and managers.hud._hud_chat.receive_message or nil
                                                       }
    
    function SimpleInput:init(opts)
        self.cblk = opts.cblk or function(...) end
        self.intro = opts.intro
        self.intro_color = opts.intro_color or Color.white
        self.prompt = opts.prompt
        self.isVisible = false
        self.chatWasVisible = false
    end
    
    function SimpleInput:_remove_hooks()
        managers.menu_component:close_chat_gui()
        managers.chat.send_message = SimpleInput._origFuncs.managers_chat_send_message
        ChatGui._create_input_panel = SimpleInput._origFuncs.ChatGui_create_input_panel
        managers.menu_component.key_press_controller_support = SimpleInput._origFuncs.managers_menucomp_key_press_controller_support
        if self.chatWasVisible then
            self.chatWasVisible = false
            if managers.hud then
                managers.hud._hud_chat._on_focus = SimpleInput._origFuncs.managers_hudchat_on_focus
                managers.hud._hud_chat.receive_message = SimpleInput._origFuncs.managers_hudchat_receive_message
                managers.hud:set_chat_focus( false )
            else
                managers.menu_component:_create_lobby_chat_gui()
            end
        end
    end
    
    function SimpleInput:_inject_hooks()
        if managers.menu_component._game_chat_gui or (managers.hud and managers.hud._hud_chat) then
            self.chatWasVisible = true
        end
        pcall(managers.menu_component.close_chat_gui, managers.menu_component)
        managers.chat.send_message = managers.chat.receive_message_by_name
        ChatGui._create_input_panel = self._create_input_panel
        managers.menu_component.key_press_controller_support = function(...) end
        managers.SimpleInput = self
        managers.menu_component:force_create_chat()
        managers.menu_component._game_chat_gui.receive_message = self._receive_message
        if managers.hud then
            managers.hud._hud_chat.receive_message = function (...) end
            managers.hud._hud_chat._on_focus = function(...) end
        end
        managers.menu_component._game_chat_gui:open_page()
    end
    
    function SimpleInput:show()
        if SimpleInput._visible then
            return
        end
        SimpleInput._visible = true
        self.isVisible = true
        self:_inject_hooks()
        if self.intro then
            local cblkTmp = managers.SimpleInput.cblk
            managers.SimpleInput.cblk = function(...) return { msg = self.intro, color = self.intro_color } end
            managers.menu_component._game_chat_gui:receive_message(nil, nil, nil, nil)
            managers.SimpleInput.cblk = cblkTmp
        end
    end
    
    function SimpleInput:hide()
        if not SimpleInput._visible then
            return
        end
        SimpleInput._visible = false
        self.isVisible = false
        self:_remove_hooks()
    end
    
    function SimpleInput:is_visible()
        return self.isVisible
    end
    
    function SimpleInput:_create_input_panel()
        self._input_panel = self._panel:panel( { alpha = 0, name = "input_panel", x = 0, h = 150, w = self._panel_width, layer = 1 } )
        self._input_panel:rect( { name = "focus_indicator", visible = false, color = Color.black:with_alpha( 0.2 ), layer = 0 } )
        local say = self._input_panel:text( { name = "say", text = managers.SimpleInput.prompt, font = tweak_data.menu.pd2_small_font, font_size = tweak_data.menu.pd2_small_font_size, x = 5, y = 0,
                                        align="left", halign="left", vertical="top", hvertical="center", blend_mode="normal",
                                        color = Color.white, layer = 1 } )
        local _,_,w,h = say:text_rect()
        say:set_size( w, self._input_panel:h() )
        local input_text = self._input_panel:text( { name = "input_text", text = "", font = tweak_data.menu.pd2_small_font, font_size = tweak_data.menu.pd2_small_font_size, x = 0, y = 0,
                                        align="left", halign="left", vertical="top", hvertical="top", blend_mode="normal",
                                        color = Color.white, layer = 1, wrap = true, word_wrap = false } )
        local caret = self._input_panel:rect( { name="caret", layer = 2, x = 0, y = 0, w = 0, h = 0, color = Color(0.05, 1, 1, 1) } )
        self._input_panel:rect( { name="input_bg", color=Color.black:with_alpha(0.5), layer = -1, valign = "grow", h = self._input_panel:h() } )
        self._input_panel:child( "input_bg" ):set_w( self._input_panel:w() - w )
        self._input_panel:child( "input_bg" ):set_x( w )
        
        self._input_panel:stop()
        self._input_panel:animate( callback( self, self, "_animate_hide_input" ) )
    end
    
    function SimpleInput:_receive_message(_, message, ... )
        if( not alive( self._panel ) ) then
            return
        end
        local status, output = pcall(managers.SimpleInput.cblk, message)
        if not status or not output then
            return
        end
        local output_panel = self._panel:child( "output_panel" )
        local scroll_panel = output_panel:child( "scroll_panel" )
        local x = 0
        local icon = output.icon
        local icon_bitmap
        if icon then
            local icon_texture, icon_texture_rect = tweak_data.hud_icons:get_icon_data( icon )
            icon_bitmap = scroll_panel:bitmap( { texture = icon_texture, texture_rect = icon_texture_rect, color = output.color or Color.white, y = 1 } )
            x = icon_bitmap:right()
        end
        local line = scroll_panel:text( { text = tostring(output.msg), font = output.font or tweak_data.menu.pd2_small_font,
                                        font_size = output.font_size or tweak_data.menu.pd2_medium_font_size, x = 0, y = 5,
                                        align="left", halign="left", vertical="top", hvertical="top", blend_mode="normal", wrap = true, word_wrap = true,
                                        color = output.color or Color.white, layer = 0 } )
        local total_len = utf8.len( line:text() )                        
        line:set_range_color( 0, total_len, output.color or Color.white )
        local _,_,w,h = line:text_rect()
        line:set_h( h )
        local line_bg = scroll_panel:rect( { color=Color.black:with_alpha(0.5), layer = -1, halign="left", hvertical="top" } )
        line_bg:set_h( h )
        table.insert( self._lines, { line, line_bg, icon_bitmap } )
        self:_layout_output_panel()
        if not self._focus then
            output_panel:stop()
            output_panel:animate( callback( self, self, "_animate_show_component" ), output_panel:alpha() )
            output_panel:animate( callback( self, self, "_animate_fade_output" ) )
        end
    end
end
--[[
Usage is contained below here.

This is a very simple example that creates an in-game Lua interpreter out of the prompt.
Using a check to see whether we are visible, the key you bind the script to will act as a toggle.

Obviously, parseMessage is the function that will receive the user's input, so adapt it if writing your
own function.

Also bear in mind that whilst you CAN instantiate multiple instances of SimpleInput, for obvious reasons, only
one is allowed to be visible at a time - this is enforced within SimpleInput, it will not render again if one is
already showing.

If you actually want to make use of the interpreter, your Lua command should either return a type that can be
converted to a string (e.g. return "test" would print test to the prompt) so if doing something involved, make
a wrapper function that builds a string before returning.

e.g. return function() local ret = "" ret = ret .. doSomethingElse() end

All configuration is optional although you probably want to set a callback function or it won't do anything useful.

Available fonts are in lib/tweak_data somewhere, use grep.
]]--

function parseMessage(message)
    local status, ret
    status, ret = pcall(loadstring(message))
    return { msg = ret, font = nil, font_size = nil, color = Color.white, icon = nil }
end

local options = { intro = "Lua CLI", intro_color = Color.green, prompt = "Lua: > ", cblk = parseMessage }

LuaInterpreter = LuaInterpreter or SimpleInput:new(options)

if LuaInterpreter:is_visible() then
    LuaInterpreter:hide()
else
    LuaInterpreter:show()
end