if not _onIntimidated then _onIntimidated = CopLogicIdle.on_intimidated 
end
if not _onIIntimidated then _onIIntimidated = CopLogicIntimidated.on_intimidated 
end
if not _onSniperEnter then _onSniperEnter = CopLogicSniper.enter 
end

-- INSTANT INTIMIDATIONS (normalizable)
instantintim = instantintim or function()
	function CopLogicIdle.on_intimidated( data, amount, aggressor_unit )
		if aggressor_unit == managers.player:player_unit() then
			CopLogicIdle._surrender( data, amount )
			return true
		else
			return _onIntimidated(data, amount, aggressor_unit)
		end
	end
	CopLogicAttack.on_intimidated = CopLogicIdle.on_intimidated
	CopLogicArrest.on_intimidated = CopLogicIdle.on_intimidated
	CopLogicSniper.on_intimidated = CopLogicIdle.on_intimidated
	-- SHIELD LOGIC
	CopBrain._logic_variants.shield.intimidated = CopLogicIntimidated
	function CopLogicIntimidated.on_intimidated( data, amount, aggressor_unit ) 
		-- If shield we skip animations, go straight to conversion & spawn a new shield since it was destroyed during intimidation
		if data.unit:base()._tweak_table == "shield" then
			CopLogicIntimidated._do_tied( data, aggressor_unit )
			CopInventory._chk_spawn_shield( data.unit:inventory(), nil )
		else
			_onIIntimidated(data, amount, aggressor_unit)
		end
		-- PROPER SNIPER ((100% ACCURACY, NO SPREAD) normalizable)
		CopBrain._logic_variants.sniper = clone( CopBrain._logic_variants.security )
		CopBrain._logic_variants.sniper.attack = CopLogicSniper
		function CopLogicSniper.enter( data, new_logic_name, enter_params )
			if data.unit:brain()._logic_data and data.unit:brain()._logic_data.objective and data.unit:brain()._logic_data.objective.type == "follow" then
			data.char_tweak.weapon[ data.unit:inventory():equipped_unit():base():weapon_tweak_data().usage ] = tweak_data.character.presets.weapon.sniper.m4
			data.char_tweak.weapon[ data.unit:inventory():equipped_unit():base():weapon_tweak_data().usage ].	spread = 0
				-- Get dat 100% accuracy
				for distance=1, 3 do
					for interpolate=1,2 do
						data.char_tweak.weapon[ data.unit:inventory():equipped_unit():base():weapon_tweak_data().usage ].FALLOFF[distance].acc[interpolate] = 1
					end
				end
			end
		_onSniperEnter(data, new_logic_name, enter_params)
		end
	end
end
instantintim()