-- CUSTOM LOBBY CREATOR by harf
function CreateLobby(job, difficulty, permission, min_rep, drop_in, kicking_allowed, team_ai, level_id)
	Global.game_settings.permission = permission == nil and "private" or permission
	Global.game_settings.reputation_permission = type(min_rep) == "number" and min_rep or 0
	Global.game_settings.drop_in_allowed = drop_in == nil and true or drop_in
	Global.game_settings.kicking_allowed = kicking_allowed == nil and true or kicking_allowed
	Global.game_settings.team_ai = team_ai == nil and false or team_ai
	MenuCallbackHandler:start_job({ job_id = job, difficulty = difficulty})
	if level_id then
		Global.game_settings.level_id = level_id
		Global.game_settings.mission = managers.job:current_mission()
	end
end

add_job = add_job or function(data)
	CreateLobby(data.job_id, data.difficulty, managers.network.matchmake.lobby_handler and Global.game_settings.permission or "friends_only")
end

show_menu = show_menu or function(menu)
    menu:show()
end

mission = mission or function(job_id)
    local difficulty_opts = {
        { text = "Normal", callback = add_job, data = { difficulty = "normal", job_id = job_id } },
        { text = "Hard", callback = add_job, data = { difficulty = "hard", job_id = job_id } },
        { text = "Very Hard", callback = add_job, data = { difficulty = "overkill", job_id = job_id  } },
        { text = "Overkill", callback = add_job, data = { difficulty = "overkill_145", job_id = job_id } },
		{ text = "Deathwish", callback = add_job, data = { difficulty = "overkill_290", job_id = job_id } },
        { text = "Cancel", is_cancel_button = true},
    }
    local difficulty_menu = SimpleMenu:new("Mission Selector", "Choose Difficulty", difficulty_opts)
    difficulty_menu:show()
end
 

--Menu Contractor
bainc = bainc or {
{ text = "Jewelry Store", callback = mission, data="jewelry_store" },
{ text = "Bank heist: Cash", callback = mission, data="branchbank_cash" },
{ text = "Bank heist: Deposit", callback = mission, data="branchbank_deposit" },
{ text = "Diamond Store", callback = mission, data="family" },
{ text = "Bank heist: Gold (Pro Job)", callback = mission, data="branchbank_gold_prof" },
{ text = "Bank heist (Pro Job)", callback = mission, data="branchbank_prof" },
{ text = "Shadow heist", callback = mission, data="kosugi" },
--{ text = "Shadow heist (Pro Job)", callback = mission, data="kosugi_prof" },
{ text = "Cancel", is_cancel_button = true },
}
baincmenu = baincmenu or SimpleMenu:new("Mission Selector", "Choose Map", bainc)
baindlc = baindlc or {
{ text = "Transport: Crossroads", callback = mission, data = "arm_cro" },
{ text = "Transport: Downtown", callback = mission, data = "arm_hcm" },
{ text = "Transport: Harbour", callback = mission, data = "arm_fac" },
{ text = "Transport: Underpass", callback = mission, data = "arm_und" },
{ text = "Transport: Park", callback = mission, data = "arm_par" },
{ text = "Train Heist*", callback = mission, data = "arm_for" },
{ text = "GO Bank", callback = mission, data = "roberts" },
{ text = "Cancel", is_cancel_button = true },
}
baindmenu = baindmenu or SimpleMenu:new("Mission Selector", "Choose Map", baindlc)
hector = hector or {
{ text = "Watchdogs", callback = mission, data="watchdogs" },
{ text = "Fire Starter", callback = mission, data="firestarter" },
{ text = "Rats", callback = mission, data="alex" },
{ text = "Watchdogs (Pro Job)", callback = mission, data="watchdogs_prof" },
{ text = "Fire Starter (Pro Job)", callback = mission, data="firestarter_prof" },
{ text = "Rats (Pro Job)", callback = mission, data="alex_prof" },
{ text = "Cancel", is_cancel_button = true},
}
hectormenu = hectormenu or SimpleMenu:new("Mission Selector", "Choose Map", hector)
elephant = {
{ text = "Framing Frame", callback = mission, data = "framing_frame" },
{ text = "Framing Frame (Pro Job)", callback = mission, data = "framing_frame_prof" },
{ text = "Big Oil (Pro Job)", callback = mission, data = "welcome_to_the_jungle_prof" },
{ text = "Election Day", callback = mission, data = "election_day" },
{ text = "Election Day (Pro Job)", callback = mission, data = "election_day_prof" },
{ text = "Cancel", is_cancel_button = true},
}
elephantmenu = SimpleMenu:new("Mission Selector", "Choose Map",elephant)
vlad = {
{ text = "Four Stores", callback = mission, data = "four_stores" },
{ text = "Mallcrasher", callback = mission, data = "mallcrasher" },
{ text = "Nightclub", callback = mission, data = "nightclub" },
{ text = "Ukrainian Job (Pro Job)", callback = mission, data = "ukrainian_job_prof" },
{ text = "Cancel", is_cancel_button = true},
}
vladmenu = SimpleMenu:new("Mission Selector", "Choose Map", vlad)

random_stealth = random_stealth or function()
	local s_missions = { "four_stores", "nightclub", "ukrainian_job_prof", "framing_frame_prof", "welcome_to_the_jungle_prof", "firestarter_prof",
"jewelry_store", "branchbank_prof", "family", "roberts", "election_day_prof" }
	add_job({ job_id = s_missions[math.random(1, #s_missions)], difficulty = "overkill_145"})
end

rootopts = {
{ text = "Bain Classic", callback = show_menu, data = baincmenu},
{ text = "Bain DLC", callback = show_menu, data = baindmenu},
{ text = "Hector", callback = show_menu, data = hectormenu},
{ text = "The Elephant", callback = show_menu, data = elephantmenu},
{ text = "Vlad", callback = show_menu, data = vladmenu},
{ text = "Random Stealth", callback = random_stealth },
{ text = "Cancel", is_cancel_button = true},
}

if not rootmenu then
    managers.crimenet._NEW_JOB_MIN_TIME = 0
    managers.crimenet._NEW_JOB_MAX_TIME = 0
    managers.crimenet._presets = { }
    managers.crimenet._active_jobs = { }
    managers.crimenet._MAX_ACTIVE_JOBS = 0
    rootmenu = SimpleMenu:new("Mission Selector", "Choose Contractor", rootopts)
end

rootmenu:show()
